/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.server;

import gnu.java.rmi.server.UnicastConnection;
import java.util.ArrayList;
import java.util.Arrays;

class ConnectionRunnerPool {
    private static int size = 5;
    private static int max_size = 10;
    static ArrayList freelist;
    private static ThreadGroup group;

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static void setSize(int n) {
        size = n;
    }

    public static void setMaxSize(int n) {
        max_size = n;
    }

    private static synchronized ConnectionRunner getConnectionRunner() {
        ConnectionRunner connectionRunner;
        if (freelist.size() == 0) {
            if (size < max_size) {
                connectionRunner = new ConnectionRunner(group, new Integer(++size).toString());
                connectionRunner.start();
                freelist.add(connectionRunner);
            } else {
                while (freelist.size() == 0) {
                    try {
                        ConnectionRunnerPool.class$("gnu.java.rmi.server.ConnectionRunnerPool").wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        connectionRunner = (ConnectionRunner)freelist.get(0);
        freelist.remove(connectionRunner);
        return connectionRunner;
    }

    public static void dispatchConnection(UnicastConnection unicastConnection) {
        ConnectionRunner connectionRunner = ConnectionRunnerPool.getConnectionRunner();
        connectionRunner.dispatch(unicastConnection);
    }

    public static void exit() {
        Thread[] threadArray = new Thread[group.activeCount()];
        group.enumerate(threadArray);
        for (int i = 0; i < threadArray.length; ++i) {
            ((ConnectionRunner)threadArray[i]).exit();
        }
    }

    ConnectionRunnerPool() {
    }

    static {
        group = new ThreadGroup("pool");
        Object[] objectArray = new ConnectionRunner[size];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = new ConnectionRunner(group, new Integer(i).toString());
            ((Thread)objectArray[i]).setContextClassLoader(Thread.currentThread().getContextClassLoader());
            ((Thread)objectArray[i]).start();
        }
        freelist = new ArrayList(Arrays.asList(objectArray));
    }

    public static class ConnectionRunner
    extends Thread {
        private UnicastConnection conn;
        private volatile boolean exiting;

        private /* synthetic */ void finit$() {
            this.exiting = false;
        }

        public ConnectionRunner(ThreadGroup threadGroup, String string) {
            super(threadGroup, string);
            this.finit$();
        }

        public synchronized void run() {
            while (!this.exiting) {
                if (this.conn == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                this.conn.run();
                this.conn = null;
                Class clazz = ConnectionRunnerPool.class$("gnu.java.rmi.server.ConnectionRunnerPool");
                synchronized (clazz) {
                    Object var2_3;
                    block7: {
                        try {
                            freelist.add(this);
                            if (freelist.size() != 1) break block7;
                            ConnectionRunnerPool.class$("gnu.java.rmi.server.ConnectionRunnerPool").notifyAll();
                        }
                        catch (Throwable throwable) {
                            var2_3 = null;
                            throw throwable;
                        }
                    }
                    var2_3 = null;
                }
            }
        }

        public synchronized void dispatch(UnicastConnection unicastConnection) {
            this.conn = unicastConnection;
            this.notify();
        }

        void exit() {
            this.exiting = true;
            if (this.conn != null) {
                try {
                    this.join(500);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.interrupt();
        }
    }
}

