/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import gnu.java.nio.VMChannel;
import gnu.java.nio.VMPipe;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Pipe;
import java.nio.channels.spi.SelectorProvider;

class PipeImpl
extends Pipe {
    private SinkChannelImpl sink;
    private SourceChannelImpl source;

    public PipeImpl(SelectorProvider selectorProvider) throws IOException {
        VMPipe.init(this, selectorProvider);
    }

    public Pipe.SinkChannel sink() {
        return this.sink;
    }

    public Pipe.SourceChannel source() {
        return this.source;
    }

    public static final class SinkChannelImpl
    extends Pipe.SinkChannel {
        private int native_fd;
        private VMChannel vmch;

        public SinkChannelImpl(SelectorProvider selectorProvider, int n) {
            super(selectorProvider);
            this.native_fd = n;
            this.vmch = VMChannel.getVMChannel(this);
        }

        protected final void implCloseSelectableChannel() throws IOException {
            throw new Error("Not implemented");
        }

        protected final void implConfigureBlocking(boolean bl) throws IOException {
            this.vmch.setBlocking(bl);
        }

        public final int write(ByteBuffer byteBuffer) throws IOException {
            return this.vmch.write(byteBuffer);
        }

        public final long write(ByteBuffer[] byteBufferArray) throws IOException {
            return this.vmch.writeGathering(byteBufferArray, 0, byteBufferArray.length);
        }

        public final synchronized long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
            if (n < 0 || n > byteBufferArray.length || n2 < 0 || n2 > byteBufferArray.length - n) {
                throw new IndexOutOfBoundsException();
            }
            return this.vmch.writeGathering(byteBufferArray, n, n2);
        }

        public final int getNativeFD() {
            return this.native_fd;
        }
    }

    public static final class SourceChannelImpl
    extends Pipe.SourceChannel {
        private int native_fd;
        private VMChannel vmch;

        public SourceChannelImpl(SelectorProvider selectorProvider, int n) {
            super(selectorProvider);
            this.native_fd = n;
            this.vmch = VMChannel.getVMChannel(this);
        }

        protected final void implCloseSelectableChannel() throws IOException {
            throw new Error("Not implemented");
        }

        protected void implConfigureBlocking(boolean bl) throws IOException {
            this.vmch.setBlocking(bl);
        }

        public final int read(ByteBuffer byteBuffer) throws IOException {
            return this.vmch.read(byteBuffer);
        }

        public final long read(ByteBuffer[] byteBufferArray) throws IOException {
            return this.vmch.readScattering(byteBufferArray, 0, byteBufferArray.length);
        }

        public final synchronized long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
            if (n < 0 || n > byteBufferArray.length || n2 < 0 || n2 > byteBufferArray.length - n) {
                throw new IndexOutOfBoundsException();
            }
            return this.vmch.readScattering(byteBufferArray, n, n2);
        }

        public final int getNativeFD() {
            return this.native_fd;
        }
    }
}

