/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.qt;

import gnu.java.awt.peer.qt.QtScreenDevice;
import gnu.java.awt.peer.qt.QtVolatileImage;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.ImageCapabilities;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.VolatileImage;

public class QtScreenDeviceConfiguration
extends GraphicsConfiguration {
    private QtScreenDevice owner;
    private Rectangle bounds;
    private double dpiX;
    private double dpiY;
    private int depth;

    public QtScreenDeviceConfiguration(QtScreenDevice qtScreenDevice) {
        this.owner = qtScreenDevice;
        this.bounds = qtScreenDevice.getBounds();
        this.dpiX = qtScreenDevice.getDpiX();
        this.dpiY = qtScreenDevice.getDpiY();
        this.depth = qtScreenDevice.depth();
    }

    public BufferedImage createCompatibleImage(int n, int n2) {
        switch (this.depth) {
            case 24: {
                return new BufferedImage(n, n2, 5);
            }
            case 16: {
                return new BufferedImage(n, n2, 8);
            }
            case 8: {
                return new BufferedImage(n, n2, 13);
            }
        }
        return new BufferedImage(n, n2, 1);
    }

    public BufferedImage createCompatibleImage(int n, int n2, int n3) {
        if (this.depth == 32) {
            return new BufferedImage(n, n2, 2);
        }
        return this.createCompatibleImage(n, n2);
    }

    public VolatileImage createCompatibleVolatileImage(int n, int n2) {
        return new QtVolatileImage(n, n2);
    }

    public VolatileImage createCompatibleVolatileImage(int n, int n2, ImageCapabilities imageCapabilities) {
        return this.createCompatibleVolatileImage(n, n2);
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public ColorModel getColorModel() {
        return Toolkit.getDefaultToolkit().getColorModel();
    }

    public ColorModel getColorModel(int n) {
        return Toolkit.getDefaultToolkit().getColorModel();
    }

    public AffineTransform getDefaultTransform() {
        return new AffineTransform();
    }

    public GraphicsDevice getDevice() {
        return this.owner;
    }

    public AffineTransform getNormalizingTransform() {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.scale(72.0 / this.dpiX, 72.0 / this.dpiY);
        return affineTransform;
    }

    public VolatileImage createCompatibleVolatileImage(int n, int n2, int n3) {
        return this.createCompatibleVolatileImage(n, n2);
    }
}

