/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer;

import gnu.java.awt.ClasspathToolkit;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.font.TransformAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.peer.FontPeer;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIterator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public abstract class ClasspathFontPeer
implements FontPeer {
    protected String logicalName;
    protected String familyName;
    protected String faceName;
    protected int style;
    protected float size;
    protected AffineTransform transform;

    protected static ClasspathToolkit tk() {
        return (ClasspathToolkit)Toolkit.getDefaultToolkit();
    }

    protected static boolean isLogicalFontName(String string) {
        String string2 = string.toUpperCase();
        return string2.equals("SANSSERIF") || string2.equals("SERIF") || string2.equals("MONOSPACED") || string2.equals("DIALOG") || string2.equals("DIALOGINPUT") || string2.equals("DEFAULT");
    }

    protected static String logicalFontNameToFaceName(String string) {
        String string2 = string.toUpperCase();
        if (string2.equals("SANSSERIF")) {
            return "Helvetica";
        }
        if (string2.equals("SERIF")) {
            return "Times";
        }
        if (string2.equals("MONOSPACED")) {
            return "Courier";
        }
        if (string2.equals("DIALOG")) {
            return "Helvetica";
        }
        if (string2.equals("DIALOGINPUT")) {
            return "Helvetica";
        }
        if (string2.equals("DEFAULT")) {
            return "Dialog.plain";
        }
        return "Helvetica";
    }

    protected static String faceNameToFamilyName(String string) {
        return string;
    }

    public static void copyStyleToAttrs(int n, Map map) {
        if ((n & 1) == 1) {
            map.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        } else {
            map.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR);
        }
        if ((n & 2) == 2) {
            map.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        } else {
            map.put(TextAttribute.POSTURE, TextAttribute.POSTURE_REGULAR);
        }
    }

    protected static void copyFamilyToAttrs(String string, Map map) {
        if (string != null) {
            map.put(TextAttribute.FAMILY, string);
        }
    }

    public static void copySizeToAttrs(float f, Map map) {
        map.put(TextAttribute.SIZE, new Float(f));
    }

    protected static void copyTransformToAttrs(AffineTransform affineTransform, Map map) {
        if (affineTransform != null) {
            map.put(TextAttribute.TRANSFORM, new TransformAttribute(affineTransform));
        }
    }

    protected void setStandardAttributes(String string, String string2, int n, float f, AffineTransform affineTransform) {
        this.logicalName = string;
        this.faceName = ClasspathFontPeer.isLogicalFontName(string) ? ClasspathFontPeer.logicalFontNameToFaceName(string) : string;
        this.familyName = string2 != null ? string2 : ClasspathFontPeer.faceNameToFamilyName(this.faceName);
        this.style = n;
        this.size = f;
        this.transform = affineTransform;
    }

    protected void setStandardAttributes(String string, Map map) {
        Serializable serializable;
        String string2 = this.familyName;
        AffineTransform affineTransform = this.transform;
        float f = this.size;
        int n = this.style;
        if (map.containsKey(TextAttribute.FAMILY)) {
            string2 = (String)map.get(TextAttribute.FAMILY);
        }
        if (string == null) {
            string = "Default";
        }
        if (map.containsKey(TextAttribute.WEIGHT) && ((Float)(serializable = (Float)map.get(TextAttribute.WEIGHT))).floatValue() >= TextAttribute.WEIGHT_BOLD.floatValue()) {
            ++n;
        }
        if (map.containsKey(TextAttribute.POSTURE) && ((Float)(serializable = (Float)map.get(TextAttribute.POSTURE))).floatValue() >= TextAttribute.POSTURE_OBLIQUE.floatValue()) {
            n += 2;
        }
        if (map.containsKey(TextAttribute.SIZE)) {
            serializable = (Float)map.get(TextAttribute.SIZE);
            f = ((Float)serializable).floatValue();
            if (f < 1.0f) {
                f = 1.0f;
            }
        } else {
            f = 12.0f;
        }
        if (map.containsKey(TextAttribute.TRANSFORM)) {
            serializable = (TransformAttribute)map.get(TextAttribute.TRANSFORM);
            affineTransform = ((TransformAttribute)serializable).getTransform();
        }
        this.setStandardAttributes(string, string2, n, f, affineTransform);
    }

    protected void getStandardAttributes(Map map) {
        ClasspathFontPeer.copyFamilyToAttrs(this.familyName, map);
        ClasspathFontPeer.copySizeToAttrs(this.size, map);
        ClasspathFontPeer.copyStyleToAttrs(this.style, map);
        ClasspathFontPeer.copyTransformToAttrs(this.transform, map);
    }

    public ClasspathFontPeer(String string, Map map) {
        this.setStandardAttributes(string, map);
    }

    public ClasspathFontPeer(String string, int n, int n2) {
        this.setStandardAttributes(string, null, n, n2, null);
    }

    public String getName(Font font) {
        return this.logicalName;
    }

    public String getFamily(Font font) {
        return this.familyName;
    }

    public String getFamily(Font font, Locale locale) {
        return this.familyName;
    }

    public String getFontName(Font font) {
        return this.faceName;
    }

    public String getFontName(Font font, Locale locale) {
        return this.faceName;
    }

    public float getSize(Font font) {
        return this.size;
    }

    public boolean isPlain(Font font) {
        return this.style == 0;
    }

    public boolean isBold(Font font) {
        return (this.style & 1) != 0;
    }

    public boolean isItalic(Font font) {
        return (this.style & 2) != 0;
    }

    public Font deriveFont(Font font, int n, float f) {
        HashMap hashMap = new HashMap();
        this.getStandardAttributes(hashMap);
        ClasspathFontPeer.copyStyleToAttrs(n, hashMap);
        ClasspathFontPeer.copySizeToAttrs(f, hashMap);
        return ClasspathFontPeer.tk().getFont(this.logicalName, hashMap);
    }

    public Font deriveFont(Font font, float f) {
        HashMap hashMap = new HashMap();
        this.getStandardAttributes(hashMap);
        ClasspathFontPeer.copySizeToAttrs(f, hashMap);
        return ClasspathFontPeer.tk().getFont(this.logicalName, hashMap);
    }

    public Font deriveFont(Font font, int n) {
        HashMap hashMap = new HashMap();
        this.getStandardAttributes(hashMap);
        ClasspathFontPeer.copyStyleToAttrs(n, hashMap);
        return ClasspathFontPeer.tk().getFont(this.logicalName, hashMap);
    }

    public Font deriveFont(Font font, int n, AffineTransform affineTransform) {
        HashMap hashMap = new HashMap();
        this.getStandardAttributes(hashMap);
        ClasspathFontPeer.copyStyleToAttrs(n, hashMap);
        ClasspathFontPeer.copyTransformToAttrs(affineTransform, hashMap);
        return ClasspathFontPeer.tk().getFont(this.logicalName, hashMap);
    }

    public Font deriveFont(Font font, AffineTransform affineTransform) {
        HashMap hashMap = new HashMap();
        this.getStandardAttributes(hashMap);
        ClasspathFontPeer.copyTransformToAttrs(affineTransform, hashMap);
        return ClasspathFontPeer.tk().getFont(this.logicalName, hashMap);
    }

    public Font deriveFont(Font font, Map map) {
        return ClasspathFontPeer.tk().getFont(this.logicalName, map);
    }

    public Map getAttributes(Font font) {
        HashMap hashMap = new HashMap();
        this.getStandardAttributes(hashMap);
        return hashMap;
    }

    public AttributedCharacterIterator.Attribute[] getAvailableAttributes(Font font) {
        AttributedCharacterIterator.Attribute[] attributeArray = new AttributedCharacterIterator.Attribute[]{TextAttribute.FAMILY, TextAttribute.SIZE, TextAttribute.POSTURE, TextAttribute.WEIGHT, TextAttribute.TRANSFORM};
        return attributeArray;
    }

    public AffineTransform getTransform(Font font) {
        if (this.transform == null) {
            this.transform = new AffineTransform();
        }
        return this.transform;
    }

    public boolean isTransformed(Font font) {
        return this.transform.isIdentity() ^ true;
    }

    public float getItalicAngle(Font font) {
        if ((this.style & 2) == 2) {
            return TextAttribute.POSTURE_OBLIQUE.floatValue();
        }
        return TextAttribute.POSTURE_REGULAR.floatValue();
    }

    public int getStyle(Font font) {
        return this.style;
    }

    public abstract boolean canDisplay(Font var1, char var2);

    public abstract int canDisplayUpTo(Font var1, CharacterIterator var2, int var3, int var4);

    public abstract String getSubFamilyName(Font var1, Locale var2);

    public abstract String getPostScriptName(Font var1);

    public abstract int getNumGlyphs(Font var1);

    public abstract int getMissingGlyphCode(Font var1);

    public abstract byte getBaselineFor(Font var1, char var2);

    public abstract String getGlyphName(Font var1, int var2);

    public abstract GlyphVector createGlyphVector(Font var1, FontRenderContext var2, CharacterIterator var3);

    public abstract GlyphVector createGlyphVector(Font var1, FontRenderContext var2, int[] var3);

    public abstract GlyphVector layoutGlyphVector(Font var1, FontRenderContext var2, char[] var3, int var4, int var5, int var6);

    public abstract FontMetrics getFontMetrics(Font var1);

    public abstract boolean hasUniformLineMetrics(Font var1);

    public abstract LineMetrics getLineMetrics(Font var1, CharacterIterator var2, int var3, int var4, FontRenderContext var5);

    public abstract Rectangle2D getMaxCharBounds(Font var1, FontRenderContext var2);

    public abstract Rectangle2D getStringBounds(Font var1, CharacterIterator var2, int var3, int var4, FontRenderContext var5);
}

