/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.keytool;

import gnu.classpath.Configuration;
import gnu.classpath.tools.common.ProviderUtil;
import gnu.classpath.tools.getopt.ClasspathToolParser;
import gnu.classpath.tools.getopt.Option;
import gnu.classpath.tools.getopt.OptionException;
import gnu.classpath.tools.getopt.OptionGroup;
import gnu.classpath.tools.getopt.Parser;
import gnu.classpath.tools.keytool.CACertCmd;
import gnu.classpath.tools.keytool.CertReqCmd;
import gnu.classpath.tools.keytool.Command;
import gnu.classpath.tools.keytool.DeleteCmd;
import gnu.classpath.tools.keytool.ExportCmd;
import gnu.classpath.tools.keytool.GenKeyCmd;
import gnu.classpath.tools.keytool.IdentityDBCmd;
import gnu.classpath.tools.keytool.ImportCmd;
import gnu.classpath.tools.keytool.KeyCloneCmd;
import gnu.classpath.tools.keytool.KeyPasswdCmd;
import gnu.classpath.tools.keytool.ListCmd;
import gnu.classpath.tools.keytool.Messages;
import gnu.classpath.tools.keytool.PrintCertCmd;
import gnu.classpath.tools.keytool.SelfCertCmd;
import gnu.classpath.tools.keytool.StorePasswdCmd;
import gnu.javax.crypto.jce.GnuCrypto;
import gnu.javax.security.auth.callback.GnuCallbacks;
import java.security.Provider;
import java.util.logging.Logger;

public class Main {
    private static final Logger log = Logger.getLogger(Main.class$("gnu.classpath.tools.keytool.Main").getName());
    static final String KEYTOOL_TOOL = "keytool";
    static final String GENKEY_CMD = "genkey";
    static final String IMPORT_CMD = "import";
    static final String SELFCERT_CMD = "selfcert";
    static final String IDENTITYDB_CMD = "identitydb";
    static final String CERTREQ_CMD = "certreq";
    static final String EXPORT_CMD = "export";
    static final String LIST_CMD = "list";
    static final String PRINTCERT_CMD = "printcert";
    static final String KEYCLONE_CMD = "keyclone";
    static final String STOREPASSWD_CMD = "storepasswd";
    static final String KEYPASSWD_CMD = "keypasswd";
    static final String DELETE_CMD = "delete";
    static final String CACERT_CMD = "cacert";
    static final String _GENKEY = "-genkey";
    static final String _IMPORT = "-import";
    static final String _SELFCERT = "-selfcert";
    static final String _IDENTITYDB = "-identitydb";
    static final String _CERTREQ = "-certreq";
    static final String _EXPORT = "-export";
    static final String _LIST = "-list";
    static final String _PRINTCERT = "-printcert";
    static final String _KEYCLONE = "-keyclone";
    static final String _STOREPASSWD = "-storepasswd";
    static final String _KEYPASSWD = "-keypasswd";
    static final String _DELETE = "-delete";
    static final String _HELP = "-help";
    static final String _CACERT = "-cacert";
    static final String ALIAS_OPT = "alias";
    static final String SIGALG_OPT = "sigalg";
    static final String KEYALG_OPT = "keyalg";
    static final String KEYSIZE_OPT = "keysize";
    static final String KEYPASS_OPT = "keypass";
    static final String VALIDITY_OPT = "validity";
    static final String STORETYPE_OPT = "storetype";
    static final String STOREPASS_OPT = "storepass";
    static final String KEYSTORE_OPT = "keystore";
    static final String PROVIDER_OPT = "provider";
    static final String FILE_OPT = "file";
    static final String VERBOSE_OPT = "v";
    static final String DEST_OPT = "dest";
    static final String NEW_OPT = "new";
    static final String RFC_OPT = "rfc";
    static final String DNAME_OPT = "dname";
    static final String LAST_SERIAL_NUMBER = "lastSerialNumber";
    static final String X_509 = "X.509";
    private boolean helpPrinted;
    private int gnuCryptoProviderNdx;
    private int gnuCallbacksNdx;
    private Parser cmdLineParser;
    private ShutdownHook shutdownThread;

    private /* synthetic */ void finit$() {
        this.gnuCryptoProviderNdx = -2;
        this.gnuCallbacksNdx = -2;
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private Main() {
        this.finit$();
        this.shutdownThread = new ShutdownHook(this);
        Runtime.getRuntime().addShutdownHook(this.shutdownThread);
    }

    public static final void main(String[] stringArray) {
        int n;
        block12: {
            if (Configuration.DEBUG) {
                log.entering(Main.class$("gnu.classpath.tools.keytool.Main").getName(), "main", stringArray);
            }
            Main main = new Main();
            n = 1;
            try {
                try {
                    main.setup();
                    main.start(stringArray);
                    n = 0;
                }
                catch (OptionException optionException) {
                    System.err.println(optionException.getMessage());
                    if (main.cmdLineParser != null) {
                        main.cmdLineParser.printHelp();
                    }
                }
                catch (SecurityException securityException) {
                    if (Configuration.DEBUG) {
                        log.throwing(Main.class$("gnu.classpath.tools.keytool.Main").getName(), "main", securityException);
                    }
                    System.err.println(Messages.getFormattedString("Main.6", securityException.getMessage()));
                }
                catch (Exception exception) {
                    if (Configuration.DEBUG) {
                        log.throwing(Main.class$("gnu.classpath.tools.keytool.Main").getName(), "main", exception);
                    }
                    System.err.println(Messages.getFormattedString("Main.8", exception));
                }
                Object var3_6 = null;
                main.teardown();
                if (main.shutdownThread == null) break block12;
                Runtime.getRuntime().removeShutdownHook(main.shutdownThread);
            }
            catch (Throwable throwable) {
                Object var3_7 = null;
                main.teardown();
                if (main.shutdownThread != null) {
                    Runtime.getRuntime().removeShutdownHook(main.shutdownThread);
                }
                throw throwable;
            }
        }
        if (Configuration.DEBUG) {
            log.exiting(Main.class$("gnu.classpath.tools.keytool.Main").getName(), "main", n);
        }
        System.exit(n);
    }

    private void setup() {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "setup");
        }
        this.cmdLineParser = this.getParser();
        this.gnuCryptoProviderNdx = ProviderUtil.addProvider((Provider)new GnuCrypto());
        this.gnuCallbacksNdx = ProviderUtil.addProvider((Provider)new GnuCallbacks());
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "setup");
        }
    }

    private void start(String[] stringArray) throws Exception {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "start");
        }
        if (stringArray == null || stringArray.length == 0) {
            throw new OptionException("");
        }
        while (stringArray.length > 0) {
            String string = stringArray[0];
            Command command = null;
            if (_GENKEY.equals(string)) {
                command = new GenKeyCmd();
            } else if (_IMPORT.equals(string)) {
                command = new ImportCmd();
            } else if (_SELFCERT.equals(string)) {
                command = new SelfCertCmd();
            } else if (_IDENTITYDB.equals(string)) {
                command = new IdentityDBCmd();
            } else if (_CERTREQ.equals(string)) {
                command = new CertReqCmd();
            } else if (_EXPORT.equals(string)) {
                command = new ExportCmd();
            } else if (_LIST.equals(string)) {
                command = new ListCmd();
            } else if (_PRINTCERT.equals(string)) {
                command = new PrintCertCmd();
            } else if (_KEYCLONE.equals(string)) {
                command = new KeyCloneCmd();
            } else if (_STOREPASSWD.equals(string)) {
                command = new StorePasswdCmd();
            } else if (_KEYPASSWD.equals(string)) {
                command = new KeyPasswdCmd();
            } else if (_DELETE.equals(string)) {
                command = new DeleteCmd();
            } else if (_CACERT.equals(string)) {
                command = new CACertCmd();
            } else {
                if (_HELP.equals(string)) {
                    throw new OptionException("");
                }
                throw new OptionException(Messages.getFormattedString("Main.18", string));
            }
            String[] stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
            stringArray = command.processArgs(stringArray2);
            command.doCommand();
        }
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "start");
        }
    }

    private Parser getParser() {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "getParser");
        }
        ClasspathToolParser classpathToolParser = new ClasspathToolParser(KEYTOOL_TOOL, true);
        classpathToolParser.setHeader(Messages.getString("Main.19"));
        classpathToolParser.setFooter(Messages.getString("Main.20"));
        OptionGroup optionGroup = new OptionGroup(Messages.getString("Main.21"));
        optionGroup.add(new NoParseOption(this, GENKEY_CMD, Messages.getString("Main.22")));
        optionGroup.add(new NoParseOption(this, IMPORT_CMD, Messages.getString("Main.23")));
        optionGroup.add(new NoParseOption(this, SELFCERT_CMD, Messages.getString("Main.24")));
        optionGroup.add(new NoParseOption(this, IDENTITYDB_CMD, Messages.getString("Main.25")));
        optionGroup.add(new NoParseOption(this, CERTREQ_CMD, Messages.getString("Main.26")));
        optionGroup.add(new NoParseOption(this, EXPORT_CMD, Messages.getString("Main.27")));
        optionGroup.add(new NoParseOption(this, LIST_CMD, Messages.getString("Main.28")));
        optionGroup.add(new NoParseOption(this, PRINTCERT_CMD, Messages.getString("Main.29")));
        optionGroup.add(new NoParseOption(this, KEYCLONE_CMD, Messages.getString("Main.30")));
        optionGroup.add(new NoParseOption(this, STOREPASSWD_CMD, Messages.getString("Main.31")));
        optionGroup.add(new NoParseOption(this, KEYPASSWD_CMD, Messages.getString("Main.32")));
        optionGroup.add(new NoParseOption(this, DELETE_CMD, Messages.getString("Main.33")));
        optionGroup.add(new NoParseOption(this, CACERT_CMD, Messages.getString("Main.5")));
        classpathToolParser.add(optionGroup);
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "getParser", classpathToolParser);
        }
        return classpathToolParser;
    }

    void teardown() {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "teardown");
        }
        if (this.gnuCryptoProviderNdx > 0) {
            ProviderUtil.removeProvider("GNU-CRYPTO");
        }
        if (this.gnuCallbacksNdx > 0) {
            ProviderUtil.removeProvider("GNU-CALLBACKS");
        }
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "teardown");
        }
    }

    private void printHelp() {
        if (this.helpPrinted) {
            return;
        }
        this.helpPrinted = true;
    }

    static {
        KEYTOOL_TOOL = KEYTOOL_TOOL;
        GENKEY_CMD = GENKEY_CMD;
        IMPORT_CMD = IMPORT_CMD;
        SELFCERT_CMD = SELFCERT_CMD;
        IDENTITYDB_CMD = IDENTITYDB_CMD;
        CERTREQ_CMD = CERTREQ_CMD;
        EXPORT_CMD = EXPORT_CMD;
        LIST_CMD = LIST_CMD;
        PRINTCERT_CMD = PRINTCERT_CMD;
        KEYCLONE_CMD = KEYCLONE_CMD;
        STOREPASSWD_CMD = STOREPASSWD_CMD;
        KEYPASSWD_CMD = KEYPASSWD_CMD;
        DELETE_CMD = DELETE_CMD;
        CACERT_CMD = CACERT_CMD;
        _GENKEY = _GENKEY;
        _IMPORT = _IMPORT;
        _SELFCERT = _SELFCERT;
        _IDENTITYDB = _IDENTITYDB;
        _CERTREQ = _CERTREQ;
        _EXPORT = _EXPORT;
        _LIST = _LIST;
        _PRINTCERT = _PRINTCERT;
        _KEYCLONE = _KEYCLONE;
        _STOREPASSWD = _STOREPASSWD;
        _KEYPASSWD = _KEYPASSWD;
        _DELETE = _DELETE;
        _HELP = _HELP;
        _CACERT = _CACERT;
        ALIAS_OPT = ALIAS_OPT;
        SIGALG_OPT = SIGALG_OPT;
        KEYALG_OPT = KEYALG_OPT;
        KEYSIZE_OPT = KEYSIZE_OPT;
        KEYPASS_OPT = KEYPASS_OPT;
        VALIDITY_OPT = VALIDITY_OPT;
        STORETYPE_OPT = STORETYPE_OPT;
        STOREPASS_OPT = STOREPASS_OPT;
        KEYSTORE_OPT = KEYSTORE_OPT;
        PROVIDER_OPT = PROVIDER_OPT;
        FILE_OPT = FILE_OPT;
        VERBOSE_OPT = VERBOSE_OPT;
        DEST_OPT = DEST_OPT;
        NEW_OPT = NEW_OPT;
        RFC_OPT = RFC_OPT;
        DNAME_OPT = DNAME_OPT;
        LAST_SERIAL_NUMBER = LAST_SERIAL_NUMBER;
        X_509 = X_509;
    }

    private class ShutdownHook
    extends Thread {
        private /* synthetic */ Main this$0;

        public void run() {
            this.this$0.teardown();
        }

        ShutdownHook(Main main) {
            this.this$0 = main;
        }
    }

    private class NoParseOption
    extends Option {
        private /* synthetic */ Main this$0;

        public NoParseOption(Main main, String string, String string2) {
            this.this$0 = main;
            super(string, string2);
        }

        public NoParseOption(Main main, String string, String string2, String string3) {
            this.this$0 = main;
            super(string, string2, string3);
        }

        public void parsed(String string) throws OptionException {
        }
    }
}

