/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.keytool;

import gnu.classpath.Configuration;
import gnu.classpath.tools.getopt.ClasspathToolParser;
import gnu.classpath.tools.getopt.Option;
import gnu.classpath.tools.getopt.OptionException;
import gnu.classpath.tools.getopt.OptionGroup;
import gnu.classpath.tools.getopt.Parser;
import gnu.classpath.tools.keytool.Command;
import gnu.classpath.tools.keytool.Messages;
import gnu.java.security.OID;
import gnu.java.security.der.BitString;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.der.DERWriter;
import gnu.java.security.util.Base64;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.x500.X500Principal;

class CertReqCmd
extends Command {
    private static final Logger log = Logger.getLogger(CertReqCmd.class$("gnu.classpath.tools.keytool.CertReqCmd").getName());
    private static final String ATTRIBUTES_OPT = "attributes";
    protected String _alias;
    protected String _sigAlgorithm;
    protected String _certReqFileName;
    protected String _password;
    protected String _ksType;
    protected String _ksURL;
    protected String _ksPassword;
    protected String _providerClassName;
    protected boolean nullAttributes;

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void setAlias(String string) {
        this._alias = string;
    }

    public void setSigalg(String string) {
        this._sigAlgorithm = string;
    }

    public void setFile(String string) {
        this._certReqFileName = string;
    }

    public void setKeypass(String string) {
        this._password = string;
    }

    public void setStoretype(String string) {
        this._ksType = string;
    }

    public void setKeystore(String string) {
        this._ksURL = string;
    }

    public void setStorepass(String string) {
        this._ksPassword = string;
    }

    public void setProvider(String string) {
        this._providerClassName = string;
    }

    public void setAttributes(String string) {
        this.nullAttributes = Boolean.valueOf(string);
    }

    void setup() throws Exception {
        this.setOutputStreamParam(this._certReqFileName);
        this.setKeyStoreParams(this._providerClassName, this._ksType, this._ksPassword, this._ksURL);
        this.setAliasParam(this._alias);
        this.setKeyPasswordNoPrompt(this._password);
        if (Configuration.DEBUG) {
            log.fine("-certreq handler will use the following options:");
            log.fine("  -alias=" + this.alias);
            log.fine("  -sigalg=" + this._sigAlgorithm);
            log.fine("  -file=" + this._certReqFileName);
            log.fine("  -storetype=" + this.storeType);
            log.fine("  -keystore=" + this.storeURL);
            log.fine("  -provider=" + this.provider);
            log.fine("  -v=" + this.verbose);
            log.fine("  -attributes=" + this.nullAttributes);
        }
    }

    void start() throws KeyStoreException, NoSuchAlgorithmException, IOException, UnsupportedCallbackException, UnrecoverableKeyException, InvalidKeyException, SignatureException {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "start");
        }
        Key key = this.getAliasPrivateKey();
        Certificate[] certificateArray = this.store.getCertificateChain(this.alias);
        X509Certificate x509Certificate = (X509Certificate)certificateArray[0];
        X500Principal x500Principal = x509Certificate.getIssuerX500Principal();
        PublicKey publicKey = x509Certificate.getPublicKey();
        this.setSignatureAlgorithmParam(this._sigAlgorithm, key);
        byte[] byArray = this.getCSR(x500Principal, publicKey, (PrivateKey)key);
        String string = Base64.encode((byte[])byArray, (int)0, (int)byArray.length, (boolean)true);
        PrintWriter printWriter = new PrintWriter(this.outStream, true);
        printWriter.println("-----BEGIN NEW CERTIFICATE REQUEST-----");
        printWriter.println(string);
        printWriter.println("-----END NEW CERTIFICATE REQUEST-----");
        if (this.verbose) {
            if (!this.systemOut) {
                System.out.println(Messages.getFormattedString("CertReqCmd.27", this._certReqFileName));
            }
            System.out.println(Messages.getString("CertReqCmd.28"));
        }
        printWriter.close();
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "start");
        }
    }

    Parser getParser() {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "getParser");
        }
        ClasspathToolParser classpathToolParser = new ClasspathToolParser("certreq", true);
        classpathToolParser.setHeader(Messages.getString("CertReqCmd.25"));
        classpathToolParser.setFooter(Messages.getString("CertReqCmd.24"));
        OptionGroup optionGroup = new OptionGroup(Messages.getString("CertReqCmd.23"));
        optionGroup.add(new Option(this, "alias", Messages.getString("CertReqCmd.22"), Messages.getString("CertReqCmd.21")){
            private /* synthetic */ CertReqCmd this$0;
            {
                this.this$0 = certReqCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._alias = string;
            }
        });
        optionGroup.add(new Option(this, "sigalg", Messages.getString("CertReqCmd.20"), Messages.getString("CertReqCmd.19")){
            private /* synthetic */ CertReqCmd this$0;
            {
                this.this$0 = certReqCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._sigAlgorithm = string;
            }
        });
        optionGroup.add(new Option(this, "file", Messages.getString("CertReqCmd.18"), Messages.getString("CertReqCmd.17")){
            private /* synthetic */ CertReqCmd this$0;
            {
                this.this$0 = certReqCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._certReqFileName = string;
            }
        });
        optionGroup.add(new Option(this, "keypass", Messages.getString("CertReqCmd.16"), Messages.getString("CertReqCmd.9")){
            private /* synthetic */ CertReqCmd this$0;
            {
                this.this$0 = certReqCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._password = string;
            }
        });
        optionGroup.add(new Option(this, "storetype", Messages.getString("CertReqCmd.14"), Messages.getString("CertReqCmd.13")){
            private /* synthetic */ CertReqCmd this$0;
            {
                this.this$0 = certReqCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._ksType = string;
            }
        });
        optionGroup.add(new Option(this, "keystore", Messages.getString("CertReqCmd.12"), Messages.getString("CertReqCmd.11")){
            private /* synthetic */ CertReqCmd this$0;
            {
                this.this$0 = certReqCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._ksURL = string;
            }
        });
        optionGroup.add(new Option(this, "storepass", Messages.getString("CertReqCmd.10"), Messages.getString("CertReqCmd.9")){
            private /* synthetic */ CertReqCmd this$0;
            {
                this.this$0 = certReqCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._ksPassword = string;
            }
        });
        optionGroup.add(new Option(this, "provider", Messages.getString("CertReqCmd.8"), Messages.getString("CertReqCmd.7")){
            private /* synthetic */ CertReqCmd this$0;
            {
                this.this$0 = certReqCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._providerClassName = string;
            }
        });
        optionGroup.add(new Option(this, "v", Messages.getString("CertReqCmd.6")){
            private /* synthetic */ CertReqCmd this$0;
            {
                this.this$0 = certReqCmd;
                super(string, string2);
            }

            public void parsed(String string) throws OptionException {
                this.this$0.verbose = true;
            }
        });
        optionGroup.add(new Option(this, ATTRIBUTES_OPT, Messages.getString("CertReqCmd.5")){
            private /* synthetic */ CertReqCmd this$0;
            {
                this.this$0 = certReqCmd;
                super(string, string2);
            }

            public void parsed(String string) throws OptionException {
                this.this$0.nullAttributes = true;
            }
        });
        classpathToolParser.add(optionGroup);
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "getParser", classpathToolParser);
        }
        return classpathToolParser;
    }

    private byte[] getCSR(X500Principal x500Principal, PublicKey publicKey, PrivateKey privateKey) throws IOException, InvalidKeyException, SignatureException {
        byte[] byArray;
        DERValue dERValue = new DERValue(2, (Object)BigInteger.ZERO);
        DERValue dERValue2 = new DERReader(x500Principal.getEncoded()).read();
        DERValue dERValue3 = new DERReader(publicKey.getEncoded()).read();
        if (this.nullAttributes) {
            byte[] byArray2 = new byte[2];
            byArray2[0] = 5;
            byArray = byArray2;
            byArray2[1] = 0;
        } else {
            byArray = new byte[]{};
        }
        byte[] byArray3 = byArray;
        DERValue dERValue4 = new DERValue(160, byArray3.length, (Object)byArray3, null);
        ArrayList<DERValue> arrayList = new ArrayList<DERValue>(4);
        arrayList.add(dERValue);
        arrayList.add(dERValue2);
        arrayList.add(dERValue3);
        arrayList.add(dERValue4);
        DERValue dERValue5 = new DERValue(48, arrayList);
        OID oID = this.getSignatureAlgorithmOID();
        DERValue dERValue6 = new DERValue(6, (Object)oID);
        ArrayList<DERValue> arrayList2 = new ArrayList<DERValue>(2);
        arrayList2.add(dERValue6);
        if (!oID.equals((Object)Command.SHA1_WITH_DSA)) {
            arrayList2.add(new DERValue(5, null));
        }
        arrayList2.trimToSize();
        DERValue dERValue7 = new DERValue(48, arrayList2);
        this.signatureAlgorithm.initSign(privateKey);
        this.signatureAlgorithm.update(dERValue5.getEncoded());
        byte[] byArray4 = this.signatureAlgorithm.sign();
        DERValue dERValue8 = new DERValue(3, (Object)new BitString(byArray4));
        ArrayList<DERValue> arrayList3 = new ArrayList<DERValue>(3);
        arrayList3.add(dERValue5);
        arrayList3.add(dERValue7);
        arrayList3.add(dERValue8);
        DERValue dERValue9 = new DERValue(48, arrayList3);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DERWriter.write((OutputStream)byteArrayOutputStream, (DERValue)dERValue9);
        byte[] byArray5 = byteArrayOutputStream.toByteArray();
        return byArray5;
    }

    CertReqCmd() {
    }

    static {
        ATTRIBUTES_OPT = ATTRIBUTES_OPT;
    }
}

