/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IDebugHelpContextIds;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.viewers.AsynchronousTreeNavigationDialog;
import org.eclipse.debug.internal.ui.viewers.AsynchronousTreeViewer;
import org.eclipse.debug.internal.ui.viewers.ILabelResult;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IUpdate;

public class FindElementAction
extends Action
implements IUpdate {
    private AsynchronousTreeViewer fViewer;
    private IViewPart fView;
    private List fLabelResults;
    private Map fElementToResult = new HashMap();

    public FindElementAction(IViewPart view, AsynchronousTreeViewer viewer) {
        this.setText(ActionMessages.FindAction_0);
        this.setId(String.valueOf(DebugUIPlugin.getUniqueIdentifier()) + ".FindElementAction");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, IDebugHelpContextIds.FIND_ELEMENT_ACTION);
        this.setActionDefinitionId("org.eclipse.ui.edit.findReplace");
        this.fViewer = viewer;
        this.fView = view;
    }

    public void run() {
        final Object element = this.fViewer.getControl().getData();
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                FindElementAction.this.fLabelResults = FindElementAction.this.fViewer.buildLabels(monitor, element, DebugUIPlugin.removeAccelerators(ActionMessages.FindAction_0));
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
            }
        };
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.fView.getSite().getShell());
        dialog.setCancelable(true);
        try {
            dialog.run(true, true, runnable);
        }
        catch (InvocationTargetException e) {
            DebugUIPlugin.log(e);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        for (ILabelResult result : this.fLabelResults) {
            this.fElementToResult.put(result.getElement(), result);
        }
        this.performFind();
        this.fElementToResult.clear();
        this.fLabelResults.clear();
    }

    protected void performFind() {
        ILabelResult result;
        TreePath treePath;
        Object[] elements;
        AsynchronousTreeNavigationDialog dialog = new AsynchronousTreeNavigationDialog(this.fView.getSite().getShell(), (ILabelProvider)new FindLabelProvider(), this.fElementToResult.keySet().toArray());
        dialog.setTitle(ActionMessages.FindDialog_3);
        dialog.setMessage(ActionMessages.FindDialog_1);
        if (dialog.open() == 0 && (elements = dialog.getResult()).length == 1 && (treePath = (result = (ILabelResult)this.fElementToResult.get(elements[0])).getTreePath()) != null) {
            this.fViewer.setSelection((ISelection)new TreeSelection(treePath), true, true);
        }
    }

    public void update() {
        this.setEnabled(this.fViewer.getInput() != null);
    }

    class FindLabelProvider
    extends LabelProvider {
        public Image getImage(Object element) {
            Image[] images;
            ILabelResult result = (ILabelResult)FindElementAction.this.fElementToResult.get(element);
            if (result != null && (images = result.getImages()) != null && images.length > 0) {
                return images[0];
            }
            return null;
        }

        public String getText(Object element) {
            String[] labels;
            ILabelResult result = (ILabelResult)FindElementAction.this.fElementToResult.get(element);
            if (result != null && (labels = result.getLabels()) != null && labels.length > 0) {
                return labels[0];
            }
            return "";
        }
    }
}

