/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringContribution;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IScriptableRefactoring;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringContribution;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;

public final class JavaRefactoringDescriptor
extends RefactoringDescriptor {
    public static final String ATTRIBUTE_ELEMENT = "element";
    public static final String ATTRIBUTE_INPUT = "input";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_SELECTION = "selection";
    private static final String ATTRIBUTE_VERSION = "version";
    public static final int DEPRECATION_RESOLVING = 131072;
    public static final int JAR_IMPORTABLE = 65536;
    public static final int JAR_REFACTORABLE = 524288;
    public static final int JAR_SOURCE_ATTACHMENT = 262144;
    private static final String VALUE_VERSION_1_0 = "1.0";
    private final Map fArguments;
    private JavaRefactoringContribution fContribution;

    public static String elementToHandle(String project, IJavaElement element) {
        String handle = element.getHandleIdentifier();
        if (project != null && !(element instanceof IJavaProject)) {
            String id = element.getJavaProject().getHandleIdentifier();
            return handle.substring(id.length());
        }
        return handle;
    }

    public static IJavaElement handleToElement(String project, String handle) {
        return JavaRefactoringDescriptor.handleToElement(project, handle, true);
    }

    public static IJavaElement handleToElement(String project, String handle, boolean check) {
        return JavaRefactoringDescriptor.handleToElement(null, project, handle, check);
    }

    public static IJavaElement handleToElement(WorkingCopyOwner owner, String project, String handle, boolean check) {
        IMethod method;
        IMethod[] methods;
        IJavaElement element = null;
        element = owner != null ? JavaCore.create((String)handle, (WorkingCopyOwner)owner) : JavaCore.create((String)handle);
        if (element == null && project != null) {
            IJavaProject javaProject = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProject(project);
            String identifier = javaProject.getHandleIdentifier();
            element = owner != null ? JavaCore.create((String)(String.valueOf(identifier) + handle), (WorkingCopyOwner)owner) : JavaCore.create((String)(String.valueOf(identifier) + handle));
        }
        if (check && element instanceof IMethod && (methods = (method = (IMethod)element).getDeclaringType().findMethods(method)) != null && methods.length > 0) {
            element = methods[0];
        }
        if (element != null && (!check || element.exists())) {
            return element;
        }
        return null;
    }

    public static IResource handleToResource(String project, String handle) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if ("".equals(handle)) {
            return null;
        }
        IPath path = Path.fromPortableString((String)handle);
        if (path == null) {
            return null;
        }
        if (project != null && !"".equals(project)) {
            return root.getProject(project).findMember(path);
        }
        return root.findMember(path);
    }

    public static String resourceToHandle(String project, IResource resource) {
        if (project != null && !"".equals(project)) {
            return resource.getProjectRelativePath().toPortableString();
        }
        return resource.getFullPath().toPortableString();
    }

    public JavaRefactoringDescriptor(JavaRefactoringContribution contribution, String id, String project, String description, String comment, Map arguments, int flags) {
        super(id, project, description, comment, flags);
        Assert.isNotNull((Object)arguments);
        this.fContribution = contribution;
        this.fArguments = arguments;
    }

    public JavaRefactoringDescriptor(String id, String project, String description, String comment, Map arguments, int flags) {
        this(null, id, project, description, comment, arguments, flags);
    }

    public RefactoringArguments createArguments() {
        JavaRefactoringArguments arguments = new JavaRefactoringArguments(this.getProject());
        for (Map.Entry entry : this.fArguments.entrySet()) {
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (name == null || "".equals(name) || value == null) continue;
            arguments.setAttribute(name, value);
        }
        return arguments;
    }

    public Refactoring createRefactoring(RefactoringStatus status) throws CoreException {
        Refactoring refactoring = null;
        if (this.fContribution != null) {
            refactoring = this.fContribution.createRefactoring(this);
        } else {
            RefactoringContribution contribution = RefactoringCore.getRefactoringContribution((String)this.getID());
            if (contribution instanceof JavaRefactoringContribution) {
                this.fContribution = (JavaRefactoringContribution)contribution;
                refactoring = this.fContribution.createRefactoring(this);
            }
        }
        if (refactoring != null) {
            if (refactoring instanceof IScriptableRefactoring) {
                RefactoringStatus result = ((IScriptableRefactoring)refactoring).initialize(this.createArguments());
                if (result.hasFatalError()) {
                    throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, result.getMessageMatchingSeverity(4), null));
                }
                status.merge(result);
            } else {
                throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, Messages.format(RefactoringCoreMessages.JavaRefactoringDescriptor_initialization_error, this.getDescription()), null));
            }
        }
        return refactoring;
    }

    public String elementToHandle(IJavaElement element) {
        Assert.isNotNull((Object)element);
        return JavaRefactoringDescriptor.elementToHandle(this.getProject(), element);
    }

    public Map getArguments() {
        HashMap<String, String> map = new HashMap<String, String>(this.fArguments);
        map.put(ATTRIBUTE_VERSION, VALUE_VERSION_1_0);
        return map;
    }

    public JavaRefactoringContribution getContribution() {
        return this.fContribution;
    }
}

