/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import org.eclipse.core.runtime.adaptor.EclipseStarter;
import org.eclipse.core.runtime.internal.adaptor.EclipseAdaptorMsg;
import org.eclipse.core.runtime.internal.adaptor.Semaphore;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.internal.profile.Profile;
import org.eclipse.osgi.service.runnable.ApplicationLauncher;
import org.eclipse.osgi.service.runnable.ApplicationRunnable;
import org.eclipse.osgi.service.runnable.ParameterizedRunnable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class EclipseAppLauncher
implements ApplicationLauncher {
    private ParameterizedRunnable runnable = null;
    private Object appContext = null;
    private Semaphore runningLock = new Semaphore(1);
    private Semaphore waitForAppLock = new Semaphore(0);
    private BundleContext context;
    private boolean relaunch = false;
    private boolean failOnNoDefault = false;

    public EclipseAppLauncher(BundleContext context, boolean relaunch, boolean failOnNoDefault) {
        this.context = context;
        this.relaunch = relaunch;
        this.failOnNoDefault = failOnNoDefault;
        this.findRunnableService();
    }

    private void findRunnableService() {
        String appClass = ParameterizedRunnable.class.getName();
        ServiceReference[] runRefs = null;
        try {
            runRefs = this.context.getServiceReferences(ParameterizedRunnable.class.getName(), "(&(objectClass=" + appClass + ")(eclipse.application=*))");
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        if (runRefs != null && runRefs.length > 0) {
            this.runnable = (ParameterizedRunnable)this.context.getService(runRefs[0]);
            this.relaunch = false;
            this.waitForAppLock.release();
        }
    }

    public Object start(Object defaultContext) throws Exception {
        if (this.failOnNoDefault && this.runnable == null) {
            throw new IllegalStateException(EclipseAdaptorMsg.ECLIPSE_STARTUP_ERROR_NO_APPLICATION);
        }
        Object result = null;
        do {
            result = this.runApplication(defaultContext);
        } while (this.relaunch && (this.context.getBundle().getState() & 0x20) != 0);
        return result;
    }

    private Object runApplication(Object defaultContext) throws Exception {
        this.waitForAppLock.acquire();
        this.runningLock.acquire();
        if (EclipseStarter.debug) {
            String timeString = FrameworkProperties.getProperty("eclipse.startTime");
            long time = timeString == null ? 0L : Long.parseLong(timeString);
            System.out.println("Starting application: " + (System.currentTimeMillis() - time));
        }
        if (Profile.STARTUP || Profile.BENCHMARK) {
            Profile.logTime("EclipseStarter.run(Object)()", "framework initialized! starting application...");
        }
        try {
            Object object = this.runnable.run(this.appContext != null ? this.appContext : defaultContext);
            return object;
        }
        finally {
            if (Profile.STARTUP) {
                Profile.logExit("EclipseStarter.run(Object)()");
            }
            this.runnable = null;
            this.appContext = null;
            this.runningLock.release();
        }
    }

    public void launch(ParameterizedRunnable app, Object appContext) {
        this.waitForAppLock.acquire(-1L);
        if (!this.runningLock.acquire(-1L)) {
            throw new IllegalStateException("An application is aready running.");
        }
        this.runnable = app;
        this.appContext = appContext;
        this.waitForAppLock.release();
        this.runningLock.release();
    }

    public void shutdown() {
        if (this.runningLock.acquire(-1L)) {
            return;
        }
        if (this.runnable instanceof ApplicationRunnable) {
            ((ApplicationRunnable)this.runnable).stop();
            this.runningLock.acquire(60000L);
        }
    }
}

