/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.perspective;

import javax.servlet.ServletContext;
import org.eclipse.wst.ws.internal.explorer.platform.engine.ActionEngine;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.perspective.FavoritesPerspective;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.BreadCrumb;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.History;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.MessageProvider;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Perspective;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.UDDIPerspective;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.perspective.WSDLPerspective;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.perspective.WSILPerspective;

public class Controller
extends MessageProvider {
    private String sessionId_;
    private String stateLocation_ = null;
    private String defaultFavoritesLocation_;
    private String contextPath_ = null;
    private int historyDirection_ = -1;
    private History history_ = new History();
    private UDDIPerspective uddiPerspective_ = new UDDIPerspective(this);
    private WSILPerspective wsilPerspective_ = new WSILPerspective(this);
    private WSDLPerspective wsdlPerspective_ = new WSDLPerspective(this);
    private FavoritesPerspective favoritesPerspective_ = new FavoritesPerspective(this);
    private Perspective currentPerspective_ = this.uddiPerspective_;
    private boolean isPerspectiveContentBlank_ = true;
    private ActionEngine actionEngine = new ActionEngine(this);
    private int wsdlType_ = 0;

    public Controller() {
        super("explorer");
    }

    public final void setStateLocation(String stateLocation) {
        this.stateLocation_ = stateLocation;
    }

    public final void setDefaultFavoritesLocation(String defaultFavoritesLocation) {
        this.defaultFavoritesLocation_ = defaultFavoritesLocation;
    }

    private final void setContextPath(String contextPath) {
        if (this.contextPath_ == null) {
            this.contextPath_ = contextPath;
        }
    }

    public final String getPathWithContext(String relativePath) {
        if (relativePath == null) {
            return relativePath;
        }
        StringBuffer path = new StringBuffer(relativePath);
        if (this.contextPath_ != null) {
            path.insert(0, '/').insert(0, this.contextPath_);
        }
        return path.toString();
    }

    public final String getSessionId() {
        return this.sessionId_;
    }

    public final String getContextPath() {
        return this.contextPath_;
    }

    public final String getServletEngineStateLocation() {
        return this.stateLocation_;
    }

    public final String getDefaultFavoritesLocation() {
        return this.defaultFavoritesLocation_;
    }

    public final void init(String sessionId, ServletContext application, String contextPath) {
        this.sessionId_ = sessionId;
        this.setContextPath(contextPath);
        this.uddiPerspective_.initPerspective(application);
        this.wsilPerspective_.initPerspective(application);
        this.wsdlPerspective_.initPerspective(application);
        this.favoritesPerspective_.initPerspective(application);
    }

    public final void setCurrentPerspective(int perspective) {
        switch (perspective) {
            case 0: {
                this.currentPerspective_ = this.uddiPerspective_;
                break;
            }
            case 1: {
                this.currentPerspective_ = this.wsilPerspective_;
                break;
            }
            case 2: {
                this.currentPerspective_ = this.wsdlPerspective_;
                break;
            }
            case 3: {
                this.currentPerspective_ = this.favoritesPerspective_;
            }
        }
    }

    public final Perspective getCurrentPerspective() {
        return this.currentPerspective_;
    }

    public final UDDIPerspective getUDDIPerspective() {
        return this.uddiPerspective_;
    }

    public final WSILPerspective getWSILPerspective() {
        return this.wsilPerspective_;
    }

    public final WSDLPerspective getWSDLPerspective() {
        return this.wsdlPerspective_;
    }

    public final FavoritesPerspective getFavoritesPerspective() {
        return this.favoritesPerspective_;
    }

    public final ActionEngine getActionEngine() {
        return this.actionEngine;
    }

    public final boolean addToHistory(int perspectiveId, String url) {
        if (url != null) {
            return this.history_.addBreadCrumb(new BreadCrumb(perspectiveId, url));
        }
        return false;
    }

    public final BreadCrumb forward() {
        this.historyDirection_ = 1;
        return this.history_.forward();
    }

    public final BreadCrumb back() {
        this.historyDirection_ = -1;
        return this.history_.back();
    }

    public final int getHistoryDirection() {
        return this.historyDirection_;
    }

    public final void processStaleBreadCrumb() {
        this.history_.removeCurrentBreadCrumb();
    }

    public final void setWSDLType(int wsdlType) {
        this.wsdlType_ = wsdlType;
    }

    public final int getWSDLType() {
        return this.wsdlType_;
    }

    public final boolean isPerspectiveContentBlank() {
        return this.isPerspectiveContentBlank_;
    }

    public final void enablePerspectiveContentBlank(boolean isPerspectiveContentBlank) {
        this.isPerspectiveContentBlank_ = isPerspectiveContentBlank;
    }

    public final void dumpHistory() {
        this.history_.dump();
    }
}

