/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.emf.event.impl;

import com.ibm.etools.emf.event.Add;
import com.ibm.etools.emf.event.AddMany;
import com.ibm.etools.emf.event.Event;
import com.ibm.etools.emf.event.EventFactory;
import com.ibm.etools.emf.event.EventKind;
import com.ibm.etools.emf.event.EventPackage;
import com.ibm.etools.emf.event.Move;
import com.ibm.etools.emf.event.NotifierKind;
import com.ibm.etools.emf.event.Remove;
import com.ibm.etools.emf.event.RemoveMany;
import com.ibm.etools.emf.event.Set;
import com.ibm.etools.emf.event.Unset;
import com.ibm.etools.emf.event.impl.EventWriterHelper;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;

public class EventAdapter
extends EContentAdapter {
    public static final Object EVENT_ADAPTER = "Event Adapter";
    EventFactory factory;
    EventWriterHelper helper;
    List eventsList;
    boolean isActive = true;

    public EventAdapter(Notifier topNotifier, List eventsList, ResourceSet defaultResourceSet) {
        this.helper = new EventWriterHelper(topNotifier, defaultResourceSet);
        this.eventsList = eventsList;
        this.factory = EventPackage.eINSTANCE.getEventFactory();
        this.helper.scanOriginalObjects(defaultResourceSet);
    }

    public List getEventsList() {
        return this.eventsList;
    }

    public void setEventsList(List eventsList) {
        this.eventsList = eventsList;
    }

    public void execute(List notificationList) {
        int i = 0;
        int size = notificationList.size();
        while (i < size) {
            Notification n = (Notification)notificationList.get(i);
            this.notifyChanged(n);
            ++i;
        }
    }

    public void notifyChanged(Notification n) {
        if (n != null) {
            if (this.isActive()) {
                switch (n.getEventType()) {
                    case 1: {
                        this.set(n);
                        break;
                    }
                    case 2: {
                        this.unSet(n);
                        break;
                    }
                    case 3: {
                        this.add(n);
                        break;
                    }
                    case 4: {
                        this.remove(n);
                        break;
                    }
                    case 5: {
                        this.addMany(n);
                        break;
                    }
                    case 6: {
                        this.removeMany(n);
                        break;
                    }
                    case 7: {
                        this.move(n);
                        break;
                    }
                }
            }
            super.notifyChanged(n);
        }
    }

    protected void set(Notification n) {
        Set e = (Set)this.createEvent(n);
        if (e == null) {
            return;
        }
        Object oldValue = n.getOldValue();
        Object newValue = n.getNewValue();
        if (newValue != null) {
            e.setNewLiteral(this.helper.convertValueToString(e, newValue, true));
        }
        if (oldValue != null) {
            e.setOldLiteral(this.helper.convertValueToString(e, oldValue, false));
        }
    }

    protected void unSet(Notification n) {
        Unset e = (Unset)this.createEvent(n);
        if (e == null) {
            return;
        }
        Object oldValue = n.getOldValue();
        e.setLiteral(this.helper.convertValueToString(e, oldValue, false));
    }

    protected void add(Notification n) {
        Add e = (Add)this.createEvent(n);
        if (e == null) {
            return;
        }
        e.setPosition(n.getPosition());
        Object newValue = n.getNewValue();
        e.setLiteral(this.helper.convertValueToString(e, newValue, true));
    }

    protected void remove(Notification n) {
        Remove e = (Remove)this.createEvent(n);
        if (e == null) {
            return;
        }
        e.setPosition(n.getPosition());
        Object oldValue = n.getOldValue();
        e.setLiteral(this.helper.convertValueToString(e, oldValue, false));
    }

    protected void addMany(Notification n) {
        AddMany e = (AddMany)this.createEvent(n);
        if (e == null) {
            return;
        }
        List vList = (List)n.getNewValue();
        int v = 0;
        int size = vList.size();
        while (v < size) {
            Object newValue = vList.get(v);
            e.getLiterals().add((Object)this.helper.convertValueToString(e, newValue, true));
            EList list = this.helper.getNotifierContents(e);
            int pos = list.indexOf(newValue);
            e.getPositions().add((Object)new Integer(pos));
            ++v;
        }
    }

    protected void removeMany(Notification n) {
        RemoveMany e = (RemoveMany)this.createEvent(n);
        if (e == null) {
            return;
        }
        Object newValue = n.getNewValue();
        if (newValue != null) {
            int[] posArray = (int[])newValue;
            int i = 0;
            while (i < posArray.length) {
                e.getPositions().add((Object)new Integer(posArray[i]));
                ++i;
            }
        }
        List vList = (List)n.getOldValue();
        int v = 0;
        int size = vList.size();
        while (v < size) {
            Object oldValue = vList.get(v);
            e.getLiterals().add((Object)this.helper.convertValueToString(e, oldValue, false));
            ++v;
        }
    }

    protected void move(Notification n) {
        Move e = (Move)this.createEvent(n);
        if (e == null) {
            return;
        }
        e.setNewPosition(n.getPosition());
        e.setOldPosition((Integer)n.getOldValue());
    }

    protected Event createEvent(Notification n) {
        Notifier notifier = (Notifier)n.getNotifier();
        if (this.helper.isNotifierVisible(notifier)) {
            Event e = this.factory.createEvent(n.getEventType());
            String uri = this.helper.getURIString(notifier);
            e.setNotifierURI(uri);
            EStructuralFeature sf = (EStructuralFeature)n.getFeature();
            if (sf != null) {
                e.setFeatureName(sf.getName());
            }
            if (this.helper.getNotifierKind(e) == NotifierKind.RESOURCE_LITERAL && e.getEventKind() == EventKind.SET_LITERAL) {
                return null;
            }
            this.eventsList.add(e);
            return e;
        }
        return null;
    }

    public boolean isAdapterForType(Object type) {
        return type == EVENT_ADAPTER;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setIsActive(boolean isActive) {
        this.isActive = isActive;
    }
}

