/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.subscriber;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.dialogs.CommitDialog;
import org.tigris.subversion.subclipse.ui.operations.CommitOperation;
import org.tigris.subversion.subclipse.ui.settings.ProjectProperties;
import org.tigris.subversion.subclipse.ui.subscriber.SVNSynchronizeOperation;

public class CommitSynchronizeOperation
extends SVNSynchronizeOperation {
    private String commitComment;
    private IResource[] resourcesToCommit;
    private String url;
    private boolean commit;
    private boolean keepLocks;
    private String proposedComment;
    private ISynchronizePageConfiguration configuration;

    protected CommitSynchronizeOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements, String url, String proposedComment) {
        super(configuration, elements);
        this.configuration = configuration;
        this.url = url;
        this.proposedComment = proposedComment;
    }

    private boolean confirmCommit(SyncInfoSet set) {
        this.commit = false;
        IResource[] modified = set.getResources();
        if (modified.length > 0) {
            try {
                ProjectProperties projectProperties = ProjectProperties.getProjectProperties(modified[0]);
                IResource[] unaddedResources = this.getUnaddedResources(set);
                final CommitDialog dialog = new CommitDialog(this.getShell(), modified, this.url, unaddedResources.length > 0, projectProperties);
                dialog.setComment(this.proposedComment);
                this.getShell().getDisplay().syncExec(new Runnable(){

                    public void run() {
                        CommitSynchronizeOperation.this.commit = dialog.open() == 0;
                    }
                });
                if (this.commit) {
                    this.resourcesToCommit = dialog.getSelectedResources();
                    this.commitComment = dialog.getComment();
                    this.keepLocks = dialog.isKeepLocks();
                }
            }
            catch (SVNException e) {
                e.printStackTrace();
            }
        }
        return this.commit;
    }

    protected boolean promptForConflictHandling(Shell shell, SyncInfoSet syncSet) {
        return true;
    }

    private int promptForConflicts(Shell shell, SyncInfoSet syncSet) {
        String[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL};
        String title = Policy.bind("SyncAction.commit.conflict.title");
        String question = Policy.bind("SyncAction.commit.conflict.question");
        final MessageDialog dialog = new MessageDialog(shell, title, null, question, 3, buttons, 0);
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                dialog.open();
            }
        });
        return dialog.getReturnCode();
    }

    private IResource[] getUnaddedResources(SyncInfoSet set) {
        IResource[] resources = set.getResources();
        ArrayList<IResource> result = new ArrayList<IResource>();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (this.isAdded(resource)) {
                result.add(resource);
            }
            ++i;
        }
        return result.toArray(new IResource[result.size()]);
    }

    private boolean isAdded(IResource resource) {
        block5: {
            ISVNLocalResource svnResource;
            block4: {
                svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
                try {
                    if (!svnResource.isIgnored()) break block4;
                    return false;
                }
                catch (SVNException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            if (!svnResource.isManaged()) break block5;
            return false;
        }
        return resource.getType() != 2 || !this.isSymLink(resource);
    }

    private boolean isSymLink(IResource resource) {
        File file;
        block3: {
            file = resource.getLocation().toFile();
            try {
                if (file.exists()) break block3;
                return true;
            }
            catch (IOException iOException) {
                return true;
            }
        }
        String cnnpath = file.getCanonicalPath();
        String abspath = file.getAbsolutePath();
        return !abspath.equals(cnnpath);
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        SyncInfoSet syncSet = this.getSyncInfoSet();
        if (!this.promptForConflictHandling(this.getShell(), syncSet)) {
            return;
        }
        Map projectSyncInfos = this.getProjectSyncInfoSetMap(syncSet);
        Iterator iter = projectSyncInfos.keySet().iterator();
        IProject project = (IProject)iter.next();
        SVNTeamProvider provider = (SVNTeamProvider)RepositoryProvider.getProvider((IProject)project, (String)"org.tigris.subversion.subclipse.core.svnnature");
        monitor.beginTask(null, projectSyncInfos.size() * 100);
        this.run(provider, syncSet, Policy.subMonitorFor(monitor, 100));
        monitor.done();
    }

    protected void run(SVNTeamProvider provider, SyncInfoSet set, IProgressMonitor monitor) {
        if (set.hasConflicts() || set.hasIncomingChanges()) {
            switch (this.promptForConflicts(this.getShell(), set)) {
                case 0: {
                    set.removeConflictingNodes();
                    set.removeIncomingNodes();
                    break;
                }
                case 1: {
                    return;
                }
                default: {
                    return;
                }
            }
        }
        if (this.confirmCommit(set)) {
            IResource[][] resourcesToBeAdded = new IResource[1][];
            IResource[][] resourcesToBeDeleted = new IResource[1][];
            ArrayList<IResource> toBeAddedList = new ArrayList<IResource>();
            ArrayList<IResource> toBeDeletedList = new ArrayList<IResource>();
            int i = 0;
            while (i < this.resourcesToCommit.length) {
                IResource resource = this.resourcesToCommit[i];
                ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
                try {
                    if (!svnResource.isManaged()) {
                        toBeAddedList.add(resource);
                    }
                    if (svnResource.getStatus().isMissing()) {
                        toBeDeletedList.add(resource);
                    }
                }
                catch (SVNException e) {
                    e.printStackTrace();
                }
                ++i;
            }
            resourcesToBeAdded[0] = new IResource[toBeAddedList.size()];
            toBeAddedList.toArray(resourcesToBeAdded[0]);
            resourcesToBeDeleted[0] = new IResource[toBeDeletedList.size()];
            toBeDeletedList.toArray(resourcesToBeDeleted[0]);
            try {
                CommitOperation commit = new CommitOperation(this.getPart(), this.resourcesToCommit, resourcesToBeAdded[0], resourcesToBeDeleted[0], this.resourcesToCommit, this.commitComment, this.keepLocks);
                if (SVNProviderPlugin.getPlugin().getPluginPreferences().getBoolean("show_out_of_date_folders")) {
                    commit.setConfiguration(this.configuration);
                }
                commit.run();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

