/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.commands;

import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.client.OperationManager;
import org.tigris.subversion.subclipse.core.commands.ISVNCommand;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class MergeCommand
implements ISVNCommand {
    private IResource resource;
    private SVNUrl svnUrl1;
    private SVNUrl svnUrl2;
    private SVNRevision svnRevision1;
    private SVNRevision svnRevision2;
    private SVNWorkspaceRoot root;
    private boolean force = false;
    private boolean ignoreAncestry = false;

    public MergeCommand(SVNWorkspaceRoot root, IResource resource, SVNUrl svnUrl1, SVNRevision svnRevision1, SVNUrl svnUrl2, SVNRevision svnRevision2) {
        this.root = root;
        this.resource = resource;
        this.svnUrl1 = svnUrl1;
        this.svnRevision1 = svnRevision1;
        this.svnUrl2 = svnUrl2;
        this.svnRevision2 = svnRevision2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor monitor) throws SVNException {
        try {
            try {
                monitor.beginTask(null, 100);
                ISVNClientAdapter svnClient = this.root.getRepository().getSVNClient();
                OperationManager.getInstance().beginOperation(svnClient);
                monitor.subTask(this.resource.getName());
                File file = this.resource.getLocation().toFile();
                svnClient.merge(this.svnUrl1, this.svnRevision1, this.svnUrl2, this.svnRevision2, file, this.force, true, false, this.ignoreAncestry);
                try {
                    this.resource.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException coreException) {}
                monitor.worked(100);
            }
            catch (SVNClientException e) {
                throw SVNException.wrapException((Exception)((Object)e));
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            OperationManager.getInstance().endOperation();
            monitor.done();
            throw throwable;
        }
        {
            Object var4_7 = null;
            OperationManager.getInstance().endOperation();
        }
        monitor.done();
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void setIgnoreAncestry(boolean ignoreAncestry) {
        this.ignoreAncestry = ignoreAncestry;
    }
}

