/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class BugAccumulator {
    private BugReporter reporter;
    private Map<BugInstance, LinkedList<SourceLineAnnotation>> map = new HashMap<BugInstance, LinkedList<SourceLineAnnotation>>();

    public BugAccumulator(BugReporter reporter) {
        this.reporter = reporter;
    }

    public void accumulateBug(BugInstance bug, SourceLineAnnotation sourceLine) {
        LinkedList<SourceLineAnnotation> where = this.map.get(bug);
        if (where == null) {
            where = new LinkedList();
            this.map.put(bug, where);
        }
        where.add(sourceLine);
    }

    public void accumulateBug(BugInstance bug, BytecodeScanningDetector visitor) {
        SourceLineAnnotation source = SourceLineAnnotation.fromVisitedInstruction(visitor);
        this.accumulateBug(bug, source);
    }

    public void reportAccumulatedBugs() {
        Iterator<Map.Entry<BugInstance, LinkedList<SourceLineAnnotation>>> i$ = this.map.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry<BugInstance, LinkedList<SourceLineAnnotation>> e = i$.next();
            BugInstance bug = e.getKey();
            boolean first = true;
            Iterator i$2 = e.getValue().iterator();
            while (i$2.hasNext()) {
                SourceLineAnnotation source = (SourceLineAnnotation)i$2.next();
                if (source == null) continue;
                bug.addSourceLine(source);
                if (first) {
                    first = false;
                    continue;
                }
                bug.describe("SOURCE_LINE_ANOTHER_INSTANCE");
            }
            this.reporter.reportBug(bug);
        }
        this.map.clear();
    }
}

