/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sqlobject.undo;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.log4j.Logger;

public class PropertyChangeEdit
extends AbstractUndoableEdit {
    private static final Logger logger = Logger.getLogger(PropertyChangeEdit.class);
    private final PropertyChangeEvent sourceEvent;

    public PropertyChangeEdit(PropertyChangeEvent e) {
        this.sourceEvent = e;
    }

    @Override
    public void undo() throws CannotUndoException {
        logger.debug((Object)("Undoing Property change: Setting " + this.sourceEvent.getPropertyName() + " from " + this.sourceEvent.getNewValue() + " to " + this.sourceEvent.getOldValue()));
        super.undo();
        try {
            PropertyDescriptor propertyDescriptor = PropertyUtils.getPropertyDescriptor((Object)this.sourceEvent.getSource(), (String)this.sourceEvent.getPropertyName());
            logger.debug((Object)("Found property descriptor " + propertyDescriptor));
            if (logger.isDebugEnabled()) {
                PropertyDescriptor[] propertyDescriptors = PropertyUtils.getPropertyDescriptors((Object)this.sourceEvent.getSource());
                logger.debug((Object)("Descriptor has write method " + propertyDescriptor.getWriteMethod()));
            }
            Method setter = PropertyUtils.getWriteMethod((PropertyDescriptor)propertyDescriptor);
            logger.info((Object)("Found setter: " + setter.getName()));
            setter.invoke(this.sourceEvent.getSource(), this.sourceEvent.getOldValue());
        }
        catch (Exception ex) {
            CannotUndoException wrapper = new CannotUndoException();
            wrapper.initCause(ex);
            throw wrapper;
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        logger.debug((Object)("Undoing Property change: Setting " + this.sourceEvent.getPropertyName() + " from " + this.sourceEvent.getOldValue() + " to " + this.sourceEvent.getNewValue()));
        super.redo();
        try {
            Method setter = PropertyUtils.getWriteMethod((PropertyDescriptor)PropertyUtils.getPropertyDescriptor((Object)this.sourceEvent.getSource(), (String)this.sourceEvent.getPropertyName()));
            logger.info((Object)("Found setter: " + setter.getName()));
            setter.invoke(this.sourceEvent.getSource(), this.sourceEvent.getNewValue());
        }
        catch (Exception ex) {
            CannotRedoException wrapper = new CannotRedoException();
            wrapper.initCause(ex);
            throw wrapper;
        }
    }

    @Override
    public String getPresentationName() {
        return "property change edit";
    }

    public String getPropertyName() {
        return this.sourceEvent.getPropertyName();
    }

    public Object getNewValue() {
        return this.sourceEvent.getNewValue();
    }

    public Object getOldValue() {
        return this.sourceEvent.getOldValue();
    }

    public Object getSource() {
        return this.sourceEvent.getSource();
    }

    @Override
    public String toString() {
        return "Changing property: \"" + this.sourceEvent.getPropertyName() + "\" by " + this.sourceEvent;
    }
}

