/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.ArchitectSession;
import ca.sqlpower.architect.Messages;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLObjectPreEvent;
import ca.sqlpower.sqlobject.SQLObjectPreEventListener;
import ca.sqlpower.sqlobject.SQLObjectRuntimeException;
import ca.sqlpower.sqlobject.SQLObjectUtils;
import ca.sqlpower.util.UserPrompter;
import ca.sqlpower.util.UserPrompterFactory;
import java.util.List;

public class SourceObjectIntegrityWatcher
implements SQLObjectPreEventListener {
    private final ArchitectSession session;

    SourceObjectIntegrityWatcher(ArchitectSession session) {
        this.session = session;
    }

    public void dbChildrenPreRemove(SQLObjectPreEvent e) {
        UserPrompter up = this.session.createUserPrompter(Messages.getString("SourceObjectIntegrityWatcher.removingETLLineageWarning"), UserPrompterFactory.UserPromptType.BOOLEAN, UserPrompter.UserPromptOptions.OK_NOTOK_CANCEL, UserPrompter.UserPromptResponse.OK, Boolean.TRUE, new String[]{Messages.getString("SourceObjectIntegrityWatcher.forgetLineageOption"), Messages.getString("SourceObjectIntegrityWatcher.keepSourceConnectionOption"), Messages.getString("cancel")});
        for (SQLObject so : e.getChildren()) {
            SQLDatabase db = (SQLDatabase)so;
            if (!db.isMagicEnabled()) continue;
            try {
                List refs = SQLObjectUtils.findColumnsSourcedFromDatabase((SQLDatabase)this.session.getTargetDatabase(), (SQLDatabase)db);
                if (refs.isEmpty()) continue;
                UserPrompter.UserPromptResponse response = up.promptUser(new Object[]{refs.size(), db.getName()});
                if (response == UserPrompter.UserPromptResponse.OK) {
                    for (SQLColumn col : refs) {
                        col.setSourceColumn(null);
                    }
                    continue;
                }
                if (response == UserPrompter.UserPromptResponse.NOT_OK) {
                    e.veto();
                    continue;
                }
                if (response != UserPrompter.UserPromptResponse.CANCEL) continue;
                e.veto();
            }
            catch (SQLObjectException ex) {
                throw new SQLObjectRuntimeException(ex);
            }
        }
    }
}

