/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging;

import flex.messaging.LocalizedException;
import flex.messaging.MessageBroker;
import flex.messaging.messages.ErrorMessage;
import flex.messaging.util.ResourceLoader;
import java.util.Map;

public class MessageException
extends LocalizedException {
    static final long serialVersionUID = 3310842114461162689L;
    protected String code;
    protected Map extendedData;
    protected ErrorMessage errorMessage;

    public MessageException() {
    }

    public MessageException(ResourceLoader loader) {
        super(loader);
    }

    public MessageException(String message) {
        this.setMessage(message);
    }

    public MessageException(String message, Throwable t) {
        this.setMessage(message);
        this.setRootCause(t);
    }

    public MessageException(Throwable t) {
        String rootMessage = t.getMessage();
        if (rootMessage == null) {
            rootMessage = t.toString();
        }
        this.setMessage(rootMessage);
        this.setRootCause(t);
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Map getExtendedData() {
        return this.extendedData;
    }

    public void setExtendedData(Map extendedData) {
        this.extendedData = extendedData;
    }

    public ErrorMessage getErrorMessage() {
        if (this.errorMessage == null) {
            this.errorMessage = this.createErrorMessage();
        }
        return this.errorMessage;
    }

    public void setErrorMessage(ErrorMessage errorMessage) {
        this.errorMessage = errorMessage;
    }

    public Object getRootCauseErrorMessage() {
        if (this.rootCause != null) {
            if (this.rootCause instanceof MessageException) {
                return ((MessageException)((Object)this.rootCause)).createErrorMessage();
            }
            return this.rootCause;
        }
        return null;
    }

    public ErrorMessage createErrorMessage() {
        ErrorMessage msg = new ErrorMessage();
        msg.faultCode = this.code == null ? "Server.Processing" : this.code;
        msg.faultString = this.message;
        msg.faultDetail = this.details;
        msg.rootCause = this.getRootCauseErrorMessage();
        if (this.extendedData != null) {
            msg.extendedData = this.extendedData;
        }
        return msg;
    }

    protected ResourceLoader getResourceLoader() {
        if (this.resourceLoader == null) {
            this.resourceLoader = MessageBroker.getSystemSettings().getResourceLoader();
        }
        return this.resourceLoader;
    }
}

