/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import org.h2.engine.Database;
import org.h2.security.SHA256;
import org.h2.store.FileStore;
import org.h2.tools.FileBase;
import org.h2.util.FileUtils;

public class ChangePassword
extends FileBase {
    private String dir;
    private String cipher;
    private byte[] decrypt;
    private byte[] encrypt;
    private boolean testRenameOnly;

    private void showUsage() {
        System.out.println("java " + this.getClass().getName() + " [-dir <dir>] [-db <database>] [-cipher <cipher>] [-decrypt <pwd>] [-encrypt <pwd>] [-quiet]");
    }

    public static void main(String[] args) throws Exception {
        new ChangePassword().run(args);
    }

    private void run(String[] args) throws Exception {
        String dir = ".";
        String cipher = null;
        byte[] decrypt = null;
        byte[] encrypt = null;
        String db = null;
        boolean quiet = false;
        for (int i = 0; args != null && i < args.length; ++i) {
            if (args[i].equals("-dir")) {
                dir = args[++i];
                continue;
            }
            if (args[i].equals("-cipher")) {
                cipher = args[++i];
                continue;
            }
            if (args[i].equals("-db")) {
                db = args[++i];
                continue;
            }
            if (args[i].equals("-decrypt")) {
                decrypt = this.getFileEncryptionKey(args[++i].toCharArray());
                continue;
            }
            if (args[i].equals("-encrypt")) {
                encrypt = this.getFileEncryptionKey(args[++i].toCharArray());
                continue;
            }
            if (!args[i].equals("-quiet")) continue;
            quiet = true;
        }
        if (encrypt == null && decrypt == null) {
            this.showUsage();
            return;
        }
        ChangePassword.execute(dir, db, cipher, decrypt, encrypt, quiet);
    }

    public byte[] getFileEncryptionKey(char[] password) {
        SHA256 sha = new SHA256();
        return sha.getKeyPasswordHash("file", password);
    }

    public static void execute(String dir, String db, String cipher, byte[] decrypt, byte[] encrypt, boolean quiet) throws Exception {
        ChangePassword change = new ChangePassword();
        change.dir = dir;
        change.cipher = cipher;
        change.decrypt = decrypt;
        change.encrypt = encrypt;
        change.testRenameOnly = true;
        change.processFiles(dir, db, !quiet);
        change.testRenameOnly = false;
        change.processFiles(dir, db, !quiet);
    }

    protected void process(String fileName) throws Exception {
        if (FileUtils.isDirectory(fileName)) {
            return;
        }
        if (this.testRenameOnly) {
            String temp = this.dir + "/temp.db";
            FileUtils.delete(temp);
            FileUtils.rename(fileName, temp);
            FileUtils.rename(temp, fileName);
        } else {
            boolean textStorage = Database.isTextStorage(fileName, false);
            byte[] magic = Database.getMagic(textStorage);
            FileStore in = FileStore.open(null, fileName, magic, this.decrypt == null ? null : this.cipher, this.decrypt);
            in.init();
            this.copy(fileName, textStorage, in, this.encrypt);
        }
    }

    private void copy(String fileName, boolean textStorage, FileStore in, byte[] key) throws Exception {
        long remaining;
        String temp = this.dir + "/temp.db";
        FileUtils.delete(temp);
        byte[] magic = Database.getMagic(textStorage);
        FileStore out = FileStore.open(null, temp, magic, key == null ? null : this.cipher, key);
        out.init();
        byte[] buffer = new byte[4096];
        long total = remaining = in.length() - 48L;
        in.seek(48L);
        out.seek(48L);
        long time = System.currentTimeMillis();
        while (remaining > 0L) {
            if (System.currentTimeMillis() - time > 1000L) {
                System.out.println(fileName + ": " + (100L - 100L * remaining / total) + "%");
                time = System.currentTimeMillis();
            }
            int len = (int)Math.min((long)buffer.length, remaining);
            in.readFully(buffer, 0, len);
            out.write(buffer, 0, len);
            remaining -= (long)len;
        }
        in.close();
        out.close();
        FileUtils.delete(fileName);
        FileUtils.rename(temp, fileName);
    }
}

