/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.security;

import flex.messaging.FlexContext;
import flex.messaging.security.AppServerLoginCommand;
import flex.messaging.security.SecurityException;
import flex.messaging.util.PropertyStringResourceLoader;
import flex.messaging.util.ResourceLoader;
import java.security.Principal;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jrun.security.JRunSecurityException;
import jrun.servlet.JRunServletContext;
import jrun.servlet.WebApplication;
import jrun.servlet.security.AuthenticatedUser;
import jrun.servlet.security.ServletUsers;
import jrun.servlet.security.WebAppSecurityService;
import jrunx.kernel.JRun;

public class JRunLoginCommand
extends AppServerLoginCommand {
    private WebAppSecurityService appSecurity;
    private ServletUsers usersService;
    private static final int AUTH_FAILED = 10060;
    private static final int SEC_MANAGER_REQ_FOR_AUTH = 10061;
    private static final int NO_SEC_MANAGER = 20050;
    private static final int NO_SEC_SRVC_OR_USERS = 20051;

    public void start(ServletConfig servletConfig) {
        try {
            Class.forName("jrun.servlet.security.AuthenticatedUser");
            Class.forName("jrun.servlet.security.WebAppSecurityService");
            Class.forName("jrun.servlet.JRunServletContext");
        }
        catch (Throwable t) {
            SecurityException se = new SecurityException((ResourceLoader)new PropertyStringResourceLoader("flex.messaging.vendors"));
            se.setMessage(20050);
            throw se;
        }
        if (JRun.server != null) {
            try {
                Object usersService;
                Object securityService;
                Iterator<ObjectInstance> iterator;
                ServletContext servletContext = servletConfig.getServletContext();
                String webAppName = ((JRunServletContext)servletContext).getWebApplication().getName();
                Set<ObjectInstance> serviceMBeans = null;
                ObjectInstance mbean = null;
                ObjectName serviceName = new ObjectName("ServletEngineService." + webAppName + ":service=WebAppSecurityService");
                serviceMBeans = JRun.server.queryMBeans(serviceName, null);
                if (serviceMBeans != null && (iterator = serviceMBeans.iterator()).hasNext()) {
                    mbean = iterator.next();
                }
                if (mbean != null && (securityService = JRun.server.invoke(mbean.getObjectName(), "getWebAppSecurity", null, null)) instanceof WebAppSecurityService) {
                    this.appSecurity = (WebAppSecurityService)securityService;
                }
                if ((serviceMBeans = JRun.server.queryMBeans(serviceName = new ObjectName("ServletEngineService:service=ServletUsersService"), null)) != null && (iterator = serviceMBeans.iterator()).hasNext()) {
                    mbean = iterator.next();
                }
                if (mbean != null && (usersService = JRun.server.invoke(mbean.getObjectName(), "getServletUsers", null, null)) instanceof ServletUsers) {
                    this.usersService = (ServletUsers)usersService;
                }
            }
            catch (MalformedObjectNameException ex) {
                SecurityException se = new SecurityException((ResourceLoader)new PropertyStringResourceLoader("flex.messaging.vendors"));
                se.setMessage(20051);
                se.setRootCause((Throwable)ex);
                throw se;
            }
            catch (InstanceNotFoundException ex) {
                SecurityException se = new SecurityException((ResourceLoader)new PropertyStringResourceLoader("flex.messaging.vendors"));
                se.setMessage(20051);
                se.setRootCause((Throwable)ex);
                throw se;
            }
            catch (MBeanException ex) {
                Exception e = ex.getTargetException();
                SecurityException se = new SecurityException((ResourceLoader)new PropertyStringResourceLoader("flex.messaging.vendors"));
                se.setMessage(20051);
                se.setRootCause((Throwable)e);
                throw se;
            }
            catch (ReflectionException ex) {
                SecurityException se = new SecurityException((ResourceLoader)new PropertyStringResourceLoader("flex.messaging.vendors"));
                se.setMessage(20051);
                se.setRootCause((Throwable)ex);
                throw se;
            }
            catch (NullPointerException npe) {
                SecurityException se = new SecurityException((ResourceLoader)new PropertyStringResourceLoader("flex.messaging.vendors"));
                se.setMessage(20051);
                se.setRootCause((Throwable)npe);
                throw se;
            }
        }
    }

    public Principal doAuthentication(String username, Object credentials) throws SecurityException {
        if (this.appSecurity == null) {
            this.start(FlexContext.getServletConfig());
        }
        try {
            AuthenticatedUser user = null;
            String password = this.extractPassword(credentials);
            if (password != null) {
                HttpServletRequest request = FlexContext.getHttpRequest();
                if (request != null) {
                    user = this.appSecurity.authenticate(username, password, request.getSession(true));
                } else {
                    ServletContext servletContext = FlexContext.getServletConfig().getServletContext();
                    WebApplication webApp = ((JRunServletContext)servletContext).getWebApplication();
                    HttpSession tempSession = webApp.getSessionService().createSession("temp");
                    user = this.appSecurity.authenticate(username, password, tempSession);
                    tempSession.invalidate();
                }
                return user.getPrincipal();
            }
        }
        catch (Exception ex) {
            SecurityException se;
            if (ex instanceof SecurityException) {
                se = (SecurityException)ex;
            } else if (ex instanceof MBeanException) {
                ex = ((MBeanException)ex).getTargetException();
                se = new SecurityException();
                se.setMessage(10060);
                se.setRootCause((Throwable)ex);
            } else if (ex instanceof JRunSecurityException) {
                se = new SecurityException();
                se.setMessage(10060);
                se.setRootCause((Throwable)ex);
            } else {
                se = new SecurityException();
                se.setMessage(10061);
            }
            se.setCode("Client.Authentication");
            throw se;
        }
        return null;
    }

    public boolean doAuthorization(Principal principal, List roles) throws SecurityException {
        if (this.appSecurity == null) {
            this.start(FlexContext.getServletConfig());
        }
        boolean authorized = false;
        HttpServletRequest request = FlexContext.getHttpRequest();
        if (request != null) {
            authorized = this.doAuthorization(principal, roles, request);
        } else {
            for (int i = 0; i < roles.size(); ++i) {
                String role = (String)roles.get(i);
                if (!this.appSecurity.isPrincipalInRole(principal, role)) continue;
                authorized = true;
                break;
            }
        }
        return authorized;
    }

    public boolean logout(Principal principal) throws SecurityException {
        try {
            ServletContext servletContext = FlexContext.getServletConfig().getServletContext();
            WebApplication webApp = ((JRunServletContext)servletContext).getWebApplication();
            HttpServletRequest request = FlexContext.getHttpRequest();
            HttpSession session = request.getSession();
            String sessionId = session.getId();
            AuthenticatedUser currentUser = this.usersService.getUser(sessionId, webApp);
            currentUser.logoff();
            return true;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public void stop() {
        this.usersService = null;
        this.appSecurity = null;
    }
}

