/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.security.Key;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.jpedal.constants.PDFflags;
import org.jpedal.exception.PdfException;
import org.jpedal.exception.PdfSecurityException;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfFilteredReader;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.io.SetSecurity;
import org.jpedal.io.TextTokens;
import org.jpedal.objects.Javascript;
import org.jpedal.objects.PageLookup;
import org.jpedal.objects.PdfFileInformation;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfColorSpaceObject;
import org.jpedal.objects.raw.PdfCompressedObject;
import org.jpedal.objects.raw.PdfDictionary;
import org.jpedal.objects.raw.PdfFunctionObject;
import org.jpedal.objects.raw.PdfMetadataObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.objects.raw.PdfObjectFactory;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Sorts;
import org.jpedal.utils.Strip;
import org.jpedal.utils.repositories.Vector_Int;

public class PdfReader
extends PdfFilteredReader
implements PdfObjectReader,
Serializable {
    private int startStreamPointer;
    private int endStreamPointer;
    private boolean debugAES = false;
    private byte[] lastCompressedStream = null;
    private Map fields = new HashMap();
    private Vector_Int xref = new Vector_Int(100);
    private Map lastOffsetStart;
    private Map lastOffsetEnd;
    private int lastFirst;
    private Map objData = null;
    private Map nameLookup = new HashMap();
    private String lastRef = "";
    PdfFileInformation currentFileInformation = new PdfFileInformation();
    private static final String pattern = "obj";
    private boolean extractionIsAllowed = true;
    private static final byte[] endPattern = new byte[]{101, 110, 100, 111, 98, 106};
    private static final byte[] newPattern = "obj".getBytes();
    private static final byte[] oldPattern = "xref".getBytes();
    private static final byte[] endObj = new byte[]{32, 111, 98, 106};
    private static final byte[] lengthString = new byte[]{47, 76, 101, 110, 103, 116, 104};
    private static final byte[] startStream = new byte[]{115, 116, 114, 101, 97, 109};
    private static final byte[] endStream = new byte[]{101, 110, 100, 115, 116, 114, 101, 97, 109};
    private boolean isEncrypted = false;
    private boolean isInitialised = false;
    private byte[] encryptionPassword = new byte[0];
    private String infoObject = null;
    private byte[] encryptionKey = null;
    private boolean isFileViewable = true;
    private int rev = 0;
    private int keyLength = 5;
    private int P = 0;
    private byte[] O = new byte[0];
    private byte[] U = new byte[0];
    private String ID = "";
    private boolean isPasswordSupplied = false;
    private Cipher cipher = null;
    private String[] padding = new String[]{"28", "BF", "4E", "5E", "4E", "75", "8A", "41", "64", "00", "4E", "56", "FF", "FA", "01", "08", "2E", "2E", "00", "B6", "D0", "68", "3E", "80", "2F", "0C", "A9", "FE", "64", "53", "69", "7A"};
    private int[] ObjLengthTable;
    private boolean refTableInvalid = false;
    private int miniumumCacheSize;
    public boolean interruptRefReading = false;
    String EFF;
    String CFM;
    boolean isMetaDataEncypted = true;
    Map StrF;
    Map StmF;
    boolean stringsEncoded = false;
    String StrFname;
    String StmFname;
    private int passwordStatus = 0;
    private Javascript javascript;
    private static boolean alwaysReinitCipher = false;
    private static final int[] powers;

    public PdfReader() {
        this.fields.put("T", "x");
        this.fields.put("NM", "x");
        this.fields.put("TM", "x");
        this.fields.put("TU", "x");
        this.fields.put("CA", "x");
        this.fields.put("R", "x");
        this.fields.put("V", "x");
        this.fields.put("RC", "x");
        this.fields.put("DA", "x");
        this.fields.put("DV", "x");
        this.fields.put("JS", "x");
        this.fields.put("Contents", "x");
    }

    public PdfReader(String string) {
        if (string == null) {
            string = "";
        }
        this.setEncryptionPassword(string);
    }

    public void setJavaScriptObject(Javascript javascript) {
        this.javascript = javascript;
    }

    private int readFirstStartRef() throws PdfException {
        int n;
        this.refTableInvalid = false;
        int n2 = -1;
        int n3 = 1019;
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = 1024;
        byte[] byArray = new byte[n4];
        int[] nArray = new int[]{37, 37, 69, 79, 70};
        int n5 = 4;
        boolean bl = false;
        try {
            int n6;
            long l;
            block19: {
                l = this.eof;
                n = 255;
                do {
                    byte[] byArray2 = new byte[n];
                    this.movePointer(l - (long)n);
                    this.pdf_datafile.read(byArray2);
                    n6 = 0;
                    for (int i = n - 1; i > -1; --i) {
                        if (!bl) {
                            n5 = 4;
                        }
                        if (byArray2[i] == nArray[n5]) {
                            --n5;
                            bl = true;
                        } else {
                            bl = false;
                        }
                        --n6;
                        if (n5 >= 0) continue;
                        i = -1;
                    }
                    if (n5 >= 0) continue;
                    l -= (long)n6;
                    break block19;
                } while ((l -= (long)n) >= 0L);
                l = this.eof;
            }
            int n7 = (int)(l - (long)n4);
            if (n7 < 0) {
                n7 = 0;
                n6 = (int)this.eof;
                byArray = new byte[n6];
                n3 = n6 + 3;
            }
            this.movePointer(n7);
            this.pdf_datafile.read(byArray);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " reading last 1024 bytes");
            throw new PdfException(exception + " reading last 1024 bytes");
        }
        n = byArray.length;
        if (n3 > n) {
            n3 = n - 5;
        }
        while (n3 > -1 && (byArray[n3] != 116 || byArray[n3 + 1] != 120 || byArray[n3 + 2] != 114 || byArray[n3 + 3] != 101 || byArray[n3 + 4] != 102)) {
            --n3;
        }
        if (n3 == -1) {
            try {
                this.pdf_datafile.close();
            }
            catch (IOException iOException) {
                LogWriter.writeLog("Exception " + iOException + " closing file");
            }
            throw new PdfException("No Startref found in last 1024 bytes ");
        }
        n3 += 5;
        while (n3 < 1024 && (byArray[n3] == 10 || byArray[n3] == 32 || byArray[n3] == 13)) {
            ++n3;
        }
        while (n3 < 1024 && byArray[n3] != 10 && byArray[n3] != 32 && byArray[n3] != 13) {
            stringBuffer.append((char)byArray[n3]);
            ++n3;
        }
        if (stringBuffer.length() > 0) {
            n2 = Integer.parseInt(stringBuffer.toString());
        }
        if (n2 == -1) {
            LogWriter.writeLog("No Startref found in last 1024 bytes ");
            try {
                this.pdf_datafile.close();
            }
            catch (IOException iOException) {
                LogWriter.writeLog("Exception " + iOException + " closing file");
            }
            throw new PdfException("No Startref found in last 1024 bytes ");
        }
        return n2;
    }

    public void setEncryptionPassword(String string) {
        this.encryptionPassword = string.getBytes();
    }

    public Object resolveToMapOrString(Object object, Object object2) {
        if (this.fields != null && this.fields.get(object) != null && object2 instanceof byte[]) {
            byte[] byArray = this.getByteTextStringValue(object2, this.fields);
            object2 = this.getTextString(byArray);
        } else if (object2 instanceof String && ((String)object2).endsWith(" R")) {
            Object object3 = this.getObjectValue(object2);
            if (object3 instanceof Map) {
                Map map = (Map)object3;
                this.readStream((String)object2, true);
                object2 = map;
            } else {
                object2 = object3;
            }
        }
        return object2;
    }

    private byte[] readObjectData(int n) {
        boolean bl = false;
        int n2 = n;
        int n3 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (n < 1) {
            bl4 = true;
            n = 128;
        }
        int n4 = 0;
        int n5 = n;
        byte[] byArray = new byte[n5];
        if (this.miniumumCacheSize != -1 && n > this.miniumumCacheSize) {
            n = this.miniumumCacheSize;
        }
        this.startStreamPointer = -1;
        this.endStreamPointer = -1;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = this.miniumumCacheSize;
        boolean bl5 = this.miniumumCacheSize != -1;
        int n13 = 0;
        byte[] byArray2 = null;
        if (bl5) {
            byArray2 = new byte[n12];
        }
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        byte[] byArray5 = null;
        boolean bl6 = false;
        boolean bl7 = false;
        long l = 0L;
        long l2 = -1L;
        long l3 = -1L;
        ByteArrayOutputStream byteArrayOutputStream = null;
        if (bl) {
            byteArrayOutputStream = new ByteArrayOutputStream();
        }
        try {
            int n14;
            byte by = 0;
            int n15 = n - 1;
            int n16 = -n;
            int n17 = 0;
            int n18 = -1;
            int n19 = -1;
            while (true) {
                byte[] byArray6;
                int n20;
                if (++n15 == n) {
                    if (!bl5) {
                        if (n17 == 1) {
                            byArray5 = byArray4;
                        } else if (n17 > 1) {
                            n14 = byArray5.length;
                            n20 = byArray4.length;
                            byArray6 = new byte[n14 + n20];
                            System.arraycopy(byArray5, 0, byArray6, 0, n14);
                            System.arraycopy(byArray4, 0, byArray6, n14, n20);
                            byArray5 = byArray6;
                        }
                        ++n17;
                    }
                    if ((l = this.getPointer()) + (long)n > this.eof) {
                        n = (int)(this.eof - l);
                    }
                    byArray4 = new byte[n += 6];
                    this.pdf_datafile.read(byArray4);
                    n16 += n15;
                    n15 = 0;
                }
                byte by2 = by;
                by = byArray4[n15];
                boolean bl8 = false;
                if (by == 37) {
                    n19 = n3;
                }
                n6 = by == endPattern[n6] && !bl6 ? ++n6 : 0;
                n7 = bl3 && by == endObj[n7] && !bl6 ? ++n7 : 0;
                if (!bl2 && n2 != -1) {
                    if (!bl3 && by == lengthString[n8] && !bl6) {
                        if (++n8 == 6) {
                            bl2 = true;
                        }
                    } else {
                        n8 = 0;
                    }
                }
                if (bl5) {
                    if (!bl6 && by == 62 && by2 == 62) {
                        bl7 = false;
                    }
                    if (!bl6) {
                        n9 = n9 < 6 && by == startStream[n9] && !bl7 ? ++n9 : 0;
                        if (n9 == 6) {
                            bl6 = true;
                            bl3 = true;
                            if (byteArrayOutputStream != null && bl) {
                                byteArrayOutputStream.write(by);
                            }
                            byArray[n4] = by;
                            if (++n4 == n5) {
                                n5 = n5 < 0x200000 ? (n5 *= 2) : (n5 += 100000);
                                byte[] byArray7 = new byte[n5];
                                System.arraycopy(byArray, 0, byArray7, 0, byArray.length);
                                byArray = byArray7;
                            }
                            if (this.startStreamPointer == -1) {
                                bl8 = true;
                                n9 = 0;
                                n13 = n15 + 1;
                                if (byArray4[n13] == 13 && byArray4[n13 + 1] == 10) {
                                    n13 += 2;
                                } else if (byArray4[n13] == 10 | byArray4[n13] == 13) {
                                    ++n13;
                                }
                                this.startStreamPointer = (int)((long)n13 + l);
                            }
                            n13 += n16;
                        }
                    } else {
                        if (n11 < n12) {
                            byArray2[n11] = by;
                            ++n11;
                            bl8 = true;
                        }
                        if (by == endStream[n10] && !bl7) {
                            ++n10;
                        } else {
                            n10 = 0;
                            if (by == endStream[n10] && !bl7) {
                                ++n10;
                            }
                        }
                        if (n10 == 9) {
                            n10 = 0;
                            n14 = n15 - 9;
                            if (n11 < n12) {
                                for (n20 = 0; n20 < n11; ++n20) {
                                    if (byteArrayOutputStream != null) {
                                        byteArrayOutputStream.write(byArray2[n20]);
                                    }
                                    byArray[n4] = byArray2[n20];
                                    if (++n4 != n5) continue;
                                    n5 = n5 < 0x200000 ? (n5 *= 2) : (n5 += 100000);
                                    byArray6 = new byte[n5];
                                    System.arraycopy(byArray, 0, byArray6, 0, byArray.length);
                                    byArray = byArray6;
                                }
                                this.startStreamPointer = -1;
                            }
                            if (this.startStreamPointer != -1) {
                                this.endStreamPointer = (int)((long)n14 + l);
                            }
                            if (this.endStreamPointer < this.startStreamPointer) {
                                this.startStreamPointer = -1;
                                this.endStreamPointer = -1;
                            }
                            bl6 = false;
                            bl8 = true;
                        }
                    }
                    if (!bl6 && by == 60 && by2 == 60) {
                        bl7 = true;
                    }
                }
                if (n6 == 6 || n7 == 4) {
                    if (!bl2) break;
                    n6 = 0;
                    n7 = 0;
                    n18 = n3;
                }
                if (bl2 && n3 >= n2) break;
                if (!(bl8 || bl5 && bl6)) {
                    if (byteArrayOutputStream != null) {
                        byteArrayOutputStream.write(by);
                    }
                    byArray[n4] = by;
                    if (++n4 == n5) {
                        n5 = n5 < 0x200000 ? (n5 *= 2) : (n5 += 100000);
                        byte[] byArray8 = new byte[n5];
                        System.arraycopy(byArray, 0, byArray8, 0, byArray.length);
                        byArray = byArray8;
                    }
                }
                ++n3;
            }
            if (bl5) {
                byArray3 = byArray;
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                    byArray3 = byteArrayOutputStream.toByteArray();
                }
            } else {
                if (n17 == 1) {
                    byArray3 = new byte[n15];
                    System.arraycopy(byArray4, 0, byArray3, 0, n15);
                } else {
                    n14 = byArray5.length;
                    byArray3 = new byte[n14 + n15];
                    System.arraycopy(byArray5, 0, byArray3, 0, n14);
                    System.arraycopy(byArray4, 0, byArray3, n14, n15);
                }
                if (bl2 && n18 != -1 && n19 != -1 && n19 > n18) {
                    byte[] byArray9 = new byte[n18];
                    System.arraycopy(byArray3, 0, byArray9, 0, n18);
                    byArray3 = byArray9;
                }
            }
            if (this.startStreamPointer != -1) {
                // empty if block
            }
            if (!bl5 && !bl2) {
                byArray3 = this.checkEndObject(byArray3, l3, l2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            LogWriter.writeLog("Exception " + exception + " reading object");
        }
        return byArray3;
    }

    private byte[] checkEndObject(byte[] byArray, long l, long l2) {
        int n = 0;
        for (int i = 0; i < byArray.length - 8; ++i) {
            if (n < 2 && byArray[i] == 32 && byArray[i + 1] == 111 && byArray[i + 2] == 98 && byArray[i + 3] == 106) {
                ++n;
                l = i;
            }
            if (n >= 2 || byArray[i] != 101 || byArray[i + 1] != 110 || byArray[i + 2] != 100 || byArray[i + 3] != 115 || byArray[i + 4] != 116 || byArray[i + 5] != 114 || byArray[i + 6] != 101 || byArray[i + 7] != 97 || byArray[i + 8] != 109) continue;
            l2 = i + 9;
        }
        if (l2 > 0L && l > l2) {
            byte[] byArray2 = new byte[(int)l2];
            System.arraycopy(byArray, 0, byArray2, 0, (int)l2);
            byArray = byArray2;
        }
        return byArray;
    }

    private void verifyCachedData(boolean bl, byte[] byArray, int n) throws IOException {
        try {
            int n2 = this.endStreamPointer - this.startStreamPointer;
            if (n2 < 0) {
                System.out.println("Array size negative " + n2);
                System.out.println(this.startStreamPointer + " " + this.endStreamPointer);
                System.out.println(" ");
                for (int i = 0; i < this.startStreamPointer + 30; ++i) {
                    System.err.println(i + " " + (char)byArray[i]);
                }
                System.exit(1);
            }
            byte[] byArray2 = new byte[n2];
            this.movePointer(this.startStreamPointer);
            this.pdf_datafile.read(byArray2);
            n2 = byArray2.length;
            boolean bl2 = false;
            for (int i = 0; i < n2; ++i) {
                if (byArray[i + n] == byArray2[i]) continue;
                System.out.println("X1 Not same value at " + i + " ==" + byArray[i + n] + ' ' + byArray2[i]);
                bl2 = true;
                System.exit(1);
            }
            if (bl2) {
                System.exit(1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public int readDictionaryAsObject(PdfObject pdfObject, String string, int n, byte[] byArray, int n2, String string2, boolean bl) {
        int n3;
        int n4;
        int n5 = -1;
        int n6 = -1;
        int n7 = 0;
        if (bl) {
            n7 = 1;
        }
        Object var12_11 = null;
        while (!(n >= byArray.length || byArray[n] == 115 && byArray[n + 1] == 116 && byArray[n + 2] == 114 && byArray[n + 3] == 101 && byArray[n + 4] == 97 && byArray[n + 5] == 109 || n >= byArray.length || n2 != -1 && n >= n2 || byArray[n] == 101 && byArray[n + 1] == 110 && byArray[n + 2] == 100 && byArray[n + 3] == 111)) {
            if (byArray[n] == 60 && byArray[n + 1] == 60) {
                ++n;
                ++n7;
            } else if (byArray[n] == 62 && n + 1 != byArray.length && byArray[n + 1] == 62) {
                ++n;
                if (--n7 == 0) {
                    break;
                }
            } else if (byArray[n] == 47 && (byArray[n + 1] == 47 || byArray[n + 1] == 32)) {
                ++n;
            } else if (byArray[n] == 47) {
                int n8;
                int n9;
                int n10;
                n4 = 0;
                n3 = ++n;
                while (byArray[n] != 32 && byArray[n] != 13 && byArray[n] != 9 && byArray[n] != 10 && byArray[n] != 91 && byArray[n] != 47 && byArray[n] != 40 && byArray[n] != 60 && byArray[n] != 62) {
                    ++n;
                    ++n4;
                }
                n5 = PdfDictionary.getIntKey(n3, n4, byArray);
                if (pdfObject.getObjectType() == 2004251818 && (n5 == 2087749783 || n5 == -1938465939 || n5 == 878474856 || n5 == 979194486 || n5 == 373243460 || n5 == 1146450818)) {
                    n6 = 2;
                } else if (bl && n5 == 23) {
                    n5 = 1568372915;
                } else if (bl && n5 == 0x221712) {
                    n5 = 1785221209;
                } else if (bl && n5 == 39) {
                    n5 = 959726687;
                    n6 = 6;
                } else if (bl && n5 == 20) {
                    n5 = 859785322;
                    n6 = 10;
                } else if ((pdfObject.getObjectType() == 2087749783 || pdfObject.getObjectType() == 1518239089) && n5 == 30) {
                    n6 = 7;
                } else if (bl && n5 == 22) {
                    n5 = 1011108731;
                    n6 = 18;
                } else if (bl && n5 == 24) {
                    n5 = 959926393;
                    n6 = 6;
                } else {
                    n6 = n5 == 826096968 && pdfObject.getObjectType() == 2087749783 && pdfObject.getParameterConstant(2087749783) == 391471749 ? 7 : (n5 == 590957109 && pdfObject.getObjectType() == 23 ? 6 : (n5 == 39 && pdfObject.getObjectType() == 23 ? 9 : PdfDictionary.getKeyType(n5)));
                }
                if (n6 == -1) {
                    // empty if block
                }
                if (byArray[n] == 47 || byArray[n] == 40 || byArray[n] == 91) {
                    --n;
                }
                if (n6 == -1) {
                    n10 = byArray.length - 1;
                    for (n9 = n; n9 < n10; ++n9) {
                        if (byArray[n9] == 60 && byArray[n9 + 1] == 60) {
                            n8 = 0;
                            do {
                                if (byArray[n9] == 60 && byArray[n9 + 1] == 60) {
                                    ++n8;
                                    continue;
                                }
                                if (byArray[n9] != 62 || byArray[n9 + 1] != 62) continue;
                                --n8;
                            } while (n8 != 0 && ++n9 < n10);
                            n = n9;
                            n9 = n10;
                            continue;
                        }
                        if (byArray[n9] != 47) continue;
                        n9 = n10;
                    }
                }
                if (n5 != -1 && n6 != -1) {
                    n10 = pdfObject.ignoreRecursion() ? 1 : 0;
                    switch (n6) {
                        case 25: {
                            int n11;
                            int n12;
                            int n13;
                            if (n5 == 39) {
                                int n14;
                                n9 = 0;
                                while (byArray[n] != 91) {
                                    if (byArray[n] == 40) {
                                        n9 = 0;
                                        break;
                                    }
                                    if (byArray[n] >= 48 && byArray[n] <= 57) {
                                        n9 = 1;
                                        break;
                                    }
                                    ++n;
                                }
                                byte[] byArray2 = byArray;
                                n13 = n;
                                int n15 = n;
                                int n16 = 0;
                                if (n9 != 0) {
                                    n12 = n;
                                    n11 = 0;
                                    while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                                        ++n;
                                        ++n11;
                                    }
                                    n14 = PdfReader.parseInt(n12, n, byArray);
                                    while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                                        ++n;
                                    }
                                    n12 = n;
                                    while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                                        ++n;
                                    }
                                    int n17 = PdfReader.parseInt(n12, n, byArray);
                                    while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                                        ++n;
                                    }
                                    if (byArray[n] != 82) {
                                        throw new RuntimeException("3. Unexpected value in file " + byArray[n] + " - please send to IDRsolutions for analysis");
                                    }
                                    if (n10 == 0) {
                                        byArray2 = this.readObjectAsByteArray(string, false, this.isCompressed(n14, n17), n14, n17);
                                        n15 = 3;
                                        while (byArray2[n15 - 1] != 106 && byArray2[n15 - 2] != 98 && byArray2[n15 - 3] != 111) {
                                            ++n15;
                                        }
                                        while (byArray2[n15] == 10 || byArray2[n15] == 13 || byArray2[n15] == 32) {
                                            ++n15;
                                        }
                                        n13 = n15;
                                    }
                                }
                                while (n15 < byArray2.length) {
                                    if (byArray2[n15] == 91 || byArray2[n15] == 40) {
                                        ++n16;
                                    } else if (byArray2[n15] == 93 || byArray2[n15] == 41) {
                                        --n16;
                                    }
                                    if (n16 == 0) break;
                                    ++n15;
                                }
                                if (n10 == 0) {
                                    n12 = n15 - n13 + 1;
                                    byte[] byArray3 = new byte[n12];
                                    System.arraycopy(byArray2, n13, byArray3, 0, n12);
                                    for (n14 = 0; n14 < n12; ++n14) {
                                        if (byArray3[n14] != 10 && byArray3[n14] != 13) continue;
                                        byArray3[n14] = 32;
                                    }
                                    pdfObject.setTextStreamValue(n5, byArray3);
                                }
                                if (n9 != 0) break;
                                n = n15;
                                break;
                            }
                            try {
                                while (byArray[n] != 40 && byArray[n] != 60) {
                                    ++n;
                                }
                                n9 = byArray[n];
                                n8 = n;
                                while (!(n >= byArray.length || n9 == 40 && byArray[n] == 41 && (n > 0 && byArray[n - 1] != 92 || n > 1 && byArray[n - 2] == 92) || n9 == 60 && byArray[++n] == 62)) {
                                }
                                if (n10 != 0) break;
                                n13 = n - n8;
                                byte[] byArray4 = new byte[n13];
                                System.arraycopy(byArray, n8, byArray4, 0, n13);
                                pdfObject.setTextStreamValue(n5, byArray4);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                System.exit(1);
                            }
                            break;
                        }
                        case 2: {
                            int n11;
                            int n12;
                            int n13;
                            while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47) {
                                ++n;
                            }
                            byte[] byArray5 = byArray;
                            n8 = n;
                            int n18 = n13 = byArray5[n8] != 60 ? 1 : 0;
                            if (n13 != 0) {
                                int n19 = n;
                                int n20 = 0;
                                while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                                    ++n;
                                    ++n20;
                                }
                                n12 = PdfReader.parseInt(n19, n, byArray);
                                while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                                    ++n;
                                }
                                n19 = n;
                                while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                                    ++n;
                                }
                                n11 = PdfReader.parseInt(n19, n, byArray);
                                while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                                    ++n;
                                }
                                if (byArray[n] != 82) {
                                    throw new RuntimeException("3. Unexpected value in file " + byArray[n] + " - please send to IDRsolutions for analysis");
                                }
                                if (n10 == 0) {
                                    byArray5 = this.readObjectAsByteArray(string, false, this.isCompressed(n12, n11), n12, n11);
                                    n8 = 3;
                                    while (byArray5[n8 - 1] != 106 && byArray5[n8 - 2] != 98 && byArray5[n8 - 3] != 111) {
                                        ++n8;
                                    }
                                    while (byArray5[n8] == 10 || byArray5[n8] == 13 || byArray5[n8] == 32) {
                                        ++n8;
                                    }
                                }
                            }
                            PdfObject pdfObject2 = PdfObjectFactory.createObject(n5, string);
                            if (n10 != 0) {
                                n8 = this.readKeyPairs(n5, byArray5, n8, -2, null, string2);
                            } else {
                                int n21 = this.readKeyPairs(n5, byArray5, n8, -1, null, string2);
                                n8 = this.readKeyPairs(n5, byArray5, n8, n21, pdfObject2, string2);
                                pdfObject.setDictionary(n5, pdfObject2);
                            }
                            if (n13 != 0) break;
                            n = n8;
                            break;
                        }
                        case 12: {
                            n = this.readArray(false, n, n2, 12, byArray, string, pdfObject, n5, false, string2);
                            break;
                        }
                        case 14: {
                            n = this.readArray(n10 != 0, n, n2, 14, byArray, string, pdfObject, n5, false, string2);
                            break;
                        }
                        case 18: {
                            n = this.readArray(n10 != 0, n, n2, 18, byArray, string, pdfObject, n5, false, string2);
                            break;
                        }
                        case 16: {
                            n = this.readArray(false, n, n2, 16, byArray, string, pdfObject, n5, false, string2);
                            break;
                        }
                        case 9: {
                            n = this.readArray(false, n, n2, 9, byArray, string, pdfObject, n5, false, string2);
                            break;
                        }
                        case 10: {
                            n = this.readArray(false, n, n2, 10, byArray, string, pdfObject, n5, false, string2);
                            break;
                        }
                        case 30: {
                            n = this.readUncodedString(pdfObject, string, n, byArray, false, n5, string2);
                            break;
                        }
                        case 8: {
                            ++n;
                            while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47) {
                                ++n;
                            }
                            n3 = n;
                            n4 = 0;
                            while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                                ++n;
                                ++n4;
                            }
                            --n;
                            if (byArray[n3] == 116 && byArray[n3 + 1] == 114 && byArray[n3 + 2] == 117 && byArray[n3 + 3] == 101) {
                                pdfObject.setBoolean(n5, true);
                                break;
                            }
                            if (byArray[n3] == 102 && byArray[n3 + 1] == 97 && byArray[n3 + 2] == 108 && byArray[n3 + 3] == 115 && byArray[n3 + 4] == 101) {
                                pdfObject.setBoolean(n5, false);
                                break;
                            }
                            throw new RuntimeException("Unexpected value for Boolean value ");
                        }
                        case 3: {
                            ++n;
                            while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47) {
                                ++n;
                            }
                            n3 = n;
                            n4 = 0;
                            while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                                ++n;
                                ++n4;
                            }
                            --n;
                            n9 = pdfObject.setConstant(n5, n3, n4, byArray);
                            break;
                        }
                        case 4: {
                            ++n;
                            while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47) {
                                ++n;
                            }
                            n3 = n;
                            n4 = 1;
                            while (byArray[n] != 82) {
                                ++n;
                                ++n4;
                            }
                            --n;
                            byte[] byArray6 = new byte[n4];
                            System.arraycopy(byArray, n3, byArray6, 0, n4);
                            pdfObject.setStringKey(n5, byArray6);
                            break;
                        }
                        case 6: {
                            ++n;
                            while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47) {
                                ++n;
                            }
                            n = this.readNumber(pdfObject, string, n, byArray, string2, false, n5, var12_11);
                            break;
                        }
                        case 7: {
                            int n12;
                            int n13;
                            ++n;
                            while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47) {
                                ++n;
                            }
                            n3 = n;
                            n4 = 0;
                            while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                                ++n;
                                ++n4;
                            }
                            float f = PdfReader.parseFloat(n3, n, byArray);
                            for (n8 = n; n8 < byArray.length && (byArray[n8] == 32 || byArray[n8] == 13 || byArray[n8] == 10); ++n8) {
                            }
                            if (byArray[n8] >= 48 && byArray[n8] <= 57) {
                                while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                                    ++n;
                                }
                                n3 = n;
                                while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                                    ++n;
                                }
                                n13 = PdfReader.parseInt(n3, n, byArray);
                                while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                                    ++n;
                                }
                                if (byArray[n] != 82) {
                                    throw new RuntimeException("3. Unexpected value in file - please send to IDRsolutions for analysis");
                                }
                                byte[] byArray7 = this.readObjectAsByteArray(string, false, this.isCompressed((int)f, n13), (int)f, n13);
                                int n22 = 3;
                                while (byArray7[n22 - 1] != 106 && byArray7[n22 - 2] != 98 && byArray7[n22 - 3] != 111) {
                                    ++n22;
                                }
                                while (byArray7[n22] == 10 || byArray7[n22] == 13 || byArray7[n22] == 32) {
                                    ++n22;
                                }
                                n12 = n22;
                                while (byArray7[n12] != 10 && byArray7[n12] != 13 && byArray7[n12] != 32) {
                                    ++n12;
                                }
                                f = PdfReader.parseFloat(n22, n12, byArray7);
                            }
                            pdfObject.setFloatNumber(n5, f);
                            --n;
                            break;
                        }
                        case 1: {
                            int n13;
                            if (byArray[n] != 60) {
                                ++n;
                            }
                            while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32) {
                                ++n;
                            }
                            if (byArray[n] == 47) {
                                while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                                    ++n;
                                }
                                n3 = n;
                                n4 = 0;
                                while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                                    ++n;
                                    ++n4;
                                }
                                --n;
                                if (n10 != 0) break;
                                PdfObject pdfObject3 = PdfObjectFactory.createObject(n5, string);
                                n8 = pdfObject3.setConstant(n5, n3, n4, byArray);
                                if (n8 == -1 || bl) {
                                    n13 = n4;
                                    byte[] byArray8 = new byte[n13];
                                    System.arraycopy(byArray, n3, byArray8, 0, n13);
                                    String string3 = new String(byArray8);
                                    pdfObject3.setGeneralStringValue(string3);
                                }
                                pdfObject.setDictionary(n5, pdfObject3);
                                break;
                            }
                            if (byArray[n] == 101 && byArray[n + 1] == 110 && byArray[n + 2] == 100 && byArray[n + 3] == 111 && byArray[n + 4] == 98) break;
                            if (n10 != 0) {
                                while (byArray[n] == 91 || byArray[n] == 32 || byArray[n] == 13 || byArray[n] == 10) {
                                    ++n;
                                }
                                if (byArray[n] == 60 && byArray[n + 1] == 60) {
                                    n += 2;
                                    n9 = 1;
                                    while (n9 > 0) {
                                        if (byArray[n] == 60 && byArray[n + 1] == 60) {
                                            n += 2;
                                            ++n9;
                                            continue;
                                        }
                                        if (byArray[n] == 62 && byArray[n + 1] == 62) {
                                            n += 2;
                                            --n9;
                                            continue;
                                        }
                                        ++n;
                                    }
                                    --n;
                                } else {
                                    n = this.readDictionaryFromRefOrDirect(n5, pdfObject, string, n, byArray, false, n5, var12_11, string2);
                                }
                                if (byArray[n] != 47) break;
                                --n;
                                break;
                            }
                            n = this.readDictionaryFromRefOrDirect(n5, pdfObject, string, n, byArray, false, n5, var12_11, string2);
                        }
                    }
                }
            }
            ++n;
        }
        n4 = byArray.length;
        for (n3 = n; n3 < n4 - 5 && (byArray[n3] != 62 || byArray[n3 + 1] != 62); ++n3) {
            if (byArray[n3] != 115 || byArray[n3 + 1] != 116 || byArray[n3 + 2] != 114 || byArray[n3 + 3] != 101 || byArray[n3 + 4] != 97 || byArray[n3 + 5] != 109) continue;
            this.readStreamIntoObject(pdfObject, false, n3, byArray, pdfObject, string2);
            n3 = n4;
        }
        return n;
    }

    private int readNumber(PdfObject pdfObject, String string, int n, byte[] byArray, String string2, boolean bl, int n2, Object object) {
        int n3;
        int n4;
        int n5 = n;
        int n6 = 0;
        while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62 && byArray[n] != 40) {
            ++n;
            ++n6;
        }
        int n7 = PdfReader.parseInt(n5, n, byArray);
        for (n4 = n; n4 < byArray.length && (byArray[n4] == 32 || byArray[n4] == 13 || byArray[n4] == 10); ++n4) {
        }
        boolean bl2 = false;
        if (byArray[n4] >= 48 && byArray[n4] <= 57) {
            n3 = n4;
            while (byArray[n3] != 10 && byArray[n3] != 13 && byArray[n3] != 32 && byArray[n3] != 47 && byArray[n3] != 60 && byArray[n3] != 62) {
                ++n3;
            }
            while (n3 < byArray.length && (byArray[n3] == 10 || byArray[n3] == 13 || byArray[n3] == 32 || byArray[n3] == 47)) {
                ++n3;
            }
            boolean bl3 = bl2 = n3 < byArray.length && byArray[n3] == 82;
        }
        if (bl2) {
            while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                ++n;
            }
            n5 = n;
            while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                ++n;
            }
            n3 = PdfReader.parseInt(n5, n, byArray);
            while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                ++n;
            }
            if (byArray[n] != 82) {
                throw new RuntimeException("3. Unexpected value in file - please send to IDRsolutions for analysis");
            }
            byte[] byArray2 = this.readObjectAsByteArray(string, false, this.isCompressed(n7, n3), n7, n3);
            int n8 = 3;
            while (byArray2[n8 - 1] != 106 && byArray2[n8 - 2] != 98 && byArray2[n8 - 3] != 111) {
                ++n8;
            }
            while (byArray2[n8] == 10 || byArray2[n8] == 13 || byArray2[n8] == 32) {
                ++n8;
            }
            int n9 = n8;
            while (byArray2[n9] != 10 && byArray2[n9] != 13 && byArray2[n9] != 32) {
                ++n9;
            }
            n7 = PdfReader.parseInt(n8, n9, byArray2);
        }
        pdfObject.setIntNumber(n2, n7);
        if (bl) {
            System.out.println(string2 + "set key=" + object + " numberValue=" + n7 + " in " + pdfObject);
        }
        return --n;
    }

    public int handleColorSpaces(PdfObject pdfObject, int n, byte[] byArray, boolean bl, String string) {
        while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 91) {
            ++n;
        }
        if (byArray[n] == 47) {
            ++n;
            while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47) {
                ++n;
            }
            int n2 = n;
            int n3 = 0;
            while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62 && byArray[n] != 91 && byArray[n] != 93) {
                ++n3;
                if (++n != byArray.length) continue;
            }
            --n;
            int n4 = pdfObject.setConstant(2087749783, n2, n3, byArray);
            ++n;
            switch (n4) {
                case 1008872003: {
                    n = this.handleColorSpaces(pdfObject, n, byArray, bl, string + "    ");
                    ++n;
                    break;
                }
                case 391471749: {
                    n = this.handleColorSpaces(pdfObject, n, byArray, bl, string + "    ");
                    ++n;
                    break;
                }
                case 1498837125: {
                    break;
                }
                case 1568372915: {
                    break;
                }
                case 960981604: {
                    int n5;
                    for (n5 = n; n5 < byArray.length && byArray[n5] != 93; ++n5) {
                    }
                    n = this.readArray(false, n, n5, 20, byArray, "", pdfObject, 1920898752, bl, string);
                    while (byArray[n] == 93 || byArray[n] == 32 || byArray[n] == 10 || byArray[n] == 13) {
                        ++n;
                    }
                    PdfColorSpaceObject pdfColorSpaceObject = new PdfColorSpaceObject(1);
                    n = this.handleColorSpaces(pdfColorSpaceObject, n, byArray, bl, string + "    ");
                    pdfObject.setDictionary(-1247101998, pdfColorSpaceObject);
                    ++n;
                    PdfFunctionObject pdfFunctionObject = new PdfFunctionObject(1);
                    n = this.handleColorSpaces(pdfFunctionObject, n, byArray, bl, string + "    ");
                    pdfObject.setDictionary(-1313946392, pdfFunctionObject);
                    ++n;
                    break;
                }
                case 1785221209: {
                    break;
                }
                case 1247168582: {
                    n = this.readDictionaryFromRefOrDirect(-1, pdfObject, "", n, byArray, bl, 2087749783, "ICC colorspace", string);
                    break;
                }
                case 895578984: {
                    PdfColorSpaceObject pdfColorSpaceObject = new PdfColorSpaceObject(1);
                    pdfObject.setDictionary(895578984, pdfColorSpaceObject);
                    for (n = this.handleColorSpaces(pdfColorSpaceObject, n, byArray, bl, new StringBuffer().append(string).append("    ").toString()); n < byArray.length && (byArray[n] == 32 || byArray[n] == 13 || byArray[n] == 10 || byArray[n] == 93 || byArray[n] == 62); ++n) {
                    }
                    n = this.readNumber(pdfObject, "", n, byArray, string, false, 960901492, "hival");
                    ++n;
                    while (n < byArray.length && (byArray[n] == 32 || byArray[n] == 13 || byArray[n] == 10)) {
                        ++n;
                    }
                    n = this.handleColorSpaces(pdfObject, n, byArray, bl, string);
                    ++n;
                    break;
                }
                case 1847602: {
                    n = this.handleColorSpaces(pdfObject, n, byArray, bl, string);
                    ++n;
                    break;
                }
                case 1146450818: {
                    break;
                }
                case -2073385820: {
                    int n6 = n;
                    while (byArray[n6] == 47 || byArray[n6] == 32 || byArray[n6] == 10 || byArray[n6] == 13) {
                        ++n6;
                    }
                    int n7 = n6;
                    while (n6 < byArray.length && byArray[n6] != 47 && byArray[n6] != 32 && byArray[n6] != 13 && byArray[n6] != 10) {
                        ++n6;
                    }
                    n3 = n6 - n7;
                    byte[] byArray2 = new byte[n3];
                    System.arraycopy(byArray, n7, byArray2, 0, n3);
                    pdfObject.setStringValue(506543413, byArray2);
                    n = n6;
                    if (byArray[n] != 47) {
                        ++n;
                    }
                    PdfColorSpaceObject pdfColorSpaceObject = new PdfColorSpaceObject(pdfObject.getObjectRefAsString());
                    n = this.handleColorSpaces(pdfColorSpaceObject, n, byArray, bl, string);
                    pdfObject.setDictionary(-1247101998, pdfColorSpaceObject);
                    if (byArray[n] != 60) {
                        ++n;
                    }
                    PdfFunctionObject pdfFunctionObject = new PdfFunctionObject(pdfObject.getObjectRefAsString());
                    n = this.handleColorSpaces(pdfFunctionObject, n, byArray, bl, string);
                    pdfObject.setDictionary(-1313946392, pdfFunctionObject);
                    ++n;
                    break;
                }
            }
        } else if (byArray[n] == 60 && byArray[n + 1] == 60) {
            n = this.convertDirectDictionaryToObject(pdfObject, "", n, byArray, bl, -1, string);
            int n8 = byArray.length;
            int n9 = 0;
            for (int i = n; i < n8 - 5; ++i) {
                if (byArray[i] == 62 && byArray[i + 1] == 62) {
                    ++n9;
                }
                if (n9 != 2) {
                    if (byArray[i] != 115 || byArray[i + 1] != 116 || byArray[i + 2] != 114 || byArray[i + 3] != 101 || byArray[i + 4] != 97 || byArray[i + 5] != 109) continue;
                    this.readStreamIntoObject(pdfObject, bl, i, byArray, pdfObject, string);
                    i = n8;
                    continue;
                }
                break;
            }
        } else if (byArray[n] == 60) {
            int n10 = ++n;
            int n11 = 0;
            while (byArray[n10] != 62) {
                if (byArray[n10] != 32 && byArray[n10] != 10 && byArray[n10] != 13) {
                    ++n11;
                }
                ++n10;
            }
            int n12 = n11 >> 1;
            byte[] byArray3 = new byte[n12];
            int n13 = 0;
            int n14 = 0;
            int n15 = 0;
            while (true) {
                if (byArray[n] == 32 || byArray[n] == 10 || byArray[n] == 13) {
                    ++n;
                    continue;
                }
                n14 = byArray[n];
                if (n14 >= 65 && n14 <= 70) {
                    n14 -= 55;
                } else if (n14 >= 97 && n14 <= 102) {
                    n14 -= 87;
                } else if (n14 >= 48 && n14 <= 57) {
                    n14 -= 48;
                } else {
                    throw new RuntimeException("Unexpected number " + (char)byArray[n]);
                }
                ++n;
                while (byArray[n] == 32 || byArray[n] == 10 || byArray[n] == 13) {
                    ++n;
                }
                n15 = byArray[n];
                if (n15 >= 65 && n15 <= 70) {
                    n15 -= 55;
                } else if (n15 >= 97 && n15 <= 102) {
                    n15 -= 87;
                } else if (n15 >= 48 && n15 <= 57) {
                    n15 -= 48;
                } else {
                    throw new RuntimeException("Unexpected number " + (char)byArray[n]);
                }
                ++n;
                int n16 = n15 + (n14 << 4);
                byArray3[n13] = (byte)n16;
                if (++n13 == n12) break;
            }
            pdfObject.DecodedStream = byArray3;
        } else if (byArray[n] == 40) {
            int n17 = ++n;
            int n18 = 0;
            boolean bl2 = false;
            int n19 = 0;
            for (n19 = n17; !(n19 >= byArray.length || byArray[n19] == 41 && byArray[n19 - 1] != 92 || byArray[n19] == 41 && byArray[n19 - 1] == 92 && byArray[n19 - 2] == 92); ++n19) {
            }
            byte[] byArray4 = new byte[n19 - n17];
            int n20 = n17;
            int n21 = 0;
            while (n20 < n19) {
                byArray4[n21] = byArray[n20];
                ++n20;
                ++n21;
            }
            n = n17;
            for (n20 = 0; n20 < byArray4.length; ++n20) {
                if (byArray4[n20] == 10 || byArray4[n20] == 13) continue;
                if (byArray4[n20] == 92) {
                    if (byArray4[n20 + 1] == 92) {
                        ++n18;
                        ++n20;
                        continue;
                    }
                    if (byArray4[n20 + 1] >= 48 && byArray4[n20 + 1] <= 57) {
                        if (n20 + 2 < byArray4.length && byArray4[n20 + 2] >= 48 && byArray4[n20 + 2] <= 57) {
                            ++n18;
                            n20 += 3;
                            continue;
                        }
                        ++n18;
                        ++n20;
                        continue;
                    }
                    if (byArray4[n20 + 1] < 48 || byArray4[n20 + 1] > 57) {
                        ++n18;
                        ++n20;
                        continue;
                    }
                    throw new RuntimeException("Not accounted for yet");
                }
                ++n18;
            }
            n20 = 0;
            n21 = 0;
            int n22 = n18;
            byte[] byArray5 = new byte[n22];
            n = 0;
            do {
                block100: {
                    if (n >= byArray4.length) {
                        System.err.println("Exited too soon!");
                        break;
                    }
                    while (byArray4[n] == 10 || byArray4[n] == 13) {
                        ++n;
                    }
                    n20 = byArray4[n];
                    if (n20 <= 122 && n20 >= 97) {
                        byArray5[n21] = (byte)n20;
                    } else if (n20 <= 90 && n20 >= 65) {
                        byArray5[n21] = (byte)n20;
                    } else {
                        if (n20 == 92) {
                            while (true) {
                                int n23;
                                int n24 = 0;
                                int n25 = ++n;
                                for (n23 = 0; n23 < 3; ++n23) {
                                    if (n25 >= byArray4.length || byArray4[n25] < 48 || byArray4[n25] > 57 || n24 >= 3) continue;
                                    ++n25;
                                    ++n24;
                                }
                                n20 = 0;
                                if (n24 > 0) {
                                    for (n23 = 0; n23 < n24; ++n23) {
                                        int n26 = 0;
                                        n26 = byArray4[n + n23] - 48;
                                        switch (n24) {
                                            case 1: {
                                                break;
                                            }
                                            case 2: {
                                                if (n23 != 0) break;
                                                n26 *= 8;
                                                break;
                                            }
                                            case 3: {
                                                if (n23 == 0) {
                                                    n26 *= 64;
                                                    break;
                                                }
                                                if (n23 != 1) break;
                                                n26 *= 8;
                                            }
                                        }
                                        n20 += n26;
                                    }
                                    n = n + n24 - 1;
                                    byArray5[n21] = (byte)n20;
                                    break block100;
                                }
                                if (byArray4[n] == 92) {
                                    byArray5[n21] = 92;
                                    break block100;
                                }
                                if (byArray4[n] == 114) {
                                    byArray5[n21] = 114;
                                    break block100;
                                }
                                if (byArray4[n] == 116) {
                                    byArray5[n21] = 116;
                                    break block100;
                                }
                                if (byArray4[n] == 41) {
                                    byArray5[n21] = 41;
                                    break block100;
                                }
                                if (byArray4[n] == 40) {
                                    byArray5[n21] = 40;
                                    break block100;
                                }
                                if (byArray4[n] == 98) {
                                    byArray5[n21] = 98;
                                    break block100;
                                }
                                if (byArray4[n] == 110) {
                                    byArray5[n21] = 110;
                                    break block100;
                                }
                                if (byArray4[n] == 102) {
                                    byArray5[n21] = 102;
                                    break block100;
                                }
                                if (byArray4[n] == 13) {
                                    byArray5[n21] = 13;
                                    break block100;
                                }
                                System.out.println("Encountered value nRaw[" + n + "]=" + byArray4[n]);
                            }
                        }
                        if (n20 < 48 || n20 > 57) {
                            byArray5[n21] = (byte)n20;
                        } else if (n20 >= 48 && n20 <= 57) {
                            byArray5[n21] = (byte)n20;
                        } else {
                            System.out.println("Oct: scenario not yet accounted for ! octVal=" + n20);
                        }
                    }
                }
                ++n;
            } while (++n21 != n22);
            pdfObject.DecodedStream = byArray5;
            n = n17;
        } else {
            int n27 = n;
            boolean bl3 = false;
            while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                ++n;
            }
            int n28 = PdfReader.parseInt(n27, n, byArray);
            while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                ++n;
            }
            n27 = n;
            while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                ++n;
            }
            int n29 = PdfReader.parseInt(n27, n, byArray);
            while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                ++n;
            }
            if (byArray[n] != 82) {
                throw new RuntimeException("3. Unexpected value in file " + byArray[n] + " - please send to IDRsolutions for analysis");
            }
            ++n;
            pdfObject.setRef(n28, n29);
            byte[] byArray6 = this.readObjectAsByteArray("1", false, this.isCompressed(n28, n29), n28, n29);
            int n30 = 0;
            if (byArray6[0] != 91) {
                n30 = 3;
                while (byArray6[n30 - 1] != 106 && byArray6[n30 - 2] != 98 && byArray6[n30 - 3] != 111) {
                    ++n30;
                }
            }
            this.handleColorSpaces(pdfObject, n30, byArray6, bl, string);
        }
        if (n < byArray.length && (byArray[n] == 47 || byArray[n] == 62)) {
            --n;
        }
        return n;
    }

    private int readDictionaryFromRefOrDirect(int n, PdfObject pdfObject, String string, int n2, byte[] byArray, boolean bl, int n3, Object object, String string2) {
        int n4 = -1;
        while (byArray[n2] == 91 || byArray[n2] == 32 || byArray[n2] == 13 || byArray[n2] == 10) {
            if (byArray[n2] == 91) {
                n4 = n2;
            }
            ++n2;
        }
        if (n3 == 2087749783 || n == 2087749783) {
            PdfObject pdfObject2 = (PdfObject)this.cachedColorspaces.get(string);
            if (pdfObject2 == null && !pdfObject.ignoreRecursion()) {
                if (pdfObject.getObjectType() == 2087749783) {
                    return this.handleColorSpaces(pdfObject, n2, byArray, bl, string2);
                }
                pdfObject2 = new PdfColorSpaceObject(string);
                pdfObject.setDictionary(2087749783, pdfObject2);
                return this.handleColorSpaces(pdfObject2, n2, byArray, bl, string2);
            }
            pdfObject.setDictionary(2087749783, pdfObject2);
            if (byArray[n2] == 60 && byArray[n2 + 1] == 60) {
                n2 += 2;
                int n5 = 1;
                while (n5 > 0) {
                    if (byArray[n2] == 60 && byArray[n2 + 1] == 60) {
                        n2 += 2;
                        ++n5;
                        continue;
                    }
                    if (byArray[n2] == 62 && byArray[n2 + 1] == 62) {
                        n2 += 2;
                        --n5;
                        continue;
                    }
                    ++n2;
                }
            } else {
                while (byArray[n2] != 82) {
                    ++n2;
                }
                ++n2;
            }
            return n2;
        }
        if (n4 != -1 && (n3 == 489767739 || n3 == 9250)) {
            int n6;
            for (n6 = n4; byArray[n6] != 93 && n6 <= byArray.length; ++n6) {
            }
            PdfObject pdfObject3 = PdfObjectFactory.createObject(n3, null);
            pdfObject.setDictionary(n3, pdfObject3);
            pdfObject3.ignoreRecursion(pdfObject.ignoreRecursion());
            int n7 = 9;
            if (n3 == 9250) {
                n7 = 14;
            }
            n2 = this.readArray(pdfObject.ignoreRecursion(), n4, n6, n7, byArray, string, pdfObject3, n3, bl, string2);
            if (bl) {
                System.out.println(string2 + "Set Array " + object + " for Mask or TR " + pdfObject3 + " in " + pdfObject);
            }
            return n2;
        }
        if (byArray[n2] == 37) {
            while (byArray[++n2] != 13 && byArray[n2] != 10) {
            }
            while (byArray[n2] == 91 || byArray[n2] == 32 || byArray[n2] == 13 || byArray[n2] == 10) {
                ++n2;
            }
        }
        if (byArray[n2] == 60) {
            n2 = this.convertDirectDictionaryToObject(pdfObject, string, n2, byArray, bl, n3, string2);
        } else if (byArray[n2] == 47) {
            int n8 = ++n2;
            while (n2 < byArray.length && byArray[n2] != 32 && byArray[n2] != 10 && byArray[n2] != 13) {
                ++n2;
            }
            int n9 = pdfObject.setConstant(n3, n8, n2 - n8, byArray);
            if (bl) {
                System.out.println(string2 + "Set object " + pdfObject + " to " + n9);
            }
        } else {
            int n10;
            int n11;
            int n12;
            int n13;
            boolean bl2;
            int n14 = n2;
            byte[] byArray2 = byArray;
            while (true) {
                block64: {
                    if (byArray2[n14] == 91 || byArray2[n14] == 32 || byArray2[n14] == 13 || byArray2[n14] == 10) {
                        ++n14;
                        continue;
                    }
                    bl2 = false;
                    do {
                        if (bl2 && byArray2[n14] == 93) {
                            return n14;
                        }
                        n13 = n14;
                        while (byArray2[n14] != 10 && byArray2[n14] != 13 && byArray2[n14] != 32 && byArray2[n14] != 47 && byArray2[n14] != 60 && byArray2[n14] != 62) {
                            if (bl2 && byArray2[n14] == 93) {
                                return n14;
                            }
                            ++n14;
                        }
                        n12 = PdfReader.parseInt(n13, n14, byArray2);
                        while (byArray2[n14] == 10 || byArray2[n14] == 13 || byArray2[n14] == 32) {
                            ++n14;
                        }
                        if (n12 != 69560) break block64;
                        bl2 = true;
                    } while (byArray2[n14] != 60);
                    return this.readDictionaryFromRefOrDirect(n, pdfObject, string, n14, byArray, bl, n3, object, string2);
                }
                n13 = n14;
                while (byArray2[n14] != 10 && byArray2[n14] != 13 && byArray2[n14] != 32 && byArray2[n14] != 47 && byArray2[n14] != 60 && byArray2[n14] != 62) {
                    ++n14;
                }
                n11 = PdfReader.parseInt(n13, n14, byArray2);
                while (byArray2[n14] == 10 || byArray2[n14] == 13 || byArray2[n14] == 32 || byArray2[n14] == 47 || byArray2[n14] == 60) {
                    ++n14;
                }
                if (byArray2[n14] != 82) {
                    throw new RuntimeException("ref=" + n12 + " gen=" + n12 + " 1. Unexpected value " + byArray2[n14] + " in file - please send to IDRsolutions for analysis char=" + (char)byArray2[n14]);
                }
                byArray2 = this.readObjectAsByteArray(string, false, this.isCompressed(n12, n11), n12, n11);
                if (byArray2 == null) {
                    if (!bl) break;
                    System.out.println(string2 + "null data");
                    break;
                }
                for (n10 = 0; (n10 < 3 || n10 > 2 && byArray2[n10 - 1] != 106 && byArray2[n10 - 2] != 98 && byArray2[n10 - 3] != 111) && byArray2[n10] != 47; ++n10) {
                }
                while (byArray2[n10] == 10 || byArray2[n10] == 13 || byArray2[n10] == 32) {
                    ++n10;
                }
                if (byArray2[n10] != 91) {
                    n14 = 0;
                    break;
                }
                n14 = n10;
            }
            if (byArray2 != null) {
                while (byArray2[n14] == 10 || byArray2[n14] == 13 || byArray2[n14] == 32) {
                    ++n14;
                }
                boolean bl3 = bl2 = byArray[n14] == 60;
                if (bl2) {
                    for (n10 = n14; n10 < byArray2.length && (byArray[n10] == 60 || byArray[n10] == 10 || byArray[n10] == 13 || byArray[n10] == 32); ++n10) {
                    }
                    if (byArray[n10] == 47) {
                        bl2 = false;
                    }
                }
                if (bl2) {
                    n13 = n14;
                    while (byArray2[n14] != 10 && byArray2[n14] != 13 && byArray2[n14] != 32 && byArray2[n14] != 47 && byArray2[n14] != 60 && byArray2[n14] != 62) {
                        ++n14;
                    }
                    n12 = PdfReader.parseInt(n13, n14, byArray2);
                    while (byArray2[n14] == 10 || byArray2[n14] == 13 || byArray2[n14] == 32 || byArray2[n14] == 47 || byArray2[n14] == 60) {
                        ++n14;
                    }
                    n13 = n14;
                    while (byArray2[n14] != 10 && byArray2[n14] != 13 && byArray2[n14] != 32 && byArray2[n14] != 47 && byArray2[n14] != 60 && byArray2[n14] != 62) {
                        ++n14;
                    }
                    n11 = PdfReader.parseInt(n13, n14, byArray2);
                    while (byArray2[n14 - 1] != 106 && byArray2[n14 - 2] != 98 && byArray2[n14 - 3] != 111 && byArray2[n14] != 60) {
                        ++n14;
                    }
                }
                while (byArray2[n14] == 10 || byArray2[n14] == 13 || byArray2[n14] == 32) {
                    ++n14;
                }
                if (byArray2[0] != 60) {
                    while (byArray2[n14] != 60 && byArray2[n14 + 1] != 60 && byArray2[n14] != 47) {
                        ++n14;
                    }
                }
                if (byArray2[n14] == 47) {
                    n13 = ++n14;
                    int n15 = 0;
                    while (byArray2[n14] != 10 && byArray2[n14] != 13 && byArray2[n14] != 32 && byArray2[n14] != 47 && byArray2[n14] != 60 && byArray2[n14] != 62) {
                        ++n14;
                        ++n15;
                    }
                    --n2;
                    if (n3 == -1) {
                        n10 = pdfObject.setConstant(n3, n13, n15, byArray2);
                        if (bl) {
                            System.out.println(string2 + "Set object Constant directly to " + n10);
                        }
                    } else {
                        PdfObject pdfObject4 = PdfObjectFactory.createObject(n3, null);
                        int n16 = pdfObject4.setConstant(n3, n13, n15, byArray2);
                        pdfObject.setDictionary(n3, pdfObject4);
                        if (bl) {
                            System.out.println(string2 + "Set object to Constant " + object + " in " + pdfObject4 + " to " + n16);
                        }
                    }
                } else {
                    PdfObject pdfObject5 = null;
                    if (n3 == -1) {
                        pdfObject5 = pdfObject;
                    } else {
                        pdfObject5 = PdfObjectFactory.createObject(n3, n12, n11);
                        if (n3 != 2004251818) {
                            pdfObject5.ignoreRecursion(pdfObject.ignoreRecursion());
                        }
                    }
                    if (bl) {
                        // empty if block
                    }
                    n14 = this.readDictionaryAsObject(pdfObject5, n12 + " " + n11 + " R", n14, byArray2, byArray2.length, string2, false);
                    if (bl) {
                        System.out.println(string2 + "------------------------<<<<Saving Dictionary " + pdfObject5 + " for key " + object + " into " + pdfObject);
                    }
                    if (n3 != -1) {
                        pdfObject.setDictionary(n3, pdfObject5);
                    }
                }
            }
        }
        return n2;
    }

    private int convertDirectDictionaryToObject(PdfObject pdfObject, String string, int n, byte[] byArray, boolean bl, int n2, String string2) {
        PdfObject pdfObject2 = null;
        pdfObject2 = n2 == -1 ? pdfObject : PdfObjectFactory.createObject(n2, string);
        if (bl) {
            System.out.println(string2 + "Reading [<<data>>] to " + pdfObject2 + " into " + pdfObject + " i=" + n);
        }
        n = this.readDictionaryAsObject(pdfObject2, string, n, byArray, byArray.length, string2, false);
        if (bl) {
            System.out.println(string2 + "data into pdfObject=" + pdfObject + " i=" + n);
        }
        if (n2 != -1) {
            pdfObject.setDictionary(n2, pdfObject2);
        }
        int n3 = byArray.length;
        while (n < n3 - 1 && byArray[n] == 62 && byArray[n + 1] == 62 && (++n + 1 >= byArray.length || byArray[n + 1] != 62)) {
        }
        return n;
    }

    private int readKeyPairs(int n, byte[] byArray, int n2, int n3, PdfObject pdfObject, String string) {
        int n4 = n2;
        int n5 = 1;
        int n6 = n3;
        boolean bl = false;
        boolean bl2 = false;
        Object object = null;
        Object object2 = null;
        PdfObject[] pdfObjectArray = null;
        if (n3 == -1) {
            bl = true;
        } else if (n3 == -2) {
            bl = true;
            bl2 = true;
        } else {
            object = new byte[n6][];
            object2 = new byte[n6][];
            pdfObjectArray = new PdfObject[n6];
        }
        n3 = 0;
        while (true) {
            Object object3;
            int n7;
            int n8;
            int n9;
            if (byArray[n4] == 9 || byArray[n4] == 10 || byArray[n4] == 13 || byArray[n4] == 32 || byArray[n4] == 60) {
                ++n4;
                continue;
            }
            if (byArray[n4] == 62) break;
            if (byArray[n4] == 47) {
                ++n3;
            } else {
                throw new RuntimeException("Unexpected value " + byArray[n4] + " - not key pair");
            }
            int n10 = ++n4;
            while (byArray[n4] != 32 && byArray[n4] != 10 && byArray[n4] != 13 && byArray[n4] != 91 && byArray[n4] != 60) {
                ++n4;
            }
            int n11 = n4 - n10;
            byte[] byArray2 = new byte[n11];
            System.arraycopy(byArray, n10, byArray2, 0, n11);
            if (!bl) {
                object[n3 - 1] = byArray2;
            }
            while (byArray[n4] == 10 || byArray[n4] == 13 || byArray[n4] == 32) {
                ++n4;
            }
            boolean bl3 = byArray[n4] == 60 || byArray[n4] == 91 || byArray[n4] == 47;
            byte[] byArray3 = null;
            if (bl3) {
                while (byArray[n4 - 1] != 60 && byArray[n4] != 60 && byArray[n4] != 91 && byArray[n4] != 47) {
                    ++n4;
                }
                n9 = n4;
                n8 = 1;
                if (byArray[n4] == 60) {
                    n4 += 2;
                    n5 = 1;
                    while (n5 > 0) {
                        if (byArray[n4] == 60 && byArray[n4 + 1] == 60) {
                            n4 += 2;
                            ++n5;
                            continue;
                        }
                        if (byArray[n4] == 62 && byArray[n4 + 1] == 62) {
                            n4 += 2;
                            --n5;
                            continue;
                        }
                        ++n4;
                    }
                } else if (byArray[n4] == 91) {
                    n5 = 1;
                    ++n4;
                    n7 = 0;
                    while (n5 > 0) {
                        if (n7 == 0 && byArray[n4] == 40) {
                            n7 = 1;
                        } else if (n7 != 0 && byArray[n4] == 41 && (byArray[n4 - 1] != 92 || byArray[n4 - 2] == 92)) {
                            n7 = 0;
                        }
                        if (n7 == 0) {
                            if (byArray[n4] == 91) {
                                ++n5;
                            } else if (byArray[n4] == 93) {
                                --n5;
                            }
                        }
                        ++n4;
                    }
                    n8 = 0;
                } else if (byArray[n4] == 47) {
                    ++n4;
                    while (byArray[n4] != 47 && byArray[n4] != 10 && byArray[n4] != 13 && byArray[n4] != 32) {
                        ++n4;
                    }
                }
                if (bl) continue;
                n7 = n4 - n9;
                byArray3 = new byte[n7];
                System.arraycopy(byArray, n9, byArray3, 0, n7);
                object2[n3 - 1] = byArray3;
                String string2 = pdfObject.getObjectRefAsString();
                if (pdfObject.getObjectType() == 2087749783) {
                    if (n8 != 0) {
                        this.handleColorSpaces(pdfObject, 0, byArray3, false, string + "    ");
                        pdfObjectArray[n3 - 1] = pdfObject;
                        continue;
                    }
                    object3 = new PdfColorSpaceObject(string2);
                    this.handleColorSpaces((PdfObject)object3, 0, byArray3, false, string + "    ");
                    pdfObjectArray[n3 - 1] = object3;
                    continue;
                }
                if (n8 == 0) continue;
                object3 = PdfObjectFactory.createObject(n, string2);
                this.readDictionaryFromRefOrDirect(n, (PdfObject)object3, string2, 0, byArray3, false, -1, null, string);
                pdfObjectArray[n3 - 1] = object3;
                continue;
            }
            n9 = n4;
            n8 = 0;
            while (byArray[n4] != 10 && byArray[n4] != 13 && byArray[n4] != 32 && byArray[n4] != 47 && byArray[n4] != 60 && byArray[n4] != 62) {
                ++n4;
                ++n8;
            }
            n7 = PdfReader.parseInt(n9, n4, byArray);
            while (byArray[n4] == 10 || byArray[n4] == 13 || byArray[n4] == 32 || byArray[n4] == 47 || byArray[n4] == 60) {
                ++n4;
            }
            n9 = n4;
            while (byArray[n4] != 10 && byArray[n4] != 13 && byArray[n4] != 32 && byArray[n4] != 47 && byArray[n4] != 60 && byArray[n4] != 62) {
                ++n4;
            }
            int n12 = PdfReader.parseInt(n9, n4, byArray);
            while (byArray[n4] == 10 || byArray[n4] == 13 || byArray[n4] == 32 || byArray[n4] == 47 || byArray[n4] == 60) {
                ++n4;
            }
            if (byArray[n4] != 82) {
                throw new RuntimeException("3. Unexpected value in file - please send to IDRsolutions for analysis");
            }
            ++n4;
            if (bl) continue;
            object3 = this.readObjectAsByteArray("", false, this.isCompressed(n7, n12), n7, n12);
            int n13 = 0;
            while ((n13 < 3 || object3[n13 - 1] != 106 && object3[n13 - 2] != 98 && object3[n13 - 3] != 111) && object3[n13] != 47 && object3[n13] != 91 && object3[n13] != 60) {
                if (++n13 != ((Object)object3).length) continue;
                n13 = 0;
                break;
            }
            while (object3[n13] == 10 || object3[n13] == 13 || object3[n13] == 32) {
                ++n13;
            }
            int n14 = ((Object)object3).length - n13;
            byArray3 = new byte[n14];
            System.arraycopy(object3, n13, byArray3, 0, n14);
            object2[n3 - 1] = byArray3;
            String string3 = n7 + " " + n12 + " R";
            if (pdfObject.getObjectType() == 373243460 && n == 373243460) {
                pdfObjectArray[n3 - 1] = null;
                object2[n3 - 1] = string3.getBytes();
                continue;
            }
            PdfObject pdfObject2 = PdfObjectFactory.createObject(n, string3);
            if (pdfObject2.getObjectType() == 2087749783) {
                this.handleColorSpaces(pdfObject2, 0, byArray3, false, string + "    ");
            } else {
                this.readDictionaryFromRefOrDirect(n, pdfObject2, string3, 0, byArray3, false, -1, null, string);
            }
            pdfObjectArray[n3 - 1] = pdfObject2;
        }
        if (!bl) {
            pdfObject.setDictionaryPairs((byte[][])object, (byte[][])object2, pdfObjectArray);
        }
        if (bl2 || !bl) {
            return n4;
        }
        return n3;
    }

    private void readStreamIntoObject(PdfObject pdfObject, boolean bl, int n, byte[] byArray, PdfObject pdfObject2, String string) {
        int n2 = byArray.length;
        if (bl) {
            System.out.println(string + "Looking for stream");
        }
        byte[] byArray2 = null;
        for (int i = n; i < n2; ++i) {
            int n3;
            if (byArray[i] != 115 || byArray[i + 1] != 116 || byArray[i + 2] != 114 || byArray[i + 3] != 101 || byArray[i + 4] != 97 || byArray[i + 5] != 109) continue;
            if (byArray[i += 6] == 13 && byArray[i + 1] == 10) {
                i += 2;
            } else if (byArray[i] == 10 || byArray[i] == 13) {
                // empty if block
            }
            int n4 = ++i;
            --i;
            int n5 = 0;
            int n6 = pdfObject.getInt(1043816557);
            if (bl) {
                System.out.println(string + "setStreamLength=" + n6);
            }
            if (n6 != -1) {
                n5 = n6;
                i = n4 + n5;
                if (i < n2 && byArray[i] == 13 && i + 1 < n2 && byArray[i + 1] == 10) {
                    i += 2;
                }
                if (n2 <= i + 9 || byArray[i] != 101 || byArray[i + 1] != 110 || byArray[i + 2] != 100 || byArray[i + 3] != 115 || byArray[i + 4] != 116 || byArray[i + 5] != 114 || byArray[i + 6] != 101 || byArray[i + 7] != 97 || byArray[i + 8] != 109) {
                    n3 = 0;
                    int n7 = i;
                    if (i < n2) {
                        while (n3 == 0 && ++i != n2) {
                            if (byArray[i] != 101 || byArray[i + 1] != 110 || byArray[i + 2] != 100 || byArray[i + 3] != 115 || byArray[i + 4] != 116 || byArray[i + 5] != 114 || byArray[i + 6] != 101 || byArray[i + 7] != 97 || byArray[i + 8] != 109) continue;
                            n5 = i - n4;
                            n3 = 1;
                        }
                    }
                    if (n3 == 0) {
                        i = n7;
                        if (i > n2) {
                            i = n2;
                        }
                        while (n3 == 0 && --i >= 0) {
                            if (byArray[i] != 101 || byArray[i + 1] != 110 || byArray[i + 2] != 100 || byArray[i + 3] != 115 || byArray[i + 4] != 116 || byArray[i + 5] != 114 || byArray[i + 6] != 101 || byArray[i + 7] != 97 || byArray[i + 8] != 109) continue;
                            n5 = i - n4;
                            n3 = 1;
                        }
                    }
                    if (n3 == 0) {
                        i = n7;
                    }
                }
            } else {
                while (++i != n2 && (byArray[i] != 101 || byArray[i + 1] != 110 || byArray[i + 2] != 100 || byArray[i + 3] != 115 || byArray[i + 4] != 116 || byArray[i + 5] != 114 || byArray[i + 6] != 101 || byArray[i + 7] != 97 || byArray[i + 8] != 109)) {
                }
                n3 = i - 1;
                if (n3 > n4) {
                    n5 = n3 - n4 + 1;
                }
            }
            if (n5 > 1 && (n3 = n4 + n5 - 1) < byArray.length && n3 > 0 && (byArray[n3] == 10 || byArray[n3] == 13)) {
                --n5;
                --n3;
            }
            if (this.startStreamPointer == -1) {
                if (n4 + n5 > n2) {
                    n5 = n2 - n4;
                }
                if (n5 < 0) {
                    return;
                }
                if (n5 < 0) {
                    throw new RuntimeException("Negative stream length " + n5 + " start=" + n4 + " count=" + n2);
                }
                byArray2 = new byte[n5];
                System.arraycopy(byArray, n4, byArray2, 0, n5);
            }
            if (this.startStreamPointer != -1) {
                pdfObject.startStreamOnDisk = this.startStreamPointer;
                pdfObject.endStreamOnDisk = this.endStreamPointer;
            }
            i = n2;
        }
        if (bl && byArray2 != null) {
            System.out.println(string + "stream read " + byArray2 + " saved into " + pdfObject2);
        }
        if (pdfObject2 != null) {
            pdfObject2.setStream(byArray2);
            if (pdfObject2.decompressStreamWhenRead()) {
                this.readStream(pdfObject2, true, true, false, pdfObject2.getObjectType() == 24, pdfObject2.isCompressedStream());
            }
        }
    }

    private int readUncodedString(PdfObject pdfObject, String string, int n, byte[] byArray, boolean bl, int n2, String string2) {
        byte[] byArray2;
        int n3;
        while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47) {
            ++n;
        }
        while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32) {
            ++n;
        }
        int n4 = n;
        byte[] byArray3 = byArray;
        boolean bl2 = byArray[n] != 47 && byArray[n] != 40;
        boolean bl3 = byArray[n] == 40;
        boolean bl4 = false;
        if (bl2) {
            for (n3 = n + 1; n3 < byArray.length && (byArray[n3] == 10 || byArray[n3] == 13 || byArray[n3] == 32); ++n3) {
            }
            if (byArray[n3] == 47 || byArray[n3] == 93) {
                bl2 = false;
                n = n3 + 1;
                bl4 = true;
            }
        }
        if (bl2) {
            int n5 = n;
            int n6 = 0;
            while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                ++n;
                ++n6;
            }
            n3 = PdfReader.parseInt(n5, n, byArray);
            while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                ++n;
            }
            n5 = n;
            while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                ++n;
            }
            int n7 = PdfReader.parseInt(n5, n, byArray);
            while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                ++n;
            }
            if (byArray[n] != 82) {
                throw new RuntimeException(string2 + "2. Unexpected value in file - please send to IDRsolutions for analysis");
            }
            byArray3 = this.readObjectAsByteArray(string, false, this.isCompressed(n3, n7), n3, n7);
            n4 = 3;
            while (byArray3[n4] != 47) {
                ++n4;
            }
        }
        if (byArray3[++n4] == 47) {
            return n4 - 1;
        }
        n3 = n4 + 1;
        if (bl4) {
            while (byArray3[n4] == 10 || byArray3[n4] == 13 || byArray3[n4] == 32 || byArray3[n4] == 47) {
                ++n4;
            }
            int n8 = 0;
            int n9 = 0;
            while (byArray3[n3] != 93) {
                if (byArray3[n3] == 47 && (n9 == 32 || n9 == 10 || n9 == 13)) {
                    ++n8;
                }
                n9 = byArray3[n3];
                if (++n3 != byArray3.length) continue;
            }
            int n10 = n3 - n8;
            int n11 = 0;
            byArray2 = new byte[n10 - n4];
            int n12 = 0;
            for (int i = n4; i < n10; ++i) {
                int n13 = byArray3[i];
                if (n13 == 47) {
                    if (n12 != 32 && n12 != 10 && n12 != 13) {
                        byArray2[n11] = 32;
                        ++n11;
                    }
                } else {
                    byArray2[n11] = n13;
                    ++n11;
                }
                n12 = n13;
            }
        } else {
            while (!(!bl3 ? byArray3[n3] == 32 || byArray3[n3] == 10 || byArray3[n3] == 13 || byArray3[n3] == 47 || byArray3[n3] == 62 : byArray3[n3] == 41)) {
                if (++n3 != byArray3.length) continue;
            }
            int n14 = n3 - n4;
            byArray2 = new byte[n14];
            System.arraycopy(byArray3, n4, byArray2, 0, n14);
        }
        pdfObject.setStringValue(n2, byArray2);
        if (bl) {
            System.out.println(string2 + "String set as =" + new String(byArray2) + "< written to " + pdfObject);
        }
        if (!bl2) {
            n = n3 - 1;
        }
        return n;
    }

    public int readDictionary(String string, int n, Map map, int n2, byte[] byArray, boolean bl, Map map2, int n3) {
        boolean bl2 = false;
        int n4 = 0;
        int n5 = -1;
        int n6 = -1;
        Object object = null;
        int n7 = -1;
        int n8 = -1;
        while (!(++n2 >= byArray.length || n3 != -1 && n2 >= n3 || byArray[n2] == 62 && byArray[n2 + 1] == 62 || byArray[n2] == 101 && byArray[n2 + 1] == 110 && byArray[n2 + 2] == 100 && byArray[n2 + 3] == 111)) {
            int n9;
            if (byArray[n2] == 60 && byArray[n2 + 1] == 60) {
                ++n2;
                HashMap hashMap = new HashMap();
                map.put(object, hashMap);
                n2 = this.readDictionary(string, ++n, hashMap, n2, byArray, bl, map2, n3);
                n4 = 0;
                --n;
                if (byArray[n2] != 62 || byArray[n2 + 1] != 62) continue;
                ++n2;
                continue;
            }
            if (byArray[n2] == 47 && byArray[n2 + 1] == 47) {
                ++n2;
                continue;
            }
            if (byArray[n2] == 47 && n4 == 0) {
                ++n2;
                while (byArray[n2] != 32 && byArray[n2] != 13 && byArray[n2] != 9 && byArray[n2] != 10 && byArray[n2] != 91 && byArray[n2] != 47 && byArray[n2] != 40 && byArray[n2] != 60) {
                    if (n4 == 0) {
                        n6 = byArray[n2];
                        n5 = n2;
                    }
                    ++n4;
                    ++n2;
                }
                if (byArray[n2] == 32 && byArray[n2 - 1] == 47) {
                    ++n4;
                }
                object = n5 == -1 ? null : PdfDictionary.getKey(n5, n4, byArray);
                bl2 = map2 != null && n4 > 0 && map2.containsKey(object);
                if (byArray[n2] != 47 && byArray[n2] != 40 && byArray[n2] != 60 && byArray[n2] != 91) continue;
                --n2;
                continue;
            }
            if (byArray[n2] == 32 || byArray[n2] == 13 || byArray[n2] == 10) continue;
            if (byArray[n2] == 60 && bl2) {
                Object object2;
                ByteArrayOutputStream byteArrayOutputStream = null;
                byteArrayOutputStream = new ByteArrayOutputStream();
                int n10 = 0;
                int n11 = ++n2;
                do {
                    n11 += 2;
                    ++n10;
                    while (byArray[n11] == 13 || byArray[n11] == 10) {
                        ++n11;
                    }
                } while (byArray[n11] != 62);
                byte[] byArray2 = new byte[n10];
                n10 = 0;
                do {
                    object2 = new StringBuffer(2);
                    for (n9 = 0; n9 < 2; ++n9) {
                        ((StringBuffer)object2).append((char)byArray[n2]);
                        ++n2;
                    }
                    byteArrayOutputStream.write(Integer.parseInt(((StringBuffer)object2).toString(), 16));
                    byArray2[n10] = (byte)Integer.parseInt(((StringBuffer)object2).toString(), 16);
                    ++n10;
                    while (byArray[n2] == 13 || byArray[n2] == 10) {
                        ++n2;
                    }
                } while (byArray[n2] != 62);
                try {
                    byteArrayOutputStream.close();
                    object2 = byteArrayOutputStream.toByteArray();
                    if (byArray2.length != ((Object)object2).length) {
                        System.out.println("Different lengths " + byArray2.length + ' ' + ((Object)object2).length);
                        System.exit(1);
                    }
                    for (n9 = 0; n9 < ((Object)object2).length; ++n9) {
                        if (object2[n9] == byArray2[n9]) continue;
                        System.out.println(n9 + " Different values " + (int)object2[n9] + ' ' + byArray2[n9]);
                        System.exit(1);
                    }
                    byArray2 = this.decrypt(byArray2, string, false, null, false, false);
                    map.put(object, byArray2);
                }
                catch (Exception exception) {
                    LogWriter.writeLog("[PDF] Problem " + exception + " writing text string" + object);
                    exception.printStackTrace();
                }
                n4 = 0;
                continue;
            }
            if (byArray[n2] == 40) {
                block138: {
                    if (bl2) {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        try {
                            if (byArray[n2 + 1] != 41) {
                                while (true) {
                                    boolean bl3 = false;
                                    if (byArray[++n2] == 92) {
                                        if (byArray[++n2] == 98) {
                                            byArray[n2] = 8;
                                        } else if (byArray[n2] == 110) {
                                            byArray[n2] = 10;
                                        } else if (byArray[n2] == 116) {
                                            byArray[n2] = 9;
                                        } else if (byArray[n2] == 114) {
                                            byArray[n2] = 13;
                                        } else if (byArray[n2] == 102) {
                                            byArray[n2] = 12;
                                        } else if (byArray[n2] == 92) {
                                            byArray[n2] = 92;
                                        } else if (Character.isDigit((char)byArray[n2])) {
                                            StringBuffer stringBuffer = new StringBuffer(3);
                                            for (int i = 0; i < 3; ++i) {
                                                stringBuffer.append((char)byArray[n2]);
                                                ++n2;
                                            }
                                            bl3 = true;
                                            byArray[--n2] = (byte)Integer.parseInt(stringBuffer.toString(), 8);
                                        }
                                    }
                                    if (!bl3 && byArray[n2] == 41 && (byArray[n2 - 1] != 92 || byArray[n2 - 1] == 92 && byArray[n2 - 2] == 92)) break;
                                    byteArrayOutputStream.write(byArray[n2]);
                                }
                            }
                            byteArrayOutputStream.close();
                            byte[] byArray3 = byteArrayOutputStream.toByteArray();
                            byArray3 = this.decrypt(byArray3, string, false, null, false, true);
                            if (object.equals("Dest")) {
                                String string2 = this.getTextString(byArray3);
                                map.put(object, this.nameLookup.get(string2));
                                break block138;
                            }
                            map.put(object, byArray3);
                        }
                        catch (Exception exception) {
                            LogWriter.writeLog("[PDF] Problem " + exception + " handling text string" + object);
                        }
                    } else if (bl && n4 == 1 && (n6 == 85 || n6 == 79)) {
                        int n12 = 32;
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        do {
                            int n13;
                            if ((n13 = byArray[++n2]) == 92) {
                                if ((n13 = byArray[++n2]) == 114) {
                                    n13 = 13;
                                } else if (n13 == 110) {
                                    n13 = 10;
                                } else if (n13 == 116) {
                                    n13 = 9;
                                } else if (n13 == 102) {
                                    n13 = 12;
                                } else if (n13 == 98) {
                                    n13 = 8;
                                } else if (n13 > 47 && n13 < 58) {
                                    StringBuffer stringBuffer = new StringBuffer(3);
                                    for (int i = 0; i < 3; ++i) {
                                        stringBuffer.append((char)byArray[n2 + i]);
                                    }
                                    n2 += 2;
                                    n13 = (byte)Integer.parseInt(stringBuffer.toString(), 8);
                                }
                            }
                            byteArrayOutputStream.write(n13);
                        } while (--n12 != 0);
                        try {
                            byteArrayOutputStream.close();
                            map.put(object, byteArrayOutputStream.toByteArray());
                        }
                        catch (Exception exception) {
                            LogWriter.writeLog("[PDF] Problem " + exception + " writing " + object);
                        }
                    } else {
                        int n14 = n2;
                        int n15 = 0;
                        boolean bl4 = false;
                        while (true) {
                            if (!bl4) {
                                ++n15;
                            }
                            if ((byArray[n2 - 1] != 92 || byArray[n2 - 2] == 92) && byArray[n2] == 41) break;
                            if (byArray[++n2] != 37 || byArray[n2 - 1] == 92) continue;
                            bl4 = true;
                        }
                        bl4 = false;
                        int n16 = 0;
                        char[] cArray = new char[n15];
                        while (true) {
                            if (!bl4) {
                                if (byArray[n14] == 13 | byArray[n14] == 10) {
                                    cArray[n16] = 32;
                                    ++n16;
                                } else {
                                    cArray[n16] = (char)byArray[n14];
                                    ++n16;
                                }
                            }
                            if (byArray[n14] != 92 && byArray[n14 - 1] == 92 && byArray[n14 - 2] == 92) {
                                byArray[n14 - 1] = 0;
                            }
                            if (byArray[n14 - 1] != 92 & byArray[n14] == 41) break;
                            if (byArray[++n14] != 37 || byArray[n14 - 1] == 92) continue;
                            bl4 = true;
                        }
                        String string3 = String.copyValueOf(cArray, 0, n15);
                        if (!string3.equals("null")) {
                            map.put(object, string3);
                        }
                    }
                }
                n4 = 0;
                continue;
            }
            if (byArray[n2] == 91 && this.isFDF) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                while (true) {
                    if (byArray[n2 + 1] != 60 && byArray[n2 + 2] != 60 && byArray[n2] != 93) {
                        ++n2;
                        continue;
                    }
                    int n17 = n2;
                    while (byArray[n17 + 1] != 62 && byArray[n17 + 2] != 62 && byArray[n17] != 93) {
                        ++n17;
                    }
                    if (byArray[n2] == 93) break;
                    HashMap hashMap2 = new HashMap();
                    n2 = this.readDictionary(string, 1, hashMap2, n2 + 2, byArray, bl, map2, n17);
                    --n2;
                    --n2;
                    String string4 = null;
                    String string5 = "";
                    byte[] byArray4 = this.getByteTextStringValue(hashMap2.get("T"), hashMap2);
                    if (byArray4 != null) {
                        string4 = this.getTextString(byArray4);
                    }
                    if ((byArray4 = this.getByteTextStringValue(hashMap2.get("V"), hashMap2)) != null) {
                        string5 = this.getTextString(byArray4);
                    }
                    if (string4 == null) continue;
                    hashMap.put(string4, string5);
                }
                map.put(object, hashMap);
                n4 = 0;
                continue;
            }
            if (byArray[n2] == 91) {
                Object object3;
                int n18 = n2;
                int n19 = 0;
                boolean bl5 = false;
                boolean bl6 = false;
                int n20 = 0;
                int n21 = 0;
                n9 = 32;
                int n22 = 32;
                boolean bl7 = false;
                while (byArray[n2] == 32) {
                    ++n19;
                    ++n2;
                }
                while (true) {
                    if (byArray[n2] == 92) {
                        ++n2;
                    }
                    if (n19 > 7 && !bl7 && byArray[n2 - 7] == 47 && byArray[n2 - 6] == 73 && byArray[n2 - 5] == 110 && byArray[n2 - 4] == 100 && byArray[n2 - 3] == 101 && byArray[n2 - 2] == 120 && byArray[n2 - 1] == 101 && byArray[n2] == 100) {
                        bl7 = true;
                    }
                    if (byArray[n2] == 40 && byArray[n2 - 1] != 92 && bl7) {
                        bl6 = true;
                        n19 += 2;
                    } else if (bl6) {
                        if (byArray[n2] == 41 && byArray[n2 - 1] != 92) {
                            ++n19;
                            bl6 = false;
                        } else {
                            object3 = Integer.toHexString(byArray[n2] & 0xFF);
                            if (((String)object3).length() < 2) {
                                ++n19;
                            }
                            n19 += ((String)object3).length();
                        }
                    } else if (!bl5) {
                        if (byArray[n2] == 13 || byArray[n2] == 10) {
                            ++n19;
                        } else {
                            n9 = (char)byArray[n2];
                            if (n9 == 47 && n22 != 32) {
                                ++n19;
                            }
                            if (n9 != 32 && n22 == 41) {
                                ++n19;
                            }
                            ++n19;
                            n22 = n9;
                        }
                    }
                    if (byArray[n2 - 1] != 92 || byArray[n2 - 1] == 92 && byArray[n2 - 2] == 92 && byArray[n2 - 3] != 92) {
                        if (byArray[n2] == 40) {
                            ++n21;
                        } else if (byArray[n2] == 41) {
                            --n21;
                        }
                        if (n21 == 0) {
                            if (byArray[n2] == 91) {
                                ++n20;
                            } else if (byArray[n2] == 93) {
                                --n20;
                            }
                        }
                    }
                    if (n20 == 0 && byArray[n2 - 1] != 92 && byArray[n2] == 93) break;
                    if (byArray[++n2] != 37 || byArray[n2 - 1] == 92 || n20 != 0) continue;
                    bl5 = true;
                }
                object3 = new char[n19 * 2];
                int n23 = 0;
                n2 = n18;
                while (byArray[n2] == 32) {
                    object3[n23] = (char)byArray[n2];
                    ++n23;
                    ++n2;
                }
                bl5 = false;
                bl6 = false;
                n20 = 0;
                n21 = 0;
                n9 = 32;
                n22 = 32;
                while (true) {
                    if (n2 > 7 && !bl7 && byArray[n2 - 7] == 47 && byArray[n2 - 6] == 73 && byArray[n2 - 5] == 110 && byArray[n2 - 4] == 100 && byArray[n2 - 3] == 101 && byArray[n2 - 2] == 120 && byArray[n2 - 1] == 101 && byArray[n2] == 100) {
                        bl7 = true;
                    }
                    if (byArray[n2] == 40 & byArray[n2 - 1] != 92 && bl7) {
                        int n24;
                        int n25;
                        int n26 = n2 + 1;
                        int n27 = n2;
                        while (n27 < byArray.length && !(byArray[++n27] == 41 & (byArray[n27 - 1] != 92 || byArray[n27 - 1] == 92 && byArray[n27 - 2] == 92))) {
                        }
                        int n28 = n27 - n26;
                        byte[] byArray5 = new byte[n28];
                        for (n25 = 0; n25 < n28 && n26 != n27; ++n26, ++n25) {
                            byte by = byArray[n26];
                            if (by != 92) {
                                byArray5[n25] = by;
                                continue;
                            }
                            if (byArray[++n26] == 98) {
                                byArray5[n25] = 8;
                                continue;
                            }
                            if (byArray[n26] == 110) {
                                byArray5[n25] = 10;
                                continue;
                            }
                            if (byArray[n26] == 116) {
                                byArray5[n25] = 9;
                                continue;
                            }
                            if (byArray[n26] == 114) {
                                byArray5[n25] = 13;
                                continue;
                            }
                            if (byArray[n26] == 102) {
                                byArray5[n25] = 12;
                                continue;
                            }
                            if (byArray[n26] == 92) {
                                byArray5[n25] = 92;
                                continue;
                            }
                            if (Character.isDigit((char)byArray[n26])) {
                                StringBuffer stringBuffer = new StringBuffer(3);
                                for (n24 = 0; n24 < 3 && byArray[n26] != 92 && byArray[n26] != 41; ++n24) {
                                    stringBuffer.append((char)byArray[n26]);
                                    ++n26;
                                }
                                --n26;
                                byArray5[n25] = (byte)Integer.parseInt(stringBuffer.toString(), 8);
                                continue;
                            }
                            byArray5[n25] = byArray[n26];
                        }
                        try {
                            byArray5 = this.decrypt(byArray5, string, false, null, false, false);
                        }
                        catch (PdfSecurityException pdfSecurityException) {
                            pdfSecurityException.printStackTrace();
                        }
                        object3[n23] = 32;
                        object3[++n23] = 60;
                        ++n23;
                        for (n25 = 0; n25 < n28; ++n25) {
                            String string6 = Integer.toHexString(byArray5[n25] & 0xFF);
                            if (string6.length() < 2) {
                                object3[n23] = 48;
                                ++n23;
                            }
                            int n29 = string6.length();
                            for (n24 = 0; n24 < n29; ++n24) {
                                object3[n23] = string6.charAt(n24);
                                ++n23;
                            }
                        }
                        object3[n23] = 62;
                        ++n23;
                    } else if (!bl5) {
                        if (byArray[n2] == 13 | byArray[n2] == 10) {
                            object3[n23] = 32;
                            ++n23;
                        } else {
                            n9 = (char)byArray[n2];
                            if (n9 == 47 && n22 != 32) {
                                object3[n23] = 32;
                                ++n23;
                            }
                            if (n9 != 32 && n22 == 41) {
                                object3[n23] = 32;
                                ++n23;
                            }
                            object3[n23] = n9;
                            ++n23;
                            n22 = n9;
                        }
                    }
                    if (byArray[n2 - 1] != 92 | (byArray[n2 - 1] == 92 && byArray[n2 - 2] == 92 && byArray[n2 - 3] != 92)) {
                        if (byArray[n2] == 40) {
                            ++n21;
                        } else if (byArray[n2] == 41) {
                            --n21;
                        }
                        if (n21 == 0) {
                            if (byArray[n2] == 91) {
                                ++n20;
                            } else if (byArray[n2] == 93) {
                                --n20;
                            }
                        }
                    }
                    if (n20 == 0 && byArray[n2 - 1] != 92 & byArray[n2] == 93) break;
                    if (byArray[++n2] != 37 || byArray[n2 - 1] == 92 || n20 != 0) continue;
                    bl5 = true;
                }
                String string7 = String.copyValueOf((char[])object3, 0, n23);
                if (!string7.equals("null")) {
                    map.put(object, string7);
                }
                n4 = 0;
                continue;
            }
            if (byArray[n2] == 62 || byArray[n2] == 60 || n4 <= 0) continue;
            boolean bl8 = false;
            int n30 = n2;
            int n31 = 0;
            while (true) {
                if (byArray[n2] != 13 && byArray[n2] != 9 && byArray[n2] != 10 && !bl8) {
                    ++n31;
                }
                if (byArray[n2 + 1] == 47 || byArray[n2] != 62 && byArray[n2 + 1] == 62) break;
                if (byArray[++n2] != 37 || byArray[n2 - 1] == 92) continue;
                bl8 = true;
            }
            while (n31 > 0 && (byArray[n30 + n31 - 1] == 32 || byArray[n30 + n31 - 1] == 10 || byArray[n30 + n31 - 1] == 13 || byArray[n30 + n31 - 1] == 9)) {
                --n31;
            }
            char[] cArray = new char[n31];
            --n31;
            int n32 = 0;
            do {
                if (byArray[n30] != 13 && byArray[n30] != 9 && byArray[n30] != 10) {
                    cArray[n32] = (char)byArray[n30];
                    ++n32;
                }
                ++n30;
            } while (n32 <= n31);
            String string8 = String.copyValueOf(cArray, 0, n32);
            if (!string8.equals("null")) {
                map.put(object, string8);
            }
            n4 = 0;
        }
        return n2;
    }

    private int readArray(boolean bl, int n, int n2, int n3, byte[] byArray, String string, PdfObject pdfObject, int n4, boolean bl2, String string2) {
        int n5;
        int n6;
        boolean bl3;
        ++n;
        boolean bl4 = n4 == 456733763 || n4 == 1044338049;
        boolean bl5 = bl2;
        if (bl5) {
            System.out.println(string2 + "Reading array type=" + n3 + " " + pdfObject);
        }
        int n7 = 0;
        int n8 = 0;
        while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32) {
            ++n;
        }
        int n9 = n;
        int n10 = 0;
        int n11 = n;
        byte[] byArray2 = byArray;
        boolean bl6 = bl3 = byArray[n] != 91 && n4 != 489767739 && n4 != 9250 && pdfObject.getObjectType() != 2087749783;
        if (byArray[n] == 110 && byArray[n + 1] == 117 && byArray[n + 2] == 108 && byArray[n + 2] == 108) {
            bl3 = false;
            n8 = 1;
        }
        if (bl3) {
            n6 = n;
            while (byArray[n6] != 93 && ++n6 < n2 && (byArray[n6] != 82 || byArray[n6 - 1] != 32 && byArray[n6 - 1] != 10 && byArray[n6 - 1] != 13)) {
                if (byArray[n6] == 62 && byArray[n6 - 1] == 62) {
                    bl3 = false;
                    if (!bl5) break;
                    System.out.println(string2 + "1. rejected as indirect ref");
                    break;
                }
                if (byArray[n6] != 47) continue;
                bl3 = false;
                if (!bl5) break;
                System.out.println(string2 + "2. rejected as indirect ref - starts with /");
                break;
            }
        }
        if (bl5 && bl3) {
            System.out.println(string2 + "Indirect ref");
        }
        n6 = 0;
        int n12 = -1;
        if (byArray[n] == 47 && n3 != 20 && n4 != 9250) {
            n8 = 1;
            if (bl5) {
                System.out.println(string2 + "Direct single value with /");
            }
        } else {
            int n13;
            int n14;
            int n15;
            int n16 = -1;
            if (bl3) {
                if (bl5) {
                    System.out.println(string2 + "------reading data----");
                }
                n15 = n;
                if (bl5) {
                    System.out.print(string2 + "Indirect object ref=");
                }
                while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                    if (bl5) {
                        System.out.print((char)byArray[n]);
                    }
                    ++n;
                    ++n10;
                }
                n14 = PdfReader.parseInt(n9, n, byArray);
                while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                    ++n;
                }
                n9 = n;
                while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                    ++n;
                }
                n13 = PdfReader.parseInt(n9, n, byArray);
                if (bl2) {
                    System.out.print(string2 + " " + n13 + "\n");
                }
                while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                    ++n;
                }
                if (byArray[n] != 82) {
                    throw new RuntimeException(string2 + "4. Unexpected value " + (char)byArray[n] + " in file - please send to IDRsolutions for analysis");
                }
                if (bl && !bl4) {
                    return n;
                }
                byArray2 = this.readObjectAsByteArray(string, false, this.isCompressed(n14, n13), n14, n13);
                if (bl5) {
                    System.out.println(string2 + "Raw data is>>>>>>>>>>>>>>");
                    System.out.print(string2);
                    for (int i = 0; i < byArray2.length; ++i) {
                        System.out.print((char)byArray2[i]);
                        if (i <= 5 || byArray2[i - 5] != 115 || byArray2[i - 4] != 116 || byArray2[i - 3] != 114 || byArray2[i - 2] != 101 || byArray2[i - 1] != 97 || byArray2[i] != 109) continue;
                        i = byArray2.length;
                    }
                    System.out.println("\n<<<<<<<<<<<<<<");
                }
                n11 = 0;
                while (byArray2[n11] != 91) {
                    if (byArray2[n11] == 37) {
                        while (byArray2[++n11] != 13 && byArray2[n11] != 10) {
                        }
                        while (byArray2[n11] == 13 || byArray2[n11] == 10) {
                            ++n11;
                        }
                    }
                    if (byArray2[n11] == 110 && byArray2[n11 + 1] == 117 && byArray2[n11 + 2] == 108 && byArray2[n11 + 3] == 108) break;
                    if (byArray2[n11] == 47) {
                        --n11;
                        n6 = 1;
                        break;
                    }
                    if (byArray2[n11] == 60 && byArray2[n11 + 1] == 60 || n11 + 4 < byArray2.length && byArray2[n11 + 3] == 60 && byArray2[n11 + 4] == 60) {
                        n16 = n;
                        n11 = n15;
                        byArray2 = byArray;
                        if (!bl5) break;
                        System.out.println(string2 + "Single value, not indirect");
                        break;
                    }
                    ++n11;
                }
            }
            if (n11 < 0) {
                n11 = 0;
            }
            while (byArray2[n11] == 10 || byArray2[n11] == 13 || byArray2[n11] == 32 || byArray2[n11] == 91) {
                ++n11;
            }
            n12 = n11;
            n15 = 0;
            n14 = 1;
            while (byArray2[n12] != 93) {
                if (byArray2[n12] == 60 && byArray2[n12 + 1] == 60) {
                    n13 = 1;
                    ++n8;
                    if (bl5) {
                        System.out.println("Direct value");
                    }
                    while (n13 > 0) {
                        if (byArray2[++n12] == 60 && byArray2[n12 + 1] == 60) {
                            ++n12;
                            ++n13;
                            continue;
                        }
                        if (byArray2[n12] != 62 || byArray2[n12 + 1] != 62) continue;
                        ++n12;
                        --n13;
                    }
                }
                if (byArray2[n12] == 110 && byArray2[n12 + 1] == 117 && byArray2[n12 + 2] == 108 && byArray2[n12 + 3] == 108) {
                    n8 = 1;
                    break;
                }
                if (n6 != 0 && (byArray2[n12] == 32 || byArray2[n12] == 13 || byArray2[n12] == 10) || n16 != -1 && n12 > n16) break;
                if (n3 == 14) {
                    if (byArray2[n12] == 82 || n4 == 9250 && byArray2[n12] == 47) {
                        ++n8;
                    }
                } else if (byArray2[n12] == 40) {
                    ++n8;
                    while (!(byArray2[n12] == 41 && byArray2[n12 - 1] != 92 && byArray2[n12 - 2] != 92 || byArray2[n12] == 41 && byArray2[n12 - 1] == 92 && byArray2[n12 - 2] == 92)) {
                        ++n12;
                    }
                } else {
                    n15 = byArray2[n12] == 10 || byArray2[n12] == 13 || byArray2[n12] == 32 || byArray2[n12] == 47 ? 1 : 0;
                    if (n14 != 0 && n15 == 0) {
                        n8 = n3 == 18 && byArray2[n12] == 82 && byArray2[n12 - 1] != 47 ? --n8 : ++n8;
                    }
                    n14 = n15;
                }
                ++n12;
            }
            if (n8 == 0 && bl5) {
                System.out.println(string2 + "zero elements found!!!!!!");
            }
        }
        if (bl && !bl4) {
            return n12;
        }
        float[] fArray = null;
        int[] nArray = null;
        double[] dArray = null;
        Object object = null;
        Object object2 = null;
        Object object3 = null;
        boolean[] blArray = null;
        if (n3 == 10) {
            fArray = new float[n8];
        } else if (n3 == 9) {
            nArray = new int[n8];
        } else if (n3 == 12) {
            blArray = new boolean[n8];
        } else if (n3 == 16) {
            dArray = new double[n8];
        } else if (n3 == 18) {
            object = new byte[n8][];
        } else if (n3 == 14) {
            object2 = new byte[n8][];
        } else if (n3 == 20) {
            object3 = new byte[n8][];
        }
        if (byArray2[n11] == 110 && byArray2[n11 + 1] == 117 && byArray2[n11 + 2] == 108 && byArray2[n11 + 3] == 108) {
            n11 += 3;
            object2[0] = null;
        } else {
            while (byArray2[n11] != 93 && (n12 <= -1 || n11 < n12)) {
                boolean bl7;
                while (byArray2[n11] == 10 || byArray2[n11] == 13 || byArray2[n11] == 32 || byArray2[n11] == 47) {
                    ++n11;
                }
                n9 = n11;
                n10 = 0;
                boolean bl8 = bl7 = byArray2[n11 - 1] == 47;
                if (n3 == 14) {
                    while (byArray2[n11] != 82 && byArray2[n11] != 93) {
                        if (byArray2[n11] == 60 && byArray2[n11 + 1] == 60) {
                            n5 = 1;
                            if (bl5) {
                                System.out.println("Reading Direct value");
                            }
                            while (n5 > 0) {
                                ++n10;
                                if (byArray2[++n11] == 60 && byArray2[n11 + 1] == 60) {
                                    ++n11;
                                    ++n10;
                                    ++n5;
                                    continue;
                                }
                                if (byArray2[n11] != 62 || byArray2[n11 + 1] != 62) continue;
                                ++n11;
                                ++n10;
                                --n5;
                            }
                            break;
                        }
                        if (bl7 && n4 == 9250 && byArray2[n11 + 1] == 32) break;
                        ++n11;
                        ++n10;
                    }
                    ++n11;
                    ++n10;
                } else if (byArray2[n11] == 40) {
                    while (!(byArray2[n11] == 41 && byArray2[n11 - 1] != 92 && byArray2[n11 - 2] != 92 || byArray2[n11] == 41 && byArray2[n11 - 1] == 92 && byArray2[n11 - 2] == 92)) {
                        ++n11;
                        ++n10;
                    }
                } else {
                    while (byArray2[n11] != 10 && byArray2[n11] != 13 && byArray2[n11] != 32 && byArray2[n11] != 93 && byArray2[n11] != 47 && (byArray2[n11] != 62 || byArray2[n11 + 1] != 62)) {
                        ++n11;
                        ++n10;
                    }
                }
                if (n3 == 10) {
                    fArray[n7] = PdfReader.parseFloat(n9, n11, byArray2);
                } else if (n3 == 9) {
                    nArray[n7] = PdfReader.parseInt(n9, n11, byArray2);
                } else if (n3 == 12) {
                    if (byArray[n9] == 116 && byArray[n9 + 1] == 114 && byArray[n9 + 2] == 117 && byArray[n9 + 3] == 101) {
                        blArray[n7] = true;
                    }
                } else if (n3 == 16) {
                    dArray[n7] = PdfReader.parseFloat(n9, n11, byArray2);
                } else {
                    if (n9 > 0 && byArray2[n9 - 1] == 47) {
                        --n9;
                    }
                    n5 = n11 - n9;
                    byte[] byArray3 = new byte[n5];
                    System.arraycopy(byArray2, n9, byArray3, 0, n5);
                    if (bl5) {
                        System.out.println(string2 + "value=" + new String(byArray3));
                    }
                    if (n3 == 18) {
                        object[n7] = byArray3;
                    } else if (n3 == 14) {
                        object2[n7] = byArray3;
                    } else if (n3 == 20) {
                        object3[n7] = byArray3;
                    }
                }
                if (++n7 != n8) continue;
                break;
            }
        }
        if (!bl3) {
            n = n11;
        }
        if (n3 == 10) {
            pdfObject.setFloatArray(n4, fArray);
        } else if (n3 == 9) {
            pdfObject.setIntArray(n4, nArray);
        } else if (n3 == 12) {
            pdfObject.setBooleanArray(n4, blArray);
        } else if (n3 == 16) {
            pdfObject.setDoubleArray(n4, dArray);
        } else if (n3 == 18) {
            pdfObject.setMixedArray(n4, (byte[][])object);
        } else if (n3 == 14) {
            pdfObject.setKeyArray(n4, (byte[][])object2);
        } else if (n3 == 20) {
            pdfObject.setStringArray(n4, (byte[][])object3);
        }
        if (bl5) {
            String string3 = "[";
            if (n3 == 10) {
                n5 = fArray.length;
                for (int i = 0; i < n5; ++i) {
                    string3 = string3 + fArray[i] + " ";
                }
            } else if (n3 == 16) {
                n5 = dArray.length;
                for (int i = 0; i < n5; ++i) {
                    string3 = string3 + dArray[i] + " ";
                }
            } else if (n3 == 9) {
                n5 = nArray.length;
                for (int i = 0; i < n5; ++i) {
                    string3 = string3 + nArray[i] + " ";
                }
            } else if (n3 == 12) {
                n5 = blArray.length;
                for (int i = 0; i < n5; ++i) {
                    string3 = string3 + blArray[i] + " ";
                }
            } else if (n3 == 18) {
                n5 = ((byte[][])object).length;
                for (int i = 0; i < n5; ++i) {
                    string3 = string3 + new String(object[i]) + " ";
                }
            } else if (n3 == 14) {
                n5 = ((byte[][])object2).length;
                for (int i = 0; i < n5; ++i) {
                    string3 = object2[i] == null ? string3 + "null " : string3 + new String(object2[i]) + " ";
                }
            } else if (n3 == 20) {
                n5 = ((byte[][])object3).length;
                for (int i = 0; i < n5; ++i) {
                    string3 = object3[i] == null ? string3 + "null " : string3 + new String(object3[i]) + " ";
                }
            }
            string3 = string3 + " ]";
            System.out.println(string2 + pdfObject + " set as Array " + string3 + " in " + pdfObject);
        }
        if (byArray[n] == 47 || byArray[n] == 62) {
            --n;
        }
        return n;
    }

    public static boolean checkStreamsIdentical(byte[] byArray, byte[] byArray2) {
        boolean bl = false;
        try {
            if (byArray != null || byArray2 != null) {
                int n = byArray.length;
                int n2 = byArray2.length;
                if (n != n2) {
                    System.out.println("=========old length=" + n2 + "< new length=" + n + "<");
                }
                int n3 = n2;
                if (n < n2) {
                    n3 = n;
                }
                for (int i = 0; i < n3; ++i) {
                    if (byArray[i] == byArray2[i]) continue;
                    System.out.println(i + " Difference new=" + byArray[i] + " old=" + byArray2[i]);
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            System.err.println("old=" + byArray2);
            System.err.println("new=" + byArray);
            exception.printStackTrace();
            System.exit(1);
        }
        return bl;
    }

    public static void checkStringsIdentical(String string, String string2) {
        try {
            if (!(string2 == null && string == null || string2.equals(string))) {
                System.out.println("old=" + string + "<\nnew=" + string2 + "<");
                if (!string.endsWith(" R")) {
                    System.exit(1);
                }
            }
        }
        catch (Exception exception) {
            System.err.println("In exception old value=" + string + "< new value=" + string2 + "<");
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public static void checkNumbersIdentical(float f, float f2) {
        float f3 = f - f2;
        if (f3 < 0.0f) {
            f3 = -f3;
        }
        if (f3 > 0.001f) {
            System.out.println("=========old value=" + f + "< new value=" + f2 + "<");
            System.exit(1);
        }
    }

    public static void checkFloatArraysIdentical(float[] fArray, float[] fArray2) {
        if (fArray == null && fArray2 == null) {
            return;
        }
        try {
            int n = fArray.length;
            int n2 = fArray2.length;
            if (n != n2) {
                System.out.println("Different lengths " + n + " " + n2);
                System.exit(1);
            }
            for (int i = 0; i < n; ++i) {
                float f = fArray[i] - fArray2[i];
                if (f < 0.0f) {
                    f = -f;
                }
                if (!(f > 1.0E-4f)) continue;
                System.out.println("Significant Difference in floats");
                System.out.println("--------------------------------");
                for (i = 0; i < n; ++i) {
                    System.out.println(fArray[i] + " " + fArray2[i]);
                }
                System.exit(1);
            }
        }
        catch (Exception exception) {
            System.err.println("old=" + fArray);
            System.err.println("new=" + fArray2);
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public static void checkBooleanArraysIdentical(boolean[] blArray, boolean[] blArray2) {
        if (blArray == null && blArray2 == null) {
            return;
        }
        try {
            int n = blArray.length;
            int n2 = blArray2.length;
            if (n != n2) {
                System.out.println("Different lengths " + n + " " + n2);
                System.exit(1);
            }
            for (int i = 0; i < n; ++i) {
                if (blArray[i] == blArray2[i]) continue;
                System.out.println("Significant Difference in Boolean");
                System.out.println("--------------------------------");
                for (i = 0; i < n; ++i) {
                    System.out.println(blArray[i] + " " + blArray2[i]);
                }
                System.exit(1);
            }
        }
        catch (Exception exception) {
            System.err.println("old=" + blArray);
            System.err.println("new=" + blArray2);
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public static void checkIntArraysIdentical(int[] nArray, int[] nArray2) {
        if (nArray == null && nArray2 == null) {
            return;
        }
        try {
            int n = nArray.length;
            int n2 = nArray2.length;
            if (n != n2) {
                System.out.println("Different lengths " + n + " " + n2);
                System.exit(1);
            }
            for (int i = 0; i < n; ++i) {
                if (nArray[i] == nArray2[i]) continue;
                System.out.println("Difference in Int");
                System.out.println("--------------------------------");
                for (i = 0; i < n; ++i) {
                    System.out.println(nArray[i] + " " + nArray2[i]);
                }
                System.exit(1);
            }
        }
        catch (Exception exception) {
            System.err.println("old=" + nArray);
            System.err.println("new=" + nArray2);
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public static void checkDoubleArraysIdentical(double[] dArray, double[] dArray2) {
        if (dArray == null && dArray2 == null) {
            return;
        }
        try {
            int n = dArray.length;
            int n2 = dArray2.length;
            if (n != n2) {
                System.out.println("Different lengths " + n + " " + n2);
                System.exit(1);
            }
            for (int i = 0; i < n; ++i) {
                double d = dArray[i] - dArray2[i];
                if (d < 0.0) {
                    d = -d;
                }
                if (!(d > 1.0E-4)) continue;
                System.out.println("Significant Difference in doubles " + dArray[i] + " " + dArray2[i]);
                System.exit(1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public final byte[] readStream(Map map, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        Object object;
        Object v = map.get("DecodedStream");
        BufferedOutputStream bufferedOutputStream = null;
        String string2 = null;
        boolean bl6 = false;
        if (v == null) {
            Object object2;
            int n;
            object = (byte[])map.get("Stream");
            boolean bl7 = bl6 = map.get("startStreamOnDisk") != null && this.endStreamPointer - this.startStreamPointer >= 0;
            if (bl6) {
                try {
                    File file = File.createTempFile("jpedal", ".bin");
                    string2 = file.getAbsolutePath();
                    this.cachedObjects.put(string2, "x");
                    bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                    n = 8192;
                    int n2 = this.startStreamPointer;
                    do {
                        int n3;
                        if ((n3 = 1 + this.endStreamPointer - n2) < n) {
                            n = n3;
                        }
                        byte[] byArray = new byte[n];
                        this.movePointer(n2);
                        this.pdf_datafile.read(byArray);
                        bufferedOutputStream.write(byArray);
                    } while ((n2 += n) < this.endStreamPointer);
                    bufferedOutputStream.close();
                    object2 = new File(string2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                try {
                    if (!(bl5 || !this.isMetaDataEncypted && bl4)) {
                        this.decrypt(null, string, false, string2, false, false);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    object = null;
                    LogWriter.writeLog("Exception " + exception);
                }
                map.put("CachedStream", string2);
            }
            if (object != null) {
                try {
                    if (!(bl5 || !this.isMetaDataEncypted && bl4)) {
                        object = this.decrypt((byte[])object, string, false, null, false, false);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    object = null;
                    LogWriter.writeLog("Exception " + exception);
                }
            }
            if (bl3) {
                map.remove("Stream");
            }
            int n4 = 1;
            if (object != null || bl6) {
                String string3;
                n = 1;
                int n5 = 1;
                String string4 = (String)map.get("Height");
                if (string4 != null) {
                    Map map2;
                    if (string4.indexOf(82) != -1 && (object2 = (map2 = this.readObject(new PdfObject(string4), string4, false, null)).get("rawValue")) != null) {
                        string4 = (String)object2;
                    }
                    n = Integer.parseInt(string4);
                }
                if ((string4 = (String)map.get("Width")) != null) {
                    n5 = Integer.parseInt(string4);
                }
                if ((string4 = this.getValue((String)map.get("Length"))) != null) {
                    n4 = Integer.parseInt(string4);
                }
                if (n * n5 == 1) {
                    n5 = n4;
                }
                if ((string3 = this.getValue((String)map.get("Filter"))) != null && !string3.startsWith("/JPXDecode") && !string3.startsWith("/DCT")) {
                    try {
                        String string5;
                        object2 = map.get("DecodeParms");
                        if (object2 != null && object2 instanceof String && (string5 = (String)object2).endsWith(" R")) {
                            Map map3 = this.readObject(new PdfObject(string5), string5, false, null);
                            map.put("DecodeParms", map3);
                        }
                        object = this.decodeFilters((byte[])object, string3, map.get("DecodeParms"), n5, n, true, string2);
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("[PDF] Problem " + exception + " decompressing stream " + string3);
                        object = null;
                        bl6 = false;
                    }
                    n4 = 1;
                } else if (object != null && n4 != 1 && n4 < ((byte[])object).length && ((byte[])object).length != n4) {
                    object2 = new byte[n4];
                    System.arraycopy(object, 0, object2, 0, n4);
                    object = object2;
                }
            }
            if (object != null && bl) {
                map.put("DecodedStream", object);
            }
            if (bl2 && bl6) {
                n = (int)new File(string2).length();
                byte[] byArray = new byte[n];
                try {
                    new BufferedInputStream(new FileInputStream(string2)).read(byArray);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (n4 != 1 && n4 < n) {
                    byte[] byArray2 = new byte[n4];
                    System.arraycopy(byArray, 0, byArray2, 0, n4);
                    byArray = byArray2;
                }
                return byArray;
            }
        } else {
            object = (byte[])v;
        }
        return object;
    }

    public final byte[] readStream(PdfObject pdfObject, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        byte[] byArray;
        byte[] byArray2 = pdfObject.DecodedStream;
        BufferedOutputStream bufferedOutputStream = null;
        String string = null;
        boolean bl6 = false;
        if (byArray2 == null) {
            int n;
            int n2;
            int n3;
            String string2 = pdfObject.getObjectRefAsString();
            byArray = pdfObject.stream;
            boolean bl7 = bl6 = pdfObject.startStreamOnDisk != -1 && this.endStreamPointer - this.startStreamPointer >= 0;
            if (bl6) {
                try {
                    File file = File.createTempFile("jpedal", ".bin");
                    string = file.getAbsolutePath();
                    this.cachedObjects.put(string, "x");
                    bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                    n3 = 8192;
                    n2 = this.startStreamPointer;
                    do {
                        if ((n = 1 + this.endStreamPointer - n2) < n3) {
                            n3 = n;
                        }
                        byte[] byArray3 = new byte[n3];
                        this.movePointer(n2);
                        this.pdf_datafile.read(byArray3);
                        bufferedOutputStream.write(byArray3);
                    } while ((n2 += n3) < this.endStreamPointer);
                    bufferedOutputStream.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                try {
                    if (!(bl5 || !this.isMetaDataEncypted && bl4)) {
                        this.decrypt(null, string2, false, string, false, false);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    byArray = null;
                    LogWriter.writeLog("Exception " + exception);
                }
                pdfObject.CachedStream = string;
            }
            if (byArray != null) {
                try {
                    if (!(bl5 || !this.isMetaDataEncypted && bl4)) {
                        byArray = this.decrypt(byArray, string2, false, null, false, false);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    byArray = null;
                    LogWriter.writeLog("Exception " + exception);
                }
            }
            if (bl3) {
                pdfObject.stream = null;
            }
            int n4 = 1;
            if (byArray != null || bl6) {
                int n5;
                n3 = 1;
                int n6 = 1;
                n2 = pdfObject.getInt(959926393);
                if (n2 != -1) {
                    n3 = n2;
                }
                if ((n = pdfObject.getInt(959726687)) != -1) {
                    n6 = n;
                }
                if ((n5 = pdfObject.getInt(1043816557)) != -1) {
                    n4 = n5;
                }
                if (n3 * n6 == 1) {
                    n6 = n4;
                }
                PdfObject pdfObject2 = pdfObject.getDictionary(1888135062);
                PdfArrayIterator pdfArrayIterator = pdfObject.getArrayIterator(1011108731);
                int n7 = -1;
                if (pdfArrayIterator != null && pdfArrayIterator.hasMoreTokens()) {
                    n7 = pdfArrayIterator.getNextValueAsConstant(false);
                }
                if (pdfArrayIterator != null && n7 != -1 && n7 != 1399277700 && n7 != 1180911742) {
                    try {
                        PdfObject pdfObject3;
                        byte[] byArray4 = null;
                        if (pdfObject2 != null && (pdfObject3 = pdfObject2.getDictionary(1314558361)) != null) {
                            byArray4 = this.readStream(pdfObject3, true, true, false, false, false);
                        }
                        byArray = this.decodeFilters(pdfObject2, byArray, pdfArrayIterator, n6, n3, true, byArray4, string);
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("[PDF] Problem " + exception + " decompressing stream ");
                        byArray = null;
                        bl6 = false;
                    }
                    n4 = 1;
                } else if (byArray != null && n4 != 1 && n4 < byArray.length && byArray.length != n4) {
                    byte[] byArray5 = new byte[n4];
                    System.arraycopy(byArray, 0, byArray5, 0, n4);
                    byArray = byArray5;
                }
            }
            if (byArray != null && bl) {
                pdfObject.DecodedStream = byArray;
            }
            if (bl2 && bl6) {
                n3 = (int)new File(string).length();
                byte[] byArray6 = new byte[n3];
                try {
                    new BufferedInputStream(new FileInputStream(string)).read(byArray6);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (n4 != 1 && n4 < n3) {
                    byte[] byArray7 = new byte[n4];
                    System.arraycopy(byArray6, 0, byArray7, 0, n4);
                    byArray6 = byArray7;
                }
                return byArray6;
            }
        } else {
            byArray = byArray2;
        }
        if (byArray == null) {
            return null;
        }
        int n = byArray.length;
        byte[] byArray8 = new byte[n];
        System.arraycopy(byArray, 0, byArray8, 0, n);
        return byArray8;
    }

    public final String getStreamOnDisk(String string) {
        int n = this.miniumumCacheSize;
        this.miniumumCacheSize = 0;
        Map map = this.readObject(new PdfObject(string), string, false, null);
        this.readStream(string, true);
        this.miniumumCacheSize = n;
        if (map == null) {
            return null;
        }
        return (String)map.get("CachedStream");
    }

    public final byte[] readStream(String string, boolean bl) {
        Map map = this.readObject(new PdfObject(string), string, false, null);
        return this.readStream(map, string, true, bl, false, false, false);
    }

    public final void flushObjectCache() {
        this.lastRef = null;
    }

    public final void resetCache() {
        this.lastRef = null;
    }

    public final synchronized Map readObject(PdfObject pdfObject, String string, boolean bl, Map map) {
        if (this.lastRef != null && string != null && string.equals(this.lastRef) && pdfObject.isImplemented() == 0) {
            return this.objData;
        }
        if (pdfObject.isImplemented() != 2) {
            this.lastRef = string;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        this.objData = new HashMap();
        bl3 = map != null;
        if (bl2) {
            System.err.println("reading objectRef=" + string + "< isCompressed=" + this.isCompressed(string));
        }
        boolean bl4 = this.isCompressed(string);
        pdfObject.setCompressedStream(bl4);
        if (string.endsWith(" R")) {
            int n;
            byte[] byArray = null;
            byte[] byArray2 = null;
            if (bl4) {
                n = Integer.parseInt(string.substring(0, string.indexOf(32)));
                int n2 = this.getCompressedStreamObject(string);
                String string2 = n2 + " 0 R";
                String string3 = null;
                HashMap hashMap = this.lastOffsetStart;
                HashMap hashMap2 = this.lastOffsetEnd;
                int n3 = this.lastFirst;
                boolean bl5 = true;
                byte[] byArray3 = this.lastCompressedStream;
                if (this.lastOffsetStart != null) {
                    string3 = (String)this.lastOffsetStart.get(String.valueOf(n));
                }
                while (string3 == null) {
                    bl5 = false;
                    try {
                        this.movePointer(string2);
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("Exception moving pointer to " + string);
                    }
                    byArray2 = this.readObjectData(this.ObjLengthTable[n2]);
                    HashMap hashMap3 = new HashMap();
                    this.convertObjectBytesToMap(hashMap3, string2, bl, map, bl2, bl3, byArray, byArray2, false);
                    hashMap = new HashMap();
                    hashMap2 = new HashMap();
                    n3 = Integer.parseInt((String)hashMap3.get("First"));
                    byArray3 = this.readStream(hashMap3, string2, true, true, false, false, false);
                    this.extractCompressedObjectOffset(hashMap, hashMap2, n3, byArray3);
                    string3 = (String)hashMap.get(String.valueOf(n));
                    string2 = (String)hashMap3.get("Extends");
                }
                if (!bl5) {
                    this.lastCompressedStream = byArray3;
                    this.lastOffsetStart = hashMap;
                    this.lastOffsetEnd = hashMap2;
                    this.lastFirst = n3;
                }
                int n4 = n3 + Integer.parseInt(string3);
                int n5 = byArray3.length;
                String string4 = (String)hashMap2.get(String.valueOf(n));
                if (string4 != null) {
                    n5 = n3 + Integer.parseInt(string4);
                }
                int n6 = n5 - n4;
                byArray2 = new byte[n6];
                System.arraycopy(byArray3, n4, byArray2, 0, n6);
            } else {
                try {
                    this.movePointer(string);
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Exception moving pointer to " + string);
                }
                n = string.indexOf(32);
                int n7 = Integer.parseInt(string.substring(0, n));
                if (bl || this.refTableInvalid) {
                    byArray2 = this.readObjectData(-1);
                } else if (n7 > this.ObjLengthTable.length || this.ObjLengthTable[n7] == 0) {
                    LogWriter.writeLog(string + " cannot have offset 0");
                    byArray2 = new byte[]{};
                } else {
                    byArray2 = this.readObjectData(this.ObjLengthTable[n7]);
                }
            }
            if (bl2) {
                System.out.println("convertObjectsToMap");
            }
            if (this.startStreamPointer != -1 || byArray2.length > 1) {
                try {
                    if (pdfObject.isImplemented() != 0) {
                        this.readDictionaryAsObject(pdfObject, string, 0, byArray2, -1, "", false);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (pdfObject.isImplemented() != 2) {
                    this.convertObjectBytesToMap(this.objData, string, bl, map, bl2, bl3, byArray, byArray2, bl4);
                }
            }
            if (bl2) {
                System.out.println("converted");
            }
        } else {
            byte[] byArray = string.getBytes();
            if (byArray.length > 0) {
                this.readDictionary(string, 1, this.objData, 0, byArray, bl, map, -1);
            }
            LogWriter.writeLog("Direct object read " + string + "<<");
        }
        if (bl2) {
            System.out.println("object read");
        }
        return this.objData;
    }

    private byte[] readObjectAsByteArray(String string, boolean bl, boolean bl2, int n, int n2) {
        byte[] byArray;
        byte[] byArray2 = null;
        if (bl2) {
            int n3 = this.getCompressedStreamObject(n, n2);
            String string2 = null;
            HashMap hashMap = this.lastOffsetStart;
            HashMap hashMap2 = this.lastOffsetEnd;
            int n4 = this.lastFirst;
            boolean bl3 = true;
            byte[] byArray3 = this.lastCompressedStream;
            if (this.lastOffsetStart != null) {
                string2 = (String)this.lastOffsetStart.get(String.valueOf(n));
            }
            while (string2 == null) {
                Object object;
                bl3 = false;
                try {
                    this.movePointer(n3, 0);
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Exception moving pointer to " + n);
                }
                byArray = this.readObjectData(this.ObjLengthTable[n3]);
                HashMap<String, byte[]> hashMap3 = new HashMap<String, byte[]>();
                this.convertObjectBytesToMap(hashMap3, string, bl, null, false, false, byArray2, byArray, false);
                hashMap = new HashMap();
                hashMap2 = new HashMap();
                n4 = Integer.parseInt((String)hashMap3.get("First"));
                if (this.isEncrypted) {
                    object = (byte[])hashMap3.get("Stream");
                    try {
                        object = this.decrypt((byte[])object, n3 + " 0 R", false, null, false, false);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    hashMap3.put("Stream", (byte[])object);
                }
                byArray3 = this.readStream(hashMap3, string, true, true, false, false, true);
                this.extractCompressedObjectOffset(hashMap, hashMap2, n4, byArray3);
                string2 = (String)hashMap.get(String.valueOf(n));
                object = (String)hashMap3.get("Extends");
                if (object == null) continue;
                n3 = Integer.parseInt(((String)object).substring(0, ((String)object).indexOf(" ")));
            }
            if (!bl3) {
                this.lastCompressedStream = byArray3;
                this.lastOffsetStart = hashMap;
                this.lastOffsetEnd = hashMap2;
                this.lastFirst = n4;
            }
            int n5 = n4 + Integer.parseInt(string2);
            int n6 = byArray3.length;
            String string3 = (String)hashMap2.get(String.valueOf(n));
            if (string3 != null) {
                n6 = n4 + Integer.parseInt(string3);
            }
            int n7 = n6 - n5;
            byArray = new byte[n7];
            System.arraycopy(byArray3, n5, byArray, 0, n7);
        } else {
            try {
                this.movePointer(n, n2);
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception moving pointer to " + string);
            }
            if (bl || this.refTableInvalid) {
                byArray = this.readObjectData(-1);
            } else {
                if (n > this.ObjLengthTable.length) {
                    return null;
                }
                byArray = this.readObjectData(this.ObjLengthTable[n]);
            }
        }
        return byArray;
    }

    private void extractCompressedObjectOffset(Map map, Map map2, int n, byte[] byArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        StringBuffer stringBuffer = null;
        StringBuffer stringBuffer2 = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < n; ++i) {
            int n6;
            stringBuffer = new StringBuffer();
            stringBuffer2 = new StringBuffer();
            n2 = i;
            while (byArray[i] != 32) {
                stringBuffer.append((char)byArray[i]);
                ++i;
            }
            n3 = i - 1;
            int n7 = n3 - n2 + 1;
            char[] cArray = new char[n7];
            for (n6 = 0; n6 < n7; ++n6) {
                cArray[n6] = (char)byArray[n2 + n6];
            }
            string2 = new String(cArray);
            if (!string2.equals(stringBuffer.toString())) {
                System.out.println("Different=" + string2 + "<>" + stringBuffer + '<');
                System.exit(1);
            }
            while (byArray[i] == 32) {
                ++i;
            }
            n4 = i;
            while (byArray[i] != 32 && i < n) {
                stringBuffer2.append((char)byArray[i]);
                ++i;
            }
            n5 = i - 1;
            n7 = n5 - n4 + 1;
            cArray = new char[n7];
            for (n6 = 0; n6 < n7; ++n6) {
                cArray[n6] = (char)byArray[n4 + n6];
            }
            string3 = new String(cArray);
            if (!string3.equals(stringBuffer2.toString())) {
                System.out.println("Different=" + string3 + "<>" + stringBuffer2 + '<');
                System.exit(1);
            }
            map.put(string2, string3);
            if (string != null) {
                map2.put(string, string3);
            }
            string = string2;
        }
    }

    private void convertObjectBytesToMap(Map map, String string, boolean bl, Map map2, boolean bl2, boolean bl3, byte[] byArray, byte[] byArray2, boolean bl4) {
        int n;
        int n2 = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        char c = ' ';
        StringBuffer stringBuffer = new StringBuffer();
        if (!bl4) {
            while (byArray2[n2] != 111 || byArray2[n2 + 1] != 98 || byArray2[n2 + 2] != 106) {
                ++n2;
            }
            n2 += 2;
            while (byArray2[n2] != 47 && !(byArray2[++n2] == 10 | byArray2[n2] == 13 | byArray2[n2] == 60 | byArray2[n2] == 91 | byArray2[n2] == 32)) {
            }
        }
        if (bl2) {
            for (n = n2; n < byArray2.length - 7; ++n) {
                System.err.print((char)byArray2[n]);
            }
            System.err.print("<===\n\n");
        }
        if (byArray2[n2] == 47 | byArray2[n2] == 91) {
            --n2;
        }
        while (n2 < byArray2.length - 7) {
            ++n2;
            if (bl2) {
                System.err.println((char)byArray2[n2]);
            }
            if (byArray2[n2] == 111 && byArray2[n2 + 1] == 98 && byArray2[n2 + 2] == 106) break;
            if (byArray2[n2] == 60 && byArray2[n2 + 1] == 60 | byArray2[n2 - 1] == 60) {
                if (byArray2[n2 - 1] != 60) {
                    ++n2;
                }
                if (bl2) {
                    System.err.println("Read dictionary");
                }
                n2 = this.readDictionary(string, 1, map, n2, byArray2, bl, map2, -1);
                continue;
            }
            if (byArray2[n2] == 115 && byArray2[n2 + 1] == 116 && byArray2[n2 + 2] == 114 && byArray2[n2 + 3] == 101 && byArray2[n2 + 4] == 97 && byArray2[n2 + 5] == 109) {
                int n3;
                if (bl2) {
                    System.err.println("Reading stream");
                }
                if (byArray2[n2 += 6] == 13 && byArray2[n2 + 1] == 10) {
                    n2 += 2;
                } else if (byArray2[n2] == 10 | byArray2[n2] == 13) {
                    // empty if block
                }
                n = ++n2;
                --n2;
                int n4 = 0;
                String string2 = (String)map.get("Length");
                if (string2 != null) {
                    if (string2.indexOf(" R") != -1) {
                        try {
                            int n5;
                            long l = this.movePointer(string2);
                            int n6 = 128;
                            if (l + (long)n6 > this.eof) {
                                n6 = (int)(this.eof - l - 1L);
                            }
                            StringBuffer stringBuffer2 = new StringBuffer();
                            byte[] byArray3 = new byte[n6];
                            this.pdf_datafile.read(byArray3);
                            for (n5 = 3; n5 >= n6 || byArray3[n5 - 3] != 111 || byArray3[n5 - 2] != 98 || byArray3[n5 - 1] != 106; ++n5) {
                            }
                            while (n5 >= n6 || !Character.isDigit((char)byArray3[n5])) {
                                ++n5;
                            }
                            while (n5 < n6 && Character.isDigit((char)byArray3[n5])) {
                                stringBuffer2.append((char)byArray3[n5]);
                                ++n5;
                            }
                            this.movePointer(l);
                            string2 = stringBuffer2.toString();
                        }
                        catch (Exception exception) {
                            LogWriter.writeLog("Exception moving pointer to " + string);
                            string2 = null;
                        }
                    }
                    if (string2 != null) {
                        n4 = Integer.parseInt(string2);
                        n2 = n + n4;
                        if (n2 < byArray2.length && byArray2[n2] == 13 && n2 + 1 < byArray2.length && byArray2[n2 + 1] == 10) {
                            n2 += 2;
                        }
                        if (byArray2.length <= n2 + 9 || byArray2[n2] != 101 || byArray2[n2 + 1] != 110 || byArray2[n2 + 2] != 100 || byArray2[n2 + 3] != 115 || byArray2[n2 + 4] != 116 || byArray2[n2 + 5] != 114 || byArray2[n2 + 6] != 101 || byArray2[n2 + 7] != 97 || byArray2[n2 + 8] != 109) {
                            boolean bl5 = false;
                            int n7 = n2;
                            if (n2 < byArray2.length) {
                                while (!bl5 && ++n2 != byArray2.length) {
                                    if (byArray2[n2] != 101 || byArray2[n2 + 1] != 110 || byArray2[n2 + 2] != 100 || byArray2[n2 + 3] != 115 || byArray2[n2 + 4] != 116 || byArray2[n2 + 5] != 114 || byArray2[n2 + 6] != 101 || byArray2[n2 + 7] != 97 || byArray2[n2 + 8] != 109) continue;
                                    n4 = n2 - n;
                                    bl5 = true;
                                }
                            }
                            if (!bl5) {
                                n2 = n7;
                                if (n2 > byArray2.length) {
                                    n2 = byArray2.length;
                                }
                                while (!bl5 && --n2 >= 0) {
                                    if (byArray2[n2] != 101 || byArray2[n2 + 1] != 110 || byArray2[n2 + 2] != 100 || byArray2[n2 + 3] != 115 || byArray2[n2 + 4] != 116 || byArray2[n2 + 5] != 114 || byArray2[n2 + 6] != 101 || byArray2[n2 + 7] != 97 || byArray2[n2 + 8] != 109) continue;
                                    n4 = n2 - n;
                                    bl5 = true;
                                }
                            }
                            if (!bl5) {
                                n2 = n7;
                            }
                        }
                    }
                } else {
                    while (++n2 != byArray2.length && (byArray2[n2] != 101 || byArray2[n2 + 1] != 110 || byArray2[n2 + 2] != 100 || byArray2[n2 + 3] != 115 || byArray2[n2 + 4] != 116 || byArray2[n2 + 5] != 114 || byArray2[n2 + 6] != 101 || byArray2[n2 + 7] != 97 || byArray2[n2 + 8] != 109)) {
                    }
                    int n8 = n2 - 1;
                    if (n8 > n) {
                        n4 = n8 - n + 1;
                    }
                }
                if (n4 > 1 && (n3 = n + n4 - 1) < byArray2.length && n3 > 0 && byArray2[n3] == 10) {
                    --n4;
                    --n3;
                }
                if (this.startStreamPointer == -1) {
                    if (n + n4 > byArray2.length) {
                        n4 = byArray2.length - n;
                    }
                    byArray = new byte[n4];
                    System.arraycopy(byArray2, n, byArray, 0, n4);
                }
                if (this.startStreamPointer != -1) {
                    map.put("startStreamOnDisk", new Integer(this.startStreamPointer));
                    map.put("endStreamOnDisk", new Integer(this.endStreamPointer));
                }
                n2 += 9;
                continue;
            }
            if (byArray2[n2] == 91) {
                if (bl2) {
                    System.err.println("read array");
                }
                n2 = this.readArray(string, n2, map, byArray2, bl, map2);
                continue;
            }
            if (!(byArray2[n2] != 60 & byArray2[n2] != 62)) continue;
            if (bl3) {
                if (byArray2[n2 - 1] == 92 && byArray2[n2 - 2] == 92) {
                    byteArrayOutputStream.write(byArray2[n2]);
                } else if (!((byArray2[n2] == 40 | byArray2[n2] == 41) & byArray2[n2 - 1] != 92)) {
                    byteArrayOutputStream.write(byArray2[n2]);
                }
            }
            if (byArray2[n2] == 10 | byArray2[n2] == 13 | byArray2[n2] == 32) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(' ');
                }
                c = ' ';
                continue;
            }
            if (byArray2[n2] == 47 && c != ' ') {
                stringBuffer.append(' ');
            }
            c = (char)byArray2[n2];
            stringBuffer.append(c);
        }
        if (stringBuffer.length() > 0 && (n = stringBuffer.toString().indexOf(37)) > -1) {
            stringBuffer.setLength(n);
        }
        if (stringBuffer.length() > 0) {
            String string3 = stringBuffer.toString().trim();
            if (bl3 && string3.startsWith("(")) {
                try {
                    byteArrayOutputStream.close();
                    byte[] byArray4 = byteArrayOutputStream.toByteArray();
                    byArray4 = this.decrypt(byArray4, string, false, null, false, false);
                    map.put("rawValue", byArray4);
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Exception " + exception + " writing out text string");
                }
            } else {
                if (bl2) {
                    System.err.println("Remainder value=" + stringBuffer + "<<");
                }
                map.put("rawValue", string3);
            }
        }
        if (byArray != null) {
            map.put("Stream", byArray);
        }
        if (bl2) {
            System.err.println(map);
        }
        try {
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private int readArray(String string, int n, Map map, byte[] byArray, boolean bl, Map map2) {
        int n2 = 0;
        int n3 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl4 = false;
        boolean bl5 = false;
        while (true) {
            Serializable serializable;
            if (bl2) {
                int n4 = n;
                while (byArray[n4] == 13 | byArray[n4] == 10 | byArray[n4] == 32) {
                    ++n4;
                }
                if (byArray[n4] == 60 && byArray[n4 + 1] == 60) {
                    n = n4;
                    if (bl3) {
                        stringBuffer.append(stringBuffer2);
                        stringBuffer.append(' ');
                        n = this.readDictionary(string, 1, map, n, byArray, bl, map2, -1);
                    } else {
                        serializable = new HashMap();
                        map.put(stringBuffer2.substring(1), serializable);
                        n = this.readDictionary(string, 1, (Map)((Object)serializable), n, byArray, bl, map2, -1);
                    }
                    if (byArray[n] == 62) {
                        ++n;
                    }
                    stringBuffer2 = new StringBuffer();
                } else {
                    if (stringBuffer.charAt(stringBuffer.length() - 1) != ' ') {
                        stringBuffer.append(' ');
                    }
                    stringBuffer.append(stringBuffer2);
                    stringBuffer.append(' ');
                    stringBuffer2 = new StringBuffer();
                    bl2 = false;
                    --n;
                }
            } else if (!bl5 && byArray[n] == 47) {
                bl2 = true;
                do {
                    stringBuffer2.append((char)byArray[n]);
                } while (byArray[++n] != 47 && byArray[n] != 13 && byArray[n] != 10 && byArray[n] != 32 && byArray[n] != 60 && byArray[n] != 91 && byArray[n] != 93);
                if (byArray[n] == 47 || byArray[n] == 91 || byArray[n] == 93 || byArray[n] == 60) {
                    --n;
                }
                if (stringBuffer2.toString().equals("/Separation")) {
                    bl3 = true;
                } else if (stringBuffer2.toString().equals("/Indexed")) {
                    bl4 = true;
                }
            } else if (byArray[n] == 40 && byArray[n - 1] != 92 && bl4) {
                bl5 = true;
                stringBuffer.append(" <");
            } else if (bl5) {
                if (byArray[n] == 41 && byArray[n - 1] != 92) {
                    stringBuffer.append('>');
                    bl5 = false;
                } else {
                    String string2 = null;
                    if (byArray[n] == 92 && byArray[n + 1] != 13 && byArray[n + 1] != 10 && byArray[n + 1] != 114) {
                        char c;
                        serializable = new StringBuffer(3);
                        int n5 = 0;
                        for (int i = 1; i < 4 && (c = (char)byArray[n + 1]) >= '0' && c <= '9'; ++i) {
                            ((StringBuffer)serializable).append(c);
                            ++n5;
                            ++n;
                        }
                        if (n5 > 0) {
                            string2 = Integer.toHexString(Integer.parseInt(((StringBuffer)serializable).toString(), 8));
                        }
                    }
                    if (string2 == null) {
                        string2 = Integer.toHexString(byArray[n] & 0xFF);
                    }
                    if (string2.length() < 2) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(string2);
                }
            } else {
                if (n > 0 && byArray[n - 1] == 47) {
                    stringBuffer.append('/');
                }
                if (byArray[n] == 13 || byArray[n] == 10) {
                    stringBuffer.append(' ');
                } else {
                    if (byArray[n] == 60 && byArray[n - 1] != 32 && byArray[n - 1] != 60) {
                        stringBuffer.append(' ');
                    }
                    if (n > 0 && byArray[n - 1] == 93) {
                        stringBuffer.append(' ');
                    }
                    stringBuffer.append((char)byArray[n]);
                }
                if (n == 0 || n > 0 && byArray[n - 1] != 92) {
                    if (byArray[n] == 91) {
                        ++n2;
                    } else if (byArray[n] == 93) {
                        ++n3;
                    }
                }
            }
            if (byArray[n] == 93 & n2 == n3) break;
            ++n;
        }
        map.put("rawValue", stringBuffer.toString().trim());
        return n;
    }

    public final Map readFDF() throws PdfException {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        Map map = new HashMap();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("F", "x");
        hashMap.put("T", "x");
        hashMap.put("V", "x");
        try {
            n = (int)this.pdf_datafile.length();
            this.pdf_datafile.readLine();
            n2 = (int)this.pdf_datafile.getFilePointer();
            byte[] byArray = new byte[n -= n2];
            this.pdf_datafile.read(byArray);
            this.convertObjectBytesToMap(map, "1 0 R", false, hashMap, false, true, byArray, byArray, false);
            map = (Map)map.get("FDF");
        }
        catch (Exception exception) {
            try {
                this.pdf_datafile.close();
            }
            catch (IOException iOException) {
                LogWriter.writeLog("Exception " + exception + " closing file");
            }
            throw new PdfException("Exception " + exception + " reading trailer");
        }
        return map;
    }

    public int getPDFflag(Integer n) {
        if (n.equals(PDFflags.USER_ACCESS_PERMISSIONS)) {
            return this.P;
        }
        if (n == PDFflags.VALID_PASSWORD_SUPPLIED) {
            return this.passwordStatus;
        }
        return -1;
    }

    public final String readReferenceTable() throws PdfException {
        int n = this.readFirstStartRef();
        int n2 = (int)this.eof;
        this.xref.addElement(n);
        if (n >= n2) {
            LogWriter.writeLog("Pointer not if file - trying to manually find startref");
            this.refTableInvalid = true;
            return this.findOffsets();
        }
        if (this.isCompressedStream(n, n2)) {
            return this.readCompressedStream(n);
        }
        return this.readLegacyReferenceTable(n, n2);
    }

    private final int getWord(byte[] byArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 = (n3 << 8) + (byArray[n + i] & 0xFF);
        }
        return n3;
    }

    private String readCompressedStream(int n) throws PdfException {
        String string = "";
        String string2 = null;
        while (n != -1) {
            String string3;
            int n2;
            int n3;
            if (this.interruptRefReading) {
                return null;
            }
            boolean bl = false;
            boolean bl2 = false;
            this.objData = new HashMap();
            byte[] byArray = null;
            try {
                this.movePointer(n);
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception moving pointer to " + n);
            }
            byte[] byArray2 = this.readObjectData(-1);
            StringBuffer stringBuffer = new StringBuffer();
            int n4 = 32;
            int n5 = 0;
            for (int i = 0; i < byArray2.length; ++i) {
                char c = (char)byArray2[i];
                if (c == '\n' || c == '\r') {
                    c = ' ';
                }
                if (c == ' ' && n4 == 32) {
                    n5 = 0;
                } else if (c == pattern.charAt(n5)) {
                    ++n5;
                } else {
                    n5 = 0;
                    stringBuffer.append(c);
                }
                if (n5 == 3) break;
                n4 = c;
            }
            stringBuffer.append('R');
            String string4 = stringBuffer.toString();
            this.convertObjectBytesToMap(this.objData, string4, false, null, bl, bl2, byArray, byArray2, false);
            PdfCompressedObject pdfCompressedObject = new PdfCompressedObject(string4);
            pdfCompressedObject.setCompressedStream(true);
            this.readDictionaryAsObject(pdfCompressedObject, string4, 0, byArray2, -1, "", false);
            this.lastRef = "-1";
            HashMap hashMap = this.objData;
            int[] nArray = ((PdfObject)pdfCompressedObject).getIntArray(1043608929);
            if (nArray == null) {
                n3 = 0;
                n2 = ((PdfObject)pdfCompressedObject).getInt(590957109);
            } else {
                n3 = nArray[0];
                n2 = nArray[1];
            }
            int[] nArray2 = ((PdfObject)pdfCompressedObject).getIntArray(39);
            byte[] byArray3 = pdfCompressedObject.DecodedStream;
            if (byArray3 == null) {
                byArray3 = this.readStream(pdfCompressedObject, true, true, false, false, true);
            }
            int n6 = 0;
            int[] nArray3 = new int[]{1, 0, 0};
            block9: for (int i = 0; i < n2; ++i) {
                int n7;
                int[] nArray4 = new int[3];
                for (n7 = 0; n7 < 3; ++n7) {
                    if (nArray2[n7] == 0) {
                        nArray4[n7] = nArray3[n7];
                        continue;
                    }
                    nArray4[n7] = this.getWord(byArray3, n6, nArray2[n7]);
                    n6 += nArray2[n7];
                }
                n7 = 0;
                switch (nArray4[0]) {
                    case 0: {
                        ++n3;
                        continue block9;
                    }
                    case 1: {
                        n7 = nArray4[1];
                        int n8 = nArray4[2];
                        this.storeObjectOffset(n3, n7, n8, false);
                        ++n3;
                        continue block9;
                    }
                    case 2: {
                        n7 = nArray4[1];
                        int n8 = nArray4[2];
                        this.storeObjectOffset(n3, n7, n8, true);
                        ++n3;
                        continue block9;
                    }
                    default: {
                        throw new PdfException("Exception Unsupported Compression mode with value " + nArray4[0]);
                    }
                }
            }
            if (string.length() == 0) {
                string3 = (String)hashMap.get("Root");
                if (string3 != null) {
                    string = string3;
                }
                if ((string2 = (String)hashMap.get("Encrypt")) != null) {
                    this.ID = (String)hashMap.get("ID");
                    if (this.ID == null) {
                        this.ID = "";
                    } else {
                        this.ID = Strip.removeArrayDeleminators(this.ID);
                        if (this.ID.startsWith("<")) {
                            this.ID = this.ID.substring(1, this.ID.indexOf(62));
                        }
                    }
                }
                this.infoObject = (string3 = (String)hashMap.get("Info")) != null && (!this.isEncrypted || this.isPasswordSupplied) ? string3 : null;
            }
            if ((string3 = (String)hashMap.get("Prev")) != null) {
                hashMap = new HashMap();
                n = Integer.parseInt(string3);
                continue;
            }
            n = -1;
        }
        if (!this.interruptRefReading) {
            if (string2 != null) {
                this.readEncryptionObject(string2);
            }
            this.calculateObjectLength();
        }
        return string;
    }

    private boolean isCompressedStream(int n, int n2) throws PdfException {
        int n3 = 50;
        int n4 = 0;
        int[] nArray = new int[]{79, 98, 106, 83, 116, 109};
        int[] nArray2 = new int[]{88, 82, 101, 102};
        int n5 = -1;
        while (true) {
            if (n + n3 > n2) {
                n3 = n2 - n;
            }
            if (n3 < 0) {
                n3 = 50;
            }
            byte[] byArray = new byte[n3];
            this.movePointer(n);
            try {
                this.pdf_datafile.read(byArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new PdfException("Exception " + exception + " scanning trailer for ref or obj");
            }
            for (int i = 0; i < n3; ++i) {
                byte by = byArray[i];
                if (by == oldPattern[n4] && n5 != 1) {
                    ++n4;
                    n5 = 2;
                } else if ((by == nArray[n4] || by == nArray2[n4]) && n5 != 2) {
                    ++n4;
                    n5 = 1;
                } else {
                    n4 = 0;
                    n5 = -1;
                }
                if (n4 == 3) break;
            }
            if (n4 == 3) break;
            n += n3;
        }
        if (n5 == -1) {
            try {
                this.pdf_datafile.close();
            }
            catch (IOException iOException) {
                LogWriter.writeLog("Exception 1 closing file");
            }
            throw new PdfException("Exception unable to find ref or obj in trailer");
        }
        return n5 == 1;
    }

    private final String readLegacyReferenceTable(int n, int n2) throws PdfException {
        String string = "";
        String string2 = "";
        String string3 = null;
        int n3 = 0;
        byte[] byArray = null;
        int n4 = 1024;
        int n5 = 0;
        int n6 = 0;
        byte[] byArray2 = new byte[]{37, 37, 69, 79, 70};
        HashMap hashMap = new HashMap();
        do {
            int n7;
            if (this.interruptRefReading) {
                return null;
            }
            try {
                byArray = this.readTrailer(n4, n5, byArray2, n, n2);
            }
            catch (Exception exception) {
                byArray = null;
                try {
                    this.pdf_datafile.close();
                }
                catch (IOException iOException) {
                    LogWriter.writeLog("Exception " + exception + " closing file");
                }
                throw new PdfException("Exception " + exception + " reading trailer");
            }
            if (byArray == null) break;
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            StringBuffer stringBuffer3 = new StringBuffer();
            int n8 = byArray.length;
            for (n7 = 0; n7 < n8 && (byArray[n7] != 116 || byArray[n7 + 1] != 114 || byArray[n7 + 2] != 97 || byArray[n7 + 3] != 105 || byArray[n7 + 4] != 108 || byArray[n7 + 5] != 101 || byArray[n7 + 6] != 114); ++n7) {
            }
            n6 = n7;
            while (byArray[n7] != 60 && byArray[n7 + 1] != 60) {
                ++n7;
            }
            n7 = this.readRef2(byArray, hashMap, n7, stringBuffer2, stringBuffer3);
            string2 = (String)hashMap.get("XRefStm");
            if (string2 != null) {
                n = Integer.parseInt(string2);
            } else {
                boolean bl = true;
                while (byArray[n7] != 116 && byArray[n7 + 1] != 120 && byArray[n7 + 2] != 114 && byArray[n7 + 3] != 101 && byArray[n7 + 4] != 102) {
                    if (byArray[n7] == 111 && byArray[n7 + 1] == 98 && byArray[n7 + 2] == 106) {
                        bl = false;
                        break;
                    }
                    ++n7;
                }
                if (bl) {
                    n7 += 8;
                    while (n7 < n8 && byArray[n7] == 10 | byArray[n7] == 32 | byArray[n7] == 13) {
                        ++n7;
                    }
                    while (n7 < n8 && byArray[n7] != 10 && byArray[n7] != 32 && byArray[n7] != 13) {
                        stringBuffer.append((char)byArray[n7]);
                        ++n7;
                    }
                    if (stringBuffer.length() > 0) {
                        n = Integer.parseInt(stringBuffer.toString());
                    }
                }
            }
            if (n == -1) {
                LogWriter.writeLog("No startRef");
                continue;
            }
            if (byArray[0] == 120 & byArray[1] == 114 & byArray[2] == 101 & byArray[3] == 102) {
                n7 = 5;
                while (byArray[n7] == 10 | byArray[n7] == 32 | byArray[n7] == 13) {
                    ++n7;
                }
                n3 = this.readXRefs(n3, byArray, n6, n7);
                n7 = n6;
                if (string.length() == 0) {
                    string2 = (String)hashMap.get("Root");
                    if (string2 != null) {
                        string = string2;
                    }
                    if ((string3 = (String)hashMap.get("Encrypt")) != null) {
                        this.ID = (String)hashMap.get("ID");
                        if (this.ID == null) {
                            this.ID = "";
                        } else {
                            this.ID = Strip.removeArrayDeleminators(this.ID);
                            if (this.ID.startsWith("<")) {
                                this.ID = this.ID.substring(1, this.ID.indexOf(62));
                            }
                        }
                    }
                    this.infoObject = (string2 = (String)hashMap.get("Info")) != null && !this.isEncrypted | this.isPasswordSupplied ? string2 : null;
                }
                if ((string2 = (String)hashMap.get("Prev")) != null) {
                    n4 = 1024;
                    n5 = 0;
                    hashMap = new HashMap();
                    n = Integer.parseInt(string2);
                    this.xref.addElement(n);
                    continue;
                }
                n = -1;
                continue;
            }
            n = -1;
            string = this.findOffsets();
            this.refTableInvalid = true;
        } while (n != -1);
        if (!this.interruptRefReading) {
            if (string3 != null) {
                this.readEncryptionObject(string3);
            }
            if (!this.refTableInvalid) {
                this.calculateObjectLength();
            }
        }
        return string;
    }

    private void calculateObjectLength() {
        int n;
        int n2;
        this.xref.addElement((int)this.eof);
        int[] nArray = this.xref.get();
        int n3 = nArray.length;
        int[] nArray2 = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            nArray2[n2] = n2;
        }
        nArray2 = Sorts.quicksort(nArray, nArray2);
        n2 = this.offset.getCapacity();
        this.ObjLengthTable = new int[n2];
        int[] nArray3 = new int[n2];
        int[] nArray4 = new int[n2];
        int[] nArray5 = this.offset.get();
        boolean[] blArray = this.isCompressed.get();
        for (n = 0; n < n2; ++n) {
            if (blArray[n]) continue;
            nArray4[n] = nArray5[n];
            nArray3[n] = n;
        }
        nArray3 = Sorts.quicksort(nArray4, nArray3);
        n = 0;
        while (true) {
            try {
                while (nArray4[nArray3[n]] == 0) {
                    ++n;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.exit(1);
                continue;
            }
            break;
        }
        int n4 = nArray4[nArray3[n]];
        int n5 = 0;
        while (nArray[nArray2[n5]] < n4 + 1) {
            ++n5;
        }
        while (n < n2 - 1) {
            int n6 = nArray4[nArray3[n + 1]];
            int n7 = n6 - n4 - 1;
            if (nArray[nArray2[n5]] < n6) {
                n7 = nArray[nArray2[n5]] - n4 - 1;
                while (nArray[nArray2[n5]] < n6 + 1) {
                    ++n5;
                }
            }
            this.ObjLengthTable[nArray3[n]] = n7;
            n4 = n6;
            while (nArray[nArray2[n5]] < n4 + 1) {
                ++n5;
            }
            ++n;
        }
        this.ObjLengthTable[nArray3[n]] = nArray[nArray2[n5]] - n4 - 1;
    }

    private int readXRefs(int n, byte[] byArray, int n2, int n3) {
        int n4 = 99;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        boolean bl = false;
        int[] nArray = new int[5];
        int[] nArray2 = new int[5];
        while (n3 < n2) {
            int n9;
            int n10 = n3;
            int n11 = -1;
            while (byArray[n3] != 10 & byArray[n3] != 13) {
                if (n11 == -1 && byArray[n3] == 37) {
                    n11 = n3 - 1;
                }
                ++n3;
            }
            if (n11 == -1) {
                n11 = n3 - 1;
            }
            while (byArray[n10] == 32) {
                ++n10;
            }
            while (byArray[n11] == 32) {
                --n11;
            }
            ++n3;
            n6 = 0;
            n8 = n11 - n10 + 1;
            if (n8 <= 0) continue;
            int n12 = 1;
            for (n9 = 1; n9 < n8; ++n9) {
                int n13 = byArray[n10 + n9];
                if (n13 == 32 && n12 != 32) {
                    nArray[n6] = n9;
                    ++n6;
                } else if (n13 != 32 && n12 == 32) {
                    nArray2[n6] = n9;
                }
                n12 = n13;
            }
            nArray[n6] = n8;
            if (++n6 == 1) {
                if (bl) {
                    bl = false;
                    continue;
                }
                n = PdfReader.parseInt(n10, n10 + nArray[0], byArray);
                bl = true;
                continue;
            }
            if (n6 == 2) {
                n = PdfReader.parseInt(n10, n10 + nArray[0], byArray);
                continue;
            }
            n5 = PdfReader.parseInt(n10, n10 + nArray[0], byArray);
            n7 = PdfReader.parseInt(n10 + nArray2[1], n10 + nArray[1], byArray);
            n4 = (char)byArray[n10 + nArray2[2]];
            if (n4 == 110) {
                n9 = 0;
                int n14 = 20;
                if ((long)(n5 + n14) > this.eof) {
                    n14 = (int)(this.eof - (long)n5);
                }
                if (n14 > 0) {
                    byte[] byArray2 = new byte[n14];
                    this.movePointer(n5);
                    try {
                        this.pdf_datafile.read(byArray2);
                        for (int i = 4; i < n14; ++i) {
                            if (byArray2[i - 3] != 32 || byArray2[i - 2] != 111 || byArray2[i - 1] != 98 || byArray2[i] != 106) continue;
                            n9 = 1;
                            i = n14;
                        }
                        if (n9 != 0) {
                            this.storeObjectOffset(n, n5, n7, false);
                            this.xref.addElement(n5);
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
            ++n;
        }
        return n;
    }

    public static int parseInt(int n, int n2, byte[] byArray) {
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        --n;
        for (int i = n2 - 1; i > n; --i) {
            if (byArray[i] == 45) {
                bl = true;
                continue;
            }
            n3 += (byArray[i] - 48) * powers[n4];
            ++n4;
        }
        if (bl) {
            return -n3;
        }
        return n3;
    }

    private static float parseFloat(int n, int n2, byte[] byArray) {
        int n3;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        int n4 = n2;
        int n5 = n;
        boolean bl = false;
        for (n3 = n2 - 1; n3 > n - 1; --n3) {
            if (byArray[n3] != 46) continue;
            n4 = n3;
            break;
        }
        n3 = n4;
        int n6 = n4;
        if (byArray[n] == 43) {
            --n3;
            ++n5;
        } else if (byArray[n] == 45) {
            ++n5;
            bl = true;
        }
        int n7 = n3 - n5;
        int n8 = n2 - n4;
        if (n7 > 4) {
            bl = false;
            try {
                int n9 = n2 - n;
                byte[] byArray2 = new byte[n9];
                System.arraycopy(byArray, n, byArray2, 0, n9);
                f = Float.parseFloat(new String(byArray2));
            }
            catch (Exception exception) {
                f = 0.0f;
            }
        } else {
            int n10;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            float f7 = 0.0f;
            float f8 = 0.0f;
            float f9 = 0.0f;
            float f10 = 0.0f;
            float f11 = 0.0f;
            float f12 = 0.0f;
            float f13 = 0.0f;
            if (n7 > 3) {
                n10 = byArray[n5] - 48;
                switch (n10) {
                    case 1: {
                        f4 = 1000.0f;
                        break;
                    }
                    case 2: {
                        f4 = 2000.0f;
                        break;
                    }
                    case 3: {
                        f4 = 3000.0f;
                        break;
                    }
                    case 4: {
                        f4 = 4000.0f;
                        break;
                    }
                    case 5: {
                        f4 = 5000.0f;
                        break;
                    }
                    case 6: {
                        f4 = 6000.0f;
                        break;
                    }
                    case 7: {
                        f4 = 7000.0f;
                        break;
                    }
                    case 8: {
                        f4 = 8000.0f;
                        break;
                    }
                    case 9: {
                        f4 = 9000.0f;
                    }
                }
                ++n5;
            }
            if (n7 > 2) {
                n10 = byArray[n5] - 48;
                switch (n10) {
                    case 1: {
                        f7 = 100.0f;
                        break;
                    }
                    case 2: {
                        f7 = 200.0f;
                        break;
                    }
                    case 3: {
                        f7 = 300.0f;
                        break;
                    }
                    case 4: {
                        f7 = 400.0f;
                        break;
                    }
                    case 5: {
                        f7 = 500.0f;
                        break;
                    }
                    case 6: {
                        f7 = 600.0f;
                        break;
                    }
                    case 7: {
                        f7 = 700.0f;
                        break;
                    }
                    case 8: {
                        f7 = 800.0f;
                        break;
                    }
                    case 9: {
                        f7 = 900.0f;
                    }
                }
                ++n5;
            }
            if (n7 > 1) {
                n10 = byArray[n5] - 48;
                switch (n10) {
                    case 1: {
                        f6 = 10.0f;
                        break;
                    }
                    case 2: {
                        f6 = 20.0f;
                        break;
                    }
                    case 3: {
                        f6 = 30.0f;
                        break;
                    }
                    case 4: {
                        f6 = 40.0f;
                        break;
                    }
                    case 5: {
                        f6 = 50.0f;
                        break;
                    }
                    case 6: {
                        f6 = 60.0f;
                        break;
                    }
                    case 7: {
                        f6 = 70.0f;
                        break;
                    }
                    case 8: {
                        f6 = 80.0f;
                        break;
                    }
                    case 9: {
                        f6 = 90.0f;
                    }
                }
                ++n5;
            }
            if (n7 > 0) {
                n10 = byArray[n5] - 48;
                switch (n10) {
                    case 1: {
                        f5 = 1.0f;
                        break;
                    }
                    case 2: {
                        f5 = 2.0f;
                        break;
                    }
                    case 3: {
                        f5 = 3.0f;
                        break;
                    }
                    case 4: {
                        f5 = 4.0f;
                        break;
                    }
                    case 5: {
                        f5 = 5.0f;
                        break;
                    }
                    case 6: {
                        f5 = 6.0f;
                        break;
                    }
                    case 7: {
                        f5 = 7.0f;
                        break;
                    }
                    case 8: {
                        f5 = 8.0f;
                        break;
                    }
                    case 9: {
                        f5 = 9.0f;
                    }
                }
            }
            if (n8 > 1) {
                n10 = byArray[++n6] - 48;
                switch (n10) {
                    case 1: {
                        f8 = 0.1f;
                        break;
                    }
                    case 2: {
                        f8 = 0.2f;
                        break;
                    }
                    case 3: {
                        f8 = 0.3f;
                        break;
                    }
                    case 4: {
                        f8 = 0.4f;
                        break;
                    }
                    case 5: {
                        f8 = 0.5f;
                        break;
                    }
                    case 6: {
                        f8 = 0.6f;
                        break;
                    }
                    case 7: {
                        f8 = 0.7f;
                        break;
                    }
                    case 8: {
                        f8 = 0.8f;
                        break;
                    }
                    case 9: {
                        f8 = 0.9f;
                    }
                }
            }
            if (n8 > 2) {
                n10 = byArray[++n6] - 48;
                switch (n10) {
                    case 1: {
                        f9 = 0.01f;
                        break;
                    }
                    case 2: {
                        f9 = 0.02f;
                        break;
                    }
                    case 3: {
                        f9 = 0.03f;
                        break;
                    }
                    case 4: {
                        f9 = 0.04f;
                        break;
                    }
                    case 5: {
                        f9 = 0.05f;
                        break;
                    }
                    case 6: {
                        f9 = 0.06f;
                        break;
                    }
                    case 7: {
                        f9 = 0.07f;
                        break;
                    }
                    case 8: {
                        f9 = 0.08f;
                        break;
                    }
                    case 9: {
                        f9 = 0.09f;
                    }
                }
            }
            if (n8 > 3) {
                n10 = byArray[++n6] - 48;
                switch (n10) {
                    case 1: {
                        f10 = 0.001f;
                        break;
                    }
                    case 2: {
                        f10 = 0.002f;
                        break;
                    }
                    case 3: {
                        f10 = 0.003f;
                        break;
                    }
                    case 4: {
                        f10 = 0.004f;
                        break;
                    }
                    case 5: {
                        f10 = 0.005f;
                        break;
                    }
                    case 6: {
                        f10 = 0.006f;
                        break;
                    }
                    case 7: {
                        f10 = 0.007f;
                        break;
                    }
                    case 8: {
                        f10 = 0.008f;
                        break;
                    }
                    case 9: {
                        f10 = 0.009f;
                    }
                }
            }
            if (n8 > 4) {
                n10 = byArray[++n6] - 48;
                switch (n10) {
                    case 1: {
                        f11 = 1.0E-4f;
                        break;
                    }
                    case 2: {
                        f11 = 2.0E-4f;
                        break;
                    }
                    case 3: {
                        f11 = 3.0E-4f;
                        break;
                    }
                    case 4: {
                        f11 = 4.0E-4f;
                        break;
                    }
                    case 5: {
                        f11 = 5.0E-4f;
                        break;
                    }
                    case 6: {
                        f11 = 6.0E-4f;
                        break;
                    }
                    case 7: {
                        f11 = 7.0E-4f;
                        break;
                    }
                    case 8: {
                        f11 = 8.0E-4f;
                        break;
                    }
                    case 9: {
                        f11 = 9.0E-4f;
                    }
                }
            }
            if (n8 > 5) {
                n10 = byArray[++n6] - 48;
                switch (n10) {
                    case 1: {
                        f12 = 1.0E-5f;
                        break;
                    }
                    case 2: {
                        f12 = 2.0E-5f;
                        break;
                    }
                    case 3: {
                        f12 = 3.0E-5f;
                        break;
                    }
                    case 4: {
                        f12 = 4.0E-5f;
                        break;
                    }
                    case 5: {
                        f12 = 5.0E-5f;
                        break;
                    }
                    case 6: {
                        f12 = 6.0E-5f;
                        break;
                    }
                    case 7: {
                        f12 = 7.0E-5f;
                        break;
                    }
                    case 8: {
                        f12 = 8.0E-5f;
                        break;
                    }
                    case 9: {
                        f12 = 9.0E-5f;
                    }
                }
            }
            if (n8 > 6) {
                n10 = byArray[++n6] - 48;
                switch (n10) {
                    case 1: {
                        f13 = 1.0E-6f;
                        break;
                    }
                    case 2: {
                        f13 = 2.0E-6f;
                        break;
                    }
                    case 3: {
                        f13 = 3.0E-6f;
                        break;
                    }
                    case 4: {
                        f13 = 4.0E-6f;
                        break;
                    }
                    case 5: {
                        f13 = 5.0E-6f;
                        break;
                    }
                    case 6: {
                        f13 = 6.0E-6f;
                        break;
                    }
                    case 7: {
                        f13 = 7.0E-6f;
                        break;
                    }
                    case 8: {
                        f13 = 8.0E-6f;
                        break;
                    }
                    case 9: {
                        f13 = 9.0E-6f;
                    }
                }
            }
            f2 = f8 + f9 + f10 + f11 + f12 + f13;
            f3 = f4 + f7 + f6 + f5;
            f = f3 + f2;
        }
        if (bl) {
            return -f;
        }
        return f;
    }

    private int readRef2(byte[] byArray, Map map, int n, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        while (byArray[++n] != 62 || byArray[n + 1] != 62) {
            if (byArray[n] == 47) {
                String string;
                ++n;
                while (!(byArray[n] == 32 | byArray[n] == 91 | byArray[n] == 10 | byArray[n] == 13 | byArray[n] == 60)) {
                    stringBuffer.append((char)byArray[n]);
                    ++n;
                }
                boolean bl = stringBuffer.length() != 2 || stringBuffer.charAt(0) != 'I' || stringBuffer.charAt(1) != 'D';
                if (byArray[n] != 91) {
                    while (byArray[n] == 32) {
                        ++n;
                    }
                }
                int n2 = 0;
                int n3 = 0;
                int n4 = n;
                int n5 = 0;
                while (true) {
                    char c = (char)byArray[n];
                    if (byArray[n - 1] == 60 && byArray[n] == 60) {
                        ++n5;
                    }
                    if (c == '(' && n > 0 && byArray[n - 1] != 92 | (n > 1 && byArray[n - 1] == 92 && byArray[n - 2] != 92)) {
                        ++n3;
                    } else if (c == ')' && n > 0 && byArray[n - 1] != 92 | (n > 1 && byArray[n - 1] == 92 && byArray[n - 2] != 92)) {
                        ++n3;
                    }
                    if (n != n4 && c == '/' & bl && n5 == 0) {
                        --n;
                    }
                    if (!bl && c == ']' && byArray[n + 1] == 47 || !bl && c == ']' && n3 == 0 || n5 == 0 && c == '\n' | c == '\r' | (c == '/' && bl) && n2 > 0) break;
                    if (byArray[n] == 62 && byArray[n + 1] == 62) {
                        if (n5 == 0) break;
                        --n5;
                    }
                    if (c == '\\') {
                        c = (char)byArray[++n];
                    }
                    if (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 || n2 != 0) {
                        stringBuffer2.append((char)byArray[n]);
                        ++n2;
                    }
                    ++n;
                }
                if (!(string = (stringBuffer2 = this.removeTrailingSpaces(stringBuffer2)).toString()).equals("null")) {
                    int n6 = string.indexOf(37);
                    if (n6 != -1 & string.indexOf("\\%") != n6 - 1) {
                        string = string.substring(0, n6).trim();
                    }
                    map.put(stringBuffer.toString(), string);
                }
                stringBuffer = new StringBuffer();
                stringBuffer2 = new StringBuffer();
            }
            if (byArray[n] != 62 || byArray[n + 1] != 62) continue;
            break;
        }
        return n;
    }

    private byte[] readTrailer(int n, int n2, byte[] byArray, int n3, int n4) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        do {
            if (n3 + n > n4) {
                n = n4 - n3;
            }
            byte[] byArray2 = new byte[n];
            this.movePointer(n3);
            this.pdf_datafile.read(byArray2);
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                byte by = byArray2[i];
                n2 = by == byArray[n2] ? ++n2 : 0;
                if (n2 != 5) continue;
                for (int j = 0; j < i + 1; ++j) {
                    byteArrayOutputStream.write(byArray2[j]);
                }
                i = n;
                bl = true;
            }
            if (!bl) {
                byteArrayOutputStream.write(byArray2);
            }
            n3 += n;
        } while (n2 != 5);
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public final PdfFileInformation readPdfFileMetadata(String string) {
        if (this.infoObject != null && !this.isEncrypted | this.isPasswordSupplied) {
            this.readInformationObject(this.infoObject);
        }
        if (string != null) {
            PdfMetadataObject pdfMetadataObject = new PdfMetadataObject(string);
            this.readObject(pdfMetadataObject, string, false, null);
            byte[] byArray = pdfMetadataObject.DecodedStream;
            this.currentFileInformation.setFileXMLMetaData(byArray);
        }
        return this.currentFileInformation;
    }

    public final String getValue(String string) {
        if (string != null && string.endsWith(" R")) {
            Map map = this.readObject(new PdfObject(string), string, false, null);
            string = (String)map.get("rawValue");
        }
        if (string != null && string.equals("null")) {
            string = null;
        }
        return string;
    }

    private Object getObjectValue(Object object) {
        Object v;
        Map map = this.readObject(new PdfObject((String)object), (String)object, false, this.fields);
        int n = map.size();
        object = n == 1 ? ((v = map.get("rawValue")) != null ? (v instanceof String ? v : this.getTextString((byte[])v)) : map) : map;
        return object;
    }

    public final byte[] getByteTextStringValue(Object object, Map map) {
        if (object instanceof String) {
            String string = (String)object;
            if (string != null && string.endsWith(" R")) {
                Map map2 = this.readObject(new PdfObject(string), string, false, map);
                object = map2.get("rawValue");
            } else {
                return string.getBytes();
            }
        }
        return (byte[])object;
    }

    private StringBuffer removeTrailingSpaces(StringBuffer stringBuffer) {
        int n = stringBuffer.length();
        for (int i = n - 1; i > -1; --i) {
            if (stringBuffer.charAt(i) == ' ') {
                stringBuffer.deleteCharAt(i);
                continue;
            }
            i = -2;
        }
        return stringBuffer;
    }

    public final boolean isEncrypted() {
        return this.isEncrypted;
    }

    public final boolean isPasswordSupplied() {
        return this.isPasswordSupplied;
    }

    public final boolean isExtractionAllowed() {
        return this.extractionIsAllowed;
    }

    public boolean isFileViewable() {
        return this.isFileViewable;
    }

    private final byte[] decrypt(byte[] byArray, String string, boolean bl, String string2, boolean bl2, boolean bl3) throws PdfSecurityException {
        boolean bl4 = false;
        if (this.isEncrypted || bl) {
            int n;
            int n2;
            Object object;
            Object object2;
            BufferedOutputStream bufferedOutputStream = null;
            BufferedInputStream bufferedInputStream = null;
            int n3 = 0;
            boolean bl5 = false;
            if (string2 != null) {
                try {
                    n3 = (int)new File(string2).length();
                    File file = File.createTempFile("jpedal", ".raw");
                    this.cachedObjects.put(file.getAbsolutePath(), "x");
                    ObjectStore.copy(string2, file.getAbsolutePath());
                    object2 = new File(string2);
                    ((File)object2).delete();
                    bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
                    bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                }
                catch (IOException iOException) {
                    LogWriter.writeLog("Exception " + iOException + " in decrypt");
                }
            }
            int n4 = this.keyLength;
            object2 = "RC4";
            String string3 = "RC4";
            IvParameterSpec ivParameterSpec = null;
            Map map = null;
            String string4 = null;
            if (!bl3) {
                map = this.StmF;
                string4 = this.StrFname;
            } else {
                map = this.StrF;
                string4 = this.StmFname;
            }
            if (!bl2 && map == null && string4 != null && string4.equals("Identity")) {
                return byArray;
            }
            if (map != null) {
                String string5;
                object = (String)map.get("Length");
                if (object != null) {
                    n4 = Integer.parseInt((String)object);
                }
                if ((string5 = (String)map.get("CFM")) != null && string5.equals("/AESV2") && !bl2) {
                    this.cipher = null;
                    object2 = "AES/CBC/PKCS5Padding";
                    string3 = "AES";
                    bl5 = true;
                    byte[] byArray2 = new byte[16];
                    System.arraycopy(byArray, 0, byArray2, 0, 16);
                    ivParameterSpec = new IvParameterSpec(byArray2);
                    n2 = byArray.length;
                    n = n2 - 16;
                    byte[] byArray3 = new byte[n];
                    System.arraycopy(byArray, 16, byArray3, 0, n);
                    byArray = byArray3;
                    int n5 = byArray.length & 0xF;
                    int n6 = byArray.length;
                    if (n5 > 0) {
                        n6 = n6 + 16 - n5;
                        byArray3 = new byte[n6];
                        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                        byArray = byArray3;
                    }
                }
            }
            object = new byte[n4];
            if (string.length() > 0) {
                object = new byte[n4 + 5];
            }
            System.arraycopy(this.encryptionKey, 0, object, 0, n4);
            try {
                if (string.length() > 0) {
                    int n7 = string.indexOf(32);
                    int n8 = string.indexOf(32, n7 + 1);
                    n2 = Integer.parseInt(string.substring(0, n7));
                    n = Integer.parseInt(string.substring(n7 + 1, n8));
                    object[n4] = (byte)(n2 & 0xFF);
                    object[n4 + 1] = (byte)(n2 >> 8 & 0xFF);
                    object[n4 + 2] = (byte)(n2 >> 16 & 0xFF);
                    object[n4 + 3] = (byte)(n & 0xFF);
                    object[n4 + 4] = (byte)(n >> 8 & 0xFF);
                }
                byte[] byArray4 = new byte[Math.min(((byte[])object).length, 16)];
                if (string.length() > 0) {
                    MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                    messageDigest.update((byte[])object);
                    if (bl5 && n4 >= 16) {
                        byte[] byArray5 = new byte[]{115, 65, 108, 84};
                        messageDigest.update(byArray5);
                    }
                    System.arraycopy(messageDigest.digest(), 0, byArray4, 0, byArray4.length);
                } else {
                    System.arraycopy(object, 0, byArray4, 0, byArray4.length);
                }
                if (this.cipher == null) {
                    this.cipher = Cipher.getInstance((String)object2);
                }
                SecretKeySpec secretKeySpec = new SecretKeySpec(byArray4, string3);
                if (bl) {
                    this.cipher.init(1, secretKeySpec);
                } else if (ivParameterSpec == null) {
                    this.cipher.init(2, secretKeySpec);
                } else {
                    this.cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
                }
                if (byArray == null) {
                    CipherInputStream cipherInputStream = new CipherInputStream(bufferedInputStream, this.cipher);
                    while ((n = cipherInputStream.read()) != -1) {
                        bufferedOutputStream.write(n);
                    }
                    cipherInputStream.close();
                    bufferedOutputStream.close();
                    bufferedInputStream.close();
                }
                if (byArray != null) {
                    byArray = this.cipher.doFinal(byArray);
                }
            }
            catch (Exception exception) {
                throw new PdfSecurityException("Exception " + exception + " decrypting content");
            }
        }
        if (alwaysReinitCipher) {
            this.cipher = null;
        }
        return byArray;
    }

    private byte[] getPaddedKey(byte[] byArray) {
        byte[] byArray2 = new byte[32];
        int n = byArray.length;
        if (n > 32) {
            n = 32;
        }
        System.arraycopy(this.encryptionPassword, 0, byArray2, 0, n);
        for (int i = n; i < 32; ++i) {
            byArray2[i] = (byte)Integer.parseInt(this.padding[i - n], 16);
        }
        return byArray2;
    }

    private boolean testPassword() throws PdfSecurityException {
        int n;
        int n2 = 32;
        byte[] byArray = new byte[32];
        byte[] byArray2 = new byte[32];
        for (int i = 0; i < 32; ++i) {
            byArray[i] = (byte)Integer.parseInt(this.padding[i], 16);
        }
        byte[] byArray3 = (byte[])byArray.clone();
        if (this.rev == 2) {
            this.encryptionKey = this.calculateKey(this.O, this.P, this.ID);
            byArray3 = this.decrypt(byArray3, "", true, null, false, false);
        } else if (this.rev >= 3) {
            Object object;
            n = this.keyLength;
            if (this.rev == 4 && this.StmF != null && (object = (String)this.StmF.get("Length")) != null) {
                n = Integer.parseInt((String)object);
            }
            n2 = 16;
            this.encryptionKey = this.calculateKey(this.O, this.P, this.ID);
            object = (byte[])this.encryptionKey.clone();
            MessageDigest messageDigest = null;
            try {
                messageDigest = MessageDigest.getInstance("MD5");
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " with digest");
            }
            messageDigest.update(byArray3);
            byte[] byArray4 = new byte[this.ID.length() / 2];
            for (int i = 0; i < this.ID.length(); i += 2) {
                String string = this.ID.substring(i, i + 2);
                byArray4[i / 2] = (byte)Integer.parseInt(string, 16);
            }
            byArray2 = messageDigest.digest(byArray4);
            byArray2 = this.decrypt(byArray2, "", true, null, true, false);
            byte[] byArray5 = new byte[n];
            for (int i = 1; i <= 19; ++i) {
                for (int j = 0; j < n; ++j) {
                    byArray5[j] = (byte)(object[j] ^ i);
                }
                this.encryptionKey = byArray5;
                byArray2 = this.decrypt(byArray2, "", true, null, true, false);
            }
            this.encryptionKey = (byte[])object;
            byArray3 = new byte[32];
            System.arraycopy(byArray2, 0, byArray3, 0, 16);
            System.arraycopy(byArray, 0, byArray3, 16, 16);
        }
        n = 1;
        for (int i = 0; i < n2; ++i) {
            if (this.U[i] == byArray3[i]) continue;
            n = 0;
            i = this.U.length;
        }
        return n != 0;
    }

    private void computeEncryptionKey() throws PdfSecurityException {
        int n;
        MessageDigest messageDigest = null;
        String string = "";
        if (this.debugAES) {
            System.out.println("Compute encryption key");
        }
        byte[] byArray = this.getPaddedKey(this.encryptionPassword);
        if (this.debugAES) {
            string = "raw before 50 times   ---- ";
            for (n = 0; n < byArray.length; ++n) {
                string = string + byArray[n] + ' ';
            }
            System.out.println(string);
        }
        try {
            messageDigest = MessageDigest.getInstance("MD5");
            this.encryptionKey = messageDigest.digest(byArray);
            if (this.debugAES) {
                string = "encryptionKey before 50 times   ---- ";
                for (n = 0; n < byArray.length; ++n) {
                    string = string + byArray[n] + ' ';
                }
                System.out.println(string);
            }
            if (this.rev >= 3) {
                for (n = 0; n < 50; ++n) {
                    this.encryptionKey = messageDigest.digest(this.encryptionKey);
                }
            }
        }
        catch (Exception exception) {
            throw new PdfSecurityException("Exception " + exception + " generating encryption key");
        }
        if (this.debugAES) {
            string = "returned encryptionKey   ---- ";
            for (n = 0; n < this.encryptionKey.length; ++n) {
                string = string + this.encryptionKey[n] + ' ';
            }
            System.out.println(string);
        }
    }

    private boolean testOwnerPassword() throws PdfSecurityException {
        int n;
        String string = "";
        if (this.debugAES) {
            System.out.println("testOwnerPassword " + this.encryptionPassword.length);
        }
        byte[] byArray = this.encryptionPassword;
        byte[] byArray2 = new byte[this.keyLength];
        byte[] byArray3 = (byte[])this.O.clone();
        if (this.debugAES) {
            string = "originalPassword   ---- ";
            for (int i = 0; i < byArray.length; ++i) {
                string = string + byArray[i] + ' ';
            }
            System.out.println(string);
        }
        this.computeEncryptionKey();
        byte[] byArray4 = (byte[])this.encryptionKey.clone();
        if (this.rev == 2) {
            byArray2 = this.decrypt((byte[])this.O.clone(), "", false, null, false, false);
        } else if (this.rev >= 3) {
            Object object;
            n = this.keyLength;
            if (this.rev == 4 && this.StmF != null && (object = (Object)((String)this.StmF.get("Length"))) != null) {
                n = Integer.parseInt((String)object);
            }
            if (this.debugAES) {
                System.out.println("Decrypt 20 times");
            }
            byArray2 = byArray3;
            object = new byte[n];
            for (int i = 19; i >= 0; --i) {
                for (int j = 0; j < n; ++j) {
                    object[j] = (byte)(byArray4[j] ^ i);
                }
                this.encryptionKey = object;
                byArray2 = this.decrypt(byArray2, "", false, null, true, false);
            }
        }
        this.encryptionPassword = byArray2;
        this.computeEncryptionKey();
        n = this.testPassword() ? 1 : 0;
        if (this.debugAES && n == 0) {
            System.out.println("Match failed on owner key");
            System.exit(1);
        }
        if (n == 0) {
            this.encryptionPassword = byArray;
            this.computeEncryptionKey();
        }
        return n != 0;
    }

    private final String findOffsets() throws PdfSecurityException {
        String string;
        block7: {
            LogWriter.writeLog("Corrupt xref table - trying to find objects manually");
            string = "";
            try {
                this.movePointer(0L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            while (true) {
                int n;
                String string2 = null;
                int n2 = (int)this.getPointer();
                try {
                    string2 = this.pdf_datafile.readLine();
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Exception " + exception + " reading line");
                }
                if (string2 == null) break block7;
                if (string2.indexOf(" obj") != -1) {
                    int n3 = string2.indexOf(32);
                    if (n3 <= -1) continue;
                    n = Integer.parseInt(string2.substring(0, n3));
                    this.storeObjectOffset(n, n2, 1, false);
                    continue;
                }
                if (string2.indexOf("Root") != -1) {
                    int n4 = string2.indexOf("Root") + 4;
                    n = string2.indexOf(82, n4);
                    if (n <= -1) continue;
                    string = string2.substring(n4, n + 1).trim();
                    continue;
                }
                if (string2.indexOf("/Encrypt") != -1) break;
            }
            throw new PdfSecurityException("Corrupted, encrypted file");
        }
        return string;
    }

    public final void readEncryptionObject(String string) throws PdfSecurityException {
        int n;
        int n2;
        String string2;
        this.stringsEncoded = false;
        this.isMetaDataEncypted = true;
        if (!this.isInitialised) {
            this.isInitialised = true;
            SetSecurity.init();
        }
        Map map = this.readObject(new PdfObject(string), string, true, null);
        if (this.debugAES) {
            System.out.println(map);
        }
        String string3 = (String)map.get("Filter");
        int n3 = 1;
        String string4 = (String)map.get("V");
        if (string4 != null) {
            n3 = Integer.parseInt(string4);
        }
        if ((string4 = (String)map.get("Length")) != null) {
            this.keyLength = Integer.parseInt(string4) / 8;
        }
        if (n3 == 3) {
            throw new PdfSecurityException("Unsupported Custom Adobe Encryption method " + map);
        }
        if (n3 > 4 && string3.indexOf("Standard") == -1) {
            throw new PdfSecurityException("Unsupported Encryption method " + map);
        }
        this.rev = Integer.parseInt((String)map.get("R"));
        this.P = Integer.parseInt((String)map.get("P"));
        Object v = map.get("O");
        if (v instanceof String) {
            string2 = (String)v;
            int n4 = string2.length() / 2;
            this.O = new byte[n4];
            for (n2 = 0; n2 < n4; ++n2) {
                n = n2 * 2;
                this.O[n2] = (byte)Integer.parseInt(string2.substring(n, n + 2), 16);
            }
        } else {
            this.O = (byte[])v;
        }
        if ((string2 = map.get("U")) instanceof String) {
            String string5 = string2;
            n2 = string5.length() / 2;
            this.U = new byte[n2];
            for (n = 0; n < n2; ++n) {
                int n5 = n * 2;
                this.U[n] = (byte)Integer.parseInt(string5.substring(n5, n5 + 2), 16);
            }
        } else {
            this.U = (byte[])string2;
        }
        if (n3 == 4) {
            String string6;
            Map map2 = (Map)map.get("CF");
            this.EFF = (String)map.get("EFF");
            this.CFM = (String)map.get("CFM");
            Object v2 = map.get("EncryptMetadata");
            if (v2 != null && ((String)v2).toLowerCase().equals("false")) {
                this.isMetaDataEncypted = false;
            }
            if ((string6 = (String)map.get("StrF")) != null) {
                this.StrFname = string6 = string6.substring(1);
                this.StrF = (Map)map2.get(string6);
                this.stringsEncoded = true;
            } else {
                this.StrF = null;
            }
            string6 = (String)map.get("StmF");
            if (string6 != null) {
                this.StmFname = string6 = string6.substring(1);
                this.StmF = (Map)map2.get(string6);
            } else {
                this.StmF = null;
            }
        }
        this.isEncrypted = true;
        this.isFileViewable = false;
        LogWriter.writeLog("File has encryption settings");
        try {
            this.verifyAccess();
        }
        catch (PdfSecurityException pdfSecurityException) {
            LogWriter.writeLog("File requires password");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void verifyAccess() throws PdfSecurityException {
        this.isPasswordSupplied = false;
        this.extractionIsAllowed = false;
        this.passwordStatus = 0;
        boolean bl = this.testOwnerPassword();
        if (!bl) {
            boolean bl2 = this.testPassword();
            if (!bl2) throw new PdfSecurityException("No valid password supplied");
            if (this.encryptionPassword.length > 0) {
                LogWriter.writeLog("Correct user password supplied ");
            }
            this.isFileViewable = true;
            this.isPasswordSupplied = true;
            if ((this.P & 0x10) == 16) {
                this.extractionIsAllowed = true;
            }
            this.passwordStatus = 1;
            return;
        } else {
            LogWriter.writeLog("Correct owner password supplied");
            this.isFileViewable = true;
            this.isPasswordSupplied = true;
            this.extractionIsAllowed = true;
            this.passwordStatus = 2;
        }
    }

    private byte[] calculateKey(byte[] byArray, int n, String string) throws PdfSecurityException {
        byte[] byArray2;
        if (this.debugAES) {
            System.out.println("calculate key");
        }
        String string2 = "";
        MessageDigest messageDigest = null;
        byte[] byArray3 = null;
        byte[] byArray4 = this.getPaddedKey(this.encryptionPassword);
        try {
            Object object;
            messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(byArray4);
            messageDigest.update(byArray);
            byArray2 = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 24 & 0xFF)};
            messageDigest.update(byArray2);
            string2 = "documentID   ---- ";
            byte[] byArray5 = new byte[string.length() / 2];
            for (int i = 0; i < string.length(); i += 2) {
                object = string.substring(i, i + 2);
                byArray5[i / 2] = (byte)Integer.parseInt((String)object, 16);
                string2 = string2 + byArray5[i / 2] + ' ';
            }
            messageDigest.update(byArray5);
            if (this.debugAES) {
                System.out.println(string2 + " \n" + string);
            }
            byte[] byArray6 = new byte[]{-1, -1, -1, -1};
            if (this.rev == 4 && !this.isMetaDataEncypted) {
                messageDigest.update(byArray6);
            }
            object = new byte[this.keyLength];
            System.arraycopy(messageDigest.digest(), 0, object, 0, this.keyLength);
            if (this.rev >= 3) {
                for (int i = 0; i < 50; ++i) {
                    System.arraycopy(messageDigest.digest((byte[])object), 0, object, 0, this.keyLength);
                }
            }
            byArray3 = new byte[this.keyLength];
            System.arraycopy(object, 0, byArray3, 0, this.keyLength);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new PdfSecurityException("Exception " + exception + " generating encryption key");
        }
        byArray2 = new byte[this.keyLength];
        System.arraycopy(byArray3, 0, byArray2, 0, this.keyLength);
        return byArray2;
    }

    private final void readInformationObject(String string) {
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String[] stringArray = this.currentFileInformation.getFieldNames();
            for (int i = 0; i < stringArray.length; ++i) {
                hashMap.put(stringArray[i], "z");
            }
            Map map = this.readObject(new PdfObject(string), string, false, hashMap);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2;
                Object v = map.get(stringArray[i]);
                if (v == null) continue;
                if (v instanceof byte[]) {
                    string2 = this.getTextString((byte[])v);
                    this.currentFileInformation.setFieldValue(i, string2);
                    continue;
                }
                if (!(v instanceof String)) continue;
                string2 = (String)v;
                if (string2.indexOf("False") != -1) {
                    this.currentFileInformation.setFieldValue(i, "False");
                    continue;
                }
                if (string2.indexOf("False") == -1) continue;
                this.currentFileInformation.setFieldValue(i, "True");
            }
        }
        catch (Exception exception) {
            System.out.println(" problem with info");
            LogWriter.writeLog("Exception " + exception + " reading information object " + string);
        }
    }

    public byte[] getPdfBuffer() {
        return this.pdf_datafile.getPdfBuffer();
    }

    public String getTextString(byte[] byArray) {
        String string = "";
        StandardFonts.checkLoaded(6);
        String string2 = "";
        char[] cArray = null;
        if (byArray != null) {
            cArray = new char[byArray.length];
        }
        int n = 0;
        Object var7_6 = null;
        TextTokens textTokens = new TextTokens(byArray);
        if (textTokens.isUnicode()) {
            while (textTokens.hasMoreTokens()) {
                char c = textTokens.nextUnicodeToken();
                if (c == '\t') {
                    cArray[n] = 32;
                    ++n;
                    continue;
                }
                if (c <= '\u001f') continue;
                cArray[n] = c;
                ++n;
            }
        } else {
            while (textTokens.hasMoreTokens()) {
                char c = textTokens.nextToken();
                if (c == '\t') {
                    cArray[n] = 32;
                    ++n;
                    continue;
                }
                if (c <= '\u001f') continue;
                String string3 = StandardFonts.getEncodedChar(6, c);
                int n2 = string3.length();
                if (n + n2 >= cArray.length) {
                    char[] cArray2 = new char[n2 + n + 10];
                    System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
                    cArray = cArray2;
                }
                for (int i = 0; i < n2; ++i) {
                    cArray[n] = string3.charAt(i);
                    ++n;
                }
            }
        }
        if (cArray != null) {
            string = String.copyValueOf(cArray, 0, n);
        }
        return string;
    }

    public void readJavascriptNames(Object object, Javascript javascript) {
        Map map = null;
        map = object instanceof String ? this.readObject(new PdfObject((String)object), (String)object, false, null) : (Map)object;
        String string = this.getValue((String)map.get("Names"));
        if (string != null) {
            String string2 = Strip.removeArrayDeleminators(string);
            if (string2.startsWith("<feff")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    string3 = string3.substring(1, string3.length() - 1);
                    String string4 = stringTokenizer.nextToken() + ' ' + stringTokenizer.nextToken() + ' ' + stringTokenizer.nextToken();
                    javascript.setCode(string3, string4);
                }
            } else if (string2.indexOf(40) != -1) {
                int n;
                int n2;
                String string5 = (String)object;
                byte[] byArray = null;
                if (string5.endsWith("]")) {
                    string5 = Strip.removeArrayDeleminators(string5);
                }
                if (string5.endsWith(" R")) {
                    n2 = string5.indexOf(32);
                    n = Integer.parseInt(string5.substring(0, n2));
                    int n3 = Integer.parseInt(string5.substring(n2 + 1, string5.indexOf(32, n2 + 1)));
                    byArray = this.readObjectAsByteArray(string5, false, this.isCompressed(n, n3), n, n3);
                } else {
                    byArray = string5.getBytes();
                }
                n2 = byArray.length;
                n = 0;
                while (byArray[n] != 47 || byArray[n + 1] != 78 || byArray[n + 2] != 97 || byArray[n + 3] != 109 || byArray[n + 4] != 101 || byArray[n + 5] != 115) {
                    ++n;
                }
                n += 5;
                while (n < n2) {
                    while (byArray[n] != 40) {
                        ++n;
                    }
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    try {
                        int n4;
                        StringBuffer stringBuffer;
                        if (byArray[n + 1] != 41) {
                            while (true) {
                                boolean bl = false;
                                if (byArray[++n] == 92 && (byArray[n - 1] != 92 || byArray[n - 1] == 92 && byArray[n - 2] == 92)) {
                                    if (byArray[++n] == 98) {
                                        byArray[n] = 8;
                                    } else if (byArray[n] == 110) {
                                        byArray[n] = 10;
                                    } else if (byArray[n] == 116) {
                                        byArray[n] = 9;
                                    } else if (byArray[n] == 114) {
                                        byArray[n] = 13;
                                    } else if (byArray[n] == 102) {
                                        byArray[n] = 12;
                                    } else if (byArray[n] == 92) {
                                        byArray[n] = 92;
                                    } else if (Character.isDigit((char)byArray[n])) {
                                        stringBuffer = new StringBuffer(3);
                                        for (n4 = 0; n4 < 3; ++n4) {
                                            stringBuffer.append((char)byArray[n]);
                                            ++n;
                                        }
                                        bl = true;
                                        byArray[--n] = (byte)Integer.parseInt(stringBuffer.toString(), 8);
                                    }
                                }
                                if (!bl && byArray[n] == 41 && (byArray[n - 1] != 92 || byArray[n - 1] == 92 && byArray[n - 2] == 92)) break;
                                byteArrayOutputStream.write(byArray[n]);
                            }
                        }
                        byteArrayOutputStream.close();
                        byte[] byArray2 = byteArrayOutputStream.toByteArray();
                        byArray2 = this.decrypt(byArray2, (String)object, false, null, false, false);
                        stringBuffer = new StringBuffer();
                        ++n;
                        while (byArray[n] == 32 | byArray[n] == 10 | byArray[n] == 13) {
                            ++n;
                        }
                        n4 = n;
                        while (byArray[n4] == 32) {
                            ++n4;
                        }
                        boolean bl = false;
                        while (byArray[n4] != 40 & n4 + 1 < n2) {
                            if (byArray[n4] == 91) {
                                bl = true;
                            }
                            if (byArray[n4] == 93) break;
                            ++n4;
                        }
                        if (bl) {
                            n4 += 2;
                        }
                        int n5 = n4;
                        if (!bl && byArray[n4] == 93) {
                            n5 = n2;
                        }
                        while (byArray[n4] == 32) {
                            --n4;
                        }
                        int n6 = n4 - n;
                        stringBuffer = new StringBuffer(n6);
                        for (int i = 0; i < n6; ++i) {
                            stringBuffer.append((char)byArray[i + n]);
                            if ((!bl && byArray[i + n] == 82) | byArray[i + n] == 93) break;
                        }
                        Map map2 = this.readObject(new PdfObject(stringBuffer.toString()), stringBuffer.toString(), false, null);
                        String string6 = (String)map2.get("S");
                        this.setJavascriptCommand(map2.get("JS"), byArray2);
                        n = n5;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            } else {
                LogWriter.writeLog("Javascript format not supported");
            }
        }
    }

    private void setJavascriptCommand(Object object, byte[] byArray) {
        if (object instanceof String) {
            this.readObject(new PdfObject((String)object), (String)object, false, null);
            byte[] byArray2 = this.readStream((String)object, true);
            String string = new String(byArray2);
            this.javascript.setCode(this.getTextString(byArray), string);
        }
    }

    public void setJavascriptForObject(String string, Object object, int n) {
        if (object instanceof Map) {
            Object object2;
            Object v = ((Map)object).get("JS");
            if (v instanceof String) {
                object2 = this.readObject(new PdfObject((String)v), (String)v, false, this.fields);
                v = object2.get("Stream");
            }
            if (v instanceof byte[]) {
                object2 = this.getTextString((byte[])v);
                this.javascript.storeJavascript(string, object2, n);
            } else if (v == null && ((String)(object2 = (Map)object).get("S")).indexOf("Hide") != -1) {
                object2.put("T", this.resolveToMapOrString("T", object2.get("T")));
                this.javascript.storeJavascript(string, object2, n);
            }
        }
    }

    public void readNames(Object object, Javascript javascript) {
        block42: {
            String string;
            Map map;
            block44: {
                String string2;
                block43: {
                    String string3;
                    Object v;
                    block41: {
                        map = null;
                        map = object instanceof String ? this.readObject(new PdfObject((String)object), (String)object, false, null) : (Map)object;
                        v = map.get("Dests");
                        String string4 = this.getValue((String)map.get("Names"));
                        string2 = (String)map.get("JavaScript");
                        if (string4 == null) break block41;
                        String string5 = Strip.removeArrayDeleminators(string4);
                        if (string5.startsWith("<feff")) {
                            StringTokenizer stringTokenizer = new StringTokenizer(string5);
                            while (stringTokenizer.hasMoreTokens()) {
                                String string6 = stringTokenizer.nextToken();
                                string6 = string6.substring(1, string6.length() - 1);
                                String string7 = stringTokenizer.nextToken() + ' ' + stringTokenizer.nextToken() + ' ' + stringTokenizer.nextToken();
                                this.nameLookup.put(string6, string7);
                            }
                        } else if (string5.indexOf(40) != -1) {
                            int n;
                            int n2;
                            String string8 = (String)object;
                            byte[] byArray = null;
                            if (string8.endsWith("]")) {
                                string8 = Strip.removeArrayDeleminators(string8);
                            }
                            if (string8.endsWith(" R")) {
                                n2 = string8.indexOf(32);
                                n = Integer.parseInt(string8.substring(0, n2));
                                int n3 = Integer.parseInt(string8.substring(n2 + 1, string8.indexOf(32, n2 + 1)));
                                byArray = this.readObjectAsByteArray(string8, false, this.isCompressed(n, n3), n, n3);
                            } else {
                                byArray = string8.getBytes();
                            }
                            n2 = byArray.length;
                            n = 0;
                            while (byArray[n] != 47 || byArray[n + 1] != 78 || byArray[n + 2] != 97 || byArray[n + 3] != 109 || byArray[n + 4] != 101 || byArray[n + 5] != 115) {
                                ++n;
                            }
                            n += 5;
                            while (n < n2) {
                                while (byArray[n] != 40) {
                                    ++n;
                                }
                                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                                try {
                                    int n4;
                                    StringBuffer stringBuffer;
                                    if (byArray[n + 1] != 41) {
                                        while (true) {
                                            boolean bl = false;
                                            if (byArray[++n] == 92 && (byArray[n - 1] != 92 || byArray[n - 1] == 92 && byArray[n - 2] == 92)) {
                                                if (byArray[++n] == 98) {
                                                    byArray[n] = 8;
                                                } else if (byArray[n] == 110) {
                                                    byArray[n] = 10;
                                                } else if (byArray[n] == 116) {
                                                    byArray[n] = 9;
                                                } else if (byArray[n] == 114) {
                                                    byArray[n] = 13;
                                                } else if (byArray[n] == 102) {
                                                    byArray[n] = 12;
                                                } else if (byArray[n] == 92) {
                                                    byArray[n] = 92;
                                                } else if (Character.isDigit((char)byArray[n])) {
                                                    stringBuffer = new StringBuffer(3);
                                                    for (n4 = 0; n4 < 3; ++n4) {
                                                        stringBuffer.append((char)byArray[n]);
                                                        ++n;
                                                    }
                                                    bl = true;
                                                    byArray[--n] = (byte)Integer.parseInt(stringBuffer.toString(), 8);
                                                }
                                            }
                                            if (!bl && byArray[n] == 41 && (byArray[n - 1] != 92 || byArray[n - 1] == 92 && byArray[n - 2] == 92)) break;
                                            byteArrayOutputStream.write(byArray[n]);
                                        }
                                    }
                                    byteArrayOutputStream.close();
                                    byte[] byArray2 = byteArrayOutputStream.toByteArray();
                                    byArray2 = this.decrypt(byArray2, (String)object, false, null, false, false);
                                    stringBuffer = new StringBuffer();
                                    ++n;
                                    while (byArray[n] == 32 | byArray[n] == 10 | byArray[n] == 13) {
                                        ++n;
                                    }
                                    n4 = n;
                                    while (byArray[n4] == 32) {
                                        ++n4;
                                    }
                                    boolean bl = false;
                                    while (byArray[n4] != 40 & n4 + 1 < n2) {
                                        if (byArray[n4] == 91) {
                                            bl = true;
                                        }
                                        if (byArray[n4] == 93) break;
                                        ++n4;
                                    }
                                    if (bl) {
                                        n4 += 2;
                                    }
                                    int n5 = n4;
                                    if (!bl && byArray[n4] == 93) {
                                        n5 = n2;
                                    }
                                    while (byArray[n4] == 32) {
                                        --n4;
                                    }
                                    int n6 = n4 - n;
                                    stringBuffer = new StringBuffer(n6);
                                    for (int i = 0; i < n6; ++i) {
                                        stringBuffer.append((char)byArray[i + n]);
                                        if ((!bl && byArray[i + n] == 82) | byArray[i + n] == 93) break;
                                    }
                                    this.nameLookup.put(this.getTextString(byArray2), stringBuffer.toString());
                                    n = n5;
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                        } else {
                            LogWriter.writeLog("Name list format not supported");
                        }
                        break block42;
                    }
                    if (v == null) break block43;
                    Map map2 = null;
                    map2 = v instanceof String ? this.readObject(new PdfObject((String)v), (String)v, false, null) : (Map)v;
                    String string9 = (String)map2.get("Kids");
                    if (string9 == null || (string3 = Strip.removeArrayDeleminators(this.getValue((String)map2.get("Kids")))).length() <= 0) break block42;
                    StringTokenizer stringTokenizer = new StringTokenizer(string3, "R");
                    while (stringTokenizer.hasMoreTokens()) {
                        this.readNames(stringTokenizer.nextToken().trim() + " R", javascript);
                    }
                    break block42;
                }
                if (string2 == null) break block44;
                if (javascript == null) break block42;
                javascript.readJavascript();
                break block42;
            }
            String string10 = (String)map.get("Kids");
            if (string10 != null && (string = Strip.removeArrayDeleminators(this.getValue((String)map.get("Kids")))).length() > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "R");
                while (stringTokenizer.hasMoreTokens()) {
                    this.readNames(stringTokenizer.nextToken().trim() + " R", javascript);
                }
            }
        }
    }

    public String convertNameToRef(String string) {
        return (String)this.nameLookup.get(string);
    }

    public void flattenValuesInObject(boolean bl, boolean bl2, Map map, Map map2, Map map3, PageLookup pageLookup, String object) {
        if (bl) {
            map2.put("PageNumber", "1");
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            HashMap hashMap;
            Object object2;
            String string = (String)iterator.next();
            Object object3 = null;
            if (string.equals("P")) {
                try {
                    object2 = map.get("P");
                    if (object2 != null && pageLookup != null && object2 instanceof String) {
                        int n = pageLookup.convertObjectToPageNumber((String)object2);
                        map2.put("PageNumber", String.valueOf(n));
                    }
                }
                catch (Exception exception) {}
            } else if (string.equals("Stream")) {
                object2 = this.readStream(map, (String)object, false, true, false, false, false);
                map2.put("DecodedStream", object2);
            } else if (!string.equals("Kids") && !string.equals("Parent")) {
                object3 = map.get(string);
            } else if (bl2 && string.equals("Kids") && (object2 = (String)map.get("Kids")) != null) {
                HashMap hashMap2 = new HashMap();
                if (((String)object2).startsWith("[")) {
                    object2 = ((String)object2).substring(1, ((String)object2).length() - 1).trim();
                }
                StringTokenizer stringTokenizer = new StringTokenizer((String)object2, "R");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken().trim() + " R";
                    hashMap = new HashMap();
                    this.flattenValuesInObject(true, bl2, this.readObject(new PdfObject(string2), string2, false, map3), hashMap, map3, pageLookup, (String)object);
                    hashMap2.put(string2, hashMap);
                }
                map2.put("Kids", hashMap2);
            }
            if (object3 == null) continue;
            if (string.equals("rawValue")) {
                if (object3 instanceof byte[] && (object2 = (Object)this.getByteTextStringValue(object3, map3)) != null) {
                    object3 = this.getTextString((byte[])object2);
                }
            } else if (map3 != null && map3.get(string) != null && object3 instanceof byte[] && (object2 = (Object)this.getByteTextStringValue(object3, map3)) != null) {
                object3 = this.getTextString((byte[])object2);
            }
            if (object3 instanceof String) {
                object2 = object3.toString();
                StringTokenizer stringTokenizer = new StringTokenizer((String)object2);
                if (stringTokenizer.countTokens() == 3) {
                    int n = ((String)object2).indexOf(" R");
                    int n2 = ((String)object2).indexOf(" R", n + 1);
                    if (n2 == -1 && ((String)object2).endsWith("]") && ((String)object2).indexOf(" R") != -1) {
                        object = object2 = Strip.removeArrayDeleminators((String)object2);
                        hashMap = new HashMap();
                        this.flattenValuesInObject(bl, bl2, this.readObject(new PdfObject((String)object2), (String)object2, false, map3), hashMap, map3, pageLookup, (String)object);
                        map2.put(string, hashMap);
                        continue;
                    }
                    if (n2 == -1 && ((String)object2).endsWith(" R")) {
                        hashMap = new HashMap();
                        object = object2;
                        this.flattenValuesInObject(bl, bl2, this.readObject(new PdfObject((String)object2), (String)object2, false, map3), hashMap, map3, pageLookup, (String)object);
                        map2.put(string, hashMap);
                        continue;
                    }
                    map2.put(string, object3);
                    continue;
                }
                map2.put(string, object3);
                continue;
            }
            if (object3 instanceof Map) {
                object2 = (Map)object3;
                HashMap hashMap3 = new HashMap();
                this.flattenValuesInObject(bl, bl2, (Map)object2, hashMap3, map3, pageLookup, (String)object);
                map2.put(string, hashMap3);
                continue;
            }
            map2.put(string, object3);
        }
    }

    public void setCacheSize(int n) {
        this.miniumumCacheSize = n;
    }

    public byte[] readStreamFromPDF(int n, int n2) {
        byte[] byArray = new byte[n2 - n + 1];
        try {
            this.movePointer(n);
            this.pdf_datafile.read(byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byArray;
    }

    public void setInterruptRefReading(boolean bl) {
        this.interruptRefReading = bl;
    }

    public void readStreamIntoMemory(Map map) {
        String string = (String)map.get("CachedStream");
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            int n = (int)new File(string).length();
            byte[] byArray = new byte[n];
            bufferedInputStream.read(byArray);
            bufferedInputStream.close();
            map.put("DecodedStream", byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        String string = System.getProperty("org.jpedal.cipher.reinit");
        if (string != null && string.toLowerCase().equals("true")) {
            alwaysReinitCipher = true;
        }
        powers = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    }
}

