/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.sql.SQLException;
import org.h2.message.Message;
import org.h2.util.HashBase;

public class IntIntHashMap
extends HashBase {
    public static final int NOT_FOUND = -1;
    private static final int DELETED = 1;
    private int[] keys;
    private int[] values;
    private int zeroValue;

    protected void reset(int newLevel) {
        super.reset(newLevel);
        this.keys = new int[this.len];
        this.values = new int[this.len];
    }

    public void put(int key, int value) {
        if (key == 0) {
            this.zeroKey = true;
            this.zeroValue = value;
        }
        try {
            this.checkSizePut();
        }
        catch (SQLException e) {
            // empty catch block
        }
        int index = this.getIndex(key);
        int plus = 1;
        int deleted = -1;
        do {
            int k;
            if ((k = this.keys[index]) == 0) {
                if (this.values[index] != 1) {
                    if (deleted >= 0) {
                        index = deleted;
                        --this.deletedCount;
                    }
                    ++this.size;
                    this.keys[index] = key;
                    this.values[index] = value;
                    return;
                }
                if (deleted < 0) {
                    deleted = index;
                }
            } else if (k == key) {
                this.values[index] = value;
                return;
            }
            index = index + plus++ & this.mask;
        } while (plus <= this.len);
        throw Message.internal("hashmap is full");
    }

    public void remove(int key) {
        if (key == 0) {
            this.zeroKey = false;
            return;
        }
        try {
            this.checkSizeRemove();
        }
        catch (SQLException e) {
            // empty catch block
        }
        int index = this.getIndex(key);
        int plus = 1;
        do {
            int k;
            if ((k = this.keys[index]) == key) {
                this.keys[index] = 0;
                this.values[index] = 1;
                ++this.deletedCount;
                --this.size;
                return;
            }
            if (k == 0 && this.values[index] == 0) {
                return;
            }
            index = index + plus++ & this.mask;
            k = this.keys[index];
        } while (plus <= this.len);
    }

    protected void rehash(int newLevel) {
        int[] oldKeys = this.keys;
        int[] oldValues = this.values;
        this.reset(newLevel);
        for (int i = 0; i < oldKeys.length; ++i) {
            int k = oldKeys[i];
            if (k == 0) continue;
            this.put(k, oldValues[i]);
        }
    }

    public int get(int key) {
        if (key == 0) {
            return this.zeroKey ? this.zeroValue : -1;
        }
        int index = this.getIndex(key);
        int plus = 1;
        do {
            int k;
            if ((k = this.keys[index]) == 0 && this.values[index] == 0) {
                return -1;
            }
            if (k == key) {
                return this.values[index];
            }
            index = index + plus++ & this.mask;
        } while (plus <= this.len);
        return -1;
    }
}

