/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.services.messaging.adapters;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import flex.messaging.MessageException;
import flex.messaging.log.Log;
import flex.messaging.services.messaging.adapters.AsyncMessageReceiver;
import flex.messaging.services.messaging.adapters.JMSExceptionEvent;
import flex.messaging.services.messaging.adapters.JMSExceptionListener;
import flex.messaging.services.messaging.adapters.JMSMessageEvent;
import flex.messaging.services.messaging.adapters.JMSMessageListener;
import flex.messaging.services.messaging.adapters.JMSProxy;
import flex.messaging.services.messaging.adapters.MessageReceiver;
import flex.messaging.services.messaging.adapters.SyncMessageReceiver;
import java.util.Iterator;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.naming.NamingException;

public abstract class JMSConsumer
extends JMSProxy
implements ExceptionListener {
    protected MessageConsumer consumer;
    protected MessageReceiver messageReceiver;
    protected String selectorExpression;
    private boolean messageReceiverManuallySet = false;
    protected Object lock = new Object();
    private final CopyOnWriteArrayList jmsMessageListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList jmsExceptionListeners = new CopyOnWriteArrayList();

    public void start() throws NamingException, JMSException {
        super.start();
        if (Log.isInfo()) {
            Log.getLogger((String)"Service.Message.JMS").info("JMS consumer for JMS destination '" + this.destinationJndiName + "' is starting.");
        }
    }

    public void stop() {
        block4: {
            if (Log.isInfo()) {
                Log.getLogger((String)"Service.Message.JMS").info("JMS consumer for JMS destination '" + this.destinationJndiName + "' is stopping.");
            }
            this.stopMessageReceiver();
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
            }
            catch (JMSException e) {
                if (!Log.isWarn()) break block4;
                Log.getLogger((String)"Service.Message.JMS").warn("JMS consumer for JMS destination '" + this.destinationJndiName + "' received an error while closing its underlying MessageConsumer: " + e.getMessage());
            }
        }
        super.stop();
    }

    public void stop(boolean unsubscribe) {
        this.stop();
    }

    public void addJMSMessageListener(JMSMessageListener listener) {
        if (listener != null) {
            this.jmsMessageListeners.addIfAbsent((Object)listener);
        }
    }

    public void removeJMSMessageListener(JMSMessageListener listener) {
        if (listener != null) {
            this.jmsMessageListeners.remove((Object)listener);
        }
    }

    public void addJMSExceptionListener(JMSExceptionListener listener) {
        if (listener != null) {
            this.jmsExceptionListeners.addIfAbsent((Object)listener);
        }
    }

    public void removeJMSExceptionListener(JMSExceptionListener listener) {
        if (listener != null) {
            this.jmsExceptionListeners.remove((Object)listener);
        }
    }

    public MessageListener setMessageListener(MessageListener listener) throws JMSException {
        MessageListener oldListener = this.consumer.getMessageListener();
        this.consumer.setMessageListener(listener);
        return oldListener;
    }

    public MessageReceiver getMessageReceiver() {
        return this.messageReceiver;
    }

    public void setMessageReceiver(MessageReceiver messageReceiver) {
        this.messageReceiver = messageReceiver;
        this.messageReceiverManuallySet = true;
    }

    public String getSelectorExpression() {
        return this.selectorExpression;
    }

    public void setSelectorExpression(String selectorExpression) {
        this.selectorExpression = selectorExpression;
    }

    public void onException(JMSException exception) {
        if (!this.jmsExceptionListeners.isEmpty()) {
            Iterator iter = this.jmsExceptionListeners.iterator();
            while (iter.hasNext()) {
                ((JMSExceptionListener)iter.next()).exceptionThrown(new JMSExceptionEvent(this, exception));
            }
        }
    }

    public void onMessage(Message jmsMessage) {
        this.acknowledgeMessage(jmsMessage);
        if (!this.jmsMessageListeners.isEmpty()) {
            Iterator iter = this.jmsMessageListeners.iterator();
            while (iter.hasNext()) {
                ((JMSMessageListener)iter.next()).messageReceived(new JMSMessageEvent(this, jmsMessage));
            }
        }
    }

    public Message receive() throws JMSException {
        if (Log.isInfo()) {
            Log.getLogger((String)"Service.Message.JMS").info(Thread.currentThread() + " JMS consumer for JMS destination '" + this.destinationJndiName + "' is waiting forever until a new message arrives.");
        }
        return this.consumer.receive();
    }

    public Message receive(long timeout) throws JMSException {
        if (Log.isInfo()) {
            Log.getLogger((String)"Service.Message.JMS").info(Thread.currentThread() + " JMS consumer for JMS destination '" + this.destinationJndiName + "' is waiting " + timeout + " ms for new message to arrive");
        }
        return this.consumer.receive(timeout);
    }

    public Message receiveNoWait() throws JMSException {
        return this.consumer.receiveNoWait();
    }

    void startMessageReceiver() throws JMSException {
        this.initializeMessageReceiver();
        this.messageReceiver.startReceive();
        this.connection.start();
    }

    void stopMessageReceiver() {
        if (this.messageReceiver != null) {
            this.messageReceiver.stopReceive();
        }
    }

    protected void acknowledgeMessage(Message message) {
        block3: {
            if (this.getAcknowledgeMode() == 2) {
                try {
                    message.acknowledge();
                }
                catch (JMSException e) {
                    if (!Log.isInfo()) break block3;
                    Log.getLogger((String)"Service.Message.JMS").info("JMS consumer for JMS destination '" + this.destinationJndiName + "' received an error in message acknowledgement: " + e.getMessage());
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initializeMessageReceiver() {
        if (this.messageReceiverManuallySet && this.messageReceiver != null) {
            if (this.messageReceiver instanceof AsyncMessageReceiver) {
                String restrictedMethod = null;
                try {
                    restrictedMethod = "javax.jms.MessageConsumer.setMessageListener";
                    this.consumer.getMessageListener();
                    restrictedMethod = "javax.jms.Connection.setExceptionListener";
                    this.connection.setExceptionListener((ExceptionListener)((AsyncMessageReceiver)this.messageReceiver));
                    if (!Log.isInfo()) return;
                    Log.getLogger((String)"Service.Message.JMS").info("JMS consumer for JMS destination '" + this.destinationJndiName + "' is using async message receiver.");
                    return;
                }
                catch (JMSException jmsEx) {
                    MessageException me = new MessageException();
                    me.setMessage(10818, new Object[]{this.destinationJndiName, restrictedMethod});
                    throw me;
                }
            } else {
                if (!(this.messageReceiver instanceof SyncMessageReceiver)) return;
                SyncMessageReceiver smr = (SyncMessageReceiver)this.messageReceiver;
                if (!Log.isInfo()) return;
                Log.getLogger((String)"Service.Message.JMS").info("JMS consumer for JMS destination '" + this.destinationJndiName + "' is using sync message receiver" + " with sync-receive-interval-millis: " + smr.getSyncReceiveIntervalMillis() + ", sync-receive-wait-millis: " + smr.getSyncReceiveWaitMillis());
            }
            return;
        }
        try {
            this.messageReceiver = new AsyncMessageReceiver(this);
            this.consumer.getMessageListener();
            this.connection.setExceptionListener((ExceptionListener)((AsyncMessageReceiver)this.messageReceiver));
            if (!Log.isInfo()) return;
            Log.getLogger((String)"Service.Message.JMS").info("JMS consumer for JMS destination '" + this.destinationJndiName + "' is using async message receiver.");
            return;
        }
        catch (JMSException e) {
            SyncMessageReceiver smr = new SyncMessageReceiver(this);
            smr.setSyncReceiveIntervalMillis(1L);
            smr.setSyncReceiveWaitMillis(-1L);
            this.messageReceiver = smr;
            if (!Log.isInfo()) return;
            Log.getLogger((String)"Service.Message.JMS").info("JMS consumer for JMS destination '" + this.destinationJndiName + "' is using sync message receiver" + " with sync-receive-interval-millis: " + smr.getSyncReceiveIntervalMillis() + ", sync-receive-wait-millis: " + smr.getSyncReceiveWaitMillis());
        }
    }
}

