'''OpenGL extension SGIS.fog_function

Overview (from the spec)
	
	This extension allows to define application-specific fog blend-factor
	function.  Function is defined by the set of the "control" points and
	should be monotonic. Each control point represented as a pair of the
	eye-space distance value and corresponding value of the fog blending 
	factor. The minimum number of control points is one. The maximum 
	number is implementation dependent.
	

The official definition of this extension is available here:
	http://oss.sgi.com/projects/ogl-sample/registry/SGIS/fog_function.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
EXTENSION_NAME = 'GL_SGIS_fog_function'
GL_FOG_FUNC_SGIS = constant.Constant( 'GL_FOG_FUNC_SGIS', 0x812A )
GL_FOG_FUNC_POINTS_SGIS = constant.Constant( 'GL_FOG_FUNC_POINTS_SGIS', 0x812B )
GL_MAX_FOG_FUNC_POINTS_SGIS = constant.Constant( 'GL_MAX_FOG_FUNC_POINTS_SGIS', 0x812C )
glFogFuncSGIS = platform.createExtensionFunction( 
	'glFogFuncSGIS', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLsizei, arrays.GLfloatArray,),
	doc = 'glFogFuncSGIS( GLsizei(n), GLfloatArray(points) ) -> None',
	argNames = ('n', 'points',),
)

glGetFogFuncSGIS = platform.createExtensionFunction( 
	'glGetFogFuncSGIS', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(arrays.GLfloatArray,),
	doc = 'glGetFogFuncSGIS( GLfloatArray(points) ) -> None',
	argNames = ('points',),
)


def glInitFogFunctionSGIS():
	'''Return boolean indicating whether this extension is available'''
	return extensions.hasGLExtension( EXTENSION_NAME )
