/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.server.ShutdownHandler;
import org.h2.tools.Server;
import org.h2.util.Resources;
import org.h2.util.StartBrowser;

public class Console
implements ActionListener,
MouseListener,
ShutdownHandler {
    private static final int EXIT_ERROR = 1;
    Frame frame;
    private Font font;
    private Image icon16;
    private Image icon24;
    private Button startBrowser;
    private Server web;
    private Server tcp;
    private Server pg;
    private boolean isWindows;
    static /* synthetic */ Class class$java$awt$Image;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$awt$PopupMenu;
    static /* synthetic */ Class class$java$awt$event$MouseListener;

    public static void main(String[] stringArray) {
        int n = new Console().run(stringArray, System.out);
        if (n != 0) {
            System.exit(n);
        }
    }

    private void showUsage(PrintStream printStream) {
        printStream.println("Starts H2 Console");
        printStream.println("By default, -web, -tool, -browser, -tcp, and -pg are started. Options are case sensitive.");
        printStream.println("java " + this.getClass().getName());
        printStream.println("-web                  Start the Web Server and H2 Console");
        printStream.println("-tool                 Start the icon or window that allows to start a browser (includes -web)");
        printStream.println("-browser              Start a browser to connect to the H2 Console (includes -web)");
        printStream.println("-tcp                  Start the TCP Server");
        printStream.println("-pg                   Start the PG Server");
        printStream.println("See also http://h2database.com/javadoc/" + this.getClass().getName().replace('.', '/') + ".html");
    }

    private int run(String[] stringArray, PrintStream printStream) {
        int n;
        this.isWindows = SysProperties.getStringSetting("os.name", "").startsWith("Windows");
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = true;
        for (n = 0; stringArray != null && n < stringArray.length; ++n) {
            String string = stringArray[n];
            if (string == null) continue;
            if ("-?".equals(string) || "-help".equals(string)) {
                this.showUsage(printStream);
                return 1;
            }
            if ("-web".equals(string)) {
                bl6 = false;
                bl3 = true;
                continue;
            }
            if ("-tool".equals(string)) {
                bl6 = false;
                bl3 = true;
                bl4 = true;
                continue;
            }
            if ("-browser".equals(string)) {
                bl6 = false;
                bl3 = true;
                bl5 = true;
                continue;
            }
            if ("-tcp".equals(string)) {
                bl6 = false;
                bl = true;
                continue;
            }
            if (!"-pg".equals(string)) continue;
            bl6 = false;
            bl2 = true;
        }
        if (bl6) {
            bl3 = true;
            bl4 = true;
            bl5 = true;
            bl = true;
            bl2 = true;
        }
        n = 0;
        if (bl3) {
            try {
                this.web = Server.createWebServer(stringArray);
                this.web.setShutdownHandler(this);
                this.web.start();
            }
            catch (SQLException sQLException) {
                this.printProblem(sQLException, this.web);
            }
        }
        if (bl) {
            try {
                this.tcp = Server.createTcpServer(stringArray);
                this.tcp.start();
            }
            catch (SQLException sQLException) {
                this.printProblem(sQLException, this.tcp);
            }
        }
        if (bl2) {
            try {
                this.pg = Server.createPgServer(stringArray);
                this.pg.start();
            }
            catch (SQLException sQLException) {
                this.printProblem(sQLException, this.pg);
            }
        }
        if (bl4 && !GraphicsEnvironment.isHeadless()) {
            this.font = this.isWindows ? new Font("Dialog", 0, 11) : new Font("Dialog", 0, 12);
            try {
                this.icon16 = this.loadImage("/org/h2/res/h2.png");
                this.icon24 = this.loadImage("/org/h2/res/h2b.png");
                if (!this.createTrayIcon()) {
                    this.showWindow(true);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (bl5) {
            StartBrowser.openURL(this.web.getURL());
        }
        if (!this.web.isRunning(true)) {
            n = 1;
        }
        return n;
    }

    private void printProblem(SQLException sQLException, Server server) {
        if (server == null) {
            sQLException.printStackTrace();
        } else {
            System.out.println(server.getStatus());
            System.out.println("Root cause: " + sQLException.getMessage());
        }
    }

    private Image loadImage(String string) throws IOException {
        byte[] byArray = Resources.get(string);
        if (byArray == null) {
            return null;
        }
        return Toolkit.getDefaultToolkit().createImage(byArray);
    }

    public void shutdown() {
        this.stopAll();
    }

    void stopAll() {
        if (this.web != null && this.web.isRunning(false)) {
            this.web.stop();
            this.web = null;
        }
        if (this.tcp != null && this.tcp.isRunning(false)) {
            this.tcp.stop();
            this.tcp = null;
        }
        if (this.pg != null && this.pg.isRunning(false)) {
            this.pg.stop();
            this.pg = null;
        }
        if (this.frame != null) {
            this.frame.dispose();
            this.frame = null;
        }
        System.exit(0);
    }

    private boolean createTrayIcon() {
        try {
            Boolean bl = (Boolean)Class.forName("java.awt.SystemTray").getMethod("isSupported", new Class[0]).invoke(null, new Object[0]);
            if (!bl.booleanValue()) {
                return false;
            }
            PopupMenu popupMenu = new PopupMenu();
            MenuItem menuItem = new MenuItem("H2 Console");
            menuItem.setActionCommand("console");
            menuItem.addActionListener(this);
            menuItem.setFont(this.font);
            popupMenu.add(menuItem);
            MenuItem menuItem2 = new MenuItem("Status");
            menuItem2.setActionCommand("status");
            menuItem2.addActionListener(this);
            menuItem2.setFont(this.font);
            popupMenu.add(menuItem2);
            MenuItem menuItem3 = new MenuItem("Exit");
            menuItem3.setFont(this.font);
            menuItem3.setActionCommand("exit");
            menuItem3.addActionListener(this);
            popupMenu.add(menuItem3);
            Object object = Class.forName("java.awt.SystemTray").getMethod("getSystemTray", new Class[0]).invoke(null, new Object[0]);
            Dimension dimension = (Dimension)Class.forName("java.awt.SystemTray").getMethod("getTrayIconSize", new Class[0]).invoke(object, new Object[0]);
            Image image = dimension.width >= 24 && dimension.height >= 24 ? this.icon24 : this.icon16;
            Object obj = Class.forName("java.awt.TrayIcon").getConstructor(class$java$awt$Image == null ? (class$java$awt$Image = Console.class$("java.awt.Image")) : class$java$awt$Image, class$java$lang$String == null ? (class$java$lang$String = Console.class$("java.lang.String")) : class$java$lang$String, class$java$awt$PopupMenu == null ? (class$java$awt$PopupMenu = Console.class$("java.awt.PopupMenu")) : class$java$awt$PopupMenu).newInstance(image, "H2 Database Engine", popupMenu);
            obj.getClass().getMethod("addMouseListener", class$java$awt$event$MouseListener == null ? (class$java$awt$event$MouseListener = Console.class$("java.awt.event.MouseListener")) : class$java$awt$event$MouseListener).invoke(obj, this);
            object.getClass().getMethod("add", Class.forName("java.awt.TrayIcon")).invoke(object, obj);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void showWindow(final boolean bl) {
        this.frame = new Frame("H2 Console");
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (bl) {
                    Console.this.stopAll();
                } else {
                    Console.this.frame.dispose();
                }
            }
        });
        if (this.icon16 != null) {
            this.frame.setIconImage(this.icon16);
        }
        this.frame.setResizable(false);
        this.frame.setBackground(SystemColor.control);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.frame.setLayout(gridBagLayout);
        Panel panel = new Panel(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        gridBagConstraints.gridy = 0;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.insets = new Insets(10, 0, 0, 0);
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.anchor = 13;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints3.gridx = 1;
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 0;
        Label label = new Label("H2 Console URL:", 0);
        label.setFont(this.font);
        panel.add((Component)label, gridBagConstraints4);
        TextField textField = new TextField();
        textField.setEditable(false);
        textField.setFont(this.font);
        textField.setText(this.web.getURL());
        if (this.isWindows) {
            textField.setFocusable(false);
        }
        panel.add((Component)textField, gridBagConstraints3);
        this.startBrowser = new Button("Start Browser");
        this.startBrowser.setFocusable(false);
        this.startBrowser.setActionCommand("console");
        this.startBrowser.addActionListener(this);
        this.startBrowser.setFont(this.font);
        panel.add((Component)this.startBrowser, gridBagConstraints2);
        this.frame.add((Component)panel, gridBagConstraints);
        int n = 300;
        int n2 = 120;
        this.frame.setSize(n, n2);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.frame.setLocation((dimension.width - n) / 2, (dimension.height - n2) / 2);
        try {
            this.frame.setVisible(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void startBrowser() {
        if (this.web != null) {
            StartBrowser.openURL(this.web.getURL());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("exit".equals(string)) {
            this.stopAll();
        } else if ("console".equals(string)) {
            this.startBrowser();
        } else if ("status".equals(string)) {
            this.showWindow(false);
        } else if (this.startBrowser == actionEvent.getSource()) {
            this.startBrowser();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            this.startBrowser();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

