/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.h2.engine.SessionInterface;
import org.h2.message.Message;
import org.h2.result.ResultInterface;
import org.h2.util.ObjectArray;
import org.h2.util.StringUtils;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class UpdatableRow {
    private final SessionInterface session;
    private final Connection conn;
    private final DatabaseMetaData meta;
    private final ResultInterface result;
    private final int columnCount;
    private String schemaName;
    private String tableName;
    private ObjectArray key;
    private boolean isUpdatable;

    public UpdatableRow(Connection connection, ResultInterface resultInterface, SessionInterface sessionInterface) throws SQLException {
        this.conn = connection;
        this.meta = connection.getMetaData();
        this.result = resultInterface;
        this.session = sessionInterface;
        this.columnCount = resultInterface.getVisibleColumnCount();
        for (int i = 0; i < this.columnCount; ++i) {
            String string = resultInterface.getTableName(i);
            String string2 = resultInterface.getSchemaName(i);
            if (string == null || string2 == null) {
                return;
            }
            if (this.tableName == null) {
                this.tableName = string;
            } else if (!this.tableName.equals(string)) {
                return;
            }
            if (this.schemaName == null) {
                this.schemaName = string2;
                continue;
            }
            if (this.schemaName.equals(string2)) continue;
            return;
        }
        ResultSet resultSet = this.meta.getTables(null, this.schemaName, this.tableName, new String[]{"TABLE"});
        if (!resultSet.next()) {
            return;
        }
        if (resultSet.getString("SQL") == null) {
            return;
        }
        this.key = new ObjectArray();
        resultSet = this.meta.getPrimaryKeys(null, this.schemaName, this.tableName);
        while (resultSet.next()) {
            this.key.add(resultSet.getString("COLUMN_NAME"));
        }
        if (this.key.size() == 0) {
            resultSet = this.meta.getIndexInfo(null, this.schemaName, this.tableName, true, true);
            while (resultSet.next()) {
                this.key.add(resultSet.getString("COLUMN_NAME"));
            }
        }
        this.isUpdatable = this.key.size() > 0;
    }

    public boolean isUpdatable() {
        return this.isUpdatable;
    }

    private int getColumnIndex(String string) throws SQLException {
        for (int i = 0; i < this.columnCount; ++i) {
            String string2 = this.result.getColumnName(i);
            if (!string2.equals(string)) continue;
            return i;
        }
        throw Message.getSQLException(42122, string);
    }

    private void appendColumnList(StringBuffer stringBuffer, boolean bl) {
        for (int i = 0; i < this.columnCount; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            String string = this.result.getColumnName(i);
            stringBuffer.append(StringUtils.quoteIdentifier(string));
            if (!bl) continue;
            stringBuffer.append("=? ");
        }
    }

    private void appendKeyCondition(StringBuffer stringBuffer) {
        stringBuffer.append(" WHERE ");
        for (int i = 0; i < this.key.size(); ++i) {
            if (i > 0) {
                stringBuffer.append(" AND ");
            }
            stringBuffer.append(StringUtils.quoteIdentifier((String)this.key.get(i)));
            stringBuffer.append("=?");
        }
    }

    private void setKey(PreparedStatement preparedStatement, int n, Value[] valueArray) throws SQLException {
        for (int i = 0; i < this.key.size(); ++i) {
            String string = (String)this.key.get(i);
            int n2 = this.getColumnIndex(string);
            Value value = valueArray[n2];
            if (value == null || value == ValueNull.INSTANCE) {
                throw Message.getSQLException(2000);
            }
            value.set(preparedStatement, n + i);
        }
    }

    private void appendTableName(StringBuffer stringBuffer) {
        if (this.schemaName != null && this.schemaName.length() > 0) {
            stringBuffer.append(StringUtils.quoteIdentifier(this.schemaName));
            stringBuffer.append('.');
        }
        stringBuffer.append(StringUtils.quoteIdentifier(this.tableName));
    }

    public Value[] readRow(Value[] valueArray) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ");
        this.appendColumnList(stringBuffer, false);
        stringBuffer.append(" FROM ");
        this.appendTableName(stringBuffer);
        this.appendKeyCondition(stringBuffer);
        PreparedStatement preparedStatement = this.conn.prepareStatement(stringBuffer.toString());
        this.setKey(preparedStatement, 1, valueArray);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (!resultSet.next()) {
            throw Message.getSQLException(2000);
        }
        Value[] valueArray2 = new Value[this.columnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            int n = this.result.getColumnType(i);
            valueArray2[i] = DataType.readValue(this.session, resultSet, i + 1, n);
        }
        return valueArray2;
    }

    public void deleteRow(Value[] valueArray) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DELETE FROM ");
        this.appendTableName(stringBuffer);
        this.appendKeyCondition(stringBuffer);
        PreparedStatement preparedStatement = this.conn.prepareStatement(stringBuffer.toString());
        this.setKey(preparedStatement, 1, valueArray);
        int n = preparedStatement.executeUpdate();
        if (n != 1) {
            throw Message.getSQLException(2000);
        }
    }

    public void updateRow(Value[] valueArray, Value[] valueArray2) throws SQLException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UPDATE ");
        this.appendTableName(stringBuffer);
        stringBuffer.append(" SET ");
        this.appendColumnList(stringBuffer, true);
        this.appendKeyCondition(stringBuffer);
        PreparedStatement preparedStatement = this.conn.prepareStatement(stringBuffer.toString());
        int n2 = 1;
        for (n = 0; n < this.columnCount; ++n) {
            Value value = valueArray2[n];
            if (value == null) {
                value = valueArray[n];
            }
            value.set(preparedStatement, n2++);
        }
        this.setKey(preparedStatement, n2, valueArray);
        n = preparedStatement.executeUpdate();
        if (n != 1) {
            throw Message.getSQLException(2000);
        }
    }

    public void insertRow(Value[] valueArray) throws SQLException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO ");
        this.appendTableName(stringBuffer);
        stringBuffer.append('(');
        this.appendColumnList(stringBuffer, false);
        stringBuffer.append(")VALUES(");
        for (int i = 0; i < this.columnCount; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append('?');
        }
        stringBuffer.append(')');
        PreparedStatement preparedStatement = this.conn.prepareStatement(stringBuffer.toString());
        for (n = 0; n < this.columnCount; ++n) {
            Value value = valueArray[n];
            if (value == null) {
                value = ValueNull.INSTANCE;
            }
            value.set(preparedStatement, n + 1);
        }
        n = preparedStatement.executeUpdate();
        if (n != 1) {
            throw Message.getSQLException(2000);
        }
    }
}

