// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_RADIOACTION_H
#define _GTKMM_RADIOACTION_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* $Id: radioaction.hg,v 1.8 2006/01/29 12:21:43 murrayc Exp $ */

/* Copyright (C) 2003 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <gtkmm/toggleaction.h>
#include <gtkmm/radiobuttongroup.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkRadioAction GtkRadioAction;
typedef struct _GtkRadioActionClass GtkRadioActionClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class RadioAction_Class; } // namespace Gtk
namespace Gtk
{

/** An action of which only one in a group can be active.
 *
 * A Gtk::RadioAction is similar to Gtk::RadioMenuItem. A number of
 * radio actions can be linked together so that only one may be active
 * at any one time.
 */

class RadioAction : public Gtk::ToggleAction
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef RadioAction CppObjectType;
  typedef RadioAction_Class CppClassType;
  typedef GtkRadioAction BaseObjectType;
  typedef GtkRadioActionClass BaseClassType;

private:  friend class RadioAction_Class;
  static CppClassType radioaction_class_;

private:
  // noncopyable
  RadioAction(const RadioAction&);
  RadioAction& operator=(const RadioAction&);

protected:
  explicit RadioAction(const Glib::ConstructParams& construct_params);
  explicit RadioAction(GtkRadioAction* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~RadioAction();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkRadioAction*       gobj()       { return reinterpret_cast<GtkRadioAction*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkRadioAction* gobj() const { return reinterpret_cast<GtkRadioAction*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkRadioAction* gobj_copy();

private:

public:
  typedef RadioButtonGroup Group;

protected:
  //TODO: Remove the default constructor, because name may not be NULL.
  RadioAction();

  /**
   * Creates a radio action.
   *
   * @param group    The radio group this action belongs to.
   * @param name     A unique name for the action.
   * @param stock_id The stock icon to display in widgets representing the
   *                 action.
   * @param label    The label displayed in menu items and on buttons.
   * @param tooltip  A tooltip for the action.
   */
  explicit RadioAction(Group& group, const Glib::ustring& name, const StockID& stock_id = StockID(), const Glib::ustring& label = Glib::ustring(), const Glib::ustring& tooltip = Glib::ustring());

  /** Creates a radio action with an icon name.
   * The radio action's icon will reflect the specified icon name in the
   * user's icon theme.
   *
   * @param group    The radio group this action belongs to.
   * @param name     A unique name for the action.
   * @param icon_name An IconTheme icon name used for widgets representing the
   *                  action.
   * @param label    The label displayed in menu items and on buttons.
   * @param tooltip  A tooltip for the action.
   */
  explicit RadioAction(Group& group, const Glib::ustring& name, const Glib::ustring& icon_name, const Glib::ustring& label = Glib::ustring(), const Glib::ustring& tooltip = Glib::ustring());

public:
  //Note that gtk_recent_action_new() does not allow name to be NULL, which suggests that we should not have a default constructor,
  //but it's OK to set the name later:
  
  static Glib::RefPtr<RadioAction> create();


  /** Creates a radio action.
   *
   * @param group    The radio group this action belongs to.
   * @param name     A unique name for the action.
   * @param label    The label displayed in menu items and on buttons.
   * @param tooltip  A tooltip for the action.
   *
   * @return A new RadioAction.
   */
  static Glib::RefPtr<RadioAction> create(Group& group, const Glib::ustring& name, const Glib::ustring& label = Glib::ustring(), const Glib::ustring& tooltip = Glib::ustring());

  /** Creates a radio action with a stock ID.
   * The stock ID is used to set a default icon, text and accelerator for
   * the radio action.
   *
   * @param group    The radio group this action belongs to.
   * @param name     A unique name for the action.
   * @param stock_id The stock icon to display in widgets representing the
   *                 action.
   * @param label    The label displayed in menu items and on buttons.
   * @param tooltip  A tooltip for the action.
   *
   * @return A new RadioAction.
   */
  static Glib::RefPtr<RadioAction> create(Group& group, const Glib::ustring& name, const Gtk::StockID& stock_id, const Glib::ustring& label = Glib::ustring(), const Glib::ustring& tooltip = Glib::ustring());

  /** Creates a radio action with an icon name.
   * The radio action's icon will reflect the specified icon name in the
   * user's icon theme.
   *
   * @param group    The radio group this action belongs to.
   * @param name     A unique name for the action.
   * @param icon_name An IconTheme icon name used for widgets representing the
   *                  action.
   * @param label    The label displayed in menu items and on buttons.
   * @param tooltip  A tooltip for the action.
   *
   * @return A new RadioAction.
   */
  static Glib::RefPtr<RadioAction> create_with_icon_name(Group& group, const Glib::ustring& name, const Glib::ustring& icon_name, const Glib::ustring& label, const Glib::ustring& tooltip);

  
  /** Returns the list representing the radio group for this object.
   * Note that the returned list is only valid until the next change
   * to the group. 
   * 
   * A common way to set up a group of radio group is the following:
   * 
   * [C example ellipted]
   * 
   * @newin{2,4}
   * @return The list representing the radio group for this object.
   */
  Group get_group();
   void set_group(Group& group);
  

  /** Joins a radio action object to the group of another radio action object.
   * 
   * Use this in language bindings instead of the get_group() 
   * and set_group() methods
   * 
   * A common way to set up a group of radio actions is the following:
   * 
   * [C example ellipted]
   * 
   * @newin{3,0}
   * @param group_source A radio action object whos group we are 
   * joining, or <tt>0</tt> to remove the radio action from its group.
   */
  void join_group(const Glib::RefPtr<RadioAction>& group_source);

  
  /** Obtains the value property of the currently active member of 
   * the group to which @a action belongs.
   * 
   * @newin{2,4}
   * @return The value of the currently active group member.
   */
  int get_current_value() const;
  
  /** Sets the currently active group member to the member with value
   * property @a current_value.
   * 
   * @newin{2,10}
   * @param current_value The new value.
   */
  void set_current_value(int current_value);

   
/**
   * @par Slot Prototype:
   * <tt>void on_my_%changed(const Glib::RefPtr<RadioAction>& current)</tt>
   *
   * The signal_changed() signal is emitted on every member of a radio group when the
   * active member is changed. The signal gets emitted after the signal_activate() signals
   * for the previous and current active members.
   * 
   * @newin{2,4}
   * @param current The member of @a action<!-- -->s group which has just been activated.
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<RadioAction>& > signal_changed();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The value returned by gtk_radio_action_get_current_value() when this action is the current action of its group.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< int > property_value() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The value returned by gtk_radio_action_get_current_value() when this action is the current action of its group.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_value() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  //Probably wouldn't work: _WRAP_PROPERTY("group", Group)
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The value property of the currently active member of the group to which this action belongs.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< int > property_current_value() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The value property of the currently active member of the group to which this action belongs.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_current_value() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_changed().
  virtual void on_changed(const Glib::RefPtr<RadioAction>& current);


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::RadioAction
   */
  Glib::RefPtr<Gtk::RadioAction> wrap(GtkRadioAction* object, bool take_copy = false);
}


#endif /* _GTKMM_RADIOACTION_H */

