# rcov Copyright (c) 2004-2006 Mauricio Fernandez <mfp@acm.org>
#
# See LICENSE for licensing information.

# NOTE: if you're reading this in the XHTML code coverage report generated by
# rcov, you'll notice that only code inside methods is reported as covered,
# very much like what happens when you run it with --test-unit-only.
# This is due to the fact that we're running rcov on itself: the code below is
# already loaded before coverage tracing is activated, so only code inside
# methods is actually executed under rcov's inspection.

require 'rcov/version'
require 'rcov/formatters'
require 'rcov/coverage_info'
require 'rcov/file_statistics'
require 'rcov/differential_analyzer'
require 'rcov/code_coverage_analyzer'
require 'rcov/call_site_analyzer'

SCRIPT_LINES__ = {} unless defined? SCRIPT_LINES__

module Rcov
  # TODO: Move to Ruby 1.8.6 Backport module
  unless RUBY_VERSION =~ /1.9/  
    class ::String
      def lines
        map
      end
    end
  end

  autoload :RCOV__, "rcov/lowlevel.rb"
end
