#!/usr/bin/ruby
#
# A really simplistic script which prints out service information for the
# open TCP and UDP ports found by scanning a host
#
# Kris Katterjohn 01/27/2009

require 'nmap/parser'

def printport(port, proto)
	srv = port.service

	puts
	puts "Port ##{port.num}/#{proto} is open (#{port.reason})"
	puts "\tService: #{srv.name}" if srv.name
	puts "\tProduct: #{srv.product}" if srv.product
	puts "\tVersion: #{srv.version}" if srv.version
	puts
end

p = Nmap::Parser.parsescan("sudo nmap", "-sSUV 192.168.11.1")

p.hosts("up") do |host|
	puts "#{host.addr}:"
	host.tcp_ports("open") { |port| printport(port, "tcp") }
	host.udp_ports("open") { |port| printport(port, "udp") }
	puts
end

