/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.poweroff;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.RandomAccessFile;
import java.net.Socket;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class Test {
    String driver;
    String url;
    String user;
    String password;
    Connection conn;
    Statement stat;
    PreparedStatement prep;

    private Test() {
    }

    private Test(String driver, String url, String user, String password, boolean writeDelay0) {
        this.driver = driver;
        this.url = url;
        this.user = user;
        this.password = password;
        try {
            Class.forName(driver);
            this.conn = DriverManager.getConnection(url, user, password);
            this.stat = this.conn.createStatement();
            if (writeDelay0) {
                this.stat.execute("SET WRITE_DELAY 0");
            }
            System.out.println(url + " started");
        }
        catch (Exception e) {
            System.out.println(url + ": " + e.toString());
            return;
        }
        try {
            ResultSet rs = this.stat.executeQuery("SELECT MAX(ID) FROM TEST");
            rs.next();
            System.out.println(url + ": MAX(ID)=" + rs.getInt(1));
            this.stat.execute("DROP TABLE TEST");
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            this.stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR(255))");
            this.prep = this.conn.prepareStatement("INSERT INTO TEST VALUES(?, ?)");
        }
        catch (SQLException e) {
            System.out.println(url + ": " + e.toString());
        }
    }

    private void insert(int id) {
        try {
            if (this.prep != null) {
                this.prep.setInt(1, id);
                this.prep.setString(2, "World " + id);
                this.prep.execute();
            }
        }
        catch (SQLException e) {
            System.out.println(this.url + ": " + e.toString());
        }
    }

    public static void main(String[] args) throws Exception {
        new Test().test(args);
    }

    void test(String[] args) throws Exception {
        int port = 9099;
        String connect = "192.168.0.3";
        boolean file = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-port")) {
                port = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-connect")) {
                connect = args[++i];
                continue;
            }
            if (!args[i].equals("-file")) continue;
            file = true;
        }
        this.test(connect, port, file);
    }

    void test(String connect, int port, boolean file) throws Exception {
        Socket socket = new Socket(connect, port);
        DataOutputStream out = new DataOutputStream(socket.getOutputStream());
        System.out.println("Connected to " + socket.toString());
        if (file) {
            this.testFile(out);
        } else {
            this.testDatabases(out);
        }
    }

    void testFile(DataOutputStream out) throws Exception {
        File file = new File("test.txt");
        if (file.exists()) {
            file.delete();
        }
        RandomAccessFile write = new RandomAccessFile(file, "rws");
        int fileSize = 0xA00000;
        write.setLength(fileSize);
        write.seek(0L);
        int i = 0;
        FileDescriptor fd = write.getFD();
        while (write.getFilePointer() < (long)fileSize) {
            write.writeBytes(i + "\r\n");
            fd.sync();
            out.writeInt(i);
            out.flush();
            ++i;
        }
        write.close();
    }

    void testDatabases(DataOutputStream out) throws Exception {
        Test[] dbs = new Test[]{new Test("org.h2.Driver", "jdbc:h2:test1", "sa", "", true), new Test("org.h2.Driver", "jdbc:h2:test2", "sa", "", false), new Test("org.hsqldb.jdbcDriver", "jdbc:hsqldb:test4", "sa", "", false), new Test("org.postgresql.Driver", "jdbc:postgresql:test", "sa", "sa", false), new Test("org.apache.derby.jdbc.EmbeddedDriver", "jdbc:derby:test;create=true", "sa", "", false), new Test("org.h2.Driver", "jdbc:h2:test5", "sa", "", true), new Test("org.h2.Driver", "jdbc:h2:test6", "sa", "", false)};
        int i = 0;
        while (true) {
            for (int j = 0; j < dbs.length; ++j) {
                dbs[j].insert(i);
            }
            out.writeInt(i);
            out.flush();
            ++i;
        }
    }
}

