/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jpedal.color.PdfColor;
import org.jpedal.utils.repositories.Vector_Float;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Object;
import org.jpedal.utils.repositories.Vector_Rectangle;
import org.jpedal.utils.repositories.Vector_boolean;

public class PageLines
implements Serializable {
    private int initSize = 20;
    private Vector_Int t_x1 = new Vector_Int(this.initSize);
    private Vector_Int t_x2 = new Vector_Int(this.initSize);
    private Vector_Int t_y1 = new Vector_Int(this.initSize);
    private Vector_Int t_y2 = new Vector_Int(this.initSize);
    int boxCount = 0;
    public Vector_Float box_x1 = new Vector_Float(this.initSize);
    public Vector_Float box_y1 = new Vector_Float(this.initSize);
    public Vector_Float box_x2 = new Vector_Float(this.initSize);
    public Vector_Float box_y2 = new Vector_Float(this.initSize);
    private Vector_Rectangle box_shape = new Vector_Rectangle(this.initSize);
    private Vector_Object box_col = new Vector_Object(this.initSize);
    private Vector_boolean box_isLive = new Vector_boolean(this.initSize);
    private Vector_boolean box_isComposite = new Vector_boolean(this.initSize);
    private Vector_Float v_x1 = new Vector_Float(this.initSize);
    private Vector_Float v_x2 = new Vector_Float(this.initSize);
    private Vector_Float v_y1 = new Vector_Float(this.initSize);
    private Vector_Float v_y2 = new Vector_Float(this.initSize);
    private Vector_Rectangle v_shape = new Vector_Rectangle(this.initSize);
    private Vector_Float h_x1 = new Vector_Float(this.initSize);
    private Vector_boolean h_isLive = new Vector_boolean(this.initSize);
    private Vector_Float h_x2 = new Vector_Float(this.initSize);
    private Vector_Float h_y1 = new Vector_Float(this.initSize);
    private Vector_Float h_y2 = new Vector_Float(this.initSize);
    private Vector_Float add_Hx1 = new Vector_Float(this.initSize);
    private Vector_Float add_Hx2 = new Vector_Float(this.initSize);
    private Vector_Float add_Hy1 = new Vector_Float(this.initSize);
    private Vector_Float add_Vx1 = new Vector_Float(this.initSize);
    private Vector_Float add_Vy1 = new Vector_Float(this.initSize);
    private Vector_Float add_Vy2 = new Vector_Float(this.initSize);
    private Vector_Rectangle add_box = new Vector_Rectangle(this.initSize);
    private Vector_Rectangle h_shape = new Vector_Rectangle(this.initSize);
    private float vertical_x_divide = -1.0f;
    private float vertical_y_divide = -1.0f;
    private int pageWidth;
    private int pageHeight;

    public PageLines() {
    }

    public PageLines(ObjectInputStream objectInputStream) {
        try {
            this.initSize = objectInputStream.readInt();
            this.vertical_x_divide = objectInputStream.readFloat();
            this.vertical_y_divide = objectInputStream.readFloat();
            this.pageWidth = objectInputStream.readInt();
            this.pageHeight = objectInputStream.readInt();
            this.boxCount = objectInputStream.readInt();
            this.t_x1 = (Vector_Int)objectInputStream.readObject();
            this.t_x2 = (Vector_Int)objectInputStream.readObject();
            this.t_y1 = (Vector_Int)objectInputStream.readObject();
            this.t_y2 = (Vector_Int)objectInputStream.readObject();
            this.box_x1 = (Vector_Float)objectInputStream.readObject();
            this.box_y1 = (Vector_Float)objectInputStream.readObject();
            this.box_x2 = (Vector_Float)objectInputStream.readObject();
            this.box_y2 = (Vector_Float)objectInputStream.readObject();
            this.box_shape = (Vector_Rectangle)objectInputStream.readObject();
            this.box_col = (Vector_Object)objectInputStream.readObject();
            this.box_isLive = (Vector_boolean)objectInputStream.readObject();
            this.box_isComposite = (Vector_boolean)objectInputStream.readObject();
            this.v_x1 = (Vector_Float)objectInputStream.readObject();
            this.v_x2 = (Vector_Float)objectInputStream.readObject();
            this.v_y1 = (Vector_Float)objectInputStream.readObject();
            this.v_y2 = (Vector_Float)objectInputStream.readObject();
            this.v_shape = (Vector_Rectangle)objectInputStream.readObject();
            this.h_x1 = (Vector_Float)objectInputStream.readObject();
            this.h_isLive = (Vector_boolean)objectInputStream.readObject();
            this.h_x2 = (Vector_Float)objectInputStream.readObject();
            this.h_y1 = (Vector_Float)objectInputStream.readObject();
            this.h_y2 = (Vector_Float)objectInputStream.readObject();
            this.add_Hx1 = (Vector_Float)objectInputStream.readObject();
            this.add_Hx2 = (Vector_Float)objectInputStream.readObject();
            this.add_Hy1 = (Vector_Float)objectInputStream.readObject();
            this.add_Vx1 = (Vector_Float)objectInputStream.readObject();
            this.add_Vy1 = (Vector_Float)objectInputStream.readObject();
            this.add_Vy2 = (Vector_Float)objectInputStream.readObject();
            this.add_box = (Vector_Rectangle)objectInputStream.readObject();
            this.h_shape = (Vector_Rectangle)objectInputStream.readObject();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void serializeToStream(ObjectOutputStream objectOutputStream) {
        try {
            objectOutputStream.writeInt(this.initSize);
            objectOutputStream.writeFloat(this.vertical_x_divide);
            objectOutputStream.writeFloat(this.vertical_y_divide);
            objectOutputStream.writeInt(this.pageWidth);
            objectOutputStream.writeInt(this.pageHeight);
            objectOutputStream.writeInt(this.boxCount);
            objectOutputStream.writeObject(this.t_x1);
            objectOutputStream.writeObject(this.t_x2);
            objectOutputStream.writeObject(this.t_y1);
            objectOutputStream.writeObject(this.t_y2);
            objectOutputStream.writeObject(this.box_x1);
            objectOutputStream.writeObject(this.box_y1);
            objectOutputStream.writeObject(this.box_x2);
            objectOutputStream.writeObject(this.box_y2);
            objectOutputStream.writeObject(this.box_shape);
            objectOutputStream.writeObject(this.box_col);
            objectOutputStream.writeObject(this.box_isLive);
            objectOutputStream.writeObject(this.box_isComposite);
            objectOutputStream.writeObject(this.v_x1);
            objectOutputStream.writeObject(this.v_x2);
            objectOutputStream.writeObject(this.v_y1);
            objectOutputStream.writeObject(this.v_y2);
            objectOutputStream.writeObject(this.v_shape);
            objectOutputStream.writeObject(this.h_x1);
            objectOutputStream.writeObject(this.h_isLive);
            objectOutputStream.writeObject(this.h_x2);
            objectOutputStream.writeObject(this.h_y1);
            objectOutputStream.writeObject(this.h_y2);
            objectOutputStream.writeObject(this.add_Hx1);
            objectOutputStream.writeObject(this.add_Hx2);
            objectOutputStream.writeObject(this.add_Hy1);
            objectOutputStream.writeObject(this.add_Vx1);
            objectOutputStream.writeObject(this.add_Vy1);
            objectOutputStream.writeObject(this.add_Vy2);
            objectOutputStream.writeObject(this.add_box);
            objectOutputStream.writeObject(this.h_shape);
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public final boolean testHorizontalBetween(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        float f10;
        float f11;
        boolean bl = false;
        int n = this.h_x1.size();
        float f12 = 0.0f;
        float f13 = 0.0f;
        float[] fArray = this.h_x1.get();
        float[] fArray2 = this.h_x2.get();
        float[] fArray3 = this.h_y1.get();
        float[] fArray4 = this.h_y2.get();
        boolean[] blArray = this.h_isLive.get();
        if (f5 < f8) {
            float f14 = f4;
            f4 = f8;
            f8 = f14;
            f14 = f5;
            f5 = f9;
            f9 = f14;
        }
        float f15 = (f11 = f3 - f2) < (f10 = f7 - f6) ? f11 : f10;
        f12 = f2 > f6 ? f2 : f6;
        f13 = f3 < f7 ? f3 : f7;
        for (int i = 0; i < n; ++i) {
            if (!blArray[i] || !(fArray3[i] < f4 | fArray4[i] > f5) || !(f == -1.0f | f > fArray2[i] - fArray[i]) || !(fArray2[i] - fArray[i] > f15) || !(f12 >= fArray[i]) || !(f13 <= fArray2[i]) || !(f5 > fArray3[i]) || !(f8 < fArray4[i])) continue;
            bl = true;
            i = n;
        }
        return bl;
    }

    public final boolean testLineAcrossPage(float f, float f2, float f3, float f4, float f5, float f6) {
        boolean bl = false;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float[] fArray = this.h_x1.get();
        float[] fArray2 = this.h_x2.get();
        float[] fArray3 = this.h_y1.get();
        float[] fArray4 = this.h_y2.get();
        boolean[] blArray = this.h_isLive.get();
        int n = fArray.length;
        int n2 = (int)((f + f2) / 2.0f);
        int n3 = (int)((f4 + f5) / 2.0f);
        for (int i = 0; i < n; ++i) {
            if (!blArray[i] || !(fArray3[i] < f3) || !(fArray4[i] > f6) || !(fArray2[i] - fArray[i] >= 700.0f) || !(fArray[i] < (float)n2) || !(fArray[i] < (float)n3) || !(fArray2[i] > (float)n2) || !(fArray2[i] > (float)n3)) continue;
            bl = true;
            i = n;
        }
        return bl;
    }

    public final int testHorizontalBetweenLines(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, boolean bl, float f9, float f10) {
        int n = -1;
        float[] fArray = this.h_x1.get();
        float[] fArray2 = this.h_x2.get();
        float[] fArray3 = this.h_y1.get();
        float[] fArray4 = this.h_y2.get();
        boolean[] blArray = this.h_isLive.get();
        int n2 = fArray.length;
        if (f4 < f7) {
            float f11 = f3;
            f3 = f7;
            f7 = f11;
            f11 = f4;
            f4 = f8;
            f8 = f11;
        }
        float f12 = f2 - f;
        int n3 = (int)((f + f2) / 2.0f);
        int n4 = (int)((f5 + f6) / 2.0f);
        int n5 = (int)((f3 + f4) / 2.0f);
        for (int i = 0; i < n2; ++i) {
            float f13;
            if (!blArray[i]) continue;
            int n6 = (int)(fArray2[i] - fArray[i]);
            if (!(fArray3[i] < (float)n5) || !(fArray4[i] > f8) || !(fArray[i] < (float)n3) || !(fArray[i] < (float)n4) || !(fArray2[i] > (float)n3) || !(fArray2[i] > (float)n4)) continue;
            float f14 = fArray2[i] - fArray[i] - f12;
            if (f14 < 0.0f) {
                f14 = -f14;
            }
            if ((f13 = fArray[i] - f) < 0.0f) {
                f13 = -f13;
            }
            if (f10 != -1.0f && f14 < f10 || bl && f3 - f4 > 12.0f && f14 < 20.0f) continue;
            n = n6;
            i = n2;
        }
        return n;
    }

    public final boolean testVerticalBetween(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        float f9;
        float f10;
        this.vertical_x_divide = -1.0f;
        this.vertical_y_divide = -1.0f;
        boolean bl = false;
        float f11 = 0.0f;
        float[] fArray = this.v_x1.get();
        float[] fArray2 = this.v_x2.get();
        float[] fArray3 = this.v_y1.get();
        float[] fArray4 = this.v_y2.get();
        int n = fArray.length;
        if (f > f5) {
            float f12 = f;
            f = f5;
            f5 = f12;
            f12 = f2;
            f2 = f6;
            f6 = f12;
        }
        float f13 = (f10 = f3 - f4) < (f9 = f7 - f8) ? f10 : f9;
        f11 = f3 > f7 ? f7 : f3;
        float f14 = f4 < f8 ? f8 : f4;
        for (int i = 0; i < n; ++i) {
            if (!(fArray[i] < f | fArray2[i] > f2) || !(fArray3[i] - fArray4[i] > f13) || !(f11 < fArray3[i]) || !(fArray4[i] < f14) || !(f2 < fArray[i]) || !(f5 > fArray2[i])) continue;
            bl = true;
            this.vertical_x_divide = fArray[i];
            this.vertical_y_divide = fArray3[i];
            i = n;
        }
        return bl;
    }

    public final float getVerticalLineX() {
        return this.vertical_x_divide;
    }

    public final float getVerticalLineY() {
        return this.vertical_y_divide;
    }

    public final void addVerticalLine(float f, float f2, float f3, float f4) {
        if (f2 < f4) {
            float f5 = f2;
            f2 = f4;
            f4 = f5;
            f5 = f;
            f = f3;
            f3 = f5;
        }
        this.v_x1.addElement(f);
        this.v_x2.addElement(f3);
        this.v_y1.addElement(f2);
        this.v_y2.addElement(f4);
        this.v_shape.addElement(new Rectangle((int)f, (int)f4, (int)(f3 - f), (int)(f2 - f4)));
    }

    public Rectangle[] getComplexBoxes() {
        int n = 0;
        int n2 = 0;
        boolean[] blArray = this.box_isComposite.get();
        int n3 = blArray.length;
        for (int i = 0; i < n3; ++i) {
            if (!blArray[i]) continue;
            ++n;
        }
        Rectangle[] rectangleArray = new Rectangle[n];
        for (int i = 0; i < n3; ++i) {
            if (!blArray[i]) continue;
            rectangleArray[n2] = this.box_shape.elementAt(i);
            ++n2;
        }
        return rectangleArray;
    }

    public final void addBox(float f, float f2, float f3, float f4, PdfColor pdfColor) {
        float f5;
        if (f2 < f4) {
            f5 = f2;
            f2 = f4;
            f4 = f5;
        }
        if (f3 < f) {
            f5 = f;
            f = f3;
            f3 = f5;
        }
        Rectangle rectangle = new Rectangle((int)f, (int)f4, (int)(f3 - f), (int)(f2 - f4));
        boolean bl = false;
        Rectangle[] rectangleArray = this.box_shape.get();
        for (int i = 0; i < this.boxCount; ++i) {
            boolean bl2;
            boolean bl3;
            int n;
            int n2;
            int n3 = rectangleArray[i].x - rectangle.x;
            if (n3 < 0) {
                n3 = -n3;
            }
            if ((n2 = rectangleArray[i].y - rectangle.y) < 0) {
                n2 = -n2;
            }
            if ((n = rectangleArray[i].width - rectangle.width) < 0) {
                n = -n;
            }
            boolean bl4 = bl3 = n2 < 2 && n3 < 2 && n < 2;
            if (rectangleArray[i].contains(rectangle) && !bl3) {
                bl = true;
                i = this.boxCount;
                continue;
            }
            if (rectangle.contains(rectangleArray[i])) {
                this.box_x1.setElementAt(f, i);
                this.box_x2.setElementAt(f3, i);
                this.box_y1.setElementAt(f2, i);
                this.box_y2.setElementAt(f4, i);
                this.box_shape.setElementAt(rectangle, i);
                this.box_isComposite.setElementAt(false, i);
                this.box_isLive.setElementAt(true, i);
                bl = true;
                i = this.boxCount;
                continue;
            }
            if (bl3) continue;
            int n4 = rectangleArray[i].getBounds().x;
            int n5 = rectangleArray[i].getBounds().x + rectangleArray[i].getBounds().width;
            int n6 = rectangleArray[i].getBounds().y;
            int n7 = rectangleArray[i].getBounds().y + rectangleArray[i].getBounds().height;
            boolean bl5 = (float)n4 <= f && (float)n5 >= f || (float)n4 <= f3 && (float)n5 >= f3;
            boolean bl6 = (float)n7 >= f2 && (float)n6 <= f2 || (float)n7 >= f4 && (float)n6 <= f4;
            boolean bl7 = bl2 = n5 - n4 > 600 || f3 - f > 600.0f;
            if (!bl5 || !bl6 || bl2) continue;
            int n8 = (int)(f - (float)n4);
            int n9 = (int)(f3 - (float)n5);
            if (n8 < 0) {
                n8 = -n8;
            }
            if (n9 < 0) {
                n9 = -n9;
            }
            if (n8 > 5 || n9 > 5 || f2 - f4 > 32.0f && n7 - n6 > 32) {
                this.box_isComposite.setElementAt(true, i);
            }
            if (f > (float)n4) {
                f = n4;
            }
            if (f3 < (float)n5) {
                f3 = n5;
            }
            if (f4 > (float)n6) {
                f4 = n6;
            }
            if (f2 < (float)n7) {
                f2 = n7;
            }
            this.box_x1.setElementAt(f, i);
            this.box_x2.setElementAt(f3, i);
            this.box_y1.setElementAt(f2, i);
            this.box_y2.setElementAt(f4, i);
            this.box_shape.setElementAt(new Rectangle((int)f, (int)f4, (int)(f3 - f), (int)(f2 - f4)), i);
            this.box_isLive.setElementAt(true, i);
            bl = true;
            i = this.boxCount;
        }
        if (!bl) {
            this.box_x1.addElement(f);
            this.box_x2.addElement(f3);
            this.box_y1.addElement(f2);
            this.box_y2.addElement(f4);
            this.box_shape.addElement(rectangle);
            this.box_col.addElement(pdfColor);
            this.box_isComposite.addElement(false);
            this.box_isLive.addElement(true);
            ++this.boxCount;
        }
    }

    private final void checkImagesBisectingBox(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, int[] nArray) {
        int n = nArray.length;
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            float f;
            float f2;
            float f3;
            float f4;
            int n2;
            if (blArray[i]) continue;
            int n3 = nArray[i];
            float f5 = fArray[n3];
            float f6 = fArray3[n3];
            float f7 = fArray2[n3];
            float f8 = fArray4[n3];
            for (n2 = i + 1; n2 < n; ++n2) {
                if (blArray[n2]) continue;
                int n4 = nArray[n2];
                f4 = fArray[n4];
                f3 = fArray3[n4];
                f2 = fArray2[n4];
                f = fArray4[n4];
                if (f4 == f5 && f3 == f6) {
                    blArray[n2] = true;
                    if (f2 > f7) {
                        f7 = f2;
                    }
                    if (!(f < f8)) continue;
                    f8 = f;
                    continue;
                }
                if (f2 != f7 || f != f8) continue;
                blArray[n2] = true;
                if (f4 < f5) {
                    f5 = f4;
                }
                if (!(f3 > f6)) continue;
                f6 = f3;
            }
            for (n2 = 0; n2 < this.boxCount; ++n2) {
                float f9;
                float f10;
                float f11;
                float f12 = this.box_x1.elementAt(n2);
                f4 = this.box_x2.elementAt(n2);
                f3 = this.box_y1.elementAt(n2);
                f2 = this.box_y2.elementAt(n2);
                f = f12 - f5;
                if (f < 0.0f) {
                    f = -f;
                }
                if ((f11 = f4 - f6) < 0.0f) {
                    f11 = -f11;
                }
                if ((f10 = f3 - f7) < 0.0f) {
                    f10 = -f10;
                }
                if ((f9 = f2 - f8) < 0.0f) {
                    f9 = -f9;
                }
                if (!(f10 < 2.0f) || !(f9 < 2.0f)) continue;
                this.box_x2.setElementAt(f5, n2);
                this.box_shape.addElement(new Rectangle((int)f12, (int)f2, (int)(f5 - f12), (int)(f3 - f2)));
                this.box_x1.addElement(f6);
                this.box_x2.addElement(f4);
                this.box_y1.addElement(f3);
                this.box_y2.addElement(f2);
                this.box_shape.addElement(new Rectangle((int)f6, (int)f2, (int)(f4 - f6), (int)(f3 - f2)));
                this.box_col.addElement(this.box_col.elementAt(n2));
                this.box_isLive.addElement(true);
            }
        }
    }

    public final void addHorizontalLine(float f, float f2, float f3, float f4) {
        float f5;
        if (f > f3) {
            f5 = f;
            f = f3;
            f3 = f5;
        }
        if (f2 < f4) {
            f5 = f2;
            f2 = f4;
            f4 = f5;
        }
        this.h_x1.addElement(f);
        this.h_x2.addElement(f3);
        this.h_y1.addElement(f2);
        this.h_y2.addElement(f4);
        this.h_shape.addElement(new Rectangle((int)f, (int)f4, (int)(f3 - f), (int)(f2 - f4)));
        this.h_isLive.addElement(true);
    }

    public void drawLines(Graphics2D graphics2D) {
        try {
            Rectangle rectangle;
            int n;
            graphics2D.setColor(Color.red);
            int n2 = this.v_shape.size();
            for (n = 0; n < n2; ++n) {
                rectangle = this.v_shape.elementAt(n);
                if (rectangle == null) continue;
                graphics2D.draw(rectangle);
            }
            n2 = this.h_shape.size();
            for (n = 0; n < n2; ++n) {
                rectangle = this.h_shape.elementAt(n);
                if (rectangle == null || !this.h_isLive.elementAt(n)) continue;
                graphics2D.draw(rectangle);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void drawBoxes(Graphics2D graphics2D) {
        try {
            Rectangle rectangle;
            int n;
            int n2 = this.box_shape.size();
            for (n = 0; n < n2; ++n) {
                rectangle = this.box_shape.elementAt(n);
                if (rectangle == null) continue;
                graphics2D.setColor((PdfColor)this.box_col.elementAt(n));
                graphics2D.fill(rectangle);
                graphics2D.setColor(Color.magenta);
                graphics2D.draw(rectangle);
                graphics2D.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
            }
            n2 = this.add_box.size();
            for (n = 0; n < n2; ++n) {
                rectangle = this.add_box.elementAt(n);
                if (rectangle == null) continue;
                graphics2D.setColor(Color.lightGray);
                graphics2D.fill(rectangle);
                graphics2D.setColor(Color.magenta);
                graphics2D.draw(rectangle);
                graphics2D.drawLine(rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width, rectangle.y);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void lookForCompositeLines() {
        int[] nArray = this.t_x1.get();
        int[] nArray2 = this.t_y1.get();
        int[] nArray3 = this.t_x2.get();
        int[] nArray4 = this.t_y2.get();
        int n = nArray.length;
        boolean bl = false;
        int n2 = nArray[0];
        int n3 = nArray2[0];
        int n4 = nArray[0];
        int n5 = nArray4[0];
        int n6 = 3;
        for (int i = 1; i < n; ++i) {
            boolean bl2;
            if (nArray[i] == 0 && nArray2[i] == 0 && nArray3[i] == 0 && nArray4[i] == 0) continue;
            if (bl) {
                System.out.println(i + " Testing " + nArray[i] + ' ' + nArray2[i] + ' ' + nArray3[i] + ' ' + nArray4[i]);
            }
            boolean bl3 = bl2 = Math.abs(n3 - nArray2[i]) < 2;
            if (bl2 && Math.abs(nArray[i] - n4) < 10 | Math.abs(nArray3[i] - n2) < 10) {
                if (n4 < nArray3[i]) {
                    n4 = nArray3[i];
                } else if (n2 > nArray[i]) {
                    n2 = nArray[i];
                }
                if (!bl) continue;
                System.out.println("ON line");
                continue;
            }
            if (n2 != n4) {
                if (n4 - n2 > 10) {
                    if (bl) {
                        System.out.println("====================Line found " + n2 + ' ' + n3 + ' ' + n4 + ' ' + n5);
                    }
                    this.addHorizontalLine(n2, n3, n4, n3);
                } else if (bl) {
                    System.out.println("Too short " + n2 + ' ' + n4);
                }
                n3 = nArray2[i];
                n2 = nArray[i];
                n4 = nArray[i];
                n5 = nArray4[i];
                continue;
            }
            if (bl) {
                System.out.println("NO");
            }
            n3 = nArray2[i];
            n2 = nArray[i];
            n4 = nArray3[i];
            n5 = nArray4[i];
        }
        if (n2 != n4 && n4 - n2 > 50) {
            if (bl) {
                System.out.println("Line found " + n2 + ' ' + n3 + ' ' + n4 + ' ' + n5);
            }
            this.addHorizontalLine(n2, n3, n4, n3);
        }
        this.t_x1.clear();
        this.t_y1.clear();
        this.t_x2.clear();
        this.t_y2.clear();
    }

    public void addPossiblePartLine(int n, int n2, int n3, int n4) {
        this.t_x1.addElement(n);
        this.t_y1.addElement(n2);
        this.t_x2.addElement(n3);
        this.t_y2.addElement(n4);
    }

    public int[] getBoxIDs(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, int[] nArray, int[] nArray2) {
        float f;
        float f2;
        int n;
        int n2;
        int n3;
        this.checkImagesBisectingBox(fArray, fArray2, fArray3, fArray4, nArray2);
        int n4 = fArray.length;
        int[] nArray3 = new int[n4];
        float[] fArray5 = new float[n4];
        System.arraycopy(fArray2, 0, fArray5, 0, n4);
        int n5 = -1;
        float[] fArray6 = this.box_x1.get();
        float[] fArray7 = this.box_x2.get();
        float[] fArray8 = this.box_y1.get();
        float[] fArray9 = this.box_y2.get();
        boolean[] blArray = this.box_isLive.get();
        int[] nArray4 = new int[this.boxCount];
        for (n3 = 0; n3 < n4; ++n3) {
            nArray3[n3] = -1;
            n2 = n3;
            if (fArray5[n2] > (float)this.pageHeight) {
                fArray5[n2] = this.pageHeight;
            }
            for (n = 0; n < this.boxCount; ++n) {
                f2 = fArray8[n] - fArray9[n];
                f = nArray[n2] / 4;
                if (nArray[n2] <= 10) {
                    f = 0.0f;
                }
                if (!blArray[n] || !(fArray[n2] > fArray6[n]) || !(fArray3[n2] < fArray7[n]) || !(fArray5[n2] - f <= fArray8[n]) || !(fArray4[n2] + f >= fArray9[n])) continue;
                int n6 = n;
                nArray4[n6] = nArray4[n6] + 1;
            }
        }
        for (n3 = 0; n3 < n4; ++n3) {
            nArray3[n3] = -1;
            n2 = n3;
            for (n = 0; n < this.boxCount; ++n) {
                boolean bl;
                f2 = fArray8[n] - fArray9[n];
                f = nArray[n2] / 4;
                if (nArray[n2] <= 10) {
                    f = 0.0f;
                }
                boolean bl2 = blArray[n] && fArray[n2] > fArray6[n] && fArray3[n2] < fArray7[n] && fArray5[n2] - f <= fArray8[n] && fArray4[n2] + f >= fArray9[n];
                boolean bl3 = (fArray8[n] - fArray9[n]) / (float)nArray[n2] < 2.4f;
                float f3 = fArray6[n] - fArray[n2];
                float f4 = fArray3[n2] - fArray7[n];
                float f5 = f3 - f4;
                if (f5 < 0.0f) {
                    f5 = -f5;
                }
                boolean bl4 = f5 < 15.0f;
                boolean bl5 = bl = nArray4[n] < 2 || nArray4[n] == n4;
                if (bl && bl3 && bl4 && bl2 && nArray4[n] == 1 && nArray[n2] == 10) {
                    bl = false;
                }
                if (bl || !bl2) continue;
                if (nArray3[n3] == -1) {
                    nArray3[n3] = n;
                    n5 = n;
                    continue;
                }
                float f6 = (fArray7[n5] - fArray6[n5]) * (fArray8[n5] - fArray9[n5]);
                float f7 = (fArray7[n] - fArray6[n]) * (fArray8[n] - fArray9[n]);
                if (!(f6 < f7)) continue;
                nArray3[n3] = n;
                n5 = n;
            }
        }
        return nArray3;
    }

    public void removeValidTextBoxes(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, String[] stringArray, int[] nArray, int[] nArray2, int n) {
        int n2 = nArray.length;
        float[] fArray5 = this.box_x1.get();
        float[] fArray6 = this.box_x2.get();
        float[] fArray7 = this.box_y1.get();
        float[] fArray8 = this.box_y2.get();
        boolean[] blArray = this.box_isLive.get();
        for (int i = 0; i < this.boxCount; ++i) {
            if (!blArray[i]) continue;
            Vector_Int vector_Int = new Vector_Int(20);
            int n3 = 0;
            for (int j = 0; j < n2; ++j) {
                int n4 = nArray[j];
                if (fArray2[n4] > (float)this.pageHeight) {
                    fArray2[n4] = this.pageHeight;
                }
                if (!(fArray[n4] > fArray5[i]) || !(fArray3[n4] < fArray6[i]) || !(fArray2[n4] <= fArray7[i]) || !(fArray4[n4] >= fArray8[i])) continue;
                ++n3;
                vector_Int.addElement(n4);
            }
            if (n3 <= 2) continue;
            int[] nArray3 = vector_Int.get();
            int n5 = vector_Int.size() - 1;
            int n6 = 0;
            int n7 = 0;
            for (int j = n5 - 1; j > 0; --j) {
                int n8 = nArray3[j];
                int n9 = nArray3[j - 1];
                if (nArray2[n8] > n && nArray2[n9] < n && fArray4[n8] > fArray2[n9] && nArray2[n8] > nArray2[n9] && fArray2[n8] - fArray4[n8] < fArray2[n9] - fArray4[n9]) {
                    ++n6;
                    --j;
                    continue;
                }
                ++n7;
            }
            if (n6 <= n7 || n6 <= 2 || n6 <= n5 / 4) continue;
            blArray[i] = false;
        }
        this.box_isLive.set(blArray);
    }

    public void addPossibleLineEnclosingAdvert(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        int n8;
        if (n3 < n4) {
            n8 = n3;
            n3 = n4;
            n4 = n8;
        }
        if (n > n2) {
            n8 = n;
            n = n2;
            n2 = n8;
        }
        if ((n8 = n3 - n4) < 0) {
            n8 = -n8;
        }
        if ((n7 = n - n2) < 0) {
            n7 = -n7;
        }
        if ((float)n7 < (float)this.pageWidth * 0.75f && (float)n8 < (float)this.pageHeight * 0.75f && (n7 < 4 && n4 < 1 || (n2 > this.pageWidth - 5 || n < 1) && n8 < 4)) {
            if (n5 > n6) {
                this.add_Hx1.addElement(n);
                this.add_Hx2.addElement(n2);
                this.add_Hy1.addElement(n3);
            } else {
                this.add_Vx1.addElement(n);
                this.add_Vy1.addElement(n3);
                this.add_Vy2.addElement(n4);
            }
        }
    }

    private void calculateAds() {
        try {
            float[] fArray = this.add_Hx1.get();
            float[] fArray2 = this.add_Hx2.get();
            float[] fArray3 = this.add_Hy1.get();
            float[] fArray4 = this.add_Vx1.get();
            float[] fArray5 = this.add_Vy2.get();
            float[] fArray6 = this.add_Vy1.get();
            int n = fArray4.length;
            int n2 = fArray.length;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    int n3;
                    int n4;
                    float f;
                    float f2 = fArray4[i] - fArray2[j];
                    if (f2 < 0.0f) {
                        f2 = -f2;
                    }
                    if (f2 > 3.0f && (f2 = fArray4[i] - fArray[j]) < 0.0f) {
                        f2 = -f2;
                    }
                    if ((f = fArray6[i] - fArray3[j]) < 0.0f) {
                        f = -f;
                    }
                    if (!(f2 < 3.0f) || !(f < 3.0f) || !((n4 = (int)(fArray2[j] - fArray[j])) > 32 & (n3 = (int)(fArray6[i] - fArray5[i])) > 32)) continue;
                    this.add_box.addElement(new Rectangle((int)fArray[j], (int)fArray5[i], n4, n3));
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Rectangle[] getAds() {
        int n = this.add_box.size() - 1;
        Rectangle[] rectangleArray = new Rectangle[n];
        int[] nArray = new int[n];
        Rectangle[] rectangleArray2 = this.add_box.get();
        for (int i = 0; i < n; ++i) {
            Rectangle rectangle = this.add_box.elementAt(i);
            int n2 = rectangle.width * rectangle.height;
            if (i == 0) {
                rectangleArray[0] = rectangle;
                nArray[0] = n2;
                continue;
            }
            for (int j = 0; j < n; ++j) {
                if (nArray[j] >= n2) continue;
                for (int k = n - 1; k > j; --k) {
                    rectangleArray[k] = rectangleArray[k - 1];
                    nArray[k] = nArray[k - 1];
                }
                rectangleArray[j] = rectangle;
                nArray[j] = n2;
                j = i;
            }
        }
        return rectangleArray;
    }

    public int getPageWidth() {
        return this.pageWidth;
    }

    public void setMaxWidth(int n, int n2) {
        this.pageWidth = n;
        this.pageHeight = n2;
    }

    public void calculatePageShapes() {
        this.calculateAds();
        float[] fArray = this.box_x1.get();
        float[] fArray2 = this.box_x2.get();
        float[] fArray3 = this.box_y1.get();
        float[] fArray4 = this.box_y2.get();
        boolean[] blArray = this.box_isLive.get();
        float[] fArray5 = this.h_x1.get();
        float[] fArray6 = this.h_x2.get();
        float[] fArray7 = this.h_y1.get();
        float[] fArray8 = this.h_y2.get();
        boolean[] blArray2 = this.h_isLive.get();
        int n = fArray5.length;
        for (int i = 0; i < this.boxCount; ++i) {
            int n2;
            for (n2 = 0; n2 < this.boxCount; ++n2) {
                if (!blArray[n2] || i == n2 || !(fArray[i] >= fArray[n2]) || !(fArray2[i] <= fArray2[n2]) || !(fArray3[i] <= fArray3[n2]) || !(fArray4[i] >= fArray4[n2])) continue;
                blArray[n2] = false;
            }
            for (n2 = 0; n2 < n; ++n2) {
                if (!blArray2[n2] || !(fArray5[n2] >= fArray[i]) || !(fArray6[n2] <= fArray2[i]) || !(fArray7[n2] <= fArray3[i]) || !(fArray8[n2] >= fArray4[i])) continue;
                blArray2[n2] = false;
            }
        }
        this.box_isLive.set(blArray);
        this.h_isLive.set(blArray2);
    }
}

