/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.mail.DefaultAuthenticator;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.EmailUtils;

public abstract class Email {
    public static final String SENDER_EMAIL = "sender.email";
    public static final String SENDER_NAME = "sender.name";
    public static final String RECEIVER_EMAIL = "receiver.email";
    public static final String RECEIVER_NAME = "receiver.name";
    public static final String EMAIL_SUBJECT = "email.subject";
    public static final String EMAIL_BODY = "email.body";
    public static final String CONTENT_TYPE = "content.type";
    public static final String MAIL_HOST = "mail.smtp.host";
    public static final String MAIL_PORT = "mail.smtp.port";
    public static final String MAIL_SMTP_FROM = "mail.smtp.from";
    public static final String MAIL_SMTP_AUTH = "mail.smtp.auth";
    public static final String MAIL_SMTP_USER = "mail.smtp.user";
    public static final String MAIL_SMTP_PASSWORD = "mail.smtp.password";
    public static final String MAIL_TRANSPORT_PROTOCOL = "mail.transport.protocol";
    public static final String MAIL_TRANSPORT_TLS = "mail.smtp.starttls.enable";
    public static final String MAIL_SMTP_SOCKET_FACTORY_FALLBACK = "mail.smtp.socketFactory.fallback";
    public static final String MAIL_SMTP_SOCKET_FACTORY_CLASS = "mail.smtp.socketFactory.class";
    public static final String MAIL_SMTP_SOCKET_FACTORY_PORT = "mail.smtp.socketFactory.port";
    public static final String SMTP = "smtp";
    public static final String TEXT_HTML = "text/html";
    public static final String TEXT_PLAIN = "text/plain";
    public static final String ATTACHMENTS = "attachments";
    public static final String FILE_SERVER = "file.server";
    public static final String MAIL_DEBUG = "mail.debug";
    public static final String KOI8_R = "koi8-r";
    public static final String ISO_8859_1 = "iso-8859-1";
    public static final String US_ASCII = "us-ascii";
    protected MimeMessage message;
    protected String charset;
    protected InternetAddress fromAddress;
    protected String subject;
    protected MimeMultipart emailBody;
    protected Object content;
    protected String contentType;
    protected boolean debug;
    protected Date sentDate;
    protected Authenticator authenticator;
    protected String hostName;
    protected String smtpPort = "25";
    protected String sslSmtpPort = "465";
    protected List toList = new ArrayList();
    protected List ccList = new ArrayList();
    protected List bccList = new ArrayList();
    protected List replyList = new ArrayList();
    protected String bounceAddress;
    protected Map headers = new HashMap();
    protected boolean popBeforeSmtp;
    protected String popHost;
    protected String popUsername;
    protected String popPassword;
    protected boolean tls;
    protected boolean ssl;
    private Session session;

    public void setDebug(boolean d) {
        this.debug = d;
    }

    public void setAuthentication(String userName, String password) {
        this.authenticator = new DefaultAuthenticator(userName, password);
        this.setAuthenticator(this.authenticator);
    }

    public void setAuthenticator(Authenticator newAuthenticator) {
        this.authenticator = newAuthenticator;
    }

    public void setCharset(String newCharset) {
        Charset set = Charset.forName(newCharset);
        this.charset = set.name();
    }

    public void setContent(MimeMultipart aMimeMultipart) {
        this.emailBody = aMimeMultipart;
    }

    public void setContent(Object aObject, String aContentType) {
        this.content = aObject;
        if (EmailUtils.isEmpty(aContentType)) {
            this.contentType = null;
        } else {
            this.contentType = aContentType;
            String strMarker = "; charset=";
            int charsetPos = aContentType.toLowerCase().indexOf(strMarker);
            if (charsetPos != -1) {
                int intCharsetEnd = aContentType.toLowerCase().indexOf(" ", charsetPos += strMarker.length());
                this.charset = intCharsetEnd != -1 ? aContentType.substring(charsetPos, intCharsetEnd) : aContentType.substring(charsetPos);
            } else if (this.contentType.startsWith("text/") && EmailUtils.isNotEmpty(this.charset)) {
                StringBuffer contentTypeBuf = new StringBuffer(this.contentType);
                contentTypeBuf.append(strMarker);
                contentTypeBuf.append(this.charset);
                this.contentType = contentTypeBuf.toString();
            }
        }
    }

    public void setHostName(String aHostName) {
        this.hostName = aHostName;
    }

    public void setTLS(boolean withTLS) {
        this.tls = withTLS;
    }

    public void setSmtpPort(int aPortNumber) {
        if (aPortNumber < 1) {
            throw new IllegalArgumentException("Cannot connect to a port number that is less than 1 ( " + aPortNumber + " )");
        }
        this.smtpPort = Integer.toString(aPortNumber);
    }

    public void setMailSession(Session aSession) {
        Properties sessionProperties = aSession.getProperties();
        String auth = sessionProperties.getProperty(MAIL_SMTP_AUTH);
        if ("true".equalsIgnoreCase(auth)) {
            String userName = sessionProperties.getProperty(MAIL_SMTP_USER);
            String password = sessionProperties.getProperty(MAIL_SMTP_PASSWORD);
            this.authenticator = new DefaultAuthenticator(userName, password);
            this.session = Session.getInstance((Properties)sessionProperties, (Authenticator)this.authenticator);
        } else {
            this.session = aSession;
        }
    }

    public void setMailSessionFromJNDI(String jndiName) throws NamingException {
        if (EmailUtils.isEmpty(jndiName)) {
            throw new IllegalArgumentException("JNDI name missing");
        }
        Context ctx = null;
        ctx = jndiName.startsWith("java:") ? new InitialContext() : (Context)new InitialContext().lookup("java:comp/env");
        this.setMailSession((Session)ctx.lookup(jndiName));
    }

    public Session getMailSession() throws EmailException {
        if (this.session == null) {
            Properties properties = new Properties(System.getProperties());
            properties.setProperty(MAIL_TRANSPORT_PROTOCOL, SMTP);
            if (EmailUtils.isEmpty(this.hostName)) {
                this.hostName = properties.getProperty(MAIL_HOST);
            }
            if (EmailUtils.isEmpty(this.hostName)) {
                throw new EmailException("Cannot find valid hostname for mail session");
            }
            properties.setProperty(MAIL_PORT, this.smtpPort);
            properties.setProperty(MAIL_HOST, this.hostName);
            properties.setProperty(MAIL_DEBUG, String.valueOf(this.debug));
            if (this.authenticator != null) {
                properties.setProperty(MAIL_TRANSPORT_TLS, this.tls ? "true" : "false");
                properties.setProperty(MAIL_SMTP_AUTH, "true");
            }
            if (this.ssl) {
                properties.setProperty(MAIL_PORT, this.sslSmtpPort);
                properties.setProperty(MAIL_SMTP_SOCKET_FACTORY_PORT, this.sslSmtpPort);
                properties.setProperty(MAIL_SMTP_SOCKET_FACTORY_CLASS, "javax.net.ssl.SSLSocketFactory");
                properties.setProperty(MAIL_SMTP_SOCKET_FACTORY_FALLBACK, "false");
            }
            if (this.bounceAddress != null) {
                properties.setProperty(MAIL_SMTP_FROM, this.bounceAddress);
            }
            this.session = Session.getInstance((Properties)properties, (Authenticator)this.authenticator);
        }
        return this.session;
    }

    private InternetAddress createInternetAddress(String email, String name, String charsetName) throws EmailException {
        InternetAddress address = null;
        try {
            address = new InternetAddress(email);
            if (EmailUtils.isEmpty(name)) {
                name = email;
            }
            if (EmailUtils.isEmpty(charsetName)) {
                address.setPersonal(name);
            } else {
                Charset set = Charset.forName(charsetName);
                address.setPersonal(name, set.name());
            }
            address.validate();
        }
        catch (AddressException e) {
            throw new EmailException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new EmailException(e);
        }
        return address;
    }

    public Email setFrom(String email) throws EmailException {
        return this.setFrom(email, null);
    }

    public Email setFrom(String email, String name) throws EmailException {
        return this.setFrom(email, name, null);
    }

    public Email setFrom(String email, String name, String charset) throws EmailException {
        this.fromAddress = this.createInternetAddress(email, name, charset);
        return this;
    }

    public Email addTo(String email) throws EmailException {
        return this.addTo(email, null);
    }

    public Email addTo(String email, String name) throws EmailException {
        return this.addTo(email, name, null);
    }

    public Email addTo(String email, String name, String charset) throws EmailException {
        this.toList.add(this.createInternetAddress(email, name, charset));
        return this;
    }

    public Email setTo(Collection aCollection) throws EmailException {
        if (aCollection == null || aCollection.isEmpty()) {
            throw new EmailException("Address List provided was invalid");
        }
        this.toList = new ArrayList(aCollection);
        return this;
    }

    public Email addCc(String email) throws EmailException {
        return this.addCc(email, null);
    }

    public Email addCc(String email, String name) throws EmailException {
        return this.addCc(email, name, null);
    }

    public Email addCc(String email, String name, String charset) throws EmailException {
        this.ccList.add(this.createInternetAddress(email, name, charset));
        return this;
    }

    public Email setCc(Collection aCollection) throws EmailException {
        if (aCollection == null || aCollection.isEmpty()) {
            throw new EmailException("Address List provided was invalid");
        }
        this.ccList = new ArrayList(aCollection);
        return this;
    }

    public Email addBcc(String email) throws EmailException {
        return this.addBcc(email, null);
    }

    public Email addBcc(String email, String name) throws EmailException {
        return this.addBcc(email, name, null);
    }

    public Email addBcc(String email, String name, String charset) throws EmailException {
        this.bccList.add(this.createInternetAddress(email, name, charset));
        return this;
    }

    public Email setBcc(Collection aCollection) throws EmailException {
        if (aCollection == null || aCollection.isEmpty()) {
            throw new EmailException("Address List provided was invalid");
        }
        this.bccList = new ArrayList(aCollection);
        return this;
    }

    public Email addReplyTo(String email) throws EmailException {
        return this.addReplyTo(email, null);
    }

    public Email addReplyTo(String email, String name) throws EmailException {
        return this.addReplyTo(email, name, null);
    }

    public Email addReplyTo(String email, String name, String charset) throws EmailException {
        this.replyList.add(this.createInternetAddress(email, name, charset));
        return this;
    }

    public Email setReplyTo(Collection aCollection) throws EmailException {
        if (aCollection == null || aCollection.isEmpty()) {
            throw new EmailException("Address List provided was invalid");
        }
        this.replyList = new ArrayList(aCollection);
        return this;
    }

    public void setHeaders(Map map) {
        Iterator iterKeyBad = map.entrySet().iterator();
        while (iterKeyBad.hasNext()) {
            Map.Entry entry = iterKeyBad.next();
            String strName = (String)entry.getKey();
            String strValue = (String)entry.getValue();
            if (EmailUtils.isEmpty(strName)) {
                throw new IllegalArgumentException("name can not be null");
            }
            if (!EmailUtils.isEmpty(strValue)) continue;
            throw new IllegalArgumentException("value can not be null");
        }
        this.headers = map;
    }

    public void addHeader(String name, String value) {
        if (EmailUtils.isEmpty(name)) {
            throw new IllegalArgumentException("name can not be null");
        }
        if (EmailUtils.isEmpty(value)) {
            throw new IllegalArgumentException("value can not be null");
        }
        this.headers.put(name, value);
    }

    public Email setSubject(String aSubject) {
        this.subject = aSubject;
        return this;
    }

    public Email setBounceAddress(String email) {
        this.bounceAddress = email;
        return this;
    }

    public abstract Email setMsg(String var1) throws EmailException;

    public void buildMimeMessage() throws EmailException {
        try {
            this.getMailSession();
            this.message = new MimeMessage(this.session);
            if (EmailUtils.isNotEmpty(this.subject)) {
                if (EmailUtils.isNotEmpty(this.charset)) {
                    this.message.setSubject(this.subject, this.charset);
                } else {
                    this.message.setSubject(this.subject);
                }
            }
            if (this.content != null) {
                this.message.setContent(this.content, this.contentType);
            } else if (this.emailBody != null) {
                this.message.setContent((Multipart)this.emailBody);
            } else {
                this.message.setContent((Object)"", TEXT_PLAIN);
            }
            if (this.fromAddress != null) {
                this.message.setFrom((Address)this.fromAddress);
            } else if (this.session.getProperty(MAIL_SMTP_FROM) == null) {
                throw new EmailException("From address required");
            }
            if (this.toList.size() + this.ccList.size() + this.bccList.size() == 0) {
                throw new EmailException("At least one receiver address required");
            }
            if (this.toList.size() > 0) {
                this.message.setRecipients(Message.RecipientType.TO, (Address[])this.toInternetAddressArray(this.toList));
            }
            if (this.ccList.size() > 0) {
                this.message.setRecipients(Message.RecipientType.CC, (Address[])this.toInternetAddressArray(this.ccList));
            }
            if (this.bccList.size() > 0) {
                this.message.setRecipients(Message.RecipientType.BCC, (Address[])this.toInternetAddressArray(this.bccList));
            }
            if (this.replyList.size() > 0) {
                this.message.setReplyTo((Address[])this.toInternetAddressArray(this.replyList));
            }
            if (this.headers.size() > 0) {
                Iterator iterHeaderKeys = this.headers.keySet().iterator();
                while (iterHeaderKeys.hasNext()) {
                    String name = (String)iterHeaderKeys.next();
                    String value = (String)this.headers.get(name);
                    this.message.addHeader(name, value);
                }
            }
            if (this.message.getSentDate() == null) {
                this.message.setSentDate(this.getSentDate());
            }
            if (this.popBeforeSmtp) {
                Store store = this.session.getStore("pop3");
                store.connect(this.popHost, this.popUsername, this.popPassword);
            }
        }
        catch (MessagingException me) {
            throw new EmailException(me);
        }
    }

    public String sendMimeMessage() throws EmailException {
        EmailUtils.notNull(this.message, "message");
        try {
            Transport.send((Message)this.message);
            return this.message.getMessageID();
        }
        catch (Throwable t) {
            String msg = "Sending the email to the following server failed : " + this.getHostName() + ":" + this.getSmtpPort();
            throw new EmailException(msg, t);
        }
    }

    public MimeMessage getMimeMessage() {
        return this.message;
    }

    public String send() throws EmailException {
        this.buildMimeMessage();
        return this.sendMimeMessage();
    }

    public void setSentDate(Date date) {
        this.sentDate = date;
    }

    public Date getSentDate() {
        if (this.sentDate == null) {
            return new Date();
        }
        return this.sentDate;
    }

    public String getSubject() {
        return this.subject;
    }

    public InternetAddress getFromAddress() {
        return this.fromAddress;
    }

    public String getHostName() {
        if (EmailUtils.isNotEmpty(this.hostName)) {
            return this.hostName;
        }
        return this.session.getProperty(MAIL_HOST);
    }

    public String getSmtpPort() {
        if (EmailUtils.isNotEmpty(this.smtpPort)) {
            return this.smtpPort;
        }
        return this.session.getProperty(MAIL_PORT);
    }

    public boolean isTLS() {
        return this.tls;
    }

    protected InternetAddress[] toInternetAddressArray(List list) {
        InternetAddress[] ia = list.toArray(new InternetAddress[list.size()]);
        return ia;
    }

    public void setPopBeforeSmtp(boolean newPopBeforeSmtp, String newPopHost, String newPopUsername, String newPopPassword) {
        this.popBeforeSmtp = newPopBeforeSmtp;
        this.popHost = newPopHost;
        this.popUsername = newPopUsername;
        this.popPassword = newPopPassword;
    }

    public boolean isSSL() {
        return this.ssl;
    }

    public void setSSL(boolean ssl) {
        this.ssl = ssl;
    }

    public String getSslSmtpPort() {
        if (EmailUtils.isNotEmpty(this.sslSmtpPort)) {
            return this.sslSmtpPort;
        }
        return this.session.getProperty(MAIL_SMTP_SOCKET_FACTORY_PORT);
    }

    public void setSslSmtpPort(String sslSmtpPort) {
        this.sslSmtpPort = sslSmtpPort;
    }
}

