/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.pythonpathconf;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.EnvironmentTab;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.python.copiedfromeclipsesrc.JDTNotAvailableException;
import org.python.copiedfromeclipsesrc.PythonListEditor;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.runners.SimpleJythonRunner;
import org.python.pydev.ui.dialogs.InterpreterInputDialog;
import org.python.pydev.ui.filetypes.FileTypesPreferencesPage;
import org.python.pydev.ui.pythonpathconf.InterpreterInfo;
import org.python.pydev.ui.pythonpathconf.MyEnvWorkingCopy;
import org.python.pydev.ui.pythonpathconf.ObtainInterpreterInfoOperation;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInterpreterEditor
extends PythonListEditor {
    private IInterpreterManager interpreterManager;
    private Tree treeWithLibs;
    private Tree treeWithInterpreters;
    private Image imageSystemLibRoot;
    private Image imageSystemLib;
    private Composite box;
    private Button addBtForcedBuiltins;
    private Button removeBtForcedBuiltins;
    private SelectionListener selectionListenerOthers;
    private boolean changed;
    private org.eclipse.swt.widgets.List listBuiltins;
    private Composite boxSystem;
    private Button addBtSystemFolder;
    private Button removeBtSystemFolder;
    private Button addBtSystemJar;
    private SelectionListener selectionListenerSystem;
    private Map<String, IInterpreterInfo> nameToInfo = new HashMap<String, IInterpreterInfo>();
    protected TabFolder tabFolder;
    private EnvironmentTab environmentTab;
    private MyEnvWorkingCopy workingCopy = new MyEnvWorkingCopy();
    private static String lastDirectoryDialogPath = null;
    private static String lastFileDialogPath = null;

    public abstract String[] getInterpreterFilterExtensions();

    protected abstract Tuple<String, String> getAutoNewInput();

    public IInterpreterInfo[] getExesList() {
        TreeItem[] items = this.treeWithInterpreters.getItems();
        ArrayList<IInterpreterInfo> infos = new ArrayList<IInterpreterInfo>();
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem exe = treeItemArray[n2];
            IInterpreterInfo info = this.nameToInfo.get(this.getNameFromTreeItem(exe));
            if (info == null) {
                PydevPlugin.log(new StringBuffer("Didn't expect interpreter info to be null in the memory: ").append(exe).toString());
            } else {
                infos.add(info);
            }
            ++n2;
        }
        return infos.toArray(new IInterpreterInfo[infos.size()]);
    }

    protected String getNameFromTreeItem(TreeItem treeItem) {
        return treeItem.getText(0);
    }

    protected AbstractInterpreterEditor(String preferenceName, String labelText, Composite parent, IInterpreterManager interpreterManager) {
        this.init(preferenceName, labelText);
        this.interpreterManager = interpreterManager;
        IInterpreterInfo[] interpreters = this.interpreterManager.getInterpreterInfos();
        this.nameToInfo.clear();
        IInterpreterInfo[] iInterpreterInfoArray = interpreters;
        int n = interpreters.length;
        int n2 = 0;
        while (n2 < n) {
            IInterpreterInfo interpreterInfo = iInterpreterInfoArray[n2];
            if (interpreterInfo != null) {
                this.nameToInfo.put(interpreterInfo.getName(), interpreterInfo.makeCopy());
            }
            ++n2;
        }
        if (USE_ICONS) {
            this.imageSystemLibRoot = PydevPlugin.getImageCache().get("icons/library_obj.gif");
            this.imageSystemLib = PydevPlugin.getImageCache().get("icons/jar_l_obj.gif");
        }
        this.createControl(parent);
        this.updateTree();
    }

    protected void createControl(Composite parent) {
        super.createControl(parent);
        this.treeWithInterpreters = this.getListControl(parent);
        this.treeWithInterpreters.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractInterpreterEditor.this.updateTree();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                AbstractInterpreterEditor.this.updateTree();
            }
        });
        this.treeWithInterpreters.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000B) {
                    AbstractInterpreterEditor.this.renameSelection();
                }
            }
        });
        this.treeWithInterpreters.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                AbstractInterpreterEditor.this.renameSelection();
            }
        });
    }

    private void renameSelection() {
        int index = this.getSelectionIndex();
        if (index >= 0) {
            String newName;
            TreeItem curr = this.treeWithInterpreters.getItem(index);
            final String initialName = this.getNameFromTreeItem(curr);
            InputDialog d = new InputDialog(this.getShell(), "New name", "Please specify the new name of the interpreter.", initialName, new IInputValidator(){

                public String isValid(String newText) {
                    if (newText == null || newText.trim().equals("")) {
                        return "Please specify a non-empty name.";
                    }
                    if ((newText = newText.trim()).equals(initialName)) {
                        return null;
                    }
                    return AbstractInterpreterEditor.this.getDuplicatedMessageError(newText, null);
                }
            });
            int retCode = d.open();
            if (retCode == 0 && !(newName = d.getValue().trim()).equals(initialName)) {
                IInterpreterInfo info = this.nameToInfo.get(initialName);
                info.setName(newName);
                curr.setText(0, newName);
                this.nameToInfo.remove(initialName);
                this.nameToInfo.put(newName, info);
            }
        }
    }

    private Tree getTreeLibsControl(Composite parent) {
        if (this.treeWithLibs == null) {
            this.treeWithLibs = new Tree(parent, 2050);
            this.treeWithLibs.setFont(parent.getFont());
            this.treeWithLibs.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    AbstractInterpreterEditor.this.treeWithLibs = null;
                }
            });
        }
        return this.treeWithLibs;
    }

    @Override
    protected void removePressed() {
        super.removePressed();
        this.updateTree();
    }

    @Override
    protected void disposeOfTreeItem(TreeItem t) {
        String nameFromTreeItem = this.getNameFromTreeItem(t);
        this.nameToInfo.remove(nameFromTreeItem);
        super.disposeOfTreeItem(t);
    }

    @Override
    protected void addPressed() {
        super.addPressed();
        this.updateTree();
    }

    @Override
    protected void upPressed() {
        super.upPressed();
    }

    @Override
    protected void downPressed() {
        super.downPressed();
    }

    @Override
    protected void adjustForNumColumns(int numColumns) {
        super.adjustForNumColumns(numColumns);
        ((GridData)this.tabFolder.getLayoutData()).horizontalSpan = numColumns;
    }

    @Override
    protected void doFillIntoGrid(Composite parent, int numColumns) {
        super.doFillIntoGrid(parent, numColumns);
        GridData gd = new GridData();
        this.tabFolder = new TabFolder(parent, 0);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = numColumns;
        this.tabFolder.setLayoutData((Object)gd);
        this.createTreeLibsControlTab();
        this.createForcedBuiltinsTab();
        this.createEnvironmentVariablesTab();
    }

    private void createEnvironmentVariablesTab() {
        Composite composite;
        TabItem tabItem = new TabItem(this.tabFolder, 0);
        tabItem.setText("Environment");
        Composite parent = composite = new Composite((Composite)this.tabFolder, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.environmentTab = new EnvironmentTab(){

            protected void createAppendReplace(Composite parent) {
                super.createAppendReplace(parent);
                this.appendEnvironment.setVisible(false);
                this.replaceEnvironment.setVisible(false);
            }
        };
        this.environmentTab.createControl(parent);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.environmentTab.getControl().setLayoutData((Object)gd);
        tabItem.setControl((Control)composite);
    }

    private void createTreeLibsControlTab() {
        Composite composite;
        TabItem tabItem = new TabItem(this.tabFolder, 0);
        tabItem.setText("Libraries");
        Composite parent = composite = new Composite((Composite)this.tabFolder, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Label l1 = new Label(parent, 0);
        l1.setText("System PYTHONPATH");
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        l1.setLayoutData((Object)gd);
        this.treeWithLibs = this.getTreeLibsControl(parent);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 200;
        this.treeWithLibs.setLayoutData((Object)gd);
        Composite control = this.getButtonBoxControlSystem(parent);
        gd = new GridData();
        gd.verticalAlignment = 1;
        control.setLayoutData((Object)gd);
        tabItem.setControl((Control)composite);
    }

    private void createForcedBuiltinsTab() {
        Composite composite;
        TabItem tabItem = new TabItem(this.tabFolder, 0);
        tabItem.setText("Forced Builtins");
        Composite parent = composite = new Composite((Composite)this.tabFolder, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Link l2 = new Link(parent, 0);
        l2.setText("Forced Builtins (check <a>Manual</a> for more info).");
        l2.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)"http://fabioz.com/pydev/manual_101_interpreter.html");
            }
        });
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        l2.setLayoutData((Object)gd);
        org.eclipse.swt.widgets.List list = this.getBuiltinsListControl(parent);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 200;
        list.setLayoutData((Object)gd);
        Composite control = this.getButtonBoxControlOthers(parent);
        gd = new GridData();
        gd.verticalAlignment = 1;
        control.setLayoutData((Object)gd);
        tabItem.setControl((Control)composite);
    }

    private org.eclipse.swt.widgets.List getBuiltinsListControl(Composite parent) {
        if (this.listBuiltins == null) {
            this.listBuiltins = new org.eclipse.swt.widgets.List(parent, 2818);
            this.listBuiltins.setFont(parent.getFont());
            this.listBuiltins.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    AbstractInterpreterEditor.this.listBuiltins = null;
                }
            });
        } else {
            this.checkParent((Control)this.listBuiltins, parent);
        }
        return this.listBuiltins;
    }

    public Composite getButtonBoxControlSystem(Composite parent) {
        if (this.boxSystem == null) {
            this.boxSystem = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            this.boxSystem.setLayout((Layout)layout);
            this.addBtSystemFolder = this.createBt(this.boxSystem, "New Folder", this.getSelectionListenerSystem());
            this.addBtSystemJar = this.interpreterManager.isJython() ? this.createBt(this.boxSystem, "New Jar/Zip(s)", this.getSelectionListenerSystem()) : this.createBt(this.boxSystem, "New Egg/Zip(s)", this.getSelectionListenerSystem());
            this.removeBtSystemFolder = this.createBt(this.boxSystem, "ListEditor.remove", this.getSelectionListenerSystem());
            this.boxSystem.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    AbstractInterpreterEditor.this.addBtSystemJar = null;
                    AbstractInterpreterEditor.this.addBtSystemFolder = null;
                    AbstractInterpreterEditor.this.removeBtSystemFolder = null;
                    AbstractInterpreterEditor.this.boxSystem = null;
                }
            });
        } else {
            this.checkParent((Control)this.boxSystem, parent);
        }
        return this.boxSystem;
    }

    public Composite getButtonBoxControlOthers(Composite parent) {
        if (this.box == null) {
            this.box = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            this.box.setLayout((Layout)layout);
            this.addBtForcedBuiltins = this.createBt(this.box, "ListEditor.add", this.getSelectionListenerForcedBuiltins());
            this.removeBtForcedBuiltins = this.createBt(this.box, "ListEditor.remove", this.getSelectionListenerForcedBuiltins());
            this.box.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    AbstractInterpreterEditor.this.addBtForcedBuiltins = null;
                    AbstractInterpreterEditor.this.removeBtForcedBuiltins = null;
                    AbstractInterpreterEditor.this.box = null;
                }
            });
        } else {
            this.checkParent((Control)this.box, parent);
        }
        return this.box;
    }

    private SelectionListener getSelectionListenerForcedBuiltins() {
        if (this.selectionListenerOthers == null) {
            this.selectionListenerOthers = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Widget widget = event.widget;
                    if (widget == AbstractInterpreterEditor.this.addBtForcedBuiltins) {
                        AbstractInterpreterEditor.this.addForcedBuiltins();
                    } else if (widget == AbstractInterpreterEditor.this.removeBtForcedBuiltins) {
                        AbstractInterpreterEditor.this.removeForcedBuiltins();
                    }
                }
            };
        }
        return this.selectionListenerOthers;
    }

    private SelectionListener getSelectionListenerSystem() {
        if (this.selectionListenerSystem == null) {
            this.selectionListenerSystem = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (AbstractInterpreterEditor.this.treeWithInterpreters.getSelectionCount() == 1) {
                        TreeItem[] selection = AbstractInterpreterEditor.this.treeWithInterpreters.getSelection();
                        InterpreterInfo info = (InterpreterInfo)AbstractInterpreterEditor.this.nameToInfo.get(AbstractInterpreterEditor.this.getNameFromTreeItem(selection[0]));
                        Widget widget = event.widget;
                        if (widget == AbstractInterpreterEditor.this.addBtSystemFolder) {
                            DirectoryDialog dialog = new DirectoryDialog(AbstractInterpreterEditor.this.getShell());
                            dialog.setFilterPath(lastDirectoryDialogPath);
                            String filePath = dialog.open();
                            if (filePath != null) {
                                lastDirectoryDialogPath = filePath;
                                info.libs.add(filePath);
                            }
                        } else if (widget == AbstractInterpreterEditor.this.addBtSystemJar) {
                            FileDialog dialog = new FileDialog(AbstractInterpreterEditor.this.getShell(), 32770);
                            if (AbstractInterpreterEditor.this.interpreterManager.isJython()) {
                                dialog.setFilterExtensions(FileTypesPreferencesPage.getWildcardJythonValidZipFiles());
                            } else {
                                dialog.setFilterExtensions(FileTypesPreferencesPage.getWildcardPythonValidZipFiles());
                            }
                            dialog.setFilterPath(lastFileDialogPath);
                            String filePath = dialog.open();
                            if (filePath != null) {
                                String[] fileNames;
                                lastFileDialogPath = filePath;
                                File filePath1 = new File(filePath);
                                String dir = filePath1.getParent();
                                String[] stringArray = fileNames = dialog.getFileNames();
                                int n = fileNames.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String f = stringArray[n2];
                                    f = String.valueOf(dir) + File.separatorChar + f;
                                    if (!info.libs.contains(f)) {
                                        info.libs.add(f);
                                    }
                                    ++n2;
                                }
                            }
                        } else if (widget == AbstractInterpreterEditor.this.removeBtSystemFolder) {
                            TreeItem[] libSelection = AbstractInterpreterEditor.this.treeWithLibs.getSelection();
                            int i = 0;
                            while (i < libSelection.length) {
                                TreeItem s = libSelection[i];
                                String text = s.getText();
                                info.libs.remove(text);
                                ++i;
                            }
                        }
                        AbstractInterpreterEditor.this.updateTree();
                    }
                }
            };
        }
        return this.selectionListenerSystem;
    }

    protected void addForcedBuiltins() {
        if (this.treeWithInterpreters.getSelectionCount() == 1) {
            TreeItem[] selection = this.treeWithInterpreters.getSelection();
            InterpreterInfo info = (InterpreterInfo)this.nameToInfo.get(this.getNameFromTreeItem(selection[0]));
            IInputValidator validator = new IInputValidator(){

                public String isValid(String newText) {
                    char[] cArray = newText.toCharArray();
                    int n = cArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        char c = cArray[n2];
                        if (!Character.isJavaIdentifierPart(c) && c != ' ' && c != ',' && c != '.') {
                            return "Can only accept valid python module names (char: '" + c + "' not accepted)";
                        }
                        ++n2;
                    }
                    return null;
                }
            };
            InputDialog d = new InputDialog(this.getShell(), "Builtin to add", "Builtin to add (comma separated)", "", validator);
            int retCode = d.open();
            if (retCode == 0) {
                String builtins = d.getValue();
                List split = StringUtils.splitAndRemoveEmptyTrimmed((String)builtins, (char)',');
                for (String string : split) {
                    String trimmed = string.trim();
                    if (trimmed.length() <= 0) continue;
                    info.addForcedLib(trimmed);
                }
            }
        }
        this.updateTree();
    }

    protected void removeForcedBuiltins() {
        if (this.treeWithInterpreters.getSelectionCount() == 1) {
            TreeItem[] interpreterSelection = this.treeWithInterpreters.getSelection();
            String[] builtins = this.listBuiltins.getSelection();
            InterpreterInfo info = (InterpreterInfo)this.nameToInfo.get(this.getNameFromTreeItem(interpreterSelection[0]));
            String[] stringArray = builtins;
            int n = builtins.length;
            int n2 = 0;
            while (n2 < n) {
                String builtin = stringArray[n2];
                info.removeForcedLib(builtin);
                ++n2;
            }
        }
        this.updateTree();
    }

    private Button createBt(Composite parent, String key, SelectionListener listenerToAdd) {
        Button button = new Button(parent, 8);
        button.setText(JFaceResources.getString((String)key));
        button.setFont(parent.getFont());
        GridData data = new GridData(768);
        int widthHint = this.convertHorizontalDLUsToPixels((Control)button, 61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        button.addSelectionListener(listenerToAdd);
        return button;
    }

    private void updateTree() {
        int index = this.getSelectionIndex();
        if (index >= 0) {
            TreeItem item = this.treeWithInterpreters.getItem(index);
            this.fillPathItemsFromName(this.getNameFromTreeItem(item));
        } else {
            this.fillPathItemsFromName(null);
            if (this.treeWithInterpreters.getItemCount() > 0) {
                this.treeWithInterpreters.select(this.treeWithInterpreters.getItem(0));
                this.selectionChanged();
                this.fillPathItemsFromName(this.getNameFromTreeItem(this.treeWithInterpreters.getItem(0)));
            }
        }
    }

    private void fillPathItemsFromName(String name) {
        this.treeWithLibs.removeAll();
        this.listBuiltins.removeAll();
        if (this.workingCopy.getInfo() != null) {
            this.environmentTab.performApply((ILaunchConfigurationWorkingCopy)this.workingCopy);
        }
        if (name != null) {
            TreeItem item = new TreeItem(this.treeWithLibs, 0);
            item.setText("System libs");
            item.setImage(this.imageSystemLibRoot);
            InterpreterInfo info = (InterpreterInfo)this.nameToInfo.get(name);
            if (info == null) {
                PydevPlugin.log(new StringBuffer("Didn't expect interpreter info to be null in the memory: ").append(name).toString());
            } else {
                Iterator<String> iter = info.libs.iterator();
                while (iter.hasNext()) {
                    TreeItem subItem = new TreeItem(item, 0);
                    subItem.setText(iter.next());
                    subItem.setImage(this.imageSystemLib);
                }
                item.setExpanded(true);
                iter = info.forcedLibsIterator();
                while (iter.hasNext()) {
                    this.listBuiltins.add(iter.next());
                }
            }
            this.workingCopy.setInfo(info);
            this.environmentTab.initializeFrom((ILaunchConfiguration)this.workingCopy);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Tuple<String, String> getNewInputObject(boolean autoConfig) {
        CharArrayWriter charWriter = new CharArrayWriter();
        PrintWriter logger = new PrintWriter(charWriter);
        logger.println("Information about process of adding new interpreter:");
        try {
            Tuple<String, String> interpreterNameAndExecutable = null;
            if (autoConfig) {
                interpreterNameAndExecutable = this.getAutoNewInput();
                if (interpreterNameAndExecutable == null) {
                    this.reportAutoConfigProblem(null);
                    return null;
                }
            } else {
                InterpreterInputDialog dialog = new InterpreterInputDialog(this.getShell(), "Select interpreter", "Enter the name and executable of your interpreter", this);
                logger.println("- Opening dialog to request executable (or jar).");
                int result = dialog.open();
                if (result != 0) return null;
                interpreterNameAndExecutable = dialog.getKeyAndValueEntered();
                if (interpreterNameAndExecutable == null) {
                    ErrorDialog.openError((Shell)this.getShell(), (String)"Error getting info on interpreter", (String)"interpreterNameAndExecutable == null", (IStatus)PydevPlugin.makeStatus(4, "interpreterNameAndExecutable == null", new RuntimeException()));
                    return null;
                }
                String error = this.getDuplicatedMessageError((String)interpreterNameAndExecutable.o1, (String)interpreterNameAndExecutable.o2);
                if (error != null) {
                    ErrorDialog.openError((Shell)this.getShell(), (String)"Error getting info on interpreter", (String)error, (IStatus)PydevPlugin.makeStatus(4, "Duplicated interpreter information", new RuntimeException()));
                    return null;
                }
            }
            if (interpreterNameAndExecutable == null) {
                logger.println("- The file chosen was null (returning null).");
                return null;
            }
            logger.println(new StringBuffer("- Chosen interpreter (name and file):'").append(interpreterNameAndExecutable).toString());
            if (((String)interpreterNameAndExecutable.o2).trim().length() == 0) {
                logger.println("- When trimmed, the chosen file was empty (returning null).");
                return null;
            }
            if (interpreterNameAndExecutable == null) return null;
            if (interpreterNameAndExecutable.o2 == null) return null;
            logger.println(new StringBuffer("- Ok, file is non-null. Getting info on:").append((String)interpreterNameAndExecutable.o2).toString());
            ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(this.getShell());
            monitorDialog.setBlockOnOpen(false);
            ObtainInterpreterInfoOperation operation = new ObtainInterpreterInfoOperation((String)interpreterNameAndExecutable.o2, logger, this.interpreterManager);
            monitorDialog.run(true, false, (IRunnableWithProgress)operation);
            if (operation.e != null) {
                logger.println("- Some error happened while getting info on the interpreter:");
                operation.e.printStackTrace(logger);
                if (operation.e instanceof SimpleJythonRunner.JavaNotConfiguredException) {
                    SimpleJythonRunner.JavaNotConfiguredException javaNotConfiguredException = (SimpleJythonRunner.JavaNotConfiguredException)operation.e;
                    ErrorDialog.openError((Shell)this.getShell(), (String)"Error getting info on interpreter", (String)javaNotConfiguredException.getMessage(), (IStatus)PydevPlugin.makeStatus(4, "Java vm not configured.\n", javaNotConfiguredException));
                    throw operation.e;
                }
                if (operation.e instanceof JDTNotAvailableException) {
                    JDTNotAvailableException noJdtException = (JDTNotAvailableException)operation.e;
                    ErrorDialog.openError((Shell)this.getShell(), (String)"Error getting info on interpreter", (String)noJdtException.getMessage(), (IStatus)PydevPlugin.makeStatus(4, "JDT not available.\n", noJdtException));
                    throw operation.e;
                }
                if (autoConfig) {
                    this.reportAutoConfigProblem(operation.e);
                    throw operation.e;
                }
                String errorMsg = "Some error happened while getting info on the interpreter.\n\nCommon reasons include:\n\n- Specifying an invalid interpreter(usually a link to the actual interpreter on Mac or Linux)\n- Having spaces in your Eclipse installation path.";
                ErrorDialog.openError((Shell)this.getShell(), (String)"Error getting info on interpreter", (String)errorMsg, (IStatus)PydevPlugin.makeStatus(4, "Check your error log for more details.\n\nMore info can also be found at the bug report: http://sourceforge.net/tracker/index.php?func=detail&aid=1523582&group_id=85796&atid=577329", operation.e));
                throw operation.e;
            }
            if (operation.result == null) return null;
            operation.result.setName((String)interpreterNameAndExecutable.o1);
            logger.println(new StringBuffer("- Success getting the info. Result:").append(operation.result).toString());
            this.nameToInfo.put(operation.result.getName(), operation.result.makeCopy());
            Tuple tuple = new Tuple((Object)operation.result.getName(), (Object)operation.result.executableOrJar);
            return tuple;
        }
        catch (Exception e) {
            PydevPlugin.log(e);
            return null;
        }
        finally {
            PydevPlugin.logInfo(charWriter.toString());
        }
    }

    public String getUniqueInterpreterName(String expectedName) {
        String additional = "";
        int i = 0;
        while (this.getDuplicatedMessageError(new StringBuffer(String.valueOf(expectedName)).append(additional).toString(), null) != null) {
            additional = String.valueOf(++i);
        }
        return new StringBuffer(String.valueOf(expectedName)).append(additional).toString();
    }

    public String getDuplicatedMessageError(String interpreterName, String executableOrJar) {
        String error = null;
        if (interpreterName != null && this.nameToInfo.containsKey(interpreterName = interpreterName.trim())) {
            error = new StringBuffer("An interpreter is already configured with the name: ").append(interpreterName).toString();
        }
        if (executableOrJar != null) {
            executableOrJar = executableOrJar.trim();
            for (IInterpreterInfo info : this.nameToInfo.values()) {
                if (!info.getExecutableOrJar().trim().equals(executableOrJar)) continue;
                error = new StringBuffer("An interpreter is already configured with the path: ").append(executableOrJar).toString();
            }
        }
        return error;
    }

    private void reportAutoConfigProblem(Exception e) {
        String errorMsg = "Unable to auto-configure the interpreter.\nPlease create a new interpreter using the 'New' button.";
        ErrorDialog.openError((Shell)this.getShell(), (String)"Unable to auto-configure.", (String)errorMsg, (IStatus)PydevPlugin.makeStatus(4, "Unable to gather the needed info from the system.", e));
    }

    @Override
    protected void doStore() {
        this.updateTree();
        String newStringToPersist = this.createListFromInterpreterInfo(this.getExesList());
        String oldStringToPersist = this.createListFromInterpreterInfo(this.interpreterManager.getInterpreterInfos());
        if (!newStringToPersist.equals(oldStringToPersist)) {
            this.interpreterManager.setPersistedString(newStringToPersist);
            this.changed = true;
        } else {
            this.changed = false;
        }
    }

    @Override
    protected void doLoad() {
        if (this.treeWithInterpreters != null) {
            String s = this.interpreterManager.getPersistedString();
            IInterpreterInfo[] array = this.parseStringToInfo(s);
            this.nameToInfo.clear();
            int i = 0;
            while (i < array.length) {
                IInterpreterInfo interpreterInfo = array[i];
                this.createInterpreterItem(interpreterInfo.getName(), interpreterInfo.getExecutableOrJar());
                this.nameToInfo.put(interpreterInfo.getName(), interpreterInfo.makeCopy());
                ++i;
            }
        }
        this.updateTree();
    }

    public String getPreferenceName() {
        throw new RuntimeException("The preferences should be stored/gotten from the IInterpreterManager, and not directly.");
    }

    protected String createListFromInterpreterInfo(IInterpreterInfo[] executables) {
        return this.interpreterManager.getStringToPersist(executables);
    }

    protected IInterpreterInfo[] parseStringToInfo(String stringList) {
        return this.interpreterManager.getInterpretersFromPersistedString(stringList);
    }

    @Override
    protected void doLoadDefault() {
    }

    public boolean checkChangedAndMarkUnchanged() {
        boolean ret = this.changed;
        this.changed = false;
        return ret;
    }
}

