/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jumpto.type;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.netbeans.api.jumpto.type.TypeBrowser;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.jumpto.file.LazyListModel;
import org.netbeans.modules.jumpto.type.GoToPanel;
import org.netbeans.modules.jumpto.type.Models;
import org.netbeans.modules.jumpto.type.TypeProviderAccessor;
import org.netbeans.modules.jumpto.type.UiOptions;
import org.netbeans.spi.jumpto.type.SearchType;
import org.netbeans.spi.jumpto.type.TypeDescriptor;
import org.netbeans.spi.jumpto.type.TypeProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public class GoToTypeAction
extends AbstractAction
implements GoToPanel.ContentProvider,
LazyListModel.Filter {
    static final Logger LOGGER = Logger.getLogger(GoToTypeAction.class.getName());
    private SearchType nameKind;
    private static ListModel EMPTY_LIST_MODEL = new DefaultListModel();
    private static final RequestProcessor rp = new RequestProcessor("GoToTypeAction-RequestProcessor", 1);
    private Worker running;
    private RequestProcessor.Task task;
    GoToPanel panel;
    private Dialog dialog;
    private JButton okButton;
    private Collection<? extends TypeProvider> typeProviders;
    private final TypeBrowser.Filter typeFilter;
    private final String title;
    private static Pattern camelCasePattern = Pattern.compile("(?:\\p{javaUpperCase}(?:\\p{javaLowerCase}|\\p{Digit}|\\.|\\$)*){2,}");
    private Dimension initialDimension;

    public GoToTypeAction() {
        this(NbBundle.getMessage(GoToTypeAction.class, (String)"DLG_GoToType"), null, new TypeProvider[0]);
    }

    public GoToTypeAction(String title, TypeBrowser.Filter typeFilter, TypeProvider ... typeProviders) {
        super(NbBundle.getMessage(GoToTypeAction.class, (String)"TXT_GoToType"));
        this.putValue("PopupMenuText", NbBundle.getBundle(GoToTypeAction.class).getString("editor-popup-TXT_GoToType"));
        this.title = title;
        this.typeFilter = typeFilter;
        this.typeProviders = typeProviders.length == 0 ? null : Arrays.asList(typeProviders);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TypeDescriptor typeDescriptor = this.getSelectedType();
        if (typeDescriptor != null) {
            typeDescriptor.open();
        }
    }

    public TypeDescriptor getSelectedType() {
        return this.getSelectedType(true);
    }

    public TypeDescriptor getSelectedType(boolean visible) {
        TypeDescriptor result = null;
        try {
            JEditorPane[] openedPanes;
            EditorCookie ec;
            this.panel = new GoToPanel(this);
            this.dialog = this.createDialog(this.panel);
            Node[] arr = TopComponent.getRegistry().getActivatedNodes();
            String initSearchText = null;
            if (arr.length > 0 && (ec = (EditorCookie)arr[0].getCookie(EditorCookie.class)) != null && (openedPanes = ec.getOpenedPanes()) != null && (initSearchText = Utilities.getSelectionOrIdentifier((JTextComponent)openedPanes[0])) != null && org.openide.util.Utilities.isJavaIdentifier((String)initSearchText)) {
                this.panel.setInitialText(initSearchText);
            }
            this.dialog.setVisible(visible);
            result = this.panel.getSelectedType();
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        return result;
    }

    @Override
    public boolean isEnabled() {
        return OpenProjects.getDefault().getOpenProjects().length > 0;
    }

    @Override
    public boolean accept(Object obj) {
        return this.typeFilter == null ? true : this.typeFilter.accept((TypeDescriptor)obj);
    }

    @Override
    public void scheduleUpdate(Runnable run) {
        SwingUtilities.invokeLater(run);
    }

    @Override
    public ListCellRenderer getListCellRenderer(JList list) {
        return new Renderer(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setListModel(GoToPanel panel, String text) {
        if (this.okButton != null) {
            this.okButton.setEnabled(false);
        }
        if (this.running != null) {
            this.running.cancel();
            this.task.cancel();
            this.running = null;
        }
        if (text == null) {
            panel.setModel(EMPTY_LIST_MODEL);
            return;
        }
        boolean exact = text.endsWith(" ");
        if ((text = text.trim()).length() == 0) {
            panel.setModel(EMPTY_LIST_MODEL);
            return;
        }
        int wildcard = GoToTypeAction.containsWildCard(text);
        this.nameKind = exact ? SearchType.EXACT_NAME : (GoToTypeAction.isAllUpper(text) && text.length() > 1 || GoToTypeAction.isCamelCase(text) ? SearchType.CAMEL_CASE : (wildcard != -1 ? (panel.isCaseSensitive() ? SearchType.REGEXP : SearchType.CASE_INSENSITIVE_REGEXP) : (panel.isCaseSensitive() ? SearchType.PREFIX : SearchType.CASE_INSENSITIVE_PREFIX)));
        GoToTypeAction goToTypeAction = this;
        synchronized (goToTypeAction) {
            this.running = new Worker(text);
            this.task = rp.post((Runnable)this.running, 220);
            if (panel.time != -1L) {
                LOGGER.fine("Worker posted after " + (System.currentTimeMillis() - panel.time) + " ms.");
            }
        }
    }

    @Override
    public void closeDialog() {
        if (this.dialog == null) {
            return;
        }
        this.dialog.setVisible(false);
        this.cleanup();
    }

    @Override
    public boolean hasValidContent() {
        return this.okButton != null && this.okButton.isEnabled();
    }

    public static boolean isAllUpper(String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (Character.isUpperCase(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static int containsWildCard(String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != '?' && text.charAt(i) != '*') continue;
            return i;
        }
        return -1;
    }

    public static boolean isCamelCase(String text) {
        return camelCasePattern.matcher(text).matches();
    }

    private Dialog createDialog(GoToPanel panel) {
        this.okButton = new JButton(NbBundle.getMessage(GoToTypeAction.class, (String)"CTL_OK"));
        this.okButton.getAccessibleContext().setAccessibleDescription(this.okButton.getText());
        this.okButton.setEnabled(false);
        panel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GoToTypeAction.class, (String)"AN_GoToType"));
        panel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GoToTypeAction.class, (String)"AD_GoToType"));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)panel, this.title, true, new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION}, (Object)this.okButton, 0, HelpCtx.DEFAULT_HELP, (ActionListener)new DialogButtonListener(panel));
        dialogDescriptor.setClosingOptions(new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION});
        Dialog d = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        int width = UiOptions.GoToTypeDialog.getWidth();
        int height = UiOptions.GoToTypeDialog.getHeight();
        if (width != -1 && height != -1) {
            d.setPreferredSize(new Dimension(width, height));
        }
        Rectangle r = org.openide.util.Utilities.getUsableScreenBounds();
        int maxW = r.width * 9 / 10;
        int maxH = r.height * 9 / 10;
        Dimension dim = d.getPreferredSize();
        dim.width = Math.min(dim.width, maxW);
        dim.height = Math.min(dim.height, maxH);
        d.setBounds(org.openide.util.Utilities.findCenterBounds((Dimension)dim));
        this.initialDimension = dim;
        d.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                GoToTypeAction.this.cleanup();
            }
        });
        return d;
    }

    private void cleanup() {
        if (this.dialog != null) {
            int currentWidth = this.dialog.getWidth();
            int currentHeight = this.dialog.getHeight();
            if (this.initialDimension != null && (this.initialDimension.width != currentWidth || this.initialDimension.height != currentHeight)) {
                UiOptions.GoToTypeDialog.setHeight(currentHeight);
                UiOptions.GoToTypeDialog.setWidth(currentWidth);
            }
            this.initialDimension = null;
            this.dialog.dispose();
            this.dialog = null;
            if (this.typeProviders != null) {
                for (TypeProvider typeProvider : this.typeProviders) {
                    typeProvider.cleanup();
                }
            }
        }
    }

    final void waitSearchFinished() {
        this.task.waitFinished();
    }

    private int compareStrings(String s1, String s2) {
        if (s1 == null) {
            s1 = "";
        }
        if (s2 == null) {
            s2 = "";
        }
        return s1.compareTo(s2);
    }

    private Profile initializeProfiling() {
        boolean assertsOn = false;
        if (!$assertionsDisabled) {
            assertsOn = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (!assertsOn) {
            return null;
        }
        FileObject fo = FileUtil.getConfigFile((String)"Actions/Profile/org-netbeans-modules-profiler-actions-SelfSamplerAction.instance");
        if (fo == null) {
            return null;
        }
        Action a = (Action)fo.getAttribute("delegate");
        if (a == null) {
            return null;
        }
        Object profiler = a.getValue("logger-jumpto");
        if (profiler == null) {
            return null;
        }
        return new Profile(profiler);
    }

    private class Profile
    implements Runnable {
        Object profiler;
        boolean profiling;
        private final long time = System.currentTimeMillis();

        public Profile(Object profiler) {
            this.profiler = profiler;
            RequestProcessor.getDefault().post((Runnable)this, 3000);
        }

        @Override
        public synchronized void run() {
            this.profiling = true;
            if (this.profiler instanceof Runnable) {
                Runnable r = (Runnable)this.profiler;
                r.run();
            }
        }

        private synchronized void stop() throws Exception {
            long delta = System.currentTimeMillis() - this.time;
            ActionListener ss = (ActionListener)this.profiler;
            this.profiler = null;
            if (!this.profiling) {
                return;
            }
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(out);
                ss.actionPerformed(new ActionEvent(dos, 0, "write"));
                dos.close();
                if (dos.size() > 0) {
                    Object[] params = new Object[]{out.toByteArray(), delta, "GoToType"};
                    Logger.getLogger("org.netbeans.ui.performance").log(Level.CONFIG, "Slowness detected", params);
                } else {
                    LOGGER.log(Level.WARNING, "no snapshot taken");
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private class TypeComparator
    implements Comparator<TypeDescriptor> {
        private TypeComparator() {
        }

        @Override
        public int compare(TypeDescriptor t1, TypeDescriptor t2) {
            int cmpr;
            String t2Name;
            String t1Name;
            Project mainProject = OpenProjects.getDefault().getMainProject();
            String mainProjectname = null;
            if (mainProject != null) {
                mainProjectname = ProjectUtils.getInformation((Project)mainProject).getDisplayName();
            }
            if ((t1Name = t1.getTypeName()).equals(t2Name = t2.getTypeName())) {
                String t1projectName = t1.getProjectName();
                String t2projectName = t2.getProjectName();
                if (t1projectName != null && t2projectName != null) {
                    if (mainProjectname != null && t1projectName.equals(mainProjectname)) {
                        return -1;
                    }
                    if (!t1projectName.equals("") && t2projectName.equals("")) {
                        return -1;
                    }
                    return 1;
                }
            }
            if ((cmpr = GoToTypeAction.this.compareStrings(t1Name, t2Name)) != 0) {
                return cmpr;
            }
            cmpr = GoToTypeAction.this.compareStrings(t1.getOuterName(), t2.getOuterName());
            if (cmpr != 0) {
                return cmpr;
            }
            return GoToTypeAction.this.compareStrings(t1.getContextName(), t2.getContextName());
        }
    }

    private class DialogButtonListener
    implements ActionListener {
        private GoToPanel panel;

        public DialogButtonListener(GoToPanel panel) {
            this.panel = panel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == GoToTypeAction.this.okButton) {
                this.panel.setSelectedType();
            }
        }
    }

    private static class Renderer
    extends DefaultListCellRenderer
    implements ChangeListener {
        private MyPanel rendererComponent;
        private JLabel jlName = new JLabel();
        private JLabel jlPkg = new JLabel();
        private JLabel jlPrj = new JLabel();
        private int DARKER_COLOR_COMPONENT = 5;
        private int LIGHTER_COLOR_COMPONENT = 80;
        private Color fgColor;
        private Color fgColorLighter;
        private Color bgColor;
        private Color bgColorDarker;
        private Color bgSelectionColor;
        private Color fgSelectionColor;
        private JList jList;

        public Renderer(JList list) {
            this.jList = list;
            Container container = list.getParent();
            if (container instanceof JViewport) {
                ((JViewport)container).addChangeListener(this);
                this.stateChanged(new ChangeEvent(container));
            }
            this.rendererComponent = new MyPanel();
            this.rendererComponent.setLayout(new BorderLayout());
            this.rendererComponent.add((Component)this.jlName, "West");
            this.rendererComponent.add((Component)this.jlPkg, "Center");
            this.rendererComponent.add((Component)this.jlPrj, "East");
            this.jlName.setOpaque(false);
            this.jlPkg.setOpaque(false);
            this.jlPrj.setOpaque(false);
            this.jlName.setFont(list.getFont());
            this.jlPkg.setFont(list.getFont());
            this.jlPrj.setFont(list.getFont());
            this.jlPrj.setHorizontalAlignment(4);
            this.jlPrj.setHorizontalTextPosition(2);
            this.fgColor = list.getForeground();
            this.fgColorLighter = new Color(Math.min(255, this.fgColor.getRed() + this.LIGHTER_COLOR_COMPONENT), Math.min(255, this.fgColor.getGreen() + this.LIGHTER_COLOR_COMPONENT), Math.min(255, this.fgColor.getBlue() + this.LIGHTER_COLOR_COMPONENT));
            this.bgColor = list.getBackground();
            this.bgColorDarker = new Color(Math.abs(this.bgColor.getRed() - this.DARKER_COLOR_COMPONENT), Math.abs(this.bgColor.getGreen() - this.DARKER_COLOR_COMPONENT), Math.abs(this.bgColor.getBlue() - this.DARKER_COLOR_COMPONENT));
            this.bgSelectionColor = list.getSelectionBackground();
            this.fgSelectionColor = list.getSelectionForeground();
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            int height = list.getFixedCellHeight();
            int width = list.getFixedCellWidth() - 1;
            width = width < 200 ? 200 : width;
            Dimension size = new Dimension(width, height);
            this.rendererComponent.setMaximumSize(size);
            this.rendererComponent.setPreferredSize(size);
            if (isSelected) {
                this.jlName.setForeground(this.fgSelectionColor);
                this.jlPkg.setForeground(this.fgSelectionColor);
                this.jlPrj.setForeground(this.fgSelectionColor);
                this.rendererComponent.setBackground(this.bgSelectionColor);
            } else {
                this.jlName.setForeground(this.fgColor);
                this.jlPkg.setForeground(this.fgColorLighter);
                this.jlPrj.setForeground(this.fgColor);
                this.rendererComponent.setBackground(index % 2 == 0 ? this.bgColor : this.bgColorDarker);
            }
            if (value instanceof TypeDescriptor) {
                long time = System.currentTimeMillis();
                TypeDescriptor td = (TypeDescriptor)value;
                this.jlName.setIcon(td.getIcon());
                this.jlName.setText(td.getTypeName());
                this.jlPkg.setText(td.getContextName());
                this.jlPrj.setText(td.getProjectName());
                this.jlPrj.setIcon(td.getProjectIcon());
                this.rendererComponent.setDescriptor(td);
                LOGGER.fine("  Time in paint " + (System.currentTimeMillis() - time) + " ms.");
            } else {
                this.jlName.setText(value.toString());
            }
            return this.rendererComponent;
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            JViewport jv = (JViewport)event.getSource();
            this.jlName.setText("Sample");
            this.jlName.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/jumpto/type/sample.png", (boolean)false));
            this.jList.setFixedCellHeight(this.jlName.getPreferredSize().height);
            this.jList.setFixedCellWidth(jv.getExtentSize().width);
        }
    }

    private static class MyPanel
    extends JPanel {
        private TypeDescriptor td;

        private MyPanel() {
        }

        void setDescriptor(TypeDescriptor td) {
            this.td = td;
            this.putClientProperty("ToolTipText", null);
        }

        @Override
        public String getToolTipText() {
            String text = (String)this.getClientProperty("ToolTipText");
            if (text == null) {
                FileObject fo;
                if (this.td != null && (fo = this.td.getFileObject()) != null) {
                    text = FileUtil.getFileDisplayName((FileObject)fo);
                }
                this.putClientProperty("ToolTipText", text);
            }
            return text;
        }
    }

    private class Worker
    implements Runnable {
        private volatile boolean isCanceled = false;
        private volatile TypeProvider current;
        private final String text;
        private final long createTime;

        public Worker(String text) {
            this.text = text;
            this.createTime = System.currentTimeMillis();
            LOGGER.fine("Worker for " + text + " - created after " + (System.currentTimeMillis() - GoToTypeAction.this.panel.time) + " ms.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                int[] retry = new int[1];
                Profile profile = GoToTypeAction.this.initializeProfiling();
                try {
                    LOGGER.fine("Worker for " + this.text + " - started " + (System.currentTimeMillis() - this.createTime) + " ms.");
                    final List<? extends TypeDescriptor> types = this.getTypeNames(this.text, retry);
                    if (this.isCanceled) {
                        LOGGER.fine("Worker for " + this.text + " exited after cancel " + (System.currentTimeMillis() - this.createTime) + " ms.");
                        return;
                    }
                    ListModel model = Models.fromList(types);
                    if (GoToTypeAction.this.typeFilter != null) {
                        model = LazyListModel.create(model, GoToTypeAction.this, 0.1, "Not computed yet");
                    }
                    final ListModel fmodel = model;
                    if (this.isCanceled) {
                        LOGGER.fine("Worker for " + this.text + " exited after cancel " + (System.currentTimeMillis() - this.createTime) + " ms.");
                        return;
                    }
                    if (!this.isCanceled && fmodel != null) {
                        LOGGER.fine("Worker for text " + this.text + " finished after " + (System.currentTimeMillis() - this.createTime) + " ms.");
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                GoToTypeAction.this.panel.setModel(fmodel);
                                if (GoToTypeAction.this.okButton != null && !types.isEmpty()) {
                                    GoToTypeAction.this.okButton.setEnabled(true);
                                }
                            }
                        });
                    }
                }
                finally {
                    if (profile != null) {
                        try {
                            profile.stop();
                        }
                        catch (Exception ex) {
                            LOGGER.log(Level.INFO, "Cannot stop profiling", ex);
                        }
                    }
                }
                if (retry[0] <= 0) break;
                try {
                    Thread.sleep(retry[0]);
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            TypeProvider _provider;
            if (GoToTypeAction.this.panel.time != -1L) {
                LOGGER.fine("Worker for text " + this.text + " canceled after " + (System.currentTimeMillis() - this.createTime) + " ms.");
            }
            Worker worker = this;
            synchronized (worker) {
                this.isCanceled = true;
                _provider = this.current;
            }
            if (_provider != null) {
                _provider.cancel();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<? extends TypeDescriptor> getTypeNames(String text, int[] retry) {
            ArrayList items = new ArrayList(128);
            String[] message = new String[1];
            TypeProvider.Context context = TypeProviderAccessor.DEFAULT.createContext(null, text, GoToTypeAction.this.nameKind);
            TypeProvider.Result result = TypeProviderAccessor.DEFAULT.createResult(items, message);
            if (GoToTypeAction.this.typeProviders == null) {
                GoToTypeAction.this.typeProviders = Lookup.getDefault().lookupAll(TypeProvider.class);
            }
            for (TypeProvider provider : GoToTypeAction.this.typeProviders) {
                if (this.isCanceled) {
                    return null;
                }
                this.current = provider;
                long start = System.currentTimeMillis();
                try {
                    LOGGER.fine("Calling TypeProvider: " + provider);
                    provider.computeTypeNames(context, result);
                }
                finally {
                    this.current = null;
                }
                long delta = System.currentTimeMillis() - start;
                LOGGER.fine("Provider '" + provider.getDisplayName() + "' took " + delta + " ms.");
            }
            retry[0] = TypeProviderAccessor.DEFAULT.getRetry(result);
            if (!this.isCanceled) {
                Collections.sort(items, new TypeComparator());
                GoToTypeAction.this.panel.setWarning(message[0]);
                return items;
            }
            return null;
        }
    }
}

