/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mobility.antext.preprocessor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Reference;
import org.netbeans.mobility.antext.Bundle;
import org.netbeans.mobility.antext.preprocessor.CommentingPreProcessor;
import org.netbeans.mobility.antext.preprocessor.PPLine;

public class CommentingPreProcessorTask
extends Task {
    ArrayList<FileSet> sources = null;
    File destDir = null;
    String abilities;
    String encoding = System.getProperty("file.encoding");

    public void setPreprocessFor(String abilities) {
        this.abilities = abilities;
    }

    public void setSrcDir(File srcDir) {
        FileSet fs = this.createFileSet();
        fs.setDir(srcDir);
        fs.setIncludes("**/*.java");
    }

    public FileSet createFileSet() {
        if (this.sources == null) {
            this.sources = new ArrayList();
        }
        FileSet source = new FileSet();
        this.sources.add(source);
        return source;
    }

    public void setFileSetRef(Reference fileSetRef) {
        this.createFileSet().setRefid(fileSetRef);
    }

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void execute() throws BuildException {
        if (this.sources == null) {
            throw new BuildException(Bundle.getMessage("ERR_MissingAttr", "srcDir, fileSetRef, or nested fileset"));
        }
        ArrayList<File> preprocessQueue = new ArrayList<File>();
        for (int a = 0; a < this.sources.size(); ++a) {
            DirectoryScanner ds = this.sources.get(a).getDirectoryScanner(this.getProject());
            String baseDir = ds.getBasedir().getAbsolutePath();
            String[] included = ds.getIncludedFiles();
            for (int b = 0; b < included.length; ++b) {
                int lastdot = included[b].lastIndexOf(46);
                if (lastdot < 0 || !"java".equals(included[b].substring(lastdot + 1).toLowerCase())) continue;
                File srcFile = new File(baseDir + File.separator + included[b]);
                File destFile = new File(this.destDir.getAbsolutePath() + File.separator + included[b]);
                if (destFile.exists() && srcFile.lastModified() <= destFile.lastModified()) continue;
                preprocessQueue.add(srcFile);
                preprocessQueue.add(destFile);
            }
        }
        this.log(Bundle.getMessage("MSG_PreprocessingXFiles", "" + preprocessQueue.size() / 2, this.destDir.getAbsolutePath()), 2);
        int errors = 0;
        int warnings = 0;
        int a = 0;
        while (a < preprocessQueue.size()) {
            File srcFile = (File)preprocessQueue.get(a++);
            File destFile = (File)preprocessQueue.get(a++);
            try {
                this.log(Bundle.getMessage("MSG_PreprocessingFile", srcFile.getAbsolutePath()), 3);
                CommentingPreProcessor cpp = new CommentingPreProcessor((CommentingPreProcessor.Source)new FileSource(srcFile), (CommentingPreProcessor.Destination)new FileDestination(destFile), this.abilities);
                cpp.run();
                for (PPLine ppl : cpp.getLines()) {
                    for (PPLine.Error e : ppl.getErrors()) {
                        this.log(srcFile.getAbsolutePath() + ':' + e.toString(), e.warning ? 1 : 0);
                        if (e.warning) {
                            ++warnings;
                            continue;
                        }
                        ++errors;
                    }
                }
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
        }
        if (warnings > 0) {
            this.log(Bundle.getMessage("MSG_Warnings", String.valueOf(warnings)), 1);
        }
        if (errors > 0) {
            this.log(Bundle.getMessage("MSG_Errors", String.valueOf(errors)), 0);
            throw new BuildException(Bundle.getMessage("MSG_PreprocessingError"));
        }
    }

    private final class FileDestination
    implements CommentingPreProcessor.Destination {
        private final File f;

        public FileDestination(File f) {
            this.f = f;
        }

        @Override
        public void doInsert(int line, String s) throws IOException {
        }

        @Override
        public void doRemove(int line, int column, int length) throws IOException {
        }

        @Override
        public Writer createWriter(boolean validOutput) throws IOException {
            if (!validOutput) {
                return null;
            }
            this.f.getParentFile().mkdirs();
            return new OutputStreamWriter((OutputStream)new FileOutputStream(this.f), CommentingPreProcessorTask.this.encoding);
        }
    }

    private final class FileSource
    implements CommentingPreProcessor.Source {
        private final File f;

        public FileSource(File f) {
            this.f = f;
        }

        @Override
        public Reader createReader() throws IOException {
            return new InputStreamReader((InputStream)new FileInputStream(this.f), CommentingPreProcessorTask.this.encoding);
        }
    }
}

