/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mobility.antext;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.MissingResourceException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.netbeans.mobility.antext.Bundle;
import org.netbeans.mobility.antext.EMapFormat;

public class PreverifyTask
extends Task {
    private static final String DEFAULT_PLATFORM_TYPE = "UEI-1.0";
    private File srcDir;
    private File destDir;
    private Path classPath;
    private String configuration;
    private File platformHome;
    private String platformType;
    private String commandLine = null;

    public void execute() throws BuildException {
        long time;
        int a;
        if (this.platformHome == null) {
            throw new BuildException(Bundle.getMessage("ERR_MissingAttr", "platformHome"));
        }
        if (this.srcDir == null) {
            throw new BuildException(Bundle.getMessage("ERR_MissingAttr", "srcDir"));
        }
        if (this.destDir == null) {
            throw new BuildException(Bundle.getMessage("ERR_MissingAttr", "destDir"));
        }
        if (!this.platformHome.isDirectory()) {
            throw new BuildException(Bundle.getMessage("ERR_MissingPlatformHome", this.platformHome.toString()));
        }
        if (!this.srcDir.isDirectory()) {
            throw new BuildException(Bundle.getMessage("ERR_MissingSrcDir", this.srcDir.toString()));
        }
        if (!this.destDir.isDirectory()) {
            throw new BuildException(Bundle.getMessage("ERR_MissingDestDir", this.destDir.toString()));
        }
        long srcLastModified = Long.MIN_VALUE;
        long destLastModified = Long.MAX_VALUE;
        FileSet fileset = new FileSet();
        fileset.setDir(this.srcDir);
        DirectoryScanner ds = fileset.getDirectoryScanner(this.getProject());
        File baseDir = ds.getBasedir();
        String[] files = ds.getIncludedFiles();
        long srcFilesCount = files.length;
        for (a = 0; a < files.length; ++a) {
            time = new File(baseDir, files[a]).lastModified();
            if (time <= srcLastModified) continue;
            srcLastModified = time;
        }
        fileset = new FileSet();
        fileset.setDir(this.destDir);
        ds = fileset.getDirectoryScanner(this.getProject());
        baseDir = ds.getBasedir();
        files = ds.getIncludedFiles();
        for (a = 0; a < files.length; ++a) {
            time = new File(baseDir, files[a]).lastModified();
            if (time >= destLastModified) continue;
            destLastModified = time;
        }
        if (destLastModified != Long.MAX_VALUE && srcLastModified <= destLastModified) {
            this.log(Bundle.getMessage("MSG_PreverifiedClassesAreUpToDate", this.destDir.getAbsolutePath()), 3);
            return;
        }
        this.log(Bundle.getMessage("MSG_Preverifying", "" + srcFilesCount, this.destDir.getAbsolutePath()), 2);
        if (this.platformType == null) {
            this.log(Bundle.getMessage("WARN_DefaultPlatform", DEFAULT_PLATFORM_TYPE), 1);
            this.platformType = DEFAULT_PLATFORM_TYPE;
        }
        if (Bundle.getMessage("NAME_CUSTOM").equals(this.platformType)) {
            if (this.commandLine == null) {
                this.log(Bundle.getMessage("WARN_MissingCommandLine", DEFAULT_PLATFORM_TYPE), 1);
                this.platformType = DEFAULT_PLATFORM_TYPE;
            }
        } else {
            this.commandLine = null;
        }
        if (this.commandLine == null) {
            String defCfg;
            try {
                defCfg = Bundle.getMessage("CFG_Preverify_" + this.platformType);
            }
            catch (MissingResourceException mre) {
                throw new BuildException(Bundle.getMessage("ERR_UnsupportedPlatform", this.platformType));
            }
            if (this.configuration != null) {
                try {
                    this.commandLine = Bundle.getMessage("CMD_Preverify_" + this.platformType + "_" + this.configuration);
                }
                catch (MissingResourceException mre) {
                    this.log(Bundle.getMessage("WARN_UnsupportedConfig", this.platformType, this.configuration, defCfg), 1);
                    this.commandLine = Bundle.getMessage("CMD_Preverify_" + this.platformType + "_" + defCfg);
                }
            } else {
                this.log(Bundle.getMessage("MSG_DefaultConfig", this.platformType, defCfg), 1);
                this.commandLine = Bundle.getMessage("CMD_Preverify_" + this.platformType + "_" + defCfg);
            }
        }
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("platformhome", this.platformHome.getAbsolutePath());
        if (this.classPath != null) {
            args.put("classpath", this.classPath.toString());
        }
        args.put("destdir", this.destDir.getAbsolutePath());
        args.put("srcdir", this.srcDir.getAbsolutePath());
        args.put("/", File.separator);
        this.commandLine = EMapFormat.format(this.commandLine, args);
        String[] commands = Commandline.translateCommandline((String)this.commandLine);
        this.log(Bundle.getMessage("MSG_ExecCmd", this.commandLine), 3);
        for (int a2 = 0; a2 < commands.length; ++a2) {
            this.log(">" + commands[a2] + "<", 3);
        }
        try {
            Execute exec = new Execute();
            exec.setAntRun(this.getProject());
            exec.setVMLauncher(true);
            exec.setCommandline(commands);
            int i = exec.execute();
            if (i != 0) {
                throw new BuildException(Bundle.getMessage("ERR_PreverifyFailed", String.valueOf(i)));
            }
        }
        catch (IOException ioe) {
            throw new BuildException((Throwable)ioe);
        }
    }

    public void setSrcDir(File srcDir) {
        this.srcDir = srcDir;
    }

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public void setClassPath(Path classPath) {
        this.createClassPath().append(classPath);
    }

    public Path createClassPath() {
        if (this.classPath == null) {
            this.classPath = new Path(this.getProject());
        }
        return this.classPath.createPath();
    }

    public void setClassPathRef(Reference classPathRef) {
        this.createClassPath().setRefid(classPathRef);
    }

    public void setConfiguration(String configuration) {
        this.configuration = configuration.toUpperCase();
    }

    public void setPlatformHome(File platformHome) {
        this.platformHome = platformHome;
    }

    public void setPlatformType(String platformType) {
        this.platformType = platformType.toUpperCase();
    }

    public void setCommandLine(String commandLine) {
        this.commandLine = commandLine;
    }
}

