/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ext.ffi.jna;

import com.sun.jna.Pointer;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyModule;
import org.jruby.nb.RubyNumeric;
import org.jruby.nb.RubyString;
import org.jruby.nb.anno.JRubyClass;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.ext.ffi.AbstractBuffer;
import org.jruby.nb.ext.ffi.AbstractMemoryPointer;
import org.jruby.nb.ext.ffi.FFIProvider;
import org.jruby.nb.ext.ffi.MemoryIO;
import org.jruby.nb.ext.ffi.Util;
import org.jruby.nb.ext.ffi.jna.JNAMemory;
import org.jruby.nb.ext.ffi.jna.JNAMemoryIO;
import org.jruby.nb.ext.ffi.jna.JNAMemoryPointer;
import org.jruby.nb.runtime.ObjectAllocator;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyClass(name={"JRuby::FFI::Buffer"}, parent="JRuby::FFI::AbstractMemoryPointer")
public class JNABuffer
extends AbstractBuffer
implements JNAMemory {
    public static final String BUFFER_RUBY_CLASS = "Buffer";
    private static final boolean CLEAR_DEFAULT = true;

    public static RubyClass createBufferClass(Ruby runtime) {
        RubyModule module = FFIProvider.getModule(runtime);
        RubyClass result = module.defineClassUnder(BUFFER_RUBY_CLASS, module.getClass("AbstractBuffer"), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        result.defineAnnotatedMethods(JNABuffer.class);
        result.defineAnnotatedConstants(JNABuffer.class);
        return result;
    }

    public JNABuffer(Ruby runtime, RubyClass klass) {
        super(runtime, klass, JNAMemoryIO.wrap(Pointer.NULL), 0L, 0L);
    }

    private JNABuffer(Ruby runtime, JNABuffer ptr, long offset) {
        this(runtime, ptr.io, ptr.offset + offset, ptr.size == Long.MAX_VALUE ? Long.MAX_VALUE : ptr.size - offset);
    }

    private JNABuffer(Ruby runtime, MemoryIO io, long offset, long size) {
        super(runtime, FFIProvider.getModule(runtime).fastGetClass(BUFFER_RUBY_CLASS), io, offset, size);
    }

    private static JNABuffer allocate(ThreadContext context, IRubyObject sizeArg, boolean clear) {
        JNAMemoryIO io;
        int size = Util.int32Value(sizeArg);
        JNAMemoryIO jNAMemoryIO = io = size > 0 ? JNAMemoryIO.allocateDirect(size) : JNAMemoryIO.NULL;
        if (clear && size > 0) {
            io.setMemory(0L, size, (byte)0);
        }
        return new JNABuffer(context.getRuntime(), io, 0L, size);
    }

    @JRubyMethod(name={"alloc_inout", "__alloc_inout", "__alloc_heap_inout", "__alloc_direct_inout"}, meta=true)
    public static JNABuffer allocateDirect(ThreadContext context, IRubyObject recv, IRubyObject sizeArg) {
        return JNABuffer.allocate(context, sizeArg, true);
    }

    @JRubyMethod(name={"alloc_inout", "__alloc_inout", "__alloc_heap_inout", "__alloc_direct_inout"}, meta=true)
    public static JNABuffer allocateDirect(ThreadContext context, IRubyObject recv, IRubyObject sizeArg, IRubyObject clearArg) {
        return JNABuffer.allocate(context, sizeArg, clearArg.isTrue());
    }

    @JRubyMethod(name={"alloc_in", "__alloc_in", "__alloc_heap_in", "__alloc_direct_in"}, meta=true)
    public static JNABuffer allocateInput(ThreadContext context, IRubyObject recv, IRubyObject arg) {
        if (arg instanceof RubyString) {
            RubyString s = (RubyString)arg;
            int size = Util.int32Value(s.length());
            ByteList bl = s.getByteList();
            JNAMemoryIO io = JNAMemoryIO.allocateDirect(size);
            io.put(0L, bl.unsafeBytes(), bl.begin(), bl.length());
            io.putByte(bl.length(), (byte)0);
            return new JNABuffer(context.getRuntime(), io, 0L, size);
        }
        return JNABuffer.allocate(context, arg, true);
    }

    @JRubyMethod(name={"alloc_in", "__alloc_in", "__alloc_heap_in", "__alloc_direct_in"}, meta=true)
    public static JNABuffer allocateInput(ThreadContext context, IRubyObject recv, IRubyObject sizeArg, IRubyObject clearArg) {
        return JNABuffer.allocate(context, sizeArg, clearArg.isTrue());
    }

    @JRubyMethod(name={"alloc_out", "__alloc_out", "__alloc_heap_out", "__alloc_direct_out"}, meta=true)
    public static JNABuffer allocateOutput(ThreadContext context, IRubyObject recv, IRubyObject sizeArg) {
        return JNABuffer.allocate(context, sizeArg, true);
    }

    @JRubyMethod(name={"alloc_out", "__alloc_out", "__alloc_heap_out", "__alloc_direct_out"}, meta=true)
    public static JNABuffer allocateOutput(ThreadContext context, IRubyObject recv, IRubyObject sizeArg, IRubyObject clearArg) {
        return JNABuffer.allocate(context, sizeArg, clearArg.isTrue());
    }

    @Override
    public Object getNativeMemory() {
        return ((JNAMemoryIO)this.getMemoryIO()).slice(this.offset).getMemory();
    }

    @JRubyMethod(name={"+"}, required=1)
    public IRubyObject op_plus(ThreadContext context, IRubyObject value) {
        return new JNABuffer(context.getRuntime(), this, RubyNumeric.fix2long(value));
    }

    @JRubyMethod(name={"put_pointer"}, required=2)
    public IRubyObject put_pointer(ThreadContext context, IRubyObject offset, IRubyObject value) {
        Pointer ptr;
        if (value instanceof JNAMemoryPointer) {
            ptr = ((JNAMemoryPointer)value).getAddress();
        } else if (value.isNil()) {
            ptr = Pointer.NULL;
        } else {
            throw context.getRuntime().newArgumentError("Cannot convert argument to pointer");
        }
        ((JNAMemoryIO)this.getMemoryIO()).putPointer(this.getOffset(offset), ptr);
        return this;
    }

    @Override
    protected AbstractMemoryPointer getMemoryPointer(Ruby runtime, long offset) {
        return new JNAMemoryPointer(runtime, this.getMemoryIO().getMemoryIO(this.offset + offset), 0L, Long.MAX_VALUE);
    }
}

