/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast.executable;

import org.jruby.nb.MetaClass;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyBignum;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyFixnum;
import org.jruby.nb.RubyHash;
import org.jruby.nb.RubyModule;
import org.jruby.nb.RubyString;
import org.jruby.nb.RubySymbol;
import org.jruby.nb.ast.executable.YARVInstructions;
import org.jruby.nb.common.IRubyWarnings;
import org.jruby.nb.internal.runtime.methods.WrapperMethod;
import org.jruby.nb.internal.runtime.methods.YARVMethod;
import org.jruby.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.parser.LocalStaticScope;
import org.jruby.nb.parser.StaticScope;
import org.jruby.nb.runtime.CallSite;
import org.jruby.nb.runtime.CallType;
import org.jruby.nb.runtime.MethodIndex;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.runtime.scope.ManyVarsDynamicScope;

public class YARVMachine {
    private static final boolean TAILCALL_OPT = Boolean.getBoolean("jruby.tailcall.enabled");
    public static final YARVMachine INSTANCE = new YARVMachine();
    IRubyObject[] stack = new IRubyObject[8192];
    int stackTop = 0;

    public static int instruction(String name) {
        return YARVInstructions.instruction(name);
    }

    private void push(IRubyObject value) {
        this.stack[this.stackTop] = value;
        ++this.stackTop;
    }

    private void swap() {
        this.stack[this.stackTop + 1] = this.stack[this.stackTop];
        this.stack[this.stackTop] = this.stack[this.stackTop - 1];
        this.stack[this.stackTop - 1] = this.stack[this.stackTop + 1];
    }

    private void dupn(int length) {
        System.arraycopy(this.stack, this.stackTop - length, this.stack, this.stackTop, length);
        this.stackTop += length;
    }

    private IRubyObject peek() {
        return this.stack[this.stackTop];
    }

    private IRubyObject pop() {
        return this.stack[--this.stackTop];
    }

    private IRubyObject[] popArray(IRubyObject[] arr) {
        this.stackTop -= arr.length;
        System.arraycopy(this.stack, this.stackTop, arr, 0, arr.length);
        return arr;
    }

    private void setn(int depth, IRubyObject value) {
        this.stack[this.stackTop - depth] = value;
    }

    private void topn(int depth) {
        this.push(this.stack[this.stackTop - depth]);
    }

    public void set(IRubyObject value) {
        this.stack[this.stackTop] = value;
    }

    public void unimplemented(int bytecode) {
        System.err.println("Not implemented, YARVMachine." + YARVInstructions.name(bytecode));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject exec(ThreadContext context, StaticScope scope, Instruction[] bytecodes) {
        try {
            RubyClass self = context.getRuntime().getObject();
            context.preScopedBody(new ManyVarsDynamicScope(scope));
            if (scope.getModule() == null) {
                scope.setModule(context.getRuntime().getObject());
            }
            IRubyObject iRubyObject = this.exec(context, self, bytecodes);
            return iRubyObject;
        }
        finally {
            context.postScopedBody();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public IRubyObject exec(ThreadContext context, IRubyObject self, Instruction[] bytecodes) {
        Ruby runtime = context.getRuntime();
        int stackStart = this.stackTop;
        int ip = 0;
        block56: while (ip < bytecodes.length) {
            switch (bytecodes[ip].bytecode) {
                case 0: {
                    break;
                }
                case 13: {
                    this.push(runtime.getGlobalVariables().get(bytecodes[ip].s_op0));
                    break;
                }
                case 14: {
                    runtime.getGlobalVariables().set(bytecodes[ip].s_op0, this.pop());
                    break;
                }
                case 1: {
                    this.push(context.getCurrentScope().getValue((int)bytecodes[ip].l_op0, 0));
                    break;
                }
                case 2: {
                    context.getCurrentScope().setValue((int)bytecodes[ip].l_op0, this.pop(), 0);
                    break;
                }
                case 7: {
                    this.push(self.getInstanceVariables().fastGetInstanceVariable(bytecodes[ip].s_op0));
                    break;
                }
                case 8: {
                    self.getInstanceVariables().fastSetInstanceVariable(bytecodes[ip].s_op0, this.pop());
                    break;
                }
                case 9: {
                    RubyModule rubyClass = context.getRubyClass();
                    String name = bytecodes[ip].s_op0;
                    if (rubyClass == null) {
                        this.push(self.getMetaClass().fastGetClassVar(name));
                        break;
                    }
                    if (!rubyClass.isSingleton()) {
                        this.push(rubyClass.fastGetClassVar(name));
                        break;
                    }
                    RubyModule module = (RubyModule)((MetaClass)rubyClass).getAttached();
                    if (module != null) {
                        this.push(module.fastGetClassVar(name));
                        break;
                    }
                    this.push(runtime.getNil());
                    break;
                }
                case 10: {
                    RubyModule rubyClass = context.getCurrentScope().getStaticScope().getModule();
                    if (rubyClass == null) {
                        rubyClass = self.getMetaClass();
                    } else if (rubyClass.isSingleton()) {
                        rubyClass = (RubyModule)((MetaClass)rubyClass).getAttached();
                    }
                    rubyClass.fastSetClassVar(bytecodes[ip].s_op0, this.pop());
                    break;
                }
                case 11: {
                    this.push(context.getConstant(bytecodes[ip].s_op0));
                    break;
                }
                case 12: {
                    context.setConstantInCurrent(bytecodes[ip].s_op0, this.pop());
                    runtime.incGlobalState();
                    break;
                }
                case 15: {
                    this.push(context.getRuntime().getNil());
                    break;
                }
                case 16: {
                    this.push(self);
                    break;
                }
                case 18: {
                    this.push(bytecodes[ip].o_op0);
                    break;
                }
                case 19: {
                    this.push(context.getRuntime().newString(bytecodes[ip].s_op0));
                    break;
                }
                case 20: {
                    StringBuilder concatter = new StringBuilder();
                    int i = 0;
                    while ((long)i < bytecodes[ip].l_op0) {
                        concatter.append(this.pop().toString());
                        ++i;
                    }
                    this.push(runtime.newString(concatter.toString()));
                    break;
                }
                case 21: {
                    IRubyObject top = this.peek();
                    if (top instanceof RubyString) break;
                    this.set(top.callMethod(context, MethodIndex.TO_S, "to_s"));
                    break;
                }
                case 23: {
                    this.push(runtime.newArrayNoCopy(this.popArray(new IRubyObject[(int)bytecodes[ip].l_op0])));
                    break;
                }
                case 24: {
                    this.push(bytecodes[ip].o_op0.dup());
                    break;
                }
                case 29: {
                    int hsize = (int)bytecodes[ip].l_op0;
                    RubyHash h = RubyHash.newHash(runtime);
                    for (int i = hsize; i > 0; i -= 2) {
                        IRubyObject v = this.pop();
                        IRubyObject k = this.pop();
                        h.op_aset(context, k, v);
                    }
                    this.push(h);
                    break;
                }
                case 31: {
                    this.push(this.peek().isTrue() ? runtime.getFalse() : runtime.getTrue());
                    break;
                }
                case 32: {
                    this.pop();
                    break;
                }
                case 33: {
                    this.push(this.peek());
                    break;
                }
                case 34: {
                    this.dupn((int)bytecodes[ip].l_op0);
                    break;
                }
                case 35: {
                    this.swap();
                    break;
                }
                case 37: {
                    this.topn((int)bytecodes[ip].l_op0);
                    break;
                }
                case 38: {
                    this.setn((int)bytecodes[ip].l_op0, this.peek());
                    break;
                }
                case 39: {
                    this.stackTop = stackStart;
                    break;
                }
                case 40: {
                    RubyModule containingClass = context.getRubyClass();
                    if (containingClass == null) {
                        throw runtime.newTypeError("No class to add method.");
                    }
                    String mname = bytecodes[ip].iseq_op.name;
                    if (containingClass == runtime.getObject() && mname == "initialize") {
                        runtime.getWarnings().warn(IRubyWarnings.ID.REDEFINING_DANGEROUS, "redefining Object#initialize may cause infinite loop", "Object#initialize");
                    }
                    Visibility visibility = context.getCurrentVisibility();
                    if (mname == "initialize" || visibility == Visibility.MODULE_FUNCTION) {
                        visibility = Visibility.PRIVATE;
                    }
                    if (containingClass.isSingleton()) {
                        IRubyObject attachedObject = ((MetaClass)containingClass).getAttached();
                        if (attachedObject instanceof RubyFixnum) throw runtime.newTypeError("can't define singleton method \"" + mname + "\" for " + attachedObject.getType());
                        if (attachedObject instanceof RubySymbol) {
                            throw runtime.newTypeError("can't define singleton method \"" + mname + "\" for " + attachedObject.getType());
                        }
                    }
                    LocalStaticScope sco = new LocalStaticScope(null);
                    sco.setVariables(bytecodes[ip].iseq_op.locals);
                    YARVMethod newMethod = new YARVMethod(containingClass, bytecodes[ip].iseq_op, sco, visibility);
                    containingClass.addMethod(mname, newMethod);
                    if (context.getCurrentVisibility() == Visibility.MODULE_FUNCTION) {
                        RubyClass singleton = containingClass.getSingletonClass();
                        singleton.addMethod(mname, new WrapperMethod((RubyModule)singleton, newMethod, Visibility.PUBLIC));
                        containingClass.callMethod(context, "singleton_method_added", runtime.fastNewSymbol(mname));
                    }
                    if (containingClass.isSingleton()) {
                        ((MetaClass)containingClass).getAttached().callMethod(context, "singleton_method_added", runtime.fastNewSymbol(mname));
                    } else {
                        containingClass.callMethod(context, "method_added", runtime.fastNewSymbol(mname));
                    }
                    this.push(runtime.getNil());
                    runtime.incGlobalState();
                    break;
                }
                case 47: {
                    ip = this.send(runtime, context, self, bytecodes, stackStart, ip);
                    break;
                }
                case 50: {
                    return this.pop();
                }
                case 53: {
                    ip = (int)bytecodes[ip].l_op0;
                    continue block56;
                }
                case 54: {
                    ip = this.pop().isTrue() ? (int)bytecodes[ip].l_op0 : ip + 1;
                    continue block56;
                }
                case 55: {
                    ip = !this.pop().isTrue() ? (int)bytecodes[ip].l_op0 : ip + 1;
                    continue block56;
                }
                case 56: {
                    if (bytecodes[ip].l_op1 != runtime.getGlobalState()) break;
                    this.push(bytecodes[ip].o_op0);
                    ip = (int)bytecodes[ip].l_op0;
                    continue block56;
                }
                case 57: {
                    if (bytecodes[ip].l_op1 <= 0L) break;
                    this.push(bytecodes[ip].o_op0);
                    ip = (int)bytecodes[ip].l_op0;
                    continue block56;
                }
                case 58: {
                    int we = (int)bytecodes[ip].l_op0;
                    bytecodes[we].o_op0 = this.peek();
                    bytecodes[we].l_op1 = runtime.getGlobalState();
                    break;
                }
                case 61: {
                    this.op_plus(runtime, context, this.pop(), this.pop());
                    break;
                }
                case 62: {
                    this.op_minus(runtime, context, this.pop(), this.pop());
                    break;
                }
                case 63: {
                    IRubyObject other = this.pop();
                    this.push(this.pop().callMethod(context, MethodIndex.OP_TIMES, "*", other));
                    break;
                }
                case 64: {
                    IRubyObject other = this.pop();
                    this.push(this.pop().callMethod(context, "/", other));
                    break;
                }
                case 65: {
                    IRubyObject other = this.pop();
                    this.push(this.pop().callMethod(context, "%", other));
                    break;
                }
                case 66: {
                    IRubyObject other = this.pop();
                    this.push(this.pop().callMethod(context, MethodIndex.EQUALEQUAL, "==", other));
                    break;
                }
                case 67: {
                    this.op_lt(runtime, context, this.pop(), this.pop());
                    break;
                }
                case 68: {
                    IRubyObject other = this.pop();
                    this.push(this.pop().callMethod(context, MethodIndex.OP_LE, "<=", other));
                    break;
                }
                case 69: {
                    IRubyObject other = this.pop();
                    this.push(this.pop().callMethod(context, MethodIndex.OP_LSHIFT, "<<", other));
                    break;
                }
                case 70: {
                    IRubyObject other = this.pop();
                    this.push(this.pop().callMethod(context, MethodIndex.AREF, "[]", other));
                    break;
                }
                case 71: {
                    IRubyObject value = this.pop();
                    IRubyObject other = this.pop();
                    this.push(RuntimeHelpers.invoke(context, this.pop(), "[]=", other, value));
                    break;
                }
                case 72: {
                    this.push(this.pop().callMethod(context, "length"));
                    break;
                }
                case 73: {
                    this.push(this.pop().callMethod(context, "succ"));
                    break;
                }
                case 74: {
                    this.push(bytecodes[ip].o_op0.callMethod(context, "=~", this.peek()));
                    break;
                }
                case 75: {
                    IRubyObject other = this.pop();
                    this.push(this.pop().callMethod(context, "=~", other));
                    break;
                }
                case 78: {
                    this.push(runtime.newFixnum(42));
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 17: 
                case 22: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 30: 
                case 36: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 51: 
                case 52: 
                case 59: 
                case 60: 
                case 76: 
                case 77: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: {
                    this.unimplemented(bytecodes[ip].bytecode);
                }
            }
            ++ip;
        }
        return this.pop();
    }

    private void op_plus(Ruby runtime, ThreadContext context, IRubyObject other, IRubyObject receiver) {
        if (other instanceof RubyFixnum && receiver instanceof RubyFixnum) {
            long result;
            long otherValue;
            long receiverValue = ((RubyFixnum)receiver).getLongValue();
            if (((receiverValue ^ (otherValue = ((RubyFixnum)other).getLongValue()) ^ 0xFFFFFFFFFFFFFFFFL) & (receiverValue ^ (result = receiverValue + otherValue)) & Long.MIN_VALUE) != 0L) {
                this.push(RubyBignum.newBignum(runtime, receiverValue).op_plus(context, other));
            }
            this.push(runtime.newFixnum(result));
        } else {
            this.push(receiver.callMethod(context, MethodIndex.OP_PLUS, "+", other));
        }
    }

    private void op_minus(Ruby runtime, ThreadContext context, IRubyObject other, IRubyObject receiver) {
        if (other instanceof RubyFixnum && receiver instanceof RubyFixnum) {
            long result;
            long otherValue;
            long receiverValue = ((RubyFixnum)receiver).getLongValue();
            if (((receiverValue ^ (otherValue = ((RubyFixnum)other).getLongValue()) ^ 0xFFFFFFFFFFFFFFFFL) & (receiverValue ^ (result = receiverValue - otherValue)) & Long.MIN_VALUE) != 0L) {
                this.push(RubyBignum.newBignum(runtime, receiverValue).op_minus(context, other));
            }
            this.push(runtime.newFixnum(result));
        } else {
            this.push(receiver.callMethod(context, MethodIndex.OP_MINUS, "-", other));
        }
    }

    private void op_lt(Ruby runtime, ThreadContext context, IRubyObject other, IRubyObject receiver) {
        if (other instanceof RubyFixnum && receiver instanceof RubyFixnum) {
            long otherValue;
            long receiverValue = ((RubyFixnum)receiver).getLongValue();
            this.push(runtime.newBoolean(receiverValue < (otherValue = ((RubyFixnum)other).getLongValue())));
        } else {
            this.push(receiver.callMethod(context, MethodIndex.OP_LT, "<", other));
        }
    }

    private int send(Ruby runtime, ThreadContext context, IRubyObject self, Instruction[] bytecodes, int stackStart, int ip) {
        CallType callType;
        IRubyObject recv;
        IRubyObject[] args;
        Instruction instruction = bytecodes[ip];
        String name = instruction.s_op0;
        int size = instruction.i_op1;
        int flags = instruction.i_op3;
        if (size == 0) {
            args = IRubyObject.NULL_ARRAY;
        } else {
            args = new IRubyObject[size];
            this.popArray(args);
        }
        if ((flags & 0x10) == 0) {
            if ((flags & 8) == 0) {
                recv = this.pop();
                callType = CallType.NORMAL;
            } else {
                this.pop();
                recv = self;
                callType = CallType.FUNCTIONAL;
            }
        } else {
            this.pop();
            recv = self;
            callType = CallType.VARIABLE;
        }
        if (instruction.callAdapter == null) {
            instruction.callAdapter = new CallSite.InlineCachingCallSite(name.intern(), callType);
        }
        if (TAILCALL_OPT && (bytecodes[ip + 1].bytecode == 50 || (flags & 0x20) == 32) && recv == self && name.equals(context.getFrameName())) {
            this.stackTop = stackStart;
            ip = -1;
            for (int i = 0; i < args.length; ++i) {
                context.getCurrentScope().getValues()[i] = args[i];
            }
        } else {
            this.push(instruction.callAdapter.call(context, recv, args));
        }
        return ip;
    }

    public static class Instruction {
        public int bytecode;
        public int line_no;
        public String s_op0;
        public IRubyObject o_op0;
        public Object _tmp;
        public long l_op0;
        public long l_op1;
        public int i_op1;
        public InstructionSequence iseq_op;
        public Instruction[] ins_op;
        public int i_op3;
        public int index;
        public int methodIndex = -1;
        public CallSite callAdapter;

        public Instruction(int bytecode) {
            this.bytecode = bytecode;
        }

        public Instruction(int bytecode, String op) {
            this.bytecode = bytecode;
            this.s_op0 = op.intern();
        }

        public Instruction(int bytecode, String op, InstructionSequence op1) {
            this.bytecode = bytecode;
            this.s_op0 = op.intern();
            this.iseq_op = op1;
        }

        public Instruction(int bytecode, long op) {
            this.bytecode = bytecode;
            this.l_op0 = op;
        }

        public Instruction(int bytecode, IRubyObject op) {
            this.bytecode = bytecode;
            this.o_op0 = op;
        }

        public Instruction(int bytecode, String op, int op1, Instruction[] op2, int op3) {
            this.bytecode = bytecode;
            this.s_op0 = op;
            this.i_op1 = op1;
            this.ins_op = op2;
            this.i_op3 = op3;
        }

        public String toString() {
            return "[:" + YARVInstructions.name(this.bytecode) + ", " + (this.s_op0 != null ? this.s_op0 : (this.o_op0 != null ? this.o_op0.toString() : "" + this.l_op0)) + "]";
        }
    }

    public static class InstructionSequence {
        public String magic = "YARVInstructionSimpledataFormat";
        public int major = 1;
        public int minor = 1;
        public int format_type = 1;
        public Object misc;
        public String name;
        public String filename;
        public Object[] line;
        public String type;
        public String[] locals;
        public int args_argc;
        public int args_arg_opts;
        public String[] args_opt_labels;
        public int args_rest;
        public int args_block;
        public Object[] exception;
        public Instruction[] body;

        public InstructionSequence(Ruby runtime, String name, String file, String type) {
            this.misc = runtime.getNil();
            this.name = name;
            this.filename = file;
            this.line = new Object[0];
            this.type = type;
            this.locals = new String[0];
            this.args_argc = 0;
            this.args_arg_opts = 0;
            this.exception = new Object[0];
        }
    }
}

