/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.oberthur;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.javacard.oberthur.CardImpl;
import org.netbeans.modules.javacard.spi.ConnectionWatchdog;

final class StateUpdaterCallback
implements ConnectionWatchdog.Callback<CardImpl> {
    private static final Logger LOGGER = Logger.getLogger(StateUpdaterCallback.class.getName());

    StateUpdaterCallback() {
    }

    public void poll(CardImpl card) throws Exception {
        URL url = card.getPollUrl();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, this + " update card status");
        }
        try {
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(200);
            conn.setUseCaches(false);
            conn.setReadTimeout(200);
            conn.setRequestMethod("GET");
            conn.setDoOutput(false);
            int code = conn.getResponseCode();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, this + " got response code " + code);
            }
            card.setConnected(code == 200);
        }
        catch (IOException ex) {
            LOGGER.log(Level.FINEST, "Could not connect to " + url, ex);
            card.setConnected(false);
        }
    }
}

