/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.TypeArray;
import com.sun.javacard.offcardverifier.TypeBase;
import com.sun.javacard.offcardverifier.TypeMethod;
import com.sun.javacard.offcardverifier.TypeNull;
import com.sun.javacard.offcardverifier.VerifierError;

abstract class Type {
    protected Type beforeNormalization = null;
    static final Type Byte = new TypeBase(3);
    static final Type Short = new TypeBase(4);
    static final Type Int = new TypeBase(5);
    static final Type Int2 = new TypeBase(6);
    static final Type Boolean = new TypeBase(2);
    static final Type Void = new TypeBase(1);
    static final Type BooleanArray = new TypeArray(Boolean);
    static final Type ByteArray = new TypeArray(Byte);
    static final Type ShortArray = new TypeArray(Short);
    static final Type IntArray = new TypeArray(Int);
    static final Type Null = new TypeNull();

    Type() {
    }

    abstract boolean isSubtype(Type var1);

    abstract Type lub(Type var1);

    int wordSize() {
        return 1;
    }

    Type normalize() {
        return this;
    }

    public String toString() {
        if (this.beforeNormalization != null) {
            return this.beforeNormalization.toStringAux();
        }
        return this.toStringAux();
    }

    abstract String toStringAux();

    static Type parseCap(Safeptr safeptr) {
        TypeMethod typeMethod = TypeMethod.parseCap(safeptr);
        if (typeMethod.args.length != 0) {
            throw new VerifierError("Type.1", safeptr);
        }
        if (typeMethod.res.equals(Void)) {
            throw new VerifierError("Type.2", safeptr);
        }
        return typeMethod.res;
    }

    static Type parseField(int n) {
        if ((n & 0x8000) == 0) {
            return Type.parseCap(Cap.TypeDescr.at(n));
        }
        switch (n) {
            case 32770: {
                return Boolean;
            }
            case 32771: {
                return Byte;
            }
            case 32772: {
                return Short;
            }
            case 32773: {
                return Int;
            }
        }
        throw new VerifierError("Type.3", n);
    }

    static Type parseExport(String string) {
        TypeMethod typeMethod = TypeMethod.parseExport(string);
        if (typeMethod.args.length != 0) {
            throw new VerifierError("Type.4", string);
        }
        if (typeMethod.res.equals(Void)) {
            throw new VerifierError("Type.5", string);
        }
        return typeMethod.res;
    }
}

