/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugcomponent;

import com.sun.javacard.basicstructure.MethodDefinition;
import com.sun.javacard.debugcomponent.DebugComponent;
import com.sun.javacard.debugcomponent.LineInfo;
import com.sun.javacard.debugcomponent.VariableInfo;
import com.sun.javacard.jcfile.JcLocalVariable;
import com.sun.javacard.jcfile.JcMethod;
import com.sun.javacard.jcfile.instructions.JcInstruction;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Vector;

public class MethodDebugInfo
extends MethodDefinition {
    private int name_index;
    private int descriptor_index;
    private int location;
    private int header_size;
    private int bytecode_size;
    private VariableInfo[] var_table;
    private LineInfo[] line_table;

    public MethodDebugInfo(JcMethod jcMethod, DebugComponent debugComponent) {
        super(jcMethod);
        this.build(jcMethod, debugComponent);
    }

    private void build(JcMethod jcMethod, DebugComponent debugComponent) {
        JcInstruction jcInstruction;
        this.name_index = debugComponent.addString(this.method_name);
        this.descriptor_index = debugComponent.addString(this.descriptor);
        this.header_size = 2;
        if (jcMethod.getMaxStack() > 15) {
            this.header_size = 4;
        }
        if (jcMethod.getNargs() > 15) {
            this.header_size = 4;
        }
        if (jcMethod.getMaxLocals() > 15) {
            this.header_size = 4;
        }
        if (jcMethod.isAbstract()) {
            this.header_size = 0;
        }
        for (jcInstruction = jcMethod.getCode(); jcInstruction != null; jcInstruction = jcInstruction.getNextInstr()) {
            this.bytecode_size += jcInstruction.getSizeInBytes();
        }
        JcLocalVariable[] jcLocalVariableArray = jcMethod.getLocalVariables();
        Vector<VariableInfo> vector = new Vector<VariableInfo>();
        Object object = jcLocalVariableArray;
        int n = ((JcLocalVariable[])object).length;
        for (int i = 0; i < n; ++i) {
            for (JcLocalVariable jcLocalVariable = object[i]; jcLocalVariable != null; jcLocalVariable = jcLocalVariable.getNext()) {
                vector.addElement(new VariableInfo(jcMethod, jcLocalVariable, debugComponent));
            }
        }
        this.var_table = new VariableInfo[vector.size()];
        vector.copyInto(this.var_table);
        jcInstruction = jcMethod.getCode();
        Vector<LineInfo> vector2 = new Vector<LineInfo>(20, 10);
        while (jcInstruction != null) {
            object = jcInstruction;
            JcInstruction jcInstruction2 = jcInstruction;
            int n2 = ((JcInstruction)object).getSourceLineNumber();
            while (jcInstruction != null) {
                jcInstruction2 = jcInstruction;
                if (jcInstruction.getSourceLineNumber() != n2) break;
                jcInstruction = jcInstruction.getNextInstr();
            }
            int n3 = ((JcInstruction)object).getPC();
            int n4 = jcInstruction2.getPC();
            n4 = jcInstruction != null ? --n4 : (n4 += jcInstruction2.getSizeInBytes() - 1);
            LineInfo lineInfo = new LineInfo(n3, n4, n2);
            vector2.addElement(lineInfo);
        }
        this.line_table = new LineInfo[vector2.size()];
        vector2.copyInto(this.line_table);
    }

    public int getSize() {
        int n = 0;
        for (VariableInfo object : this.var_table) {
            n += object.getSize();
        }
        for (LineInfo lineInfo : this.line_table) {
            n += lineInfo.getSize();
        }
        return n + 15;
    }

    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer.append("\n");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("\t");
        }
        String string = stringBuffer.toString();
        stringBuffer2.append(string + "method_debug_info { ");
        stringBuffer2.append(string + "\tname_index " + this.name_index + "\t\t//" + this.method_name);
        stringBuffer2.append(string + "\tdescriptor_index " + this.descriptor_index + "\t\t//" + this.descriptor);
        stringBuffer2.append(string + "\taccess_flags " + Modifier.toString(this.access_flags));
        stringBuffer2.append(string + "\tlocation " + this.location);
        stringBuffer2.append(string + "\theader_size " + this.header_size);
        stringBuffer2.append(string + "\tbytecode_size " + this.bytecode_size);
        stringBuffer2.append(string + "\tvariable_count " + this.var_table.length);
        stringBuffer2.append(string + "\tline_count " + this.line_table.length);
        for (VariableInfo object : this.var_table) {
            stringBuffer2.append(object.toString(n + 1));
        }
        for (LineInfo lineInfo : this.line_table) {
            stringBuffer2.append(lineInfo.toString(n + 1));
        }
        stringBuffer2.append(string + "}");
        return stringBuffer2.toString();
    }

    public void toBinary(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.name_index);
        dataOutputStream.writeShort(this.descriptor_index);
        dataOutputStream.writeShort(this.access_flags);
        dataOutputStream.writeShort(this.location);
        dataOutputStream.writeByte(this.header_size);
        dataOutputStream.writeShort(this.bytecode_size);
        dataOutputStream.writeShort(this.var_table.length);
        dataOutputStream.writeShort(this.line_table.length);
        for (VariableInfo object : this.var_table) {
            object.toBinary(dataOutputStream);
        }
        for (LineInfo lineInfo : this.line_table) {
            lineInfo.toBinary(dataOutputStream);
        }
        dataOutputStream.flush();
    }
}

