/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.optimizers;

import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.converter.util.DataType;
import com.sun.javacard.jcfile.JcClass;
import com.sun.javacard.jcfile.JcMethod;
import com.sun.javacard.jcfile.JcPackage;
import com.sun.javacard.jcfile.constants.JcConstantFieldRef;
import com.sun.javacard.jcfile.constants.JcConstantPool;
import com.sun.javacard.jcfile.instructions.JcInstrBranch;
import com.sun.javacard.jcfile.instructions.JcInstrFieldRef;
import com.sun.javacard.jcfile.instructions.JcInstruction;

public class WideInstrOptimizer {
    JcPackage jc_package;

    public WideInstrOptimizer(JcPackage jcPackage) {
        this.jc_package = jcPackage;
    }

    public JcPackage optimize() {
        JcClass[] jcClassArray;
        JcConstantPool jcConstantPool = this.jc_package.getConstantPool();
        jcConstantPool.order();
        for (JcClass jcClass : jcClassArray = this.jc_package.getClasses()) {
            JcMethod[] jcMethodArray;
            for (JcMethod jcMethod : jcMethodArray = jcClass.getMethods()) {
                this.passOne(jcMethod);
                this.passTwo(jcMethod);
            }
        }
        return this.jc_package;
    }

    private void passOne(JcMethod jcMethod) {
        block27: for (JcInstruction jcInstruction = jcMethod.getCode(); jcInstruction != null; jcInstruction = jcInstruction.getNextInstr()) {
            int n = jcInstruction.getOpcode();
            switch (n) {
                case 169: {
                    this.optimizeFieldInstr(jcInstruction, 131);
                    continue block27;
                }
                case 170: {
                    this.optimizeFieldInstr(jcInstruction, 132);
                    continue block27;
                }
                case 171: {
                    this.optimizeFieldInstr(jcInstruction, 133);
                    continue block27;
                }
                case 172: {
                    this.optimizeFieldInstr(jcInstruction, 134);
                    continue block27;
                }
                case 177: {
                    this.optimizeFieldInstr(jcInstruction, 135);
                    continue block27;
                }
                case 178: {
                    this.optimizeFieldInstr(jcInstruction, 136);
                    continue block27;
                }
                case 179: {
                    this.optimizeFieldInstr(jcInstruction, 137);
                    continue block27;
                }
                case 180: {
                    this.optimizeFieldInstr(jcInstruction, 138);
                    continue block27;
                }
                case 152: {
                    this.setBranchInstr(jcInstruction, 96);
                    continue block27;
                }
                case 153: {
                    this.setBranchInstr(jcInstruction, 97);
                    continue block27;
                }
                case 154: {
                    this.setBranchInstr(jcInstruction, 98);
                    continue block27;
                }
                case 155: {
                    this.setBranchInstr(jcInstruction, 99);
                    continue block27;
                }
                case 156: {
                    this.setBranchInstr(jcInstruction, 100);
                    continue block27;
                }
                case 157: {
                    this.setBranchInstr(jcInstruction, 101);
                    continue block27;
                }
                case 158: {
                    this.setBranchInstr(jcInstruction, 102);
                    continue block27;
                }
                case 159: {
                    this.setBranchInstr(jcInstruction, 103);
                    continue block27;
                }
                case 160: {
                    this.setBranchInstr(jcInstruction, 104);
                    continue block27;
                }
                case 161: {
                    this.setBranchInstr(jcInstruction, 105);
                    continue block27;
                }
                case 162: {
                    this.setBranchInstr(jcInstruction, 106);
                    continue block27;
                }
                case 163: {
                    this.setBranchInstr(jcInstruction, 107);
                    continue block27;
                }
                case 164: {
                    this.setBranchInstr(jcInstruction, 108);
                    continue block27;
                }
                case 165: {
                    this.setBranchInstr(jcInstruction, 109);
                    continue block27;
                }
                case 166: {
                    this.setBranchInstr(jcInstruction, 110);
                    continue block27;
                }
                case 167: {
                    this.setBranchInstr(jcInstruction, 111);
                    continue block27;
                }
                case 168: {
                    this.setBranchInstr(jcInstruction, 112);
                }
            }
        }
    }

    private void optimizeFieldInstr(JcInstruction jcInstruction, int n) {
        JcInstrFieldRef jcInstrFieldRef = (JcInstrFieldRef)jcInstruction;
        JcConstantFieldRef jcConstantFieldRef = jcInstrFieldRef.getFieldRef();
        if ((jcConstantFieldRef.getIndex() & 0xFF00) == 0) {
            jcInstrFieldRef.setWideInstr(false);
            jcInstrFieldRef.setOpcode(n);
        }
    }

    private void setBranchInstr(JcInstruction jcInstruction, int n) {
        JcInstrBranch jcInstrBranch = (JcInstrBranch)jcInstruction;
        jcInstrBranch.setWideInstr(false);
        jcInstrBranch.setOpcode(n);
    }

    private void passTwo(JcMethod jcMethod) {
        JcInstruction jcInstruction = jcMethod.getCode();
        if (jcInstruction == null) {
            return;
        }
        boolean bl = true;
        while (bl) {
            boolean bl2 = false;
            bl = false;
            for (JcInstruction jcInstruction2 = jcInstruction; jcInstruction2 != null; jcInstruction2 = jcInstruction2.getNextInstr()) {
                int n = jcInstruction2.getOpcode();
                switch (n) {
                    case 96: {
                        bl2 = this.optimizeBranchInstr(jcInstruction2, 152, jcMethod);
                        break;
                    }
                    case 97: {
                        bl2 = this.optimizeBranchInstr(jcInstruction2, 153, jcMethod);
                        break;
                    }
                    case 98: {
                        bl2 = this.optimizeBranchInstr(jcInstruction2, 154, jcMethod);
                        break;
                    }
                    case 99: {
                        bl2 = this.optimizeBranchInstr(jcInstruction2, 155, jcMethod);
                        break;
                    }
                    case 100: {
                        bl2 = this.optimizeBranchInstr(jcInstruction2, 156, jcMethod);
                        break;
                    }
                    case 101: {
                        bl2 = this.optimizeBranchInstr(jcInstruction2, 157, jcMethod);
                        break;
                    }
                    case 102: {
                        bl2 = this.optimizeBranchInstr(jcInstruction2, 158, jcMethod);
                        break;
                    }
                    case 103: {
                        bl2 = this.optimizeBranchInstr(jcInstruction2, 159, jcMethod);
                        break;
                    }
                    case 104: {
                        bl2 = this.optimizeBranchInstr(jcInstruction2, 160, jcMethod);
                        break;
                    }
                    case 105: {
                        bl2 = this.optimizeBranchInstr(jcInstruction2, 161, jcMethod);
                        break;
                    }
                    case 106: {
                        bl2 = this.optimizeBranchInstr(jcInstruction2, 162, jcMethod);
                        break;
                    }
                    case 107: {
                        bl2 = this.optimizeBranchInstr(jcInstruction2, 163, jcMethod);
                        break;
                    }
                    case 108: {
                        bl2 = this.optimizeBranchInstr(jcInstruction2, 164, jcMethod);
                        break;
                    }
                    case 109: {
                        bl2 = this.optimizeBranchInstr(jcInstruction2, 165, jcMethod);
                        break;
                    }
                    case 110: {
                        bl2 = this.optimizeBranchInstr(jcInstruction2, 166, jcMethod);
                        break;
                    }
                    case 111: {
                        bl2 = this.optimizeBranchInstr(jcInstruction2, 167, jcMethod);
                        break;
                    }
                    case 112: {
                        bl2 = this.optimizeBranchInstr(jcInstruction2, 168, jcMethod);
                    }
                }
                if (!bl2) continue;
                bl = true;
            }
        }
    }

    private boolean optimizeBranchInstr(JcInstruction jcInstruction, int n, JcMethod jcMethod) {
        JcInstrBranch jcInstrBranch = (JcInstrBranch)jcInstruction;
        int n2 = jcInstrBranch.getBranchLabel();
        int n3 = this.computeOffset(jcInstruction, n2, jcMethod);
        if (DataType.getType(n3) != 1) {
            jcInstrBranch.setWideInstr(true);
            jcInstrBranch.setOpcode(n);
            return true;
        }
        return false;
    }

    private int computeOffset(JcInstruction jcInstruction, int n, JcMethod jcMethod) {
        JcInstruction jcInstruction2;
        JcInstruction jcInstruction3 = null;
        for (jcInstruction2 = jcMethod.getCode(); jcInstruction2 != null; jcInstruction2 = jcInstruction2.getNextInstr()) {
            if (jcInstruction2.getLabel() != n) continue;
            jcInstruction3 = jcInstruction2;
            break;
        }
        if (jcInstruction3 == null) {
            throw new ConverterInternalError();
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (jcInstruction2 = jcMethod.getCode(); jcInstruction2 != null; jcInstruction2 = jcInstruction2.getNextInstr()) {
            if (jcInstruction2 == jcInstruction) {
                n2 = n4;
            }
            if (jcInstruction2 == jcInstruction3) {
                n3 = n4;
            }
            n4 += jcInstruction2.getSizeInBytes();
        }
        return n3 - n2;
    }
}

