/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelutil;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.List;
import javax.swing.JToolTip;

public class MethodParamsTipPaintComponent
extends JToolTip {
    private int drawX;
    private int drawY;
    private int drawHeight;
    private int drawWidth;
    private Font drawFont;
    private int fontHeight;
    private int ascent;
    private FontMetrics fontMetrics;
    private List<List<String>> params;
    private int idx;

    public MethodParamsTipPaintComponent(List<List<String>> params, int idx) {
        this.params = params;
        this.idx = idx;
    }

    @Override
    public void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        Rectangle r = g.getClipBounds();
        g.fillRect(r.x, r.y, r.width, r.height);
        g.setColor(this.getForeground());
        this.draw(g);
    }

    protected void draw(Graphics g) {
        Insets in = this.getInsets();
        if (in != null) {
            this.drawX = in.left;
            this.drawY = in.top;
        } else {
            this.drawX = 0;
            this.drawY = 0;
        }
        this.drawHeight = this.fontHeight;
        if (in != null) {
            this.drawHeight += in.bottom;
        }
        this.drawHeight += this.drawY;
        this.drawY += this.ascent;
        int startX = this.drawX;
        this.drawWidth = this.drawX;
        int i = 0;
        Iterator<List<String>> it = this.params.iterator();
        while (it.hasNext()) {
            for (String s : it.next()) {
                this.drawString(g, s, i == this.idx ? this.getDrawFont().deriveFont(1) : null);
                ++i;
            }
            if (this.drawWidth < this.drawX) {
                this.drawWidth = this.drawX;
            }
            this.drawY += this.drawHeight;
            this.drawX = startX;
            i = 0;
        }
    }

    protected void drawString(Graphics g, String s, Font font) {
        if (g != null) {
            g.setFont(font);
            g.drawString(s, this.drawX, this.drawY);
            g.setFont(this.drawFont);
        }
        this.drawX += this.getWidth(s, font);
    }

    protected int getWidth(String s, Font font) {
        if (font == null) {
            return this.fontMetrics.stringWidth(s);
        }
        return this.getFontMetrics(font).stringWidth(s);
    }

    protected int getHeight(String s, Font font) {
        if (font == null) {
            return this.fontMetrics.stringWidth(s);
        }
        return this.getFontMetrics(font).stringWidth(s);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.fontMetrics = this.getFontMetrics(font);
        this.fontHeight = this.fontMetrics.getHeight();
        this.ascent = this.fontMetrics.getAscent();
        this.drawFont = font;
    }

    protected Font getDrawFont() {
        return this.drawFont;
    }

    @Override
    public Dimension getPreferredSize() {
        this.draw(null);
        Insets i = this.getInsets();
        if (i != null) {
            this.drawX += i.right;
        }
        return new Dimension(this.drawWidth, this.drawHeight * this.params.size());
    }
}

