/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.parsing;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.expressions.ExpressionBuilder;
import oracle.toplink.essentials.internal.parsing.FunctionalExpressionNode;
import oracle.toplink.essentials.internal.parsing.GenerationContext;
import oracle.toplink.essentials.internal.parsing.ParseTreeContext;
import oracle.toplink.essentials.queryframework.ObjectLevelReadQuery;
import oracle.toplink.essentials.queryframework.ReportQuery;

public class DateFunctionNode
extends FunctionalExpressionNode {
    private Class type;

    public void applyToQuery(ObjectLevelReadQuery theQuery, GenerationContext context) {
        if (theQuery.isReportQuery()) {
            ReportQuery reportQuery = (ReportQuery)theQuery;
            reportQuery.addAttribute("date", this.generateExpression(context), this.type);
        }
    }

    public void validate(ParseTreeContext context) {
        this.setType(this.type);
    }

    public Expression generateExpression(GenerationContext context) {
        Expression expr = context.getBaseExpression();
        if (expr == null) {
            expr = new ExpressionBuilder();
        }
        Expression result = null;
        if (this.type == Date.class) {
            result = expr.currentDateDate();
        } else if (this.type == Time.class) {
            result = expr.currentTime();
        } else if (this.type == Timestamp.class) {
            result = expr.currentDate();
        }
        return result;
    }

    public void useCurrentDate() {
        this.type = Date.class;
    }

    public void useCurrentTime() {
        this.type = Time.class;
    }

    public void useCurrentTimestamp() {
        this.type = Timestamp.class;
    }
}

