/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.core.jaxws.nodes.JaxWsNode;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;

public class JaxWsRootChildren
extends Children.Keys<Service> {
    JaxWsModel jaxWsModel;
    Service[] services;
    JaxWsListener listener;
    FileObject[] srcRoots;
    private RequestProcessor.Task updateNodeTask = RequestProcessor.getDefault().create(new Runnable(){

        @Override
        public void run() {
            JaxWsRootChildren.this.updateKeys();
        }
    });

    public JaxWsRootChildren(JaxWsModel jaxWsModel, FileObject[] fileObjectArray) {
        this.jaxWsModel = jaxWsModel;
        this.srcRoots = fileObjectArray;
    }

    protected void addNotify() {
        this.listener = new JaxWsListener();
        this.jaxWsModel.addPropertyChangeListener((PropertyChangeListener)this.listener);
        this.updateKeys();
    }

    protected void removeNotify() {
        this.setKeys(Collections.emptySet());
        this.jaxWsModel.removePropertyChangeListener((PropertyChangeListener)this.listener);
    }

    private void updateKeys() {
        ArrayList<Service> arrayList = new ArrayList<Service>();
        this.services = this.jaxWsModel.getServices();
        if (this.services != null) {
            for (int i = 0; i < this.services.length; ++i) {
                arrayList.add(this.services[i]);
            }
        }
        this.setKeys(arrayList);
    }

    protected Node[] createNodes(Service service) {
        String string = service.getImplementationClass();
        for (FileObject fileObject : this.srcRoots) {
            FileObject fileObject2 = this.getImplementationClass(string, fileObject);
            if (fileObject2 == null) continue;
            return new Node[]{new JaxWsNode(this.jaxWsModel, service, fileObject, fileObject2)};
        }
        return new Node[0];
    }

    private FileObject getImplementationClass(String string, FileObject fileObject) {
        if (string != null && fileObject != null) {
            return fileObject.getFileObject(string.replace('.', '/') + ".java");
        }
        return null;
    }

    class JaxWsListener
    implements PropertyChangeListener {
        JaxWsListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JaxWsRootChildren.this.updateNodeTask.schedule(2000);
        }
    }
}

