/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.embedder.MavenEmbedderLogger;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.execute.AbstractOutputHandler;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

class CommandLineOutputHandler
extends AbstractOutputHandler {
    private static final RequestProcessor PROCESSOR = new RequestProcessor("Maven ComandLine Output Redirection", 8);
    private InputOutput inputOutput;
    private Pattern linePattern = Pattern.compile("\\[(DEBUG|INFO|WARN|ERROR|FATAL)\\] (.*)");
    static Pattern startPattern = Pattern.compile("\\[INFO\\] \\[([\\w]*):([\\w]*)[ ]?.*\\]");
    private OutputWriter stdOut;
    private String currentTag;
    RequestProcessor.Task outTask;
    private MavenEmbedderLogger logger;
    private Input inp;
    private ProgressHandle handle;

    CommandLineOutputHandler(ProgressHandle hand) {
        super(hand);
        this.handle = hand;
    }

    public CommandLineOutputHandler(InputOutput io, Project proj, ProgressHandle hand, RunConfig config) {
        this(hand);
        this.inputOutput = io;
        this.stdOut = this.inputOutput.getOut();
        this.logger = new Logger();
        this.initProcessorList(proj, config);
    }

    @Override
    protected final void checkSleepiness() {
        this.handle.progress("");
        super.checkSleepiness();
    }

    void setStdOut(InputStream inStr) {
        this.outTask = PROCESSOR.post((Runnable)new Output(inStr));
    }

    void setStdIn(OutputStream in) {
        this.inp = new Input(in, this.inputOutput);
        PROCESSOR.post((Runnable)this.inp);
    }

    void waitFor() {
        this.inp.stopInput();
        if (this.outTask != null) {
            this.outTask.waitFinished();
        }
    }

    @Override
    protected InputOutput getIO() {
        return this.inputOutput;
    }

    @Override
    MavenEmbedderLogger getLogger() {
        return this.logger;
    }

    private class Logger
    implements MavenEmbedderLogger {
        private Logger() {
        }

        public void debug(String arg0) {
            CommandLineOutputHandler.this.inputOutput.getOut().println(arg0);
        }

        public void debug(String arg0, Throwable arg1) {
            CommandLineOutputHandler.this.inputOutput.getOut().println(arg0);
        }

        public boolean isDebugEnabled() {
            return true;
        }

        public void info(String arg0) {
            CommandLineOutputHandler.this.inputOutput.getOut().println(arg0);
        }

        public void info(String arg0, Throwable arg1) {
            CommandLineOutputHandler.this.inputOutput.getOut().println(arg0);
        }

        public boolean isInfoEnabled() {
            return true;
        }

        public void warn(String arg0) {
            CommandLineOutputHandler.this.inputOutput.getOut().println(arg0);
        }

        public void warn(String arg0, Throwable arg1) {
            CommandLineOutputHandler.this.inputOutput.getOut().println(arg0);
        }

        public boolean isWarnEnabled() {
            return true;
        }

        public void error(String arg0) {
            CommandLineOutputHandler.this.inputOutput.getErr().println(arg0);
        }

        public void error(String arg0, Throwable arg1) {
            CommandLineOutputHandler.this.inputOutput.getErr().println(arg0);
        }

        public boolean isErrorEnabled() {
            return true;
        }

        public void fatalError(String arg0) {
            CommandLineOutputHandler.this.inputOutput.getErr().println(arg0);
        }

        public void fatalError(String arg0, Throwable arg1) {
            CommandLineOutputHandler.this.inputOutput.getErr().println(arg0);
        }

        public boolean isFatalErrorEnabled() {
            return true;
        }

        public void setThreshold(int arg0) {
        }

        public int getThreshold() {
            return 0;
        }

        public void close() {
        }
    }

    static class Input
    implements Runnable {
        private InputOutput inputOutput;
        private OutputStream str;
        private boolean stopIn = false;
        private Thread runningThread;

        public Input(OutputStream out, InputOutput inputOutput) {
            this.str = out;
            this.inputOutput = inputOutput;
        }

        public void stopInput() {
            this.stopIn = true;
            try {
                this.inputOutput.getIn().close();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            this.runningThread = Thread.currentThread();
            Reader in = this.inputOutput.getIn();
            try {
                while (true) {
                    int read;
                    if ((read = in.read()) == -1) {
                        this.str.close();
                        return;
                    }
                    this.str.write(read);
                    this.str.flush();
                    if (this.stopIn) {
                        return;
                    }
                    continue;
                    break;
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return;
            }
            finally {
                try {
                    this.str.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private class Output
    implements Runnable {
        private static final String SEC_MOJO_EXEC = "mojo-execute";
        private BufferedReader str;
        private boolean skipLF = false;

        public Output(InputStream instream) {
            this.str = new BufferedReader(new InputStreamReader(instream));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String readLine() throws IOException {
            char[] char1 = new char[1];
            boolean isReady = true;
            StringBuffer buf = new StringBuffer();
            while (isReady) {
                int ret = this.str.read(char1);
                if (ret != 1) {
                    if (ret == -1 && buf.length() == 0) {
                        return null;
                    }
                    return buf.toString();
                }
                if (this.skipLF) {
                    this.skipLF = false;
                    if (char1[0] == '\n') continue;
                }
                if (char1[0] == '\n') {
                    return buf.toString();
                }
                if (char1[0] == '\r') {
                    this.skipLF = true;
                    return buf.toString();
                }
                buf.append(char1[0]);
                isReady = this.str.ready();
                if (isReady) continue;
                Output output = this;
                synchronized (output) {
                    try {
                        this.wait(500L);
                    }
                    catch (InterruptedException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    finally {
                        if (!this.str.ready()) {
                            break;
                        }
                        isReady = true;
                    }
                }
            }
            return "&^#INCOMPLINE:" + buf.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CommandLineOutputHandler.this.processStart(CommandLineOutputHandler.this.getEventId("project-execute", null), CommandLineOutputHandler.this.stdOut);
            try {
                String line = this.readLine();
                while (line != null) {
                    Matcher match;
                    if (line.startsWith("&^#INCOMPLINE:")) {
                        CommandLineOutputHandler.this.stdOut.print(line.substring("&^#INCOMPLINE:".length()));
                        line = this.readLine();
                        continue;
                    }
                    if (line.startsWith("[INFO] Final Memory:")) {
                        if (CommandLineOutputHandler.this.currentTag != null) {
                            CommandLineOutputHandler.this.processEnd(CommandLineOutputHandler.this.getEventId(SEC_MOJO_EXEC, CommandLineOutputHandler.this.currentTag), CommandLineOutputHandler.this.stdOut);
                        }
                        CommandLineOutputHandler.this.currentTag = null;
                    }
                    if ((match = startPattern.matcher(line)).matches()) {
                        String tag = match.group(1) + ":" + match.group(2);
                        if (CommandLineOutputHandler.this.currentTag != null) {
                            CommandLineOutputHandler.this.processEnd(CommandLineOutputHandler.this.getEventId(SEC_MOJO_EXEC, CommandLineOutputHandler.this.currentTag), CommandLineOutputHandler.this.stdOut);
                        }
                        CommandLineOutputHandler.this.processStart(CommandLineOutputHandler.this.getEventId(SEC_MOJO_EXEC, tag), CommandLineOutputHandler.this.stdOut);
                        CommandLineOutputHandler.this.currentTag = tag;
                    } else {
                        match = CommandLineOutputHandler.this.linePattern.matcher(line);
                        if (match.matches()) {
                            String level = match.group(1);
                            CommandLineOutputHandler.this.processLine(match.group(2), CommandLineOutputHandler.this.stdOut, "INFO".equals(level) ? "" : level);
                        } else {
                            CommandLineOutputHandler.this.processLine(line, CommandLineOutputHandler.this.stdOut, "");
                        }
                    }
                    line = this.readLine();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            finally {
                CommandLineOutputHandler.this.processEnd(CommandLineOutputHandler.this.getEventId("project-execute", null), CommandLineOutputHandler.this.stdOut);
                try {
                    this.str.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

