/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.sync;

import java.util.Arrays;
import java.util.Vector;
import org.netbeans.modules.xml.sync.Representation;
import org.netbeans.modules.xml.util.Util;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;

public abstract class SyncSupport {
    private DataObject dobj;
    protected static final int JUST_SYNCHRONIZING = 1;
    protected static final int JUST_RESOLVING_CONFLICT = 2;
    protected static final int NOP = 0;
    private int syncOperation;
    private final Object syncOperationLock = new SyncSupportLock();

    public SyncSupport(DataObject dobj) throws IllegalArgumentException {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("Creating sychronizator " + System.identityHashCode(this) + " for: " + dobj.getPrimaryFile());
        }
        this.dobj = dobj;
        this.syncOperation = 0;
    }

    private void waitFor(int state) throws InterruptedException {
        while (this.getSyncOp() != 0) {
            this.syncOperationLock.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSyncOp(int op) {
        Object object = this.syncOperationLock;
        synchronized (object) {
            if (op == this.syncOperation) {
                return;
            }
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("" + System.identityHashCode(this) + " syncOperation " + this.syncOperation + " => " + op + " Thread:" + Thread.currentThread().getName());
            }
            this.syncOperation = op;
            this.syncOperationLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getSyncOp() {
        Object object = this.syncOperationLock;
        synchronized (object) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("" + System.identityHashCode(this) + " syncOperation = " + this.syncOperation + " Thread:" + Thread.currentThread().getName());
            }
            return this.syncOperation;
        }
    }

    public boolean isInSync() {
        return this.getSyncOp() == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postRequest(Runnable task) {
        boolean leave = false;
        try {
            Object object = this.syncOperationLock;
            synchronized (object) {
                this.waitFor(0);
                leave = true;
                this.setSyncOp(1);
            }
            task.run();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if (leave) {
                this.setSyncOp(0);
            }
        }
    }

    protected final Node.Cookie getCookie(Class klass) {
        return this.getDO().getCookie(klass);
    }

    protected final DataObject getDO() {
        return this.dobj;
    }

    public abstract void addRepresentation(Representation var1);

    public abstract void removeRepresentation(Representation var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void representationChanged(Class type) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("" + System.identityHashCode(this) + " entering synchronizator: " + type);
        }
        if (this.isInSync()) {
            return;
        }
        try {
            int i;
            this.setSyncOp(1);
            Representation master = null;
            Representation[] all = this.getRepresentations(null);
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("\tReps: " + Arrays.asList(all));
            }
            Vector<Representation> modified = new Vector<Representation>();
            for (i = 0; i < all.length; ++i) {
                if (all[i].represents(type)) {
                    master = all[i];
                    modified.add(all[i]);
                    continue;
                }
                if (!all[i].isModified()) continue;
                modified.add(all[i]);
            }
            if (modified.size() > 1) {
                master = this.selectMasterRepresentation(modified.toArray(new Representation[0]));
            }
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("\t" + System.identityHashCode(this) + " master: " + master);
            }
            if (master == null) {
                return;
            }
            for (i = 0; i < all.length; ++i) {
                Object change;
                if (all[i] == master) continue;
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("\tpreffered update class: " + all[i].getUpdateClass());
                }
                if ((change = master.getChange(all[i].getUpdateClass())) == null) {
                    change = master.getChange(null);
                }
                if (change == null) continue;
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("\t" + System.identityHashCode(this) + " updating: " + all[i] + " with:" + change.getClass());
                }
                all[i].update(change);
            }
        }
        finally {
            this.setSyncOp(0);
        }
    }

    protected abstract Representation[] getRepresentations();

    protected Representation[] getRepresentations(Class type) {
        Representation[] all = this.getRepresentations();
        if (type == null) {
            return all;
        }
        throw new RuntimeException("Not Implemened.");
    }

    protected Representation selectMasterRepresentation(Representation[] choices) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("COMODIFICATION:");
        }
        return choices[0];
    }

    private static class SyncSupportLock {
        private SyncSupportLock() {
        }
    }
}

