/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.customizer.regex;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ItemListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.TreeCellRenderer;
import org.netbeans.modules.mobility.project.ui.customizer.regex.CheckedTreeBeanView;
import org.netbeans.modules.mobility.project.ui.customizer.regex.FileObjectCookie;
import org.netbeans.modules.mobility.project.ui.customizer.regex.MultiStateCheckBox;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Node;

public class CheckedNodeRenderer
implements TreeCellRenderer {
    private RendererComponent customRenderer = null;
    private Object defaultRenderer = null;
    private CheckedTreeBeanView storage;
    private Color selectionForeground;
    private Color selectionBackground;
    private Color textForeground;

    protected RendererComponent getRenderer() {
        return this.customRenderer;
    }

    public CheckedNodeRenderer(Object defaultRenderer) {
        Boolean booleanValue;
        this.defaultRenderer = defaultRenderer;
        this.selectionForeground = UIManager.getColor("Tree.selectionForeground");
        this.selectionBackground = UIManager.getColor("Tree.selectionBackground");
        this.textForeground = UIManager.getColor("Tree.textForeground");
        this.customRenderer = new RendererComponent();
        Font fontValue = UIManager.getFont("Tree.font");
        if (fontValue != null) {
            this.customRenderer.setFont(fontValue);
        }
        this.customRenderer.setFocusPainted((booleanValue = (Boolean)UIManager.get("Tree.drawsFocusBorderAroundIcon")) != null && booleanValue != false);
    }

    public CheckedNodeRenderer() {
        this(null);
    }

    public void setContentStorage(CheckedTreeBeanView storage) {
        this.storage = storage;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component returnValue = null;
        Node node = Visualizer.findNode((Object)value);
        FileObjectCookie doj = (FileObjectCookie)node.getCookie(FileObjectCookie.class);
        if (doj != null) {
            this.customRenderer.setEnabled(tree.isEnabled());
            if (selected) {
                this.customRenderer.setForeground(this.selectionForeground, this.textForeground);
                this.customRenderer.setBackground(this.selectionBackground, tree.getBackground());
            } else {
                this.customRenderer.setForeground(this.textForeground);
                this.customRenderer.setBackground(tree.getBackground());
            }
            this.customRenderer.setText(node.getDisplayName());
            if (doj != null) {
                if (this.storage == null) {
                    this.customRenderer.setState(CheckedTreeBeanView.UNSELECTED);
                } else {
                    Object state = this.storage.getState(doj.getFileObject());
                    this.customRenderer.setState(state == null ? CheckedTreeBeanView.UNSELECTED : state);
                }
            }
            this.customRenderer.setIcon(new ImageIcon(node.getIcon(1)));
            return this.customRenderer;
        }
        if (this.defaultRenderer != null) {
            returnValue = ((TreeCellRenderer)this.defaultRenderer).getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        }
        return returnValue;
    }

    static class RendererComponent
    extends JPanel {
        MultiStateCheckBox jCheckBox1 = new MultiStateCheckBox();
        private final JLabel jLabel1;
        private final JLabel jLabel2;

        public RendererComponent() {
            this.jCheckBox1.setBorder(null);
            this.jLabel1 = new JLabel();
            this.jLabel2 = new JLabel();
            this.setLayout(new BorderLayout(5, 0));
            this.add((Component)this.jCheckBox1, "West");
            this.add((Component)this.jLabel1, "Center");
            this.add((Component)this.jLabel2, "East");
        }

        @Override
        public void setForeground(Color fg) {
            this.setForeground(fg, fg);
        }

        @Override
        public void setBackground(Color bg) {
            this.setBackground(bg, bg);
        }

        public void setForeground(Color selection, Color text) {
            if (this.jCheckBox1 == null || this.jLabel1 == null || this.jLabel2 == null) {
                return;
            }
            this.jCheckBox1.setForeground(text);
            this.jLabel1.setForeground(text);
            this.jLabel2.setForeground(selection);
            super.setForeground(selection);
        }

        public void setBackground(Color selection, Color text) {
            if (this.jCheckBox1 == null || this.jLabel1 == null || this.jLabel2 == null) {
                return;
            }
            this.jCheckBox1.setBackground(text);
            this.jLabel1.setBackground(text);
            this.jLabel2.setBackground(selection);
            super.setBackground(selection);
        }

        public void setFocusPainted(boolean painted) {
            this.jCheckBox1.setFocusPainted(painted);
        }

        public void setText(String text) {
            this.jLabel2.setText(text);
        }

        public String getText() {
            return this.jLabel2.getText();
        }

        public void setState(Object state) {
            this.jCheckBox1.setState(state);
        }

        public void setIcon(Icon icon) {
            this.jLabel1.setIcon(icon);
        }

        public void addItemListener(ItemListener itemListener) {
            this.jCheckBox1.addItemListener(itemListener);
        }

        public void removeItemListener(ItemListener itemListener) {
            this.jCheckBox1.removeItemListener(itemListener);
        }
    }
}

