/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui;

import java.awt.EventQueue;
import java.awt.Image;
import java.io.CharConversionException;
import org.netbeans.api.project.Project;
import org.netbeans.modules.mobility.project.ui.J2MEProjectRootNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.xml.XMLUtil;

class DecoratedNode
extends AbstractNode {
    static final String GRAY = "gray";
    static final String BOLD = "bold";
    static final String ERROR = "error";
    private final DisplayNameUpdater displayNameUpdater = new DisplayNameUpdater();
    private static final int INTERVAL = 200;
    private final BrokenStateUpdater brokenChecker = new BrokenStateUpdater();
    private final RequestProcessor rp;
    private final RequestProcessor.Task task;

    DecoratedNode(Children ch, Lookup lkp) {
        super(ch, lkp);
        Project p;
        RequestProcessor r = (RequestProcessor)lkp.lookup(RequestProcessor.class);
        if (r == null && (r = (RequestProcessor)(p = (Project)lkp.lookup(Project.class)).getLookup().lookup(RequestProcessor.class)) == null) {
            r = new RequestProcessor();
        }
        this.rp = r;
        this.task = this.rp.create((Runnable)this.brokenChecker);
        this.task.schedule(400);
    }

    public DecoratedNode(Children ch, Lookup lookup, String name, String dName, String icon) {
        this(ch, lookup);
        this.setName(name);
        if (dName != null) {
            this.setDisplayName(dName);
        }
        if (icon != null) {
            this.setIconBaseWithExtension(icon);
        }
    }

    protected boolean isAlive() {
        for (DecoratedNode parent = this; parent != null; parent = parent.getParentNode()) {
            boolean isProjectRoot = parent instanceof J2MEProjectRootNode;
            if (!isProjectRoot) continue;
            return true;
        }
        return false;
    }

    public final void setName(String name) {
        if (name.equals(this.getName())) {
            this.fireDisplayNameChange(null, null);
        } else {
            super.setName(name);
        }
    }

    public final void setValue(String attributeName, Object value) {
        super.setValue(attributeName, value);
        if (GRAY.equals(attributeName) || BOLD.equals(attributeName) || ERROR.equals(attributeName)) {
            EventQueue.invokeLater(this.displayNameUpdater);
        }
    }

    public String getHtmlDisplayName() {
        String displayName = this.getDisplayName();
        try {
            displayName = XMLUtil.toElementContent((String)displayName);
        }
        catch (CharConversionException ex) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean bold = Boolean.TRUE.equals(this.getValue(BOLD));
        if (bold) {
            sb.append("<B>");
        }
        boolean error = Boolean.TRUE.equals(this.getValue(ERROR));
        boolean gray = Boolean.TRUE.equals(this.getValue(GRAY));
        if (error) {
            sb.append("<font color=\"!nb.errorForeground\">");
        } else if (gray) {
            sb.append("<font color=\"!controlShadow\">");
        }
        sb.append(displayName);
        return sb.toString();
    }

    public Image getIcon(int type) {
        Image icon = super.getIcon(type);
        boolean broken = Boolean.TRUE.equals(this.getValue(ERROR));
        return broken ? ImageUtilities.mergeImages((Image)icon, (Image)ImageUtilities.loadImage((String)"org/netbeans/modules/mobility/project/ui/resources/brokenProjectBadge.gif"), (int)8, (int)0) : icon;
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    protected final void checkBroken() {
        if (this.getParentNode() != null) {
            this.task.schedule(200);
        }
    }

    protected boolean isBroken() {
        return false;
    }

    private final class BrokenStateUpdater
    implements Runnable {
        private BrokenStateUpdater() {
        }

        @Override
        public void run() {
            DecoratedNode.this.setValue(DecoratedNode.ERROR, DecoratedNode.this.isBroken());
        }
    }

    private final class DisplayNameUpdater
    implements Runnable {
        private DisplayNameUpdater() {
        }

        @Override
        public void run() {
            DecoratedNode.this.fireDisplayNameChange(null, null);
            DecoratedNode.this.fireIconChange();
            DecoratedNode.this.fireOpenedIconChange();
        }
    }
}

