/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ruby.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.refactoring.ruby.RefactoringModule;
import org.netbeans.modules.refactoring.ruby.RetoucheUtils;
import org.netbeans.modules.refactoring.ruby.RubyElementCtx;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyParseResult;
import org.netbeans.modules.ruby.elements.IndexedElement;
import org.netbeans.modules.ruby.elements.IndexedMethod;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class WhereUsedPanel
extends JPanel
implements CustomRefactoringPanel {
    private final transient RubyElementCtx element;
    private RubyElementCtx newElement;
    private final transient ChangeListener parent;
    private boolean initialized = false;
    private String methodDeclaringSuperClass = null;
    private String methodDeclaringClass = null;
    private ButtonGroup buttonGroup;
    private JRadioButton c_directOnly;
    private JRadioButton c_subclasses;
    private JRadioButton c_usages;
    private JPanel classesPanel;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JLabel label;
    private JCheckBox m_isBaseClass;
    private JCheckBox m_overriders;
    private JCheckBox m_usages;
    private JPanel methodsPanel;
    private JCheckBox searchInComments;

    public WhereUsedPanel(String name, RubyElementCtx e, ChangeListener parent) {
        this.setName(NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_WhereUsed"));
        this.element = e;
        this.parent = parent;
        this.initComponents();
    }

    String getMethodDeclaringClass() {
        return this.isMethodFromBaseClass() ? this.methodDeclaringSuperClass : this.methodDeclaringClass;
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        Source source = Source.create((FileObject)this.element.getFileObject());
        try {
            ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                private String getClassName(RubyElementCtx element) {
                    return element.getDefClass();
                }

                public void run(ResultIterator ri) throws Exception {
                    String labelText;
                    String className;
                    String methodName;
                    RubyParseResult parserResult = AstUtilities.getParseResult((Parser.Result)ri.getParserResult());
                    String m_isBaseClassText = null;
                    Set modif = new HashSet();
                    if (WhereUsedPanel.this.element.getKind() == ElementKind.METHOD) {
                        IndexedMethod method;
                        if (WhereUsedPanel.this.element.getElement() != null) {
                            modif = WhereUsedPanel.this.element.getElement().getModifiers();
                        }
                        methodName = WhereUsedPanel.this.element.getName();
                        className = this.getClassName(WhereUsedPanel.this.element);
                        String displayClassName = "<Unknown>".equals(className) ? "&lt;Unknown&gt;" : className;
                        labelText = NbBundle.getMessage(WhereUsedPanel.class, (String)"DSC_MethodUsages", (Object)methodName, (Object)displayClassName);
                        WhereUsedPanel.this.methodDeclaringClass = className;
                        IndexedMethod indexedMethod = method = parserResult != null ? RetoucheUtils.getOverridingMethod(WhereUsedPanel.this.element, (ParserResult)parserResult) : RetoucheUtils.getOverridingMethod(WhereUsedPanel.this.element, ri.getSnapshot().getSource().getFileObject());
                        if (method != null) {
                            m_isBaseClassText = new MessageFormat(NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_UsagesOfBaseClass")).format(new Object[]{WhereUsedPanel.this.methodDeclaringSuperClass = method.getIn()});
                            WhereUsedPanel.this.newElement = new RubyElementCtx((IndexedElement)method);
                        }
                    } else if (WhereUsedPanel.this.element.getKind() == ElementKind.CLASS || WhereUsedPanel.this.element.getKind() == ElementKind.MODULE) {
                        labelText = NbBundle.getMessage(WhereUsedPanel.class, (String)"DSC_ClassUsages", (Object)WhereUsedPanel.this.element.getName());
                    } else if (WhereUsedPanel.this.element.getKind() == ElementKind.CONSTRUCTOR) {
                        methodName = WhereUsedPanel.this.element.getName();
                        className = this.getClassName(WhereUsedPanel.this.element);
                        labelText = NbBundle.getMessage(WhereUsedPanel.class, (String)"DSC_ConstructorUsages", (Object)methodName, (Object)className);
                    } else if (WhereUsedPanel.this.element.getKind() == ElementKind.FIELD) {
                        String fieldName = WhereUsedPanel.this.element.getName();
                        className = this.getClassName(WhereUsedPanel.this.element);
                        labelText = NbBundle.getMessage(WhereUsedPanel.class, (String)"DSC_FieldUsages", (Object)fieldName, (Object)className);
                    } else {
                        labelText = NbBundle.getMessage(WhereUsedPanel.class, (String)"DSC_VariableUsages", (Object)WhereUsedPanel.this.element.getName());
                    }
                    final Set modifiers = modif;
                    final String isBaseClassText = m_isBaseClassText;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            WhereUsedPanel.this.remove(WhereUsedPanel.this.classesPanel);
                            WhereUsedPanel.this.remove(WhereUsedPanel.this.methodsPanel);
                            String combinedLabelText = NbBundle.getMessage(WhereUsedPanel.class, (String)"DSC_WhereUsedWarningInDevelopment", (Object)labelText);
                            WhereUsedPanel.this.label.setText(combinedLabelText);
                            if (WhereUsedPanel.this.element.getKind() == ElementKind.METHOD) {
                                WhereUsedPanel.this.add((Component)WhereUsedPanel.this.methodsPanel, "Center");
                                WhereUsedPanel.this.methodsPanel.setVisible(true);
                                WhereUsedPanel.this.m_usages.setVisible(!modifiers.contains(Modifier.STATIC));
                                WhereUsedPanel.this.m_overriders.setVisible(modifiers.contains(Modifier.STATIC) || modifiers.contains(Modifier.PRIVATE));
                                if (WhereUsedPanel.this.methodDeclaringSuperClass != null) {
                                    WhereUsedPanel.this.m_isBaseClass.setVisible(true);
                                    WhereUsedPanel.this.m_isBaseClass.setSelected(true);
                                    Mnemonics.setLocalizedText((AbstractButton)WhereUsedPanel.this.m_isBaseClass, (String)isBaseClassText);
                                } else {
                                    WhereUsedPanel.this.m_isBaseClass.setVisible(false);
                                    WhereUsedPanel.this.m_isBaseClass.setSelected(false);
                                }
                            } else if (WhereUsedPanel.this.element.getKind() == ElementKind.CLASS || WhereUsedPanel.this.element.getKind() == ElementKind.MODULE) {
                                WhereUsedPanel.this.add((Component)WhereUsedPanel.this.classesPanel, "Center");
                                WhereUsedPanel.this.classesPanel.setVisible(true);
                            } else {
                                WhereUsedPanel.this.remove(WhereUsedPanel.this.classesPanel);
                                WhereUsedPanel.this.remove(WhereUsedPanel.this.methodsPanel);
                                WhereUsedPanel.this.c_subclasses.setVisible(false);
                                WhereUsedPanel.this.m_usages.setVisible(false);
                                WhereUsedPanel.this.c_usages.setVisible(false);
                                WhereUsedPanel.this.c_directOnly.setVisible(false);
                            }
                            WhereUsedPanel.this.validate();
                        }
                    });
                }
            });
        }
        catch (ParseException pe) {
            throw (RuntimeException)new RuntimeException().initCause(pe);
        }
        this.initialized = true;
    }

    public RubyElementCtx getBaseMethod() {
        return this.newElement;
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.methodsPanel = new JPanel();
        this.m_isBaseClass = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.m_overriders = new JCheckBox();
        this.m_usages = new JCheckBox();
        this.classesPanel = new JPanel();
        this.jPanel2 = new JPanel();
        this.c_subclasses = new JRadioButton();
        this.c_usages = new JRadioButton();
        this.c_directOnly = new JRadioButton();
        this.jPanel3 = new JPanel();
        this.label = new JLabel();
        this.searchInComments = new JCheckBox();
        this.setLayout(new BorderLayout());
        this.methodsPanel.setLayout(new GridBagLayout());
        this.m_isBaseClass.setSelected(true);
        this.m_isBaseClass.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WhereUsedPanel.this.m_isBaseClassActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.methodsPanel.add((Component)this.m_isBaseClass, gridBagConstraints);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/refactoring/ruby/ui/Bundle");
        this.m_isBaseClass.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_isBaseClass"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.methodsPanel.add((Component)this.jPanel1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.m_overriders, (String)NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_FindOverridingMethods"));
        this.m_overriders.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WhereUsedPanel.this.m_overridersActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.methodsPanel.add((Component)this.m_overriders, gridBagConstraints);
        this.m_overriders.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_overriders"));
        this.m_usages.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.m_usages, (String)NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_FindUsages"));
        this.m_usages.setMargin(new Insets(10, 2, 2, 2));
        this.m_usages.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WhereUsedPanel.this.m_usagesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.methodsPanel.add((Component)this.m_usages, gridBagConstraints);
        this.m_usages.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_usages"));
        this.add((Component)this.methodsPanel, "Center");
        this.classesPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.classesPanel.add((Component)this.jPanel2, gridBagConstraints);
        this.buttonGroup.add(this.c_subclasses);
        Mnemonics.setLocalizedText((AbstractButton)this.c_subclasses, (String)NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_FindAllSubtypes"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.classesPanel.add((Component)this.c_subclasses, gridBagConstraints);
        this.c_subclasses.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_subclasses"));
        this.buttonGroup.add(this.c_usages);
        this.c_usages.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.c_usages, (String)NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_FindUsages"));
        this.c_usages.setMargin(new Insets(4, 2, 2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.classesPanel.add((Component)this.c_usages, gridBagConstraints);
        this.c_usages.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_usages"));
        this.buttonGroup.add(this.c_directOnly);
        Mnemonics.setLocalizedText((AbstractButton)this.c_directOnly, (String)NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_FindDirectSubtypesOnly"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.classesPanel.add((Component)this.c_directOnly, gridBagConstraints);
        this.c_directOnly.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_directOnly"));
        this.add((Component)this.classesPanel, "Center");
        this.jPanel3.setLayout(new BorderLayout());
        this.jPanel3.add((Component)this.label, "North");
        this.searchInComments.setSelected(RefactoringModule.getOption("searchInComments.whereUsed", Boolean.FALSE));
        Mnemonics.setLocalizedText((AbstractButton)this.searchInComments, (String)NbBundle.getBundle(WhereUsedPanel.class).getString("LBL_SearchInComents"));
        this.searchInComments.setMargin(new Insets(10, 14, 2, 2));
        this.searchInComments.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                WhereUsedPanel.this.searchInCommentsItemStateChanged(evt);
            }
        });
        this.jPanel3.add((Component)this.searchInComments, "Center");
        this.searchInComments.getAccessibleContext().setAccessibleDescription(this.searchInComments.getText());
        this.add((Component)this.jPanel3, "North");
    }

    private void searchInCommentsItemStateChanged(ItemEvent evt) {
        Boolean b = evt.getStateChange() == 1 ? Boolean.TRUE : Boolean.FALSE;
        RefactoringModule.setOption("searchInComments.whereUsed", b);
    }

    private void m_isBaseClassActionPerformed(ActionEvent evt) {
        this.parent.stateChanged(null);
    }

    private void m_overridersActionPerformed(ActionEvent evt) {
        this.parent.stateChanged(null);
    }

    private void m_usagesActionPerformed(ActionEvent evt) {
        this.parent.stateChanged(null);
    }

    public boolean isMethodFromBaseClass() {
        return this.m_isBaseClass.isSelected();
    }

    public boolean isMethodOverriders() {
        return this.m_overriders.isSelected();
    }

    public boolean isClassSubTypes() {
        return this.c_subclasses.isSelected();
    }

    public boolean isClassSubTypesDirectOnly() {
        return this.c_directOnly.isSelected();
    }

    public boolean isMethodFindUsages() {
        return this.m_usages.isSelected();
    }

    public boolean isClassFindUsages() {
        return this.c_usages.isSelected();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension orig = super.getPreferredSize();
        return new Dimension(orig.width + 30, orig.height + 80);
    }

    public boolean isSearchInComments() {
        return this.searchInComments.isSelected();
    }

    public Component getComponent() {
        return this;
    }
}

