/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.screen.editor;

import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.common.DocumentSupport;
import org.netbeans.modules.vmd.api.screen.display.ScreenDisplayPresenter;

public final class EditedScreenSupport {
    private static final WeakHashMap<DesignDocument, EditedScreenSupport> instances = new WeakHashMap();
    private long editedScreenComponentID = -1L;
    private final ArrayList<Listener> listeners = new ArrayList();

    private EditedScreenSupport() {
    }

    public static synchronized EditedScreenSupport getSupportForDocument(DesignDocument document) {
        EditedScreenSupport support = instances.get(document);
        if (support == null) {
            support = new EditedScreenSupport();
            instances.put(document, support);
        }
        return support;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Listener listener) {
        ArrayList<Listener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Listener listener) {
        ArrayList<Listener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(listener);
        }
    }

    public long getEditedScreenComponentID() {
        return this.editedScreenComponentID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEditedScreenComponentID(long editedScreenComponentID) {
        Listener[] listenersArray;
        this.editedScreenComponentID = editedScreenComponentID;
        ArrayList<Listener> arrayList = this.listeners;
        synchronized (arrayList) {
            listenersArray = this.listeners.toArray(new Listener[this.listeners.size()]);
        }
        for (Listener listener : listenersArray) {
            listener.editedScreenChanged(editedScreenComponentID);
        }
    }

    public static List<DesignComponent> getAllEditableScreensInDocument(DesignDocument document) {
        assert (document.getTransactionManager().isAccess());
        ArrayList<DesignComponent> screens = new ArrayList<DesignComponent>();
        for (DesignComponent component : DocumentSupport.gatherAllComponentsContainingPresenterClass((DesignDocument)document, ScreenDisplayPresenter.class)) {
            if (!((ScreenDisplayPresenter)component.getPresenter(ScreenDisplayPresenter.class)).isTopLevelDisplay()) continue;
            screens.add(component);
        }
        return screens;
    }

    public static interface Listener {
        public void editedScreenChanged(long var1);
    }
}

